/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport.handler;

import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcDataPackageEncoder
extends MessageToMessageEncoder<RpcDataPackage> {
    private static final Logger LOG = Logger.getLogger(RpcDataPackageEncoder.class.getName());
    private long chunkSize = -1L;

    public long getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    public RpcDataPackageEncoder() {
    }

    public RpcDataPackageEncoder(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    protected void encode(ChannelHandlerContext ctx, RpcDataPackage msg, List<Object> out) throws Exception {
        RpcDataPackage dataPackage = msg;
        byte[] encodeBytes = dataPackage.write();
        if (encodeBytes == null) {
            throw new Exception("byte is null from dataPackage");
        }
        LOG.log(Level.FINE, "Client send content byte size:" + encodeBytes.length);
        ByteBuf encodedMessage = Unpooled.copiedBuffer((byte[])encodeBytes);
        if (this.chunkSize < 0L) {
            out.add(encodedMessage);
            return;
        }
        List<RpcDataPackage> list = dataPackage.chunk(this.chunkSize);
        for (RpcDataPackage rpcDataPackage : list) {
            encodeBytes = rpcDataPackage.write();
            encodedMessage = Unpooled.copiedBuffer((byte[])encodeBytes);
            out.add(encodedMessage);
        }
    }
}

