/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.utils;

import java.lang.reflect.Method;

public class ReflectionUtils {
    public static void doWithMethods(Class<?> targetClass, MethodCallback mc) throws IllegalArgumentException {
        ReflectionUtils.doWithMethods(targetClass, mc, null);
    }

    public static void doWithMethods(Class<?> targetClass, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        do {
            Method[] methods = targetClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                if (mf == null || mf.matches(methods[i])) {
                    try {
                        mc.doWith(methods[i]);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalStateException("Shouldn't be illegal to access method '" + methods[i].getName() + "': " + ex);
                    }
                }
                ++i;
            }
        } while ((targetClass = targetClass.getSuperclass()) != null);
    }

    public static boolean isVoid(Class<?> cls) {
        return cls == Void.class || cls == Void.TYPE;
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }
}

