/*
 * Copyright 2002-2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.baidu.jprotobuf.pbrpc.data;

/**
 *  Hold the <code>Trace</code> object in the current thread.
 *
 * @author xiemalin
 * @since 4.0.0
 */
public class TraceContext {

    /** The Constant TRACE. */
    private static final ThreadLocal<Trace> TRACE = new ThreadLocal<Trace>();
    
    
    /**
     * Sets the trace.
     *
     * @param trace the new trace
     */
    public static void setTrace(Trace trace) {
        if (trace != null) {
            TRACE.set(trace);;
        }
    }
    
    /**
     * Gets the trace.
     *
     * @return the trace
     */
    public static Trace getTrace() {
        return TRACE.get();
    }
    
    
    /**
     * Clear trace.
     */
    public static void clearTrace() {
        TRACE.remove();
    }
    
    
}
