/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.compress;

import com.baidu.jprotobuf.pbrpc.compress.Compress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipCompress
implements Compress {
    private static final int BUFFER_SIZE = 256;

    @Override
    public byte[] compress(byte[] array) throws IOException {
        return this.compress0(array);
    }

    public byte[] compress0(byte[] array) throws IOException {
        if (array == null) {
            return null;
        }
        byte[] ret = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(array);
        gzip.close();
        ret = out.toByteArray();
        return ret;
    }

    @Override
    public byte[] unCompress(byte[] array) throws IOException {
        return this.unCompress0(array);
    }

    public byte[] unCompress0(byte[] array) throws IOException {
        int n;
        if (array == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(array);
        GZIPInputStream gunzip = new GZIPInputStream(in){};
        byte[] buffer = new byte[256];
        while ((n = gunzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }
}

