/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.management;

import com.baidu.jprotobuf.pbrpc.management.HttpServerInboundHandler;
import com.baidu.jprotobuf.pbrpc.transport.RpcServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpServer
extends ServerBootstrap {
    private static final Logger LOG = Logger.getLogger(HttpServer.class.getName());
    private static final int DEFAULT_WAIT_STOP_INTERVAL = 200;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private AtomicBoolean stop = new AtomicBoolean(false);
    private HttpServerInboundHandler handler;

    public HttpServer(final RpcServer rpcServer) {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.handler = new HttpServerInboundHandler(rpcServer);
        this.group(this.bossGroup, this.workerGroup);
        this.channel(NioServerSocketChannel.class);
        this.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("IDLE_HANDLER", (ChannelHandler)new IdleStateHandler(rpcServer.getRpcServerOptions().getReaderIdleTime(), rpcServer.getRpcServerOptions().getWriterIdleTime(), rpcServer.getRpcServerOptions().getKeepAliveTime()));
                ch.pipeline().addLast("HTTP_RESPONSE", (ChannelHandler)new HttpResponseEncoder());
                ch.pipeline().addLast("HTTP_REQUEST", (ChannelHandler)new HttpRequestDecoder());
                ch.pipeline().addLast("STAUTS_NADLER", (ChannelHandler)HttpServer.this.handler);
            }
        });
    }

    public void start(int port) {
        this.bind(port).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    HttpServer.this.channel = future.channel();
                }
            }
        });
        LOG.log(Level.INFO, "Http starting at port: " + port);
    }

    public void waitForStop() throws InterruptedException {
        while (!this.stop.get()) {
            Thread.sleep(200L);
        }
        this.stop();
    }

    public void stop() {
        this.stop.compareAndSet(false, true);
    }

    public void shutdownNow() {
        this.stop();
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.handler != null) {
            this.handler.close();
        }
    }
}

