/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.meta;

import com.baidu.jprotobuf.pbrpc.client.ProtobufRpcProxy;
import com.baidu.jprotobuf.pbrpc.meta.RpcServiceMetaList;
import com.baidu.jprotobuf.pbrpc.meta.RpcServiceMetaService;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;

public class MetaExportHelper {
    public static final String CHARSET_NAME = "utf-8";

    public static String exportIDL(int servicePort) {
        return MetaExportHelper.exportIDL(null, servicePort, CHARSET_NAME);
    }

    public static String exportIDL(String serviceHost, int servicePort) {
        return MetaExportHelper.exportIDL(serviceHost, servicePort, CHARSET_NAME);
    }

    public static String exportIDL(String serviceHost, int servicePort, String charset) {
        StringBuilder ret = new StringBuilder();
        RpcClient rpcClient = new RpcClient();
        ProtobufRpcProxy<RpcServiceMetaService> pbrpcProxy = new ProtobufRpcProxy<RpcServiceMetaService>(rpcClient, RpcServiceMetaService.class);
        pbrpcProxy.setPort(servicePort);
        if (serviceHost != null) {
            pbrpcProxy.setHost(serviceHost);
        }
        RpcServiceMetaService proxy = pbrpcProxy.proxy();
        RpcServiceMetaList rpcServiceMetaInfo = proxy.getRpcServiceMetaInfo();
        try {
            String rpcsIDL;
            String typesIDL = rpcServiceMetaInfo.getTypesIDL();
            if (!StringUtils.isBlank(typesIDL)) {
                ret.append(typesIDL);
            }
            if (!StringUtils.isBlank(rpcsIDL = rpcServiceMetaInfo.getRpcsIDL())) {
                ret.append(rpcsIDL);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            pbrpcProxy.close();
            rpcClient.stop();
        }
        return ret.toString();
    }

    public static RpcServiceMetaList exportRPCMeta(int servicePort) {
        return MetaExportHelper.exportRPCMeta(null, servicePort);
    }

    public static RpcServiceMetaList exportRPCMeta(String serviceHost, int servicePort) {
        RpcClient rpcClient = new RpcClient();
        ProtobufRpcProxy<RpcServiceMetaService> pbrpcProxy = new ProtobufRpcProxy<RpcServiceMetaService>(rpcClient, RpcServiceMetaService.class);
        pbrpcProxy.setPort(servicePort);
        if (serviceHost != null) {
            pbrpcProxy.setHost(serviceHost);
        }
        try {
            RpcServiceMetaList rpcServiceMetaInfo;
            RpcServiceMetaService proxy = pbrpcProxy.proxy();
            RpcServiceMetaList rpcServiceMetaList = rpcServiceMetaInfo = proxy.getRpcServiceMetaInfo();
            return rpcServiceMetaList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            pbrpcProxy.close();
            rpcClient.stop();
        }
    }
}

