/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.server;

import com.baidu.jprotobuf.pbrpc.ProtobufRPCService;
import com.baidu.jprotobuf.pbrpc.client.RpcMethodInfo;
import com.baidu.jprotobuf.pbrpc.server.AbstractAnnotationRpcHandler;
import com.google.protobuf.AbstractMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class MessageGeneratedRpcHandler
extends AbstractAnnotationRpcHandler {
    private static final Logger PERFORMANCE_LOGGER = Logger.getLogger("performance-log");
    private static final String PROTOBUF_PARSE_METHOD = "parseFrom";
    private Method parseFromMethod;

    public MessageGeneratedRpcHandler(Method method, Object service, ProtobufRPCService protobufPRCService) {
        super(method, service, protobufPRCService);
        if (this.getInputClass() != null && RpcMethodInfo.isMessageType(this.getInputClass())) {
            try {
                this.parseFromMethod = this.getInputClass().getMethod(PROTOBUF_PARSE_METHOD, InputStream.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected byte[] decodeOutputParam(Object ret) throws Exception {
        if (ret != null && ret instanceof AbstractMessage) {
            byte[] response = ((AbstractMessage)ret).toByteArray();
            return response;
        }
        return null;
    }

    @Override
    protected Object encodeInputParam(byte[] data) throws Exception {
        if (data != null && this.parseFromMethod != null) {
            Object input = this.parseFromMethod.invoke((Object)this.getInputClass(), new ByteArrayInputStream(data));
            return input;
        }
        return null;
    }
}

