/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

@ChannelHandler.Sharable
public class RpcServerChannelIdleHandler
extends ChannelDuplexHandler {
    private static Logger LOG = Logger.getLogger(RpcServerChannelIdleHandler.class.getName());
    private int idleTimeout;

    public RpcServerChannelIdleHandler(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            if (e.state() == IdleState.ALL_IDLE) {
                LOG.log(Level.WARNING, "channel:" + ctx.channel() + " ip=" + ctx.channel().remoteAddress() + " is idle for period time [" + this.idleTimeout + "]. close now.");
                ctx.close();
            } else {
                LOG.log(Level.WARNING, "idle on channel[" + e.state() + "]:" + ctx.channel());
            }
        }
    }

    public RpcServerChannelIdleHandler() {
    }
}

