/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.transport.handler;

import com.baidu.jprotobuf.pbrpc.ErrorDataException;
import com.baidu.jprotobuf.pbrpc.RpcHandler;
import com.baidu.jprotobuf.pbrpc.data.RpcDataPackage;
import com.baidu.jprotobuf.pbrpc.data.RpcMeta;
import com.baidu.jprotobuf.pbrpc.data.Trace;
import com.baidu.jprotobuf.pbrpc.data.TraceContext;
import com.baidu.jprotobuf.pbrpc.server.RpcData;
import com.baidu.jprotobuf.pbrpc.server.RpcServiceHandleContext;
import com.baidu.jprotobuf.pbrpc.server.RpcServiceRegistry;
import com.baidu.jprotobuf.pbrpc.transport.ExceptionCatcher;
import com.baidu.jprotobuf.pbrpc.transport.RpcErrorMessage;
import com.baidu.jprotobuf.pbrpc.utils.LogIdThreadLocalHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcServiceHandler
extends SimpleChannelInboundHandler<RpcDataPackage> {
    private static final Logger LOG = Logger.getLogger(RpcServiceHandler.class.getName());
    private ExecutorService es;
    private final RpcServiceRegistry rpcServiceRegistry;
    private ExceptionCatcher exceptionCatcher;

    public void setEs(ExecutorService es) {
        this.es = es;
    }

    public RpcServiceHandler(RpcServiceRegistry rpcServiceRegistry, ExceptionCatcher exceptionCatcher) {
        this.rpcServiceRegistry = rpcServiceRegistry;
        this.exceptionCatcher = exceptionCatcher;
    }

    protected void channelRead0(ChannelHandlerContext ctx, RpcDataPackage dataPackage) throws Exception {
        BackgroundTask task = new BackgroundTask(ctx, dataPackage, this.rpcServiceRegistry, this.exceptionCatcher);
        if (this.es != null) {
            this.es.submit(task);
        } else {
            task.run();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ErrorDataException error;
        RpcDataPackage dataPackage;
        LOG.log(Level.SEVERE, cause.getCause().getMessage(), cause.getCause());
        RpcDataPackage data = null;
        if (cause instanceof ErrorDataException && (dataPackage = (error = (ErrorDataException)cause).getRpcDataPackage()) != null) {
            int errorCode = 2001;
            if (error.getErrorCode() > 0) {
                errorCode = error.getErrorCode();
            }
            data = dataPackage.getErrorResponseRpcDataPackage(errorCode, cause.getCause().getMessage());
            RpcServiceHandler.handleException(data, this.exceptionCatcher, (ErrorDataException)cause);
        }
        if (data == null) {
            data = new RpcDataPackage();
            data = data.magicCode("PRPC").getErrorResponseRpcDataPackage(2001, cause.getCause().getMessage());
        }
        ctx.fireChannelRead(data);
    }

    private static void handleException(RpcDataPackage rpcDataPackage, ExceptionCatcher exceptionCatcher, Exception e) {
        if (exceptionCatcher == null) {
            return;
        }
        RpcErrorMessage rpcErrorMessage = exceptionCatcher.onException(e);
        if (rpcErrorMessage != null) {
            rpcDataPackage.errorCode(rpcErrorMessage.getErrorCode());
            rpcDataPackage.errorText(rpcErrorMessage.getErrorMessage());
        }
    }

    private static class BackgroundTask
    implements Runnable {
        private ChannelHandlerContext ctx;
        private RpcDataPackage dataPackage;
        private RpcServiceRegistry rpcServiceRegistry;
        private ExceptionCatcher exceptionCatcher;

        public BackgroundTask(ChannelHandlerContext ctx, RpcDataPackage dataPackage, RpcServiceRegistry rpcServiceRegistry, ExceptionCatcher exceptionCatcher) {
            this.ctx = ctx;
            this.dataPackage = dataPackage;
            this.rpcServiceRegistry = rpcServiceRegistry;
            this.exceptionCatcher = exceptionCatcher;
        }

        @Override
        public void run() {
            String methodName;
            Integer errorCode;
            long time = System.currentTimeMillis();
            if (this.dataPackage.getRpcMeta().getResponse() != null && (errorCode = this.dataPackage.getRpcMeta().getResponse().getErrorCode()) != null && errorCode > 0) {
                this.dataPackage.data(null);
                this.dataPackage.attachment(null);
                this.ctx.writeAndFlush((Object)this.dataPackage);
                return;
            }
            RpcMeta rpcMeta = this.dataPackage.getRpcMeta();
            String serviceName = rpcMeta.getRequest().getServiceName();
            boolean asyncMode = this.rpcServiceRegistry.isAsyncMode(serviceName, methodName = rpcMeta.getRequest().getMethodName());
            if (asyncMode) {
                RpcDataPackage copy = this.dataPackage.copy();
                copy.errorCode(0);
                copy.data(null);
                copy.attachment(null);
                this.ctx.writeAndFlush((Object)copy);
                return;
            }
            Long logId = rpcMeta.getRequest().getLogId();
            LogIdThreadLocalHolder.setLogId(logId);
            RpcServiceHandleContext.setChannelHandlerContext(this.ctx);
            try {
                RpcHandler handler = this.rpcServiceRegistry.lookupService(serviceName, methodName);
                if (handler == null) {
                    String message = "service name '" + serviceName + "' and methodName '" + methodName + "' not found";
                    LOG.log(Level.WARNING, message);
                    this.dataPackage.errorCode(1001);
                    this.dataPackage.errorText(message);
                } else {
                    byte[] data = this.dataPackage.getData();
                    RpcData request = new RpcData();
                    request.setLogId(this.dataPackage.getRpcMeta().getRequest().getLogId());
                    request.setData(data);
                    request.setAttachment(this.dataPackage.getAttachment());
                    if (this.dataPackage.getRpcMeta() != null) {
                        request.setAuthenticationData(this.dataPackage.getRpcMeta().getAuthenticationData());
                    }
                    request.setExtraParams(this.dataPackage.getRpcMeta().getRequest().getExtraParam());
                    request.setExtFields(this.dataPackage.getRpcMeta().getRequest().getExtFieldsAsMap());
                    try {
                        Trace trace = this.dataPackage.trace();
                        trace.stepInto();
                        TraceContext.setTrace(trace);
                        RpcData response = handler.doHandle(request);
                        this.dataPackage.data(response.getData());
                        this.dataPackage.attachment(response.getAttachment());
                        this.dataPackage.authenticationData(response.getAuthenticationData());
                        this.dataPackage.errorCode(0);
                        this.dataPackage.errorText(null);
                    }
                    catch (InvocationTargetException e) {
                        Throwable targetException = e.getTargetException();
                        if (targetException == null) {
                            targetException = e;
                        }
                        LOG.log(Level.SEVERE, targetException.getMessage(), targetException);
                        this.dataPackage.errorCode(2001);
                        this.dataPackage.errorText(targetException.getMessage());
                        RpcServiceHandler.handleException(this.dataPackage, this.exceptionCatcher, e);
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e.getCause());
                        this.dataPackage.errorCode(2001);
                        this.dataPackage.errorText(e.getMessage());
                        RpcServiceHandler.handleException(this.dataPackage, this.exceptionCatcher, e);
                    }
                }
                if (!asyncMode) {
                    this.ctx.writeAndFlush((Object)this.dataPackage);
                }
            }
            catch (Exception t) {
                ErrorDataException exception = new ErrorDataException(t.getMessage(), t);
                exception.setErrorCode(2001);
                exception.setRpcDataPackage(this.dataPackage);
                throw new RuntimeException(exception.getMessage(), exception);
            }
            finally {
                LOG.fine("RPC server invoke method '" + methodName + "' time took:" + (System.currentTimeMillis() - time) + " ms");
                LogIdThreadLocalHolder.clearLogId();
                RpcServiceHandleContext.clearChannelHandlerContext();
            }
        }
    }
}

