/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.EnumReadable;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.ProtobufIDLGenerator;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.descriptor.DescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.EnumDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.EnumOptionsPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.EnumValueDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.ExtensionRangePOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.FieldDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.FileDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.Label;
import com.baidu.bjf.remoting.protobuf.descriptor.MessageOptionsPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.ServiceDescriptorProtoPOJO;
import com.baidu.bjf.remoting.protobuf.descriptor.Type;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.MessageType;
import com.squareup.protoparser.Option;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.ProtoSchemaParser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodedConstant {
    private static final String FIELD_PREFIX = "f_";
    static final int TAG_TYPE_BITS = 3;

    public static String getFieldName(int order) {
        String fieldName = FIELD_PREFIX + order;
        return fieldName;
    }

    public static String getMappedTypeDefined(int order, FieldType type, String express, boolean isList) {
        String fieldName = CodedConstant.getFieldName(order);
        if (!(type != FieldType.STRING && type != FieldType.BYTES || isList)) {
            String code = "com.google.protobuf.ByteString " + fieldName + "=null" + ";\n";
            code = code + "if (!CodedConstant.isNull(" + express + ")) {\n";
            String method = "copyFromUtf8";
            if (type == FieldType.BYTES) {
                method = "copyFrom";
            }
            code = code + fieldName + " = com.google.protobuf.ByteString." + method + "(" + express + ")" + ";\n";
            code = code + "}";
            return code;
        }
        String defineType = type.getJavaType();
        if (isList) {
            defineType = "List";
        }
        String code = defineType + " " + fieldName + "=null" + ";\n";
        code = code + "if (!CodedConstant.isNull(" + express + ")) {\n";
        code = code + fieldName + "=" + express + ";\n";
        code = code + "}";
        return code;
    }

    public static String getFiledType(FieldType type, boolean isList) {
        if (!(type != FieldType.STRING && type != FieldType.BYTES || isList)) {
            return "com.google.protobuf.ByteString";
        }
        String defineType = type.getJavaType();
        if (isList) {
            defineType = "List";
        }
        return defineType;
    }

    public static String getWriteValueToField(FieldType type, String express, boolean isList) {
        if (!(type != FieldType.STRING && type != FieldType.BYTES || isList)) {
            String method = "copyFromUtf8";
            if (type == FieldType.BYTES) {
                method = "copyFrom";
            }
            return "com.google.protobuf.ByteString." + method + "(" + express + ")";
        }
        return express;
    }

    public static String getMappedTypeSize(FieldInfo field, int order, FieldType type, boolean isList, boolean debug, File path) {
        String fieldName = CodedConstant.getFieldName(order);
        String spath = "ProtobufProxy.OUTPUT_PATH.get()";
        if (isList) {
            String typeString = type.getType().toUpperCase();
            return "CodedConstant.computeListSize(" + order + "," + fieldName + ", FieldType." + typeString + "," + Boolean.valueOf(debug) + "," + spath + ");";
        }
        if (type == FieldType.OBJECT) {
            String typeString = type.getType().toUpperCase();
            return "CodedConstant.computeSize(" + order + "," + fieldName + ", FieldType." + typeString + "," + Boolean.valueOf(debug) + "," + spath + ");";
        }
        String t = type.getType();
        if (type == FieldType.STRING || type == FieldType.BYTES) {
            t = "bytes";
        }
        t = CodedConstant.capitalize(t);
        boolean enumSpecial = false;
        if (type == FieldType.ENUM && EnumReadable.class.isAssignableFrom(field.getField().getType())) {
            String clsName = field.getField().getType().getCanonicalName();
            fieldName = "((" + clsName + ") " + fieldName + ").value()";
            enumSpecial = true;
        }
        if (!enumSpecial) {
            fieldName = fieldName + type.getToPrimitiveType();
        }
        return "com.google.protobuf.CodedOutputStream.compute" + t + "Size(" + order + "," + fieldName + ")" + ";";
    }

    public static int computeListSize(int order, List list, FieldType type, boolean debug, File path) {
        int size = 0;
        if (list == null || list.isEmpty()) {
            return size;
        }
        for (Object object : list) {
            size += CodedConstant.computeSize(order, object, type, debug, path);
        }
        if (type != FieldType.OBJECT) {
            size += list.size() * CodedOutputStream.computeTagSize((int)order);
        }
        return size;
    }

    public static int computeSize(int order, Object o, FieldType type, boolean debug, File path) {
        return CodedConstant.computeSize(order, o, type, false, debug, path);
    }

    public static int computeSize(int order, Object o, FieldType type, boolean list, boolean debug, File path) {
        int size = 0;
        if (o == null) {
            return size;
        }
        if (type == FieldType.OBJECT) {
            Class<?> cls = o.getClass();
            Codec<?> target = ProtobufProxy.create(cls, debug, path);
            try {
                size = target.size(o);
                size += CodedOutputStream.computeRawVarint32Size((int)size);
                return size + CodedOutputStream.computeTagSize((int)order);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (type == FieldType.STRING) {
            size = CodedOutputStream.computeStringSizeNoTag((String)String.valueOf(o));
        } else if (type == FieldType.BOOL) {
            size = CodedOutputStream.computeBoolSizeNoTag((boolean)Boolean.valueOf(String.valueOf(o)));
        } else if (type == FieldType.BYTES) {
            byte[] bb = (byte[])o;
            size = CodedOutputStream.computeBytesSizeNoTag((ByteString)ByteString.copyFrom((byte[])bb));
        } else if (type == FieldType.DOUBLE) {
            size = CodedOutputStream.computeDoubleSizeNoTag((double)Double.valueOf(o.toString()));
        } else if (type == FieldType.FIXED32 || type == FieldType.INT32 || type == FieldType.SFIXED32 || type == FieldType.SINT32 || type == FieldType.UINT32) {
            size = CodedOutputStream.computeInt32SizeNoTag((int)Integer.valueOf(o.toString()));
        } else if (type == FieldType.FIXED64 || type == FieldType.INT64 || type == FieldType.SFIXED64 || type == FieldType.SINT64 || type == FieldType.UINT64) {
            size = CodedOutputStream.computeInt64SizeNoTag((long)Long.valueOf(o.toString()));
        } else if (type == FieldType.FLOAT) {
            size = CodedOutputStream.computeFloatSizeNoTag((float)Float.valueOf(o.toString()).floatValue());
        } else if (type == FieldType.ENUM) {
            if (o instanceof EnumReadable) {
                size = CodedOutputStream.computeInt32SizeNoTag((int)((EnumReadable)o).value());
            } else if (o instanceof Enum) {
                size = CodedOutputStream.computeInt32SizeNoTag((int)((Enum)o).ordinal());
            }
        }
        return size;
    }

    public static String getMappedWriteCode(FieldInfo field, String prefix, int order, FieldType type, boolean isList) {
        String fieldName = CodedConstant.getFieldName(order);
        StringBuilder ret = new StringBuilder();
        ret.append("if (").append(fieldName).append("!=null){");
        if (isList) {
            String typeString = type.getType().toUpperCase();
            ret.append("CodedConstant.writeToList(").append(prefix).append(",");
            ret.append(order).append(",").append("FieldType.").append(typeString);
            ret.append(",").append(fieldName).append(");\n}");
            return ret.toString();
        }
        boolean enumSpecial = false;
        if (type == FieldType.ENUM && EnumReadable.class.isAssignableFrom(field.getField().getType())) {
            String clsName = ClassHelper.getInternalName(field.getField().getType().getCanonicalName());
            fieldName = "((" + clsName + ") " + fieldName + ").value()";
            enumSpecial = true;
        }
        if (!enumSpecial) {
            fieldName = fieldName + type.getToPrimitiveType();
        }
        if (type == FieldType.OBJECT) {
            String typeString = type.getType().toUpperCase();
            ret.append("CodedConstant.writeObject(").append(prefix).append(",");
            ret.append(order).append(",").append("FieldType.").append(typeString);
            ret.append(",").append(fieldName).append(", false)").append(";\n").append("}").append("\n");
            return ret.toString();
        }
        if (type == FieldType.STRING || type == FieldType.BYTES) {
            ret.append(prefix).append(".writeBytes(").append(order);
            ret.append(", ").append(fieldName).append(")").append(";\n").append("}").append("\n");
            return ret.toString();
        }
        String t = type.getType();
        t = CodedConstant.capitalize(t);
        ret.append(prefix).append(".write").append(t).append("(").append(order);
        ret.append(", ").append(fieldName).append(")").append(";\n").append("}").append("\n");
        return ret.toString();
    }

    public static void writeToList(CodedOutputStream out, int order, FieldType type, List list) throws IOException {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Object object : list) {
            if (object == null) {
                throw new NullPointerException("List can not include Null value.");
            }
            CodedConstant.writeObject(out, order, type, object, true);
        }
    }

    public static void writeObject(CodedOutputStream out, int order, FieldType type, Object o, boolean list) throws IOException {
        if (o == null) {
            return;
        }
        if (type == FieldType.OBJECT) {
            Class<?> cls = o.getClass();
            Codec<?> target = ProtobufProxy.create(cls);
            out.writeRawVarint32(CodedConstant.makeTag(order, 2));
            out.writeRawVarint32(target.size(o));
            target.writeTo(o, out);
            return;
        }
        if (type == FieldType.BOOL) {
            out.writeBool(order, ((Boolean)o).booleanValue());
        } else if (type == FieldType.BYTES) {
            byte[] bb = (byte[])o;
            out.writeBytes(order, ByteString.copyFrom((byte[])bb));
        } else if (type == FieldType.DOUBLE) {
            out.writeDouble(order, ((Double)o).doubleValue());
        } else if (type == FieldType.FIXED32) {
            out.writeFixed32(order, ((Integer)o).intValue());
        } else if (type == FieldType.FIXED64) {
            out.writeFixed64(order, ((Long)o).longValue());
        } else if (type == FieldType.FLOAT) {
            out.writeFloat(order, ((Float)o).floatValue());
        } else if (type == FieldType.INT32) {
            out.writeInt32(order, ((Integer)o).intValue());
        } else if (type == FieldType.INT64) {
            out.writeInt64(order, ((Long)o).longValue());
        } else if (type == FieldType.SFIXED32) {
            out.writeSFixed32(order, ((Integer)o).intValue());
        } else if (type == FieldType.SFIXED64) {
            out.writeSFixed64(order, ((Long)o).longValue());
        } else if (type == FieldType.SINT32) {
            out.writeSInt32(order, ((Integer)o).intValue());
        } else if (type == FieldType.SINT64) {
            out.writeSInt64(order, ((Long)o).longValue());
        } else if (type == FieldType.STRING) {
            out.writeBytes(order, ByteString.copyFromUtf8((String)String.valueOf(o)));
        } else if (type == FieldType.UINT32) {
            out.writeUInt32(order, ((Integer)o).intValue());
        } else if (type == FieldType.UINT64) {
            out.writeUInt64(order, ((Long)o).longValue());
        } else if (type == FieldType.ENUM) {
            int value = 0;
            if (o instanceof EnumReadable) {
                value = ((EnumReadable)o).value();
            } else if (o instanceof Enum) {
                value = ((Enum)o).ordinal();
            }
            out.writeEnum(order, value);
        }
    }

    public static String getRequiredCheck(int order, Field field) {
        String fieldName = CodedConstant.getFieldName(order);
        String code = "if (" + fieldName + "== null) {\n";
        code = code + "throw new UninitializedMessageException(CodedConstant.asList(\"" + field.getName() + "\"))" + ";\n";
        code = code + "}\n";
        return code;
    }

    public static String getRetRequiredCheck(String express, Field field) {
        String code = "if (CodedConstant.isNull(" + express + ")) {\n";
        code = code + "throw new UninitializedMessageException(CodedConstant.asList(\"" + field.getName() + "\"))" + ";\n";
        code = code + "}\n";
        return code;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNull(Collection list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNull(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNull(double o) {
        return false;
    }

    public static boolean isNull(int o) {
        return false;
    }

    public static boolean isNull(byte o) {
        return false;
    }

    public static boolean isNull(short o) {
        return false;
    }

    public static boolean isNull(long o) {
        return false;
    }

    public static boolean isNull(float o) {
        return false;
    }

    public static boolean isNull(char o) {
        return false;
    }

    public static List asList(String value) {
        return Arrays.asList(value);
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static String getEnumName(Enum[] e, int value) {
        if (e != null) {
            for (Enum en : e) {
                int toCompareValue = en instanceof EnumReadable ? ((EnumReadable)((Object)en)).value() : en.ordinal();
                if (value != toCompareValue) continue;
                return en.name();
            }
        }
        return "";
    }

    public static <T extends Enum<T>> T getEnumValue(Class<T> enumType, String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        try {
            T v = Enum.valueOf(enumType, name);
            return v;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Descriptors.Descriptor getDescriptor(Class<?> cls) throws IOException {
        Descriptors.FileDescriptor fileDescriptor;
        DescriptorProtos.FileDescriptorProto fileproto;
        String idl = ProtobufIDLGenerator.getIDL(cls);
        ProtoFile file = ProtoSchemaParser.parse((String)"jprotobuf_autogenerate", (String)idl);
        FileDescriptorProtoPOJO fileDescriptorProto = new FileDescriptorProtoPOJO();
        fileDescriptorProto.name = "jprotobuf_autogenerate";
        fileDescriptorProto.pkg = file.getPackageName();
        fileDescriptorProto.dependencies = file.getDependencies();
        fileDescriptorProto.publicDependency = CodedConstant.convertList(file.getPublicDependencies());
        fileDescriptorProto.weakDependency = null;
        fileDescriptorProto.messageTypes = new ArrayList<DescriptorProtoPOJO>();
        fileDescriptorProto.enumTypes = new ArrayList<EnumDescriptorProtoPOJO>();
        fileDescriptorProto.services = new ArrayList<ServiceDescriptorProtoPOJO>();
        HashSet<String> messageSet = new HashSet<String>();
        HashSet<String> enumSet = new HashSet<String>();
        List typeElements = file.getTypes();
        if (typeElements != null) {
            for (com.squareup.protoparser.Type typeElement : typeElements) {
                if (typeElement instanceof MessageType) {
                    messageSet.add(typeElement.getName());
                    continue;
                }
                if (!(typeElement instanceof EnumType)) continue;
                enumSet.add(typeElement.getName());
            }
            for (com.squareup.protoparser.Type typeElement : typeElements) {
                if (typeElement instanceof MessageType) {
                    fileDescriptorProto.messageTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, (MessageType)typeElement, messageSet, enumSet));
                    continue;
                }
                if (!(typeElement instanceof EnumType)) continue;
                fileDescriptorProto.enumTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, (EnumType)typeElement, messageSet, enumSet));
            }
        }
        try {
            Codec<FileDescriptorProtoPOJO> descriptorCodec = ProtobufProxy.create(FileDescriptorProtoPOJO.class, ProtobufProxy.isCacheEnabled(), ProtobufProxy.OUTPUT_PATH.get());
            byte[] bs = descriptorCodec.encode(fileDescriptorProto);
            fileproto = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])bs);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException("Failed to parse protocol buffer descriptor for generated code.", e);
        }
        try {
            fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileproto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IOException(e.getMessage(), e);
        }
        return (Descriptors.Descriptor)fileDescriptor.getMessageTypes().get(0);
    }

    private static DescriptorProtoPOJO getDescritorProtoPOJO(FileDescriptorProtoPOJO fileDescriptorProto, MessageType typeElement, Set<String> messageSet, Set<String> enumSet) {
        List nestedElements;
        DescriptorProtoPOJO ret = new DescriptorProtoPOJO();
        ret.name = typeElement.getName();
        ret.fields = new ArrayList<FieldDescriptorProtoPOJO>();
        ret.nestedTypes = new ArrayList<DescriptorProtoPOJO>();
        ret.enumTypes = new ArrayList<EnumDescriptorProtoPOJO>();
        ret.extensionRanges = new ArrayList<ExtensionRangePOJO>();
        ret.extensions = new ArrayList<FieldDescriptorProtoPOJO>();
        ret.options = new ArrayList<MessageOptionsPOJO>();
        List fields = typeElement.getFields();
        if (fields != null) {
            for (MessageType.Field fieldElement : fields) {
                FieldDescriptorProtoPOJO fieldDescriptorProto = new FieldDescriptorProtoPOJO();
                fieldDescriptorProto.name = fieldElement.getName();
                fieldDescriptorProto.extendee = null;
                fieldDescriptorProto.number = fieldElement.getTag();
                MessageType.Label label = fieldElement.getLabel();
                if (label == MessageType.Label.OPTIONAL) {
                    fieldDescriptorProto.label = Label.LABEL_OPTIONAL;
                } else if (label == MessageType.Label.REQUIRED) {
                    fieldDescriptorProto.label = Label.LABEL_REQUIRED;
                } else if (label == MessageType.Label.REPEATED) {
                    fieldDescriptorProto.label = Label.LABEL_REPEATED;
                }
                String type = fieldElement.getType();
                fieldDescriptorProto.defaultValue = fieldElement.getDefault();
                try {
                    fieldDescriptorProto.type = Type.valueOf("TYPE_" + type.toUpperCase());
                }
                catch (Exception e) {
                    fieldDescriptorProto.type = messageSet.contains(type) ? Type.TYPE_MESSAGE : Type.TYPE_ENUM;
                    fieldDescriptorProto.typeName = "." + fileDescriptorProto.pkg + "." + type;
                }
                ret.fields.add(fieldDescriptorProto);
            }
        }
        if ((nestedElements = typeElement.getNestedTypes()) != null) {
            for (com.squareup.protoparser.Type nestedTypeElement : nestedElements) {
                if (nestedTypeElement instanceof MessageType) {
                    ret.nestedTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, (MessageType)nestedTypeElement, messageSet, enumSet));
                    continue;
                }
                ret.enumTypes.add(CodedConstant.getDescritorProtoPOJO(fileDescriptorProto, (EnumType)nestedTypeElement, messageSet, enumSet));
            }
        }
        return ret;
    }

    private static EnumDescriptorProtoPOJO getDescritorProtoPOJO(FileDescriptorProtoPOJO fileDescriptorProto, EnumType typeElement, Set<String> messageSet, Set<String> enumSet) {
        List options;
        EnumDescriptorProtoPOJO ret = new EnumDescriptorProtoPOJO();
        ret.name = typeElement.getName();
        ret.values = new ArrayList<EnumValueDescriptorProtoPOJO>();
        ret.options = new ArrayList<EnumOptionsPOJO>();
        List values = typeElement.getValues();
        if (values != null) {
            for (EnumType.Value fieldElement : values) {
                EnumValueDescriptorProtoPOJO fieldDescriptorProto = new EnumValueDescriptorProtoPOJO();
                fieldDescriptorProto.name = fieldElement.getName();
                fieldDescriptorProto.number = fieldElement.getTag();
                ret.values.add(fieldDescriptorProto);
            }
        }
        if ((options = typeElement.getOptions()) != null) {
            for (Option option : options) {
                EnumOptionsPOJO fieldDescriptorProto = new EnumOptionsPOJO();
                ret.options.add(fieldDescriptorProto);
            }
        }
        return ret;
    }

    private static List<Integer> convertList(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(list.size());
        for (String v : list) {
            ret.add(StringUtils.toInt(v));
        }
        return ret;
    }
}

