/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils;

import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.annotation.Packed;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ProtobufProxyUtils {
    public static final Map<Class<?>, FieldType> TYPE_MAPPING;
    private static final Logger LOGGER;

    public static boolean isScalarType(Class<?> cls) {
        return TYPE_MAPPING.containsKey(cls);
    }

    public static List<FieldInfo> processDefaultValue(List<Field> fields, boolean ignoreNoAnnotation) {
        if (fields == null) {
            return null;
        }
        ArrayList<FieldInfo> ret = new ArrayList<FieldInfo>(fields.size());
        int maxOrder = 0;
        ArrayList<FieldInfo> unorderFields = new ArrayList<FieldInfo>(fields.size());
        HashSet<Integer> orders = new HashSet<Integer>();
        for (Field field : fields) {
            Protobuf protobuf = field.getAnnotation(Protobuf.class);
            if (protobuf == null && !ignoreNoAnnotation) {
                throw new RuntimeException("Field '" + field.getName() + "' has no @Protobuf annotation");
            }
            String simpleName = field.getType().getName();
            if (simpleName.startsWith("[") && !simpleName.equals(byte[].class.getName()) && !simpleName.equals(Byte[].class.getName())) {
                throw new RuntimeException("Array type of field '" + field.getName() + "' on class '" + field.getDeclaringClass().getName() + "' is not support,  please use List instead.");
            }
            FieldInfo fieldInfo = new FieldInfo(field);
            FieldType annFieldType = FieldType.DEFAULT;
            int order = -1;
            if (protobuf != null) {
                fieldInfo.setRequired(protobuf.required());
                fieldInfo.setDescription(protobuf.description());
                annFieldType = protobuf.fieldType();
                order = protobuf.order();
            } else {
                fieldInfo.setRequired(false);
            }
            if (annFieldType == FieldType.DEFAULT) {
                FieldType fieldType;
                Class<?> fieldTypeClass = field.getType();
                boolean isList = fieldInfo.isList();
                if (isList) {
                    fieldTypeClass = fieldInfo.getGenericKeyType();
                }
                if ((fieldType = TYPE_MAPPING.get(fieldTypeClass)) == null) {
                    fieldType = Enum.class.isAssignableFrom(fieldTypeClass) ? FieldType.ENUM : FieldType.OBJECT;
                }
                fieldInfo.setFieldType(fieldType);
            } else {
                fieldInfo.setFieldType(annFieldType);
            }
            if (order > 0) {
                if (orders.contains(order)) {
                    throw new RuntimeException("order id '" + order + "' from field name '" + field.getName() + "'  is duplicate");
                }
                orders.add(order);
                fieldInfo.setOrder(order);
                if (order > maxOrder) {
                    maxOrder = order;
                }
            } else {
                unorderFields.add(fieldInfo);
            }
            if (fieldInfo.isList() && fieldInfo.getFieldType().isPrimitive()) {
                Packed packed = field.getAnnotation(Packed.class);
                if (packed == null) {
                    fieldInfo.setPacked(true);
                } else {
                    fieldInfo.setPacked(packed.value());
                }
            }
            ret.add(fieldInfo);
        }
        if (unorderFields.isEmpty()) {
            return ret;
        }
        for (FieldInfo fieldInfo : unorderFields) {
            fieldInfo.setOrder(++maxOrder);
            LOGGER.warning("Field '" + fieldInfo.getField().getName() + "' from " + fieldInfo.getField().getDeclaringClass().getName() + " with @Protobuf annotation but not set order or order is 0," + " It will set order value to " + maxOrder);
        }
        return ret;
    }

    public static boolean isObjectType(Class<?> cls) {
        FieldType fieldType = TYPE_MAPPING.get(cls);
        return fieldType == null;
    }

    public static String processProtobufType(Class<?> cls) {
        FieldType fieldType = TYPE_MAPPING.get(cls);
        if (fieldType != null) {
            return fieldType.getType();
        }
        return cls.getSimpleName();
    }

    static {
        LOGGER = Logger.getLogger(ProtobufProxy.class.getName());
        TYPE_MAPPING = new HashMap();
        TYPE_MAPPING.put(Integer.TYPE, FieldType.INT32);
        TYPE_MAPPING.put(Integer.class, FieldType.INT32);
        TYPE_MAPPING.put(Short.TYPE, FieldType.INT32);
        TYPE_MAPPING.put(Short.class, FieldType.INT32);
        TYPE_MAPPING.put(Byte.class, FieldType.INT32);
        TYPE_MAPPING.put(Byte.TYPE, FieldType.INT32);
        TYPE_MAPPING.put(Long.TYPE, FieldType.INT64);
        TYPE_MAPPING.put(Long.class, FieldType.INT64);
        TYPE_MAPPING.put(String.class, FieldType.STRING);
        TYPE_MAPPING.put(byte[].class, FieldType.BYTES);
        TYPE_MAPPING.put(Byte[].class, FieldType.BYTES);
        TYPE_MAPPING.put(Float.class, FieldType.FLOAT);
        TYPE_MAPPING.put(Float.TYPE, FieldType.FLOAT);
        TYPE_MAPPING.put(Double.TYPE, FieldType.DOUBLE);
        TYPE_MAPPING.put(Double.class, FieldType.DOUBLE);
        TYPE_MAPPING.put(Boolean.class, FieldType.BOOL);
        TYPE_MAPPING.put(Boolean.TYPE, FieldType.BOOL);
    }
}

