/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.IDLProxyObject;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.utils.CodePrinter;
import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.JavaStyleFormatter;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.baidu.jprotobuf.com.squareup.protoparser.DataType;
import com.baidu.jprotobuf.com.squareup.protoparser.EnumConstantElement;
import com.baidu.jprotobuf.com.squareup.protoparser.EnumElement;
import com.baidu.jprotobuf.com.squareup.protoparser.FieldElement;
import com.baidu.jprotobuf.com.squareup.protoparser.MessageElement;
import com.baidu.jprotobuf.com.squareup.protoparser.OptionElement;
import com.baidu.jprotobuf.com.squareup.protoparser.ProtoFile;
import com.baidu.jprotobuf.com.squareup.protoparser.ProtoParser;
import com.baidu.jprotobuf.com.squareup.protoparser.TypeElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ProtobufIDLProxy {
    private static boolean formatJavaField = false;
    private static final char PACKAGE_SPLIT_CHAR = '.';
    private static final String PACKAGE_SPLIT = ".";
    private static final String UTF_8 = "utf-8";
    private static final String JAVA_OUTER_CLASSNAME_OPTION = "java_outer_classname";
    private static final String JAVA_PACKAGE_OPTION = "java_package";
    private static final String CODE_END = ";\n";
    public static final String DEFAULT_FILE_NAME = "jprotobuf_autogenerate";
    private static final Map<String, FieldType> typeMapping = new HashMap<String, FieldType>();
    private static final Map<String, String> fieldTypeMapping;
    private static final String DEFAULT_SUFFIX_CLASSNAME = "JProtoBufProtoClass";

    public static void setFormatJavaField(boolean needFormatJavaField) {
        formatJavaField = needFormatJavaField;
    }

    private static Class checkClass(ProtoFile protoFile, TypeElement type, Map<String, String> mappedUniName, boolean isUniName) {
        String packageName = protoFile.packageName();
        String defaultClsName = type.name();
        List options = protoFile.options();
        if (options != null) {
            for (OptionElement option : options) {
                if (option.name().equals(JAVA_PACKAGE_OPTION)) {
                    packageName = option.value().toString();
                    continue;
                }
                if (!option.name().equals(JAVA_OUTER_CLASSNAME_OPTION)) continue;
                defaultClsName = option.value().toString();
            }
        }
        String simpleName = ProtobufIDLProxy.getProxyClassName(defaultClsName, mappedUniName, isUniName);
        String className = packageName + '.' + simpleName;
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            c = null;
        }
        return c;
    }

    private static Class checkClass(String packageName, TypeElement type, Map<String, String> mappedUniName, boolean isUniName) {
        String simpleName = ProtobufIDLProxy.getProxyClassName(type.name(), mappedUniName, isUniName);
        String className = packageName + '.' + simpleName;
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            c = null;
        }
        return c;
    }

    protected static void checkDirectory(boolean generateSouceOnly, File sourceOutputDir) {
        if (generateSouceOnly) {
            if (sourceOutputDir == null) {
                throw new RuntimeException("param 'sourceOutputDir' is null.");
            }
            if (!sourceOutputDir.isDirectory()) {
                throw new RuntimeException("param 'sourceOutputDir' should be a exist file directory.");
            }
        }
    }

    public static Map<String, IDLProxyObject> create(File file) throws IOException {
        return ProtobufIDLProxy.create(file, false, null, true);
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug, boolean isUniName) throws IOException {
        return ProtobufIDLProxy.create(file, debug, isUniName);
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug) throws IOException {
        return ProtobufIDLProxy.create(file, debug, null);
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug, File path) throws IOException {
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        return ProtobufIDLProxy.create(file, debug, path, cds, new HashSet<String>());
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug, File path, boolean isUniName) throws IOException {
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        return ProtobufIDLProxy.create(file, debug, path, cds, new HashSet<String>(), isUniName);
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug, File path, List<CodeDependent> cds, Set<String> compiledClass) throws IOException {
        return ProtobufIDLProxy.create(file, debug, path, cds, compiledClass, true);
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug, File path, List<CodeDependent> cds, Set<String> compiledClass, boolean isUniName) throws IOException {
        return ProtobufIDLProxy.doCreatePro(file, true, debug, path, false, null, cds, compiledClass, new HashMap<String, String>(), isUniName);
    }

    public static Map<String, IDLProxyObject> create(InputStream is) throws IOException {
        return ProtobufIDLProxy.create(is, false);
    }

    public static Map<String, IDLProxyObject> create(InputStream is, boolean debug) throws IOException {
        return ProtobufIDLProxy.create(is, debug, null, true);
    }

    public static Map<String, IDLProxyObject> create(InputStream is, boolean debug, boolean isUniName) throws IOException {
        return ProtobufIDLProxy.create(is, debug, null, isUniName);
    }

    public static Map<String, IDLProxyObject> create(InputStream is, boolean debug, File path) throws IOException {
        return ProtobufIDLProxy.create(is, debug, path, true);
    }

    public static Map<String, IDLProxyObject> create(InputStream is, boolean debug, File path, boolean isUniName) throws IOException {
        ProtoFile protoFile = ProtoParser.parseUtf8((String)DEFAULT_FILE_NAME, (InputStream)is);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        return ProtobufIDLProxy.doCreate(protoFile, true, debug, path, false, null, cds, new HashMap<String, String>(), isUniName);
    }

    public static Map<String, IDLProxyObject> create(Reader reader) throws IOException {
        return ProtobufIDLProxy.create(reader, false);
    }

    public static Map<String, IDLProxyObject> create(Reader reader, boolean debug) throws IOException {
        return ProtobufIDLProxy.create(reader, debug, null, true);
    }

    public static Map<String, IDLProxyObject> create(Reader reader, boolean debug, boolean isUniName) throws IOException {
        return ProtobufIDLProxy.create(reader, debug, null, isUniName);
    }

    public static Map<String, IDLProxyObject> create(Reader reader, boolean debug, File path) throws IOException {
        return ProtobufIDLProxy.create(reader, debug, path, true);
    }

    public static Map<String, IDLProxyObject> create(Reader reader, boolean debug, File path, boolean isUniName) throws IOException {
        ProtoFile protoFile = ProtoParser.parse((String)DEFAULT_FILE_NAME, (Reader)reader);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        return ProtobufIDLProxy.doCreate(protoFile, true, debug, path, false, null, cds, new HashMap<String, String>(), isUniName);
    }

    public static Map<String, IDLProxyObject> create(String data) {
        return ProtobufIDLProxy.create(data, false);
    }

    public static Map<String, IDLProxyObject> create(String data, boolean debug) {
        return ProtobufIDLProxy.create(data, debug, null, true);
    }

    public static Map<String, IDLProxyObject> create(String data, boolean debug, boolean isUniName) {
        return ProtobufIDLProxy.create(data, debug, null, isUniName);
    }

    public static Map<String, IDLProxyObject> create(String data, boolean debug, File path) {
        return ProtobufIDLProxy.create(data, debug, path, true);
    }

    public static Map<String, IDLProxyObject> create(String data, boolean debug, File path, boolean isUniName) {
        ProtoFile protoFile = ProtoParser.parse((String)DEFAULT_FILE_NAME, (String)data);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        try {
            return ProtobufIDLProxy.doCreate(protoFile, true, debug, path, false, null, cds, new HashMap<String, String>(), isUniName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static CodeDependent createCodeByType(EnumElement type, boolean topLevelClass, String packageName, Map<String, String> mappedUniName, boolean isUniName) {
        CodeDependent cd = new CodeDependent();
        String defaultClsName = type.name();
        String simpleName = ProtobufIDLProxy.getProxyClassName(defaultClsName, mappedUniName, isUniName);
        StringBuilder code = new StringBuilder();
        if (topLevelClass) {
            code.append("package ").append(packageName).append(CODE_END);
            code.append("\n");
            code.append("import com.baidu.bjf.remoting.protobuf.EnumReadable;\n");
        }
        if (topLevelClass) {
            code.append("public enum ");
        } else {
            code.append("public static enum ");
        }
        code.append(simpleName).append(" implements EnumReadable {\n");
        Iterator iter = type.constants().iterator();
        while (iter.hasNext()) {
            EnumConstantElement value = (EnumConstantElement)iter.next();
            String name = value.name();
            int tag = value.tag();
            code.append(name).append("(").append(tag).append(")");
            if (iter.hasNext()) {
                code.append(",");
                continue;
            }
            code.append(CODE_END);
        }
        code.append("private final int value;\n");
        code.append(simpleName).append("(int value) { this.value = value;  }\n");
        code.append("public int value() { return value; }\n");
        code.append("}\n");
        cd.name = simpleName;
        cd.pkg = packageName;
        cd.code = code.toString();
        return cd;
    }

    private static CodeDependent createCodeByType(ProtoFile protoFile, MessageElement type, Set<String> enumNames, boolean topLevelClass, List<TypeElement> parentNestedTypes, List<CodeDependent> cds, Set<String> packages, Map<String, String> mappedUniName, boolean isUniName) {
        CodeDependent cd = new CodeDependent();
        String packageName = protoFile.packageName();
        String defaultClsName = type.name();
        List options = protoFile.options();
        if (options != null) {
            for (OptionElement option : options) {
                if (!option.name().equals(JAVA_PACKAGE_OPTION)) continue;
                packageName = option.value().toString();
            }
        }
        String simpleName = ProtobufIDLProxy.getProxyClassName(defaultClsName, mappedUniName, isUniName);
        StringBuilder code = new StringBuilder();
        if (topLevelClass) {
            if (!StringUtils.isEmpty(packageName)) {
                code.append("package ").append(packageName).append(CODE_END);
                code.append("\n");
            }
            code.append("import com.baidu.bjf.remoting.protobuf.FieldType;\n");
            code.append("import com.baidu.bjf.remoting.protobuf.EnumReadable;\n");
            code.append("import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;\n");
        }
        String clsName = topLevelClass ? "public class " : "public static class ";
        code.append(clsName).append(simpleName).append(" {\n");
        List fields = type.fields();
        List<TypeElement> nestedTypes = ProtobufIDLProxy.fetchAllNestedTypes(type);
        ArrayList<TypeElement> checkNestedTypes = new ArrayList<TypeElement>(nestedTypes);
        for (TypeElement t : nestedTypes) {
            if (t instanceof EnumElement) {
                enumNames.add(t.name());
                enumNames.add(t.qualifiedName());
                if (StringUtils.isEmpty(packageName)) continue;
                enumNames.add(StringUtils.removeStart(t.qualifiedName(), packageName + PACKAGE_SPLIT));
                continue;
            }
            checkNestedTypes.add(t);
        }
        checkNestedTypes.addAll(parentNestedTypes);
        for (FieldElement field : fields) {
            String javaType;
            ProtobufIDLProxy.generateProtobufDefinedForField(code, field, enumNames);
            DataType dataType = field.type();
            String typeName = dataType.kind() == DataType.Kind.MAP ? ProtobufIDLProxy.getTypeName(((DataType.MapType)dataType).keyType()) : ProtobufIDLProxy.getTypeName(field);
            FieldType fType = typeMapping.get(typeName);
            if (fType == null) {
                javaType = ProtobufIDLProxy.getProxyClassName(ProtobufIDLProxy.getTypeName(field), packages, mappedUniName, isUniName);
                if (!ProtobufIDLProxy.isNestedTypeDependency(javaType, checkNestedTypes, mappedUniName, isUniName)) {
                    cd.addDependency(javaType);
                }
            } else {
                javaType = fType.getJavaType();
            }
            if (dataType.kind() == DataType.Kind.MAP) {
                String valueJavaType;
                DataType.MapType mapType = (DataType.MapType)dataType;
                String keyType = mapType.keyType().toString();
                FieldType subType = typeMapping.get(keyType);
                String keyJavaType = subType == null ? keyType : subType.getJavaType();
                String valueType = mapType.valueType().toString();
                subType = typeMapping.get(valueType);
                if (subType == null) {
                    valueJavaType = ProtobufIDLProxy.getProxyClassName(valueType, packages, mappedUniName, isUniName);
                    if (!ProtobufIDLProxy.isNestedTypeDependency(valueJavaType, checkNestedTypes, mappedUniName, isUniName)) {
                        cd.addDependency(valueJavaType);
                    }
                } else {
                    valueJavaType = subType.getJavaType();
                }
                javaType = Map.class.getName() + "<" + keyJavaType + ", " + valueJavaType + ">";
            }
            if (FieldElement.Label.REPEATED == field.label()) {
                javaType = List.class.getName() + "<" + javaType + ">";
            }
            code.append("public ").append(javaType);
            String fieldName = field.name();
            if (formatJavaField) {
                fieldName = JavaStyleFormatter.formatJavaFieldName(fieldName);
            }
            code.append(" ").append(fieldName);
            OptionElement defaultOption = OptionElement.findByName((List)field.options(), (String)"default");
            if (defaultOption != null) {
                code.append("=");
                Object defaultValue = defaultOption.value();
                if (defaultOption.kind() == OptionElement.Kind.ENUM) {
                    code.append(javaType).append(PACKAGE_SPLIT).append(defaultValue);
                } else if (defaultOption.kind() == OptionElement.Kind.STRING) {
                    code.append("\"").append(defaultValue).append("\"");
                } else {
                    code.append(String.valueOf(defaultValue));
                }
            }
            code.append(CODE_END);
        }
        if (nestedTypes != null) {
            for (TypeElement t : nestedTypes) {
                CodeDependent nestedCd;
                String fqname = t.qualifiedName();
                if (!StringUtils.isEmpty(packageName)) {
                    fqname = StringUtils.removeStart(t.qualifiedName(), packageName + '.');
                }
                String subClsName = ProtobufIDLProxy.getProxyClassName(fqname, mappedUniName, isUniName);
                if (t instanceof EnumElement) {
                    nestedCd = ProtobufIDLProxy.createCodeByType((EnumElement)t, false, packageName, mappedUniName, isUniName);
                    enumNames.add(t.name());
                } else {
                    nestedCd = ProtobufIDLProxy.createCodeByType(protoFile, (MessageElement)t, enumNames, false, checkNestedTypes, cds, ProtobufIDLProxy.getPackages(cds), mappedUniName, isUniName);
                }
                nestedCd.addSubClass(subClsName);
                nestedCd.addSubClass(packageName + '.' + subClsName);
                code.append(nestedCd.code);
                cd.dependencies.addAll(nestedCd.dependencies);
                cd.subClasses.addAll(nestedCd.subClasses);
            }
        }
        code.append("}\n");
        cd.name = simpleName;
        cd.pkg = packageName;
        cd.code = code.toString();
        cd.dependencies.remove(cd.name);
        if (!parentNestedTypes.isEmpty()) {
            for (TypeElement t : checkNestedTypes) {
                Iterator iterator = cd.dependencies.iterator();
                while (iterator.hasNext()) {
                    String dependName = ((String)iterator.next()).replaceAll(DEFAULT_SUFFIX_CLASSNAME, "");
                    if (!t.qualifiedName().endsWith(dependName)) continue;
                    iterator.remove();
                }
            }
        }
        return cd;
    }

    private static List<Class<?>> createEnumClasses(Map<String, EnumElement> enumTypes, Map<String, String> packageMapping, boolean generateSouceOnly, File sourceOutputDir, Set<String> compiledClass, Map<String, String> mappedUniName, boolean isUniName) {
        ArrayList ret = new ArrayList();
        HashSet<String> enumNames = new HashSet<String>();
        Collection<EnumElement> enums = enumTypes.values();
        for (EnumElement enumType : enums) {
            String name = enumType.name();
            if (enumNames.contains(name)) continue;
            enumNames.add(name);
            String packageName = packageMapping.get(name);
            Class cls = ProtobufIDLProxy.checkClass(packageName, (TypeElement)enumType, mappedUniName, isUniName);
            if (cls != null) {
                ret.add(cls);
                continue;
            }
            CodeDependent codeDependent = ProtobufIDLProxy.createCodeByType(enumType, true, packageName, mappedUniName, isUniName);
            compiledClass.add(codeDependent.name);
            compiledClass.add(packageName + '.' + codeDependent.name);
            if (!generateSouceOnly) {
                Class<?> newClass = JDKCompilerHelper.getJdkCompiler().compile(codeDependent.getClassName(), codeDependent.code, ProtobufIDLProxy.class.getClassLoader(), null, -1L);
                ret.add(newClass);
                continue;
            }
            ProtobufIDLProxy.writeSourceCode(codeDependent, sourceOutputDir);
        }
        return ret;
    }

    private static List<Class<?>> createMessageClass(ProtoFile protoFile, boolean multi, boolean debug, boolean generateSouceOnly, File sourceOutputDir, List<CodeDependent> cds, Set<String> compiledClass, Set<String> enumNames, Set<String> packages, Map<String, String> mappedUniName, boolean isUniName) {
        CodeDependent codeDependent;
        List types = protoFile.typeElements();
        if (types == null || types.isEmpty()) {
            throw new RuntimeException("No message defined in '.proto' IDL");
        }
        int count = 0;
        for (TypeElement next : types) {
            if (next instanceof EnumElement) continue;
            ++count;
        }
        if (!multi && count != 1) {
            throw new RuntimeException("Only one message defined allowed in '.proto' IDL");
        }
        ArrayList ret = new ArrayList(types.size());
        ArrayList<MessageElement> messageTypes = new ArrayList<MessageElement>();
        for (TypeElement type : types) {
            Class checkClass = ProtobufIDLProxy.checkClass(protoFile, type, mappedUniName, isUniName);
            if (checkClass != null) {
                ret.add(checkClass);
                continue;
            }
            if (!(type instanceof MessageElement)) continue;
            messageTypes.add((MessageElement)type);
        }
        for (MessageElement mt : messageTypes) {
            CodeDependent cd = ProtobufIDLProxy.createCodeByType(protoFile, mt, enumNames, true, new ArrayList<TypeElement>(), cds, packages, mappedUniName, isUniName);
            if (cd.isDepndency()) {
                cds.add(cd);
                continue;
            }
            cds.add(0, cd);
        }
        ArrayList<CodeDependent> copiedCds = new ArrayList<CodeDependent>(cds);
        while ((codeDependent = ProtobufIDLProxy.hasDependency(copiedCds, compiledClass)) != null) {
            if (debug) {
                CodePrinter.printCode(codeDependent.code, "generate jprotobuf code");
            }
            if (!generateSouceOnly) {
                Class<?> newClass = JDKCompilerHelper.getJdkCompiler().compile(codeDependent.getClassName(), codeDependent.code, ProtobufIDLProxy.class.getClassLoader(), null, -1L);
                ret.add(newClass);
                continue;
            }
            ProtobufIDLProxy.writeSourceCode(codeDependent, sourceOutputDir);
        }
        return ret;
    }

    public static IDLProxyObject createSingle(InputStream is) throws IOException {
        return ProtobufIDLProxy.createSingle(is, false);
    }

    public static IDLProxyObject createSingle(InputStream is, boolean debug) throws IOException {
        return ProtobufIDLProxy.createSingle(is, debug, null, true);
    }

    public static IDLProxyObject createSingle(InputStream is, boolean debug, boolean isUniName) throws IOException {
        return ProtobufIDLProxy.createSingle(is, debug, null, isUniName);
    }

    public static IDLProxyObject createSingle(InputStream is, boolean debug, File path) throws IOException {
        return ProtobufIDLProxy.createSingle(is, debug, path, true);
    }

    public static IDLProxyObject createSingle(InputStream is, boolean debug, File path, boolean isUniName) throws IOException {
        ProtoFile protoFile = ProtoParser.parseUtf8((String)DEFAULT_FILE_NAME, (InputStream)is);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        Map<String, IDLProxyObject> map = ProtobufIDLProxy.doCreate(protoFile, false, debug, path, false, null, cds, new HashMap<String, String>(), isUniName);
        return map.entrySet().iterator().next().getValue();
    }

    public static IDLProxyObject createSingle(Reader reader) throws IOException {
        return ProtobufIDLProxy.createSingle(reader, false);
    }

    public static IDLProxyObject createSingle(Reader reader, boolean debug) throws IOException {
        return ProtobufIDLProxy.createSingle(reader, debug, null, true);
    }

    public static IDLProxyObject createSingle(Reader reader, boolean debug, boolean isUniName) throws IOException {
        return ProtobufIDLProxy.createSingle(reader, debug, null, isUniName);
    }

    public static IDLProxyObject createSingle(Reader reader, boolean debug, File path) throws IOException {
        return ProtobufIDLProxy.createSingle(reader, debug, path, true);
    }

    public static IDLProxyObject createSingle(Reader reader, boolean debug, File path, boolean isUniName) throws IOException {
        ProtoFile protoFile = ProtoParser.parse((String)DEFAULT_FILE_NAME, (Reader)reader);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        Map<String, IDLProxyObject> map = ProtobufIDLProxy.doCreate(protoFile, false, debug, path, false, null, cds, new HashMap<String, String>(), isUniName);
        return map.entrySet().iterator().next().getValue();
    }

    public static IDLProxyObject createSingle(String data) {
        return ProtobufIDLProxy.createSingle(data, false);
    }

    public static IDLProxyObject createSingle(String data, boolean debug) {
        return ProtobufIDLProxy.createSingle(data, debug, null, true);
    }

    public static IDLProxyObject createSingle(String data, boolean debug, boolean isUniName) {
        return ProtobufIDLProxy.createSingle(data, debug, null, isUniName);
    }

    public static IDLProxyObject createSingle(String data, boolean debug, File path) {
        return ProtobufIDLProxy.createSingle(data, debug, path, true);
    }

    public static IDLProxyObject createSingle(String data, boolean debug, File path, boolean isUniName) {
        ProtoFile protoFile = ProtoParser.parse((String)DEFAULT_FILE_NAME, (String)data);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        try {
            Map<String, IDLProxyObject> map = ProtobufIDLProxy.doCreate(protoFile, false, debug, path, false, null, cds, new HashMap<String, String>(), isUniName);
            return map.entrySet().iterator().next().getValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Map<String, IDLProxyObject> doCreate(ProtoFile protoFile, boolean multi, boolean debug, File path, boolean generateSouceOnly, File sourceOutputDir, List<CodeDependent> cds, Map<String, String> mappedUniName, boolean isUniName) throws IOException {
        return ProtobufIDLProxy.doCreatePro(Arrays.asList(protoFile), multi, debug, path, generateSouceOnly, sourceOutputDir, cds, new HashSet<String>(), mappedUniName, isUniName);
    }

    private static Map<String, IDLProxyObject> doCreatePro(File file, boolean multi, boolean debug, File path, boolean generateSouceOnly, File sourceOutputDir, List<CodeDependent> cds, Set<String> compiledClass, Map<String, String> mappedUniName, boolean isUniName) throws IOException {
        ProtobufIDLProxy.checkDirectory(generateSouceOnly, sourceOutputDir);
        List<ProtoFile> protoFiles = ProtobufIDLProxy.findRelateProtoFiles(file, new HashSet<String>());
        Collections.reverse(protoFiles);
        return ProtobufIDLProxy.doCreatePro(protoFiles, multi, debug, path, generateSouceOnly, sourceOutputDir, cds, compiledClass, mappedUniName, isUniName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, IDLProxyObject> doCreatePro(List<ProtoFile> protoFiles, boolean multi, boolean debug, File path, boolean generateSouceOnly, File sourceOutputDir, List<CodeDependent> cds, Set<String> compiledClass, Map<String, String> mappedUniName, boolean isUniName) throws IOException {
        int count = 0;
        HashMap<String, EnumElement> enumTypes = new HashMap<String, EnumElement>();
        HashMap<String, String> packageMapping = new HashMap<String, String>();
        HashSet<String> packages = new HashSet<String>();
        for (ProtoFile protoFile : protoFiles) {
            List types = protoFile.typeElements();
            if (types == null || types.isEmpty()) continue;
            String packageName = protoFile.packageName();
            List options = protoFile.options();
            if (options != null) {
                for (OptionElement option : options) {
                    if (!option.name().equals(JAVA_PACKAGE_OPTION)) continue;
                    packageName = option.value().toString();
                }
            }
            packages.add(packageName);
            for (TypeElement type : types) {
                packageMapping.put(type.name(), packageName);
                packageMapping.put(type.qualifiedName(), packageName);
                if (type instanceof MessageElement) {
                    ++count;
                    continue;
                }
                enumTypes.put(type.name(), (EnumElement)type);
                enumTypes.put(type.qualifiedName(), (EnumElement)type);
            }
        }
        if (!multi && count != 1) {
            throw new RuntimeException("Only one message defined allowed in '.proto' IDL");
        }
        List<Class<?>> clsList = ProtobufIDLProxy.createEnumClasses(enumTypes, packageMapping, generateSouceOnly, sourceOutputDir, compiledClass, mappedUniName, isUniName);
        for (ProtoFile protoFile : protoFiles) {
            List<Class<?>> messageClasses = ProtobufIDLProxy.createMessageClass(protoFile, multi, debug, generateSouceOnly, sourceOutputDir, cds, compiledClass, new HashSet<String>(enumTypes.keySet()), packages, mappedUniName, isUniName);
            clsList.addAll(messageClasses);
        }
        HashMap<String, IDLProxyObject> hashMap = new HashMap<String, IDLProxyObject>();
        for (Class<?> cls : clsList) {
            Object newInstance;
            try {
                if (Enum.class.isAssignableFrom(cls)) continue;
                newInstance = cls.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            ProtobufProxy.enableCache(false);
            try {
                Codec<?> codec = ProtobufProxy.create(cls, debug, path);
                IDLProxyObject idlProxyObject = new IDLProxyObject(codec, newInstance, cls);
                String name = cls.getSimpleName();
                if (name.indexOf(DEFAULT_SUFFIX_CLASSNAME) != -1) {
                    name = StringUtils.substringBefore(name, DEFAULT_SUFFIX_CLASSNAME);
                }
                hashMap.put(name, idlProxyObject);
            }
            finally {
                ProtobufProxy.enableCache(true);
            }
        }
        return hashMap;
    }

    private static List<TypeElement> fetchAllNestedTypes(MessageElement type) {
        ArrayList<TypeElement> ret = new ArrayList<TypeElement>();
        List nestedTypes = type.nestedElements();
        ret.addAll(nestedTypes);
        for (TypeElement t : nestedTypes) {
            if (!(t instanceof MessageElement)) continue;
            List<TypeElement> subNestedTypes = ProtobufIDLProxy.fetchAllNestedTypes((MessageElement)t);
            ret.addAll(subNestedTypes);
        }
        return ret;
    }

    private static List<ProtoFile> findRelateProtoFiles(File file, Set<String> dependencyNames) throws IOException {
        List publicDependencies;
        LinkedList<ProtoFile> protoFiles = new LinkedList<ProtoFile>();
        ProtoFile protoFile = ProtoParser.parseUtf8((File)file);
        protoFiles.addFirst(protoFile);
        String parent = file.getParent();
        List dependencies = protoFile.dependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (String fn : dependencies) {
                if (dependencyNames.contains(fn)) continue;
                File dependencyFile = new File(parent, fn);
                protoFiles.addAll(ProtobufIDLProxy.findRelateProtoFiles(dependencyFile, dependencyNames));
            }
        }
        if ((publicDependencies = protoFile.publicDependencies()) != null && !publicDependencies.isEmpty()) {
            for (String fn : publicDependencies) {
                if (dependencyNames.contains(fn)) continue;
                File dependencyFile = new File(parent, fn);
                protoFiles.addAll(ProtobufIDLProxy.findRelateProtoFiles(dependencyFile, dependencyNames));
            }
        }
        return protoFiles;
    }

    private static void generateProtobufDefinedForField(StringBuilder code, FieldElement field, Set<String> enumNames) {
        code.append("@").append(Protobuf.class.getSimpleName()).append("(");
        String fieldType = fieldTypeMapping.get(ProtobufIDLProxy.getTypeName(field));
        if (fieldType == null) {
            fieldType = enumNames.contains(ProtobufIDLProxy.getTypeName(field)) ? "FieldType.ENUM" : (field.type().kind() == DataType.Kind.MAP ? "FieldType.MAP" : "FieldType.OBJECT");
        }
        code.append("fieldType=").append(fieldType);
        code.append(", order=").append(field.tag());
        if (FieldElement.Label.OPTIONAL == field.label()) {
            code.append(", required=false");
        } else if (FieldElement.Label.REQUIRED == field.label()) {
            code.append(", required=true");
        }
        code.append(")\n");
    }

    public static void generateSource(File file, File sourceOutputPath) throws IOException {
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        ProtobufIDLProxy.generateSource(file, sourceOutputPath, cds, new HashSet<String>());
    }

    public static void generateSource(File file, File sourceOutputPath, List<CodeDependent> cds, Set<String> compiledClass) throws IOException {
        ProtobufIDLProxy.doCreatePro(file, true, false, null, true, sourceOutputPath, cds, compiledClass, new HashMap<String, String>(), false);
    }

    public static void generateSource(InputStream is, File sourceOutputPath) throws IOException {
        ProtoFile protoFile = ProtoParser.parseUtf8((String)DEFAULT_FILE_NAME, (InputStream)is);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        ProtobufIDLProxy.doCreate(protoFile, true, false, null, true, sourceOutputPath, cds, new HashMap<String, String>(), false);
    }

    public static void generateSource(Reader reader, File sourceOutputPath) throws IOException {
        ProtoFile protoFile = ProtoParser.parse((String)DEFAULT_FILE_NAME, (Reader)reader);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        ProtobufIDLProxy.doCreate(protoFile, true, false, null, true, sourceOutputPath, cds, new HashMap<String, String>(), false);
    }

    public static void generateSource(String data, File sourceOutputPath) {
        ProtoFile protoFile = ProtoParser.parse((String)DEFAULT_FILE_NAME, (String)data);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        try {
            ProtobufIDLProxy.doCreate(protoFile, true, false, null, true, sourceOutputPath, cds, new HashMap<String, String>(), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Set<String> getPackages(List<CodeDependent> cds) {
        HashSet<String> ret = new HashSet<String>();
        if (cds == null) {
            return ret;
        }
        for (CodeDependent cd : cds) {
            ret.add(cd.pkg);
        }
        return ret;
    }

    private static String getProxyClassName(String name, Map<String, String> mappedUniName, boolean isUniName) {
        Set<String> emptyPkgs = Collections.emptySet();
        return ProtobufIDLProxy.getProxyClassName(name, emptyPkgs, mappedUniName, isUniName);
    }

    private static String getProxyClassName(String name, Set<String> pkgs, Map<String, String> mappedUniName, boolean isUniName) {
        String ret = "";
        if (name.indexOf(46) != -1) {
            String[] split = name.split("\\.");
            boolean classFound = false;
            for (String string : split) {
                if (pkgs.contains(string) && !classFound) {
                    ret = ret + string + '.';
                    continue;
                }
                classFound = true;
                ret = ret + ProtobufIDLProxy.getProxyClassName(string, mappedUniName, isUniName) + '.';
            }
            ret = StringUtils.removeEnd(ret, PACKAGE_SPLIT);
        } else {
            String clsName = name;
            String uniName = mappedUniName.get(clsName);
            if (uniName == null) {
                uniName = clsName + ProtobufIDLProxy.getUniNameSuffix(isUniName);
                mappedUniName.put(clsName, uniName);
            }
            ret = clsName = uniName;
        }
        return ret;
    }

    private static String getTypeName(DataType type) {
        return type.toString();
    }

    private static String getTypeName(FieldElement field) {
        DataType type = field.type();
        return type.toString();
    }

    private static String getUniNameSuffix(boolean uniName) {
        if (!uniName) {
            return "";
        }
        return DEFAULT_SUFFIX_CLASSNAME + UUID.randomUUID().toString().replace("-", "");
    }

    private static CodeDependent hasDependency(List<CodeDependent> cds, Set<String> compiledClass) {
        if (cds.isEmpty()) {
            return null;
        }
        Iterator<CodeDependent> iterator = cds.iterator();
        while (iterator.hasNext()) {
            CodeDependent next = iterator.next();
            compiledClass.addAll(next.subClasses);
            if (!next.isDepndency()) {
                compiledClass.add(next.name);
                compiledClass.add(next.pkg + '.' + next.name);
                iterator.remove();
                return next;
            }
            Set dependencies = next.dependencies;
            if (!compiledClass.containsAll(dependencies)) continue;
            compiledClass.add(next.name);
            compiledClass.add(next.pkg + '.' + next.name);
            iterator.remove();
            return next;
        }
        HashSet<String> guessLoadedClass = new HashSet<String>(compiledClass);
        if (!cds.isEmpty()) {
            for (CodeDependent codeDependent : cds) {
                guessLoadedClass.add(codeDependent.name);
            }
            for (CodeDependent next : cds) {
                if (!next.isDepndency() || guessLoadedClass.containsAll(next.dependencies)) continue;
                for (String dependClass : next.dependencies) {
                    if (guessLoadedClass.contains(dependClass)) continue;
                    throw new RuntimeException("Message '" + StringUtils.removeEnd(next.name, DEFAULT_SUFFIX_CLASSNAME) + "' depend on message '" + dependClass.replace(DEFAULT_SUFFIX_CLASSNAME, "") + "' is missed");
                }
            }
        }
        return null;
    }

    private static boolean isNestedTypeDependency(String type, List<TypeElement> nestedTypes, Map<String, String> mappedUniName, boolean isUniName) {
        if (nestedTypes == null) {
            return false;
        }
        for (TypeElement t : nestedTypes) {
            if (!type.equals(t.name()) && !type.equals(ProtobufIDLProxy.getProxyClassName(t.name(), mappedUniName, isUniName))) continue;
            return true;
        }
        return false;
    }

    private static void writeSourceCode(CodeDependent cd, File sourceOutputDir) {
        if (cd.pkg == null) {
            cd.pkg = "";
        }
        String dir = sourceOutputDir + File.separator + cd.pkg.replace('.', File.separatorChar);
        File f = new File(dir);
        f.mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(f, cd.name + ".java"));
            fos.write(cd.code.getBytes(UTF_8));
            fos.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
    }

    static {
        typeMapping.put("double", FieldType.DOUBLE);
        typeMapping.put("float", FieldType.FLOAT);
        typeMapping.put("int64", FieldType.INT64);
        typeMapping.put("uint64", FieldType.UINT64);
        typeMapping.put("int32", FieldType.INT32);
        typeMapping.put("fixed64", FieldType.FIXED64);
        typeMapping.put("fixed32", FieldType.FIXED32);
        typeMapping.put("bool", FieldType.BOOL);
        typeMapping.put("string", FieldType.STRING);
        typeMapping.put("bytes", FieldType.BYTES);
        typeMapping.put("uint32", FieldType.UINT32);
        typeMapping.put("sfixed32", FieldType.SFIXED32);
        typeMapping.put("sfixed64", FieldType.SFIXED64);
        typeMapping.put("sint64", FieldType.SINT64);
        typeMapping.put("sint32", FieldType.SINT32);
        fieldTypeMapping = new HashMap<String, String>();
        fieldTypeMapping.put("double", "FieldType.DOUBLE");
        fieldTypeMapping.put("float", "FieldType.FLOAT");
        fieldTypeMapping.put("int64", "FieldType.INT64");
        fieldTypeMapping.put("uint64", "FieldType.UINT64");
        fieldTypeMapping.put("int32", "FieldType.INT32");
        fieldTypeMapping.put("fixed64", "FieldType.FIXED64");
        fieldTypeMapping.put("fixed32", "FieldType.FIXED32");
        fieldTypeMapping.put("bool", "FieldType.BOOL");
        fieldTypeMapping.put("string", "FieldType.STRING");
        fieldTypeMapping.put("bytes", "FieldType.BYTES");
        fieldTypeMapping.put("uint32", "FieldType.UINT32");
        fieldTypeMapping.put("sfixed32", "FieldType.SFIXED32");
        fieldTypeMapping.put("sfixed64", "FieldType.SFIXED64");
        fieldTypeMapping.put("sint64", "FieldType.SINT64");
        fieldTypeMapping.put("sint32", "FieldType.SINT32");
        fieldTypeMapping.put("enum", "FieldType.ENUM");
    }

    private static class CodeDependent {
        private String name;
        private String pkg;
        private Set<String> dependencies = new HashSet<String>();
        private String code;
        private Set<String> subClasses = new HashSet<String>();

        private CodeDependent() {
        }

        private void addDependency(String name) {
            this.dependencies.add(name);
        }

        private void addSubClass(String name) {
            this.subClasses.add(name);
        }

        public String getClassName() {
            if (StringUtils.isEmpty(this.pkg)) {
                return this.name;
            }
            return this.pkg + '.' + this.name;
        }

        private boolean isDepndency() {
            return !this.dependencies.isEmpty();
        }
    }
}

