/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.code;

import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.annotation.EnableZigZap;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.baidu.bjf.remoting.protobuf.code.CodedConstant;
import com.baidu.bjf.remoting.protobuf.code.ICodeGenerator;
import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.FieldInfo;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.ProtobufProxyUtils;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.google.protobuf.Descriptors;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CodeGenerator
implements ICodeGenerator {
    public static final String LINE_BREAK = "\n";
    public static final String JAVA_END = ";";
    public static final String JAVA_LINE_BREAK = ";\n";
    private static final String DEFAULT_SUFFIX_CLASSNAME = "$$JProtoBufClass";
    public static final String PACKAGE_SPLIT = ".";
    public static final String CLASS_JOINER = "$";
    public static final String JAVA_CLASS_FILE_SUFFIX = ".class";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CodeGenerator.class.getName());
    private List<FieldInfo> fields;
    private boolean debug = false;
    private File outputPath;
    private Set<Class<?>> relativeProxyClasses = new HashSet();
    private Class<?> cls;

    @Override
    public Set<Class<?>> getRelativeProxyClasses() {
        return this.relativeProxyClasses;
    }

    @Override
    public void setOutputPath(File outputPath) {
        this.outputPath = outputPath;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public CodeGenerator(Class<?> cls) {
        this.cls = cls;
    }

    @Override
    public String getClassName() {
        return ClassHelper.getClassName(this.cls) + DEFAULT_SUFFIX_CLASSNAME;
    }

    @Override
    public String getPackage() {
        return ClassHelper.getPackage(this.cls);
    }

    @Override
    public String getFullClassName() {
        return this.getPackage() + PACKAGE_SPLIT + this.getClassName();
    }

    private void genPackageCode(StringBuilder code) {
        if (this.getPackage().length() > 0) {
            code.append("package " + this.getPackage() + JAVA_LINE_BREAK);
        }
    }

    @Override
    public String getCode() {
        if (this.fields == null) {
            this.fields = this.fetchFieldInfos();
        }
        StringBuilder code = new StringBuilder();
        String className = this.getClassName();
        this.genPackageCode(code);
        this.genImportCode(code);
        code.append("public class " + className + " implements com.baidu.bjf.remoting.protobuf.Codec");
        code.append("<").append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append("> {\n");
        String descriptorClsName = ClassHelper.getInternalName(Descriptors.Descriptor.class.getCanonicalName());
        code.append("private ").append(descriptorClsName).append(" descriptor").append(JAVA_LINE_BREAK);
        code.append(this.getEncodeMethodCode());
        code.append(this.getDecodeMethodCode());
        code.append(this.getSizeMethodCode());
        code.append(this.getWriteToMethodCode());
        code.append(this.getReadFromMethodCode());
        code.append(this.getGetDescriptorMethodCode());
        code.append("}");
        return code.toString();
    }

    protected List<FieldInfo> fetchFieldInfos() {
        ProtobufClass annotation = this.cls.getAnnotation(ProtobufClass.class);
        EnableZigZap zipZap = this.cls.getAnnotation(EnableZigZap.class);
        boolean isZipZap = false;
        if (zipZap != null) {
            isZipZap = true;
        }
        boolean typeDefined = false;
        List<Field> fields = null;
        if (annotation == null) {
            fields = FieldUtils.findMatchedFields(this.cls, Protobuf.class);
            if (fields.isEmpty()) {
                throw new IllegalArgumentException("Invalid class [" + this.cls.getName() + "] no field use annotation @" + Protobuf.class.getName() + " at class " + this.cls.getName());
            }
        } else {
            typeDefined = true;
            fields = FieldUtils.findMatchedFields(this.cls, null);
        }
        List<FieldInfo> fieldInfos = ProtobufProxyUtils.processDefaultValue(fields, typeDefined, isZipZap);
        return fieldInfos;
    }

    private void genImportCode(StringBuilder code) {
        code.append("import com.google.protobuf.*").append(JAVA_LINE_BREAK);
        code.append("import java.io.IOException").append(JAVA_LINE_BREAK);
        code.append("import com.baidu.bjf.remoting.protobuf.utils.*").append(JAVA_LINE_BREAK);
        code.append("import com.baidu.bjf.remoting.protobuf.code.*").append(JAVA_LINE_BREAK);
        code.append("import java.lang.reflect.*").append(JAVA_LINE_BREAK);
        code.append("import com.baidu.bjf.remoting.protobuf.*").append(JAVA_LINE_BREAK);
        code.append("import java.util.*").append(JAVA_LINE_BREAK);
        if (!StringUtils.isEmpty(this.getPackage())) {
            code.append("import ").append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append(JAVA_LINE_BREAK);
        }
    }

    private void getParseBytesMethodCode(StringBuilder code) {
        boolean isList;
        code.append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append(" ret = new ");
        code.append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append("();\n");
        for (FieldInfo field : this.fields) {
            isList = field.isList();
            if (field.getFieldType() != FieldType.ENUM) continue;
            String clsName = ClassHelper.getInternalName(field.getField().getType().getCanonicalName());
            if (isList) continue;
            String express = "CodedConstant.getEnumValue(" + clsName + ".class, " + clsName + ".values()[0].name())";
            code.append(this.getSetToField("ret", field.getField(), this.cls, express, isList, field.isMap(), false)).append(JAVA_LINE_BREAK);
        }
        code.append("try {").append(LINE_BREAK);
        code.append("boolean done = false").append(JAVA_LINE_BREAK);
        code.append("Codec codec = null").append(JAVA_LINE_BREAK);
        code.append("while (!done) {").append(LINE_BREAK);
        code.append("int tag = input.readTag()").append(JAVA_LINE_BREAK);
        code.append("if (tag == 0) { break;}").append(LINE_BREAK);
        for (FieldInfo field : this.fields) {
            FieldType fieldType;
            String spath;
            String name;
            Class<?> cls;
            String express;
            isList = field.isList();
            if (field.getFieldType() != FieldType.DEFAULT) {
                code.append("if (tag == ").append(CodedConstant.makeTag(field.getOrder(), field.getFieldType().getInternalFieldType().getWireType()));
                code.append(") {").append(LINE_BREAK);
            } else {
                code.append("if (tag == CodedConstant.makeTag(").append(field.getOrder());
                code.append(",WireFormat.").append(field.getFieldType().getWireFormat()).append(")) {").append(LINE_BREAK);
            }
            String t = field.getFieldType().getType();
            t = CodedConstant.capitalize(t);
            boolean listTypeCheck = false;
            if (field.getFieldType() == FieldType.ENUM) {
                String clsName = ClassHelper.getInternalName(field.getField().getType().getCanonicalName());
                if (isList && field.getGenericKeyType() != null) {
                    Class<?> cls2 = field.getGenericKeyType();
                    clsName = ClassHelper.getInternalName(cls2.getCanonicalName());
                }
                express = "CodedConstant.getEnumValue(" + clsName + ".class, CodedConstant.getEnumName(" + clsName + ".values(),input.read" + t + "()))";
            } else {
                express = "input.read" + t + "()";
            }
            if (isList && field.getFieldType() == FieldType.OBJECT) {
                if (field.getGenericKeyType() != null) {
                    cls = field.getGenericKeyType();
                    name = ClassHelper.getInternalName(cls.getCanonicalName());
                    code.append("codec = ProtobufProxy.create(").append(name).append(JAVA_CLASS_FILE_SUFFIX);
                    if (this.debug) {
                        code.append(", true");
                    } else {
                        code.append(", false");
                    }
                    spath = "null";
                    if (this.outputPath != null) {
                        spath = "new java.io.File(\"" + this.outputPath.getAbsolutePath().replace('\\', '/') + "\")";
                    }
                    code.append(",").append(spath);
                    code.append(")").append(JAVA_LINE_BREAK);
                    code.append("int length = input.readRawVarint32()").append(JAVA_LINE_BREAK);
                    code.append("final int oldLimit = input.pushLimit(length)").append(JAVA_LINE_BREAK);
                    listTypeCheck = true;
                    express = "(" + name + ") codec.readFrom(input)";
                }
            } else if (field.isMap()) {
                String getMapCommand = this.getMapCommand(field);
                if (field.isEnumValueType()) {
                    String enumClassName = field.getGenericeValueType().getCanonicalName();
                    code.append("EnumHandler<").append(enumClassName).append("> handler");
                    code.append("= new EnumHandler");
                    code.append("<").append(enumClassName).append(">() {");
                    code.append(LINE_BREAK);
                    code.append("public ").append(enumClassName).append(" handle(int value) {");
                    code.append(LINE_BREAK);
                    code.append("String enumName = CodedConstant.getEnumName(").append(enumClassName).append(".values(), value)");
                    code.append(JAVA_LINE_BREAK);
                    code.append("return ").append(enumClassName).append(".valueOf(enumName)");
                    code.append(JAVA_LINE_BREAK);
                    code.append("}}");
                    code.append(JAVA_LINE_BREAK);
                }
                express = "CodedConstant.putMapValue(input, " + getMapCommand + ",";
                express = express + CodedConstant.getMapFieldGenericParameterString(field);
                if (field.isEnumValueType()) {
                    express = express + ", handler";
                }
                express = express + ")";
            } else if (field.getFieldType() == FieldType.OBJECT) {
                cls = field.getField().getType();
                name = ClassHelper.getInternalName(cls.getCanonicalName());
                code.append("codec = ProtobufProxy.create(").append(name).append(JAVA_CLASS_FILE_SUFFIX);
                if (this.debug) {
                    code.append(", true");
                } else {
                    code.append(", false");
                }
                spath = "null";
                if (this.outputPath != null) {
                    spath = "new java.io.File(\"" + this.outputPath.getAbsolutePath().replace('\\', '/') + "\")";
                }
                code.append(",").append(spath);
                code.append(")").append(JAVA_LINE_BREAK);
                code.append("int length = input.readRawVarint32()").append(JAVA_LINE_BREAK);
                code.append("final int oldLimit = input.pushLimit(length)").append(JAVA_LINE_BREAK);
                listTypeCheck = true;
                express = "(" + name + ") codec.readFrom(input)";
            }
            if (field.getFieldType() == FieldType.BYTES) {
                express = express + ".toByteArray()";
            }
            code.append(this.getSetToField("ret", field.getField(), this.cls, express, isList, field.isMap(), false));
            code.append(JAVA_LINE_BREAK);
            if (listTypeCheck) {
                code.append("input.checkLastTagWas(0)").append(JAVA_LINE_BREAK);
                code.append("input.popLimit(oldLimit)").append(JAVA_LINE_BREAK);
            }
            code.append("continue").append(JAVA_LINE_BREAK);
            code.append("}").append(LINE_BREAK);
            if (!isList || !(fieldType = field.getFieldType()).isPrimitive()) continue;
            code.append("if (tag == ").append(CodedConstant.makeTag(field.getOrder(), 2));
            code.append(") {").append(LINE_BREAK);
            code.append("int length = input.readRawVarint32()").append(JAVA_LINE_BREAK);
            code.append("int limit = input.pushLimit(length)").append(JAVA_LINE_BREAK);
            code.append(this.getSetToField("ret", field.getField(), this.cls, express, isList, field.isMap(), true));
            code.append("input.popLimit(limit)").append(JAVA_LINE_BREAK);
            code.append("continue").append(JAVA_LINE_BREAK);
            code.append("}").append(LINE_BREAK);
        }
        code.append("input.skipField(tag)").append(JAVA_LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        code.append("} catch (com.google.protobuf.InvalidProtocolBufferException e) {").append(LINE_BREAK);
        code.append("throw e").append(JAVA_LINE_BREAK);
        code.append("} catch (java.io.IOException e) {").append(LINE_BREAK);
        code.append("throw e").append(JAVA_LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        for (FieldInfo field : this.fields) {
            if (!field.isRequired()) continue;
            code.append(CodedConstant.getRetRequiredCheck(this.getAccessByField("ret", field.getField(), this.cls), field.getField()));
        }
        code.append("return ret").append(JAVA_LINE_BREAK);
        code.append("}").append(LINE_BREAK);
    }

    private String getDecodeMethodCode() {
        StringBuilder code = new StringBuilder();
        code.append("public ").append(ClassHelper.getInternalName(this.cls.getCanonicalName()));
        code.append(" decode(byte[] bb) throws IOException {").append(LINE_BREAK);
        code.append("CodedInputStream input = CodedInputStream.newInstance(bb, 0, bb.length)").append(JAVA_LINE_BREAK);
        this.getParseBytesMethodCode(code);
        return code.toString();
    }

    private Object getGetDescriptorMethodCode() {
        StringBuilder code = new StringBuilder();
        String descriptorClsName = ClassHelper.getInternalName(Descriptors.Descriptor.class.getCanonicalName());
        code.append("public ").append(descriptorClsName);
        code.append(" getDescriptor() throws IOException {").append(LINE_BREAK);
        code.append("if (this.descriptor != null) {").append(LINE_BREAK);
        code.append("return this.descriptor").append(JAVA_LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        code.append(descriptorClsName).append(" descriptor = ");
        code.append("CodedConstant.getDescriptor(").append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append(JAVA_CLASS_FILE_SUFFIX).append(")").append(JAVA_LINE_BREAK);
        code.append("return (this.descriptor = descriptor)").append(JAVA_LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        return code.toString();
    }

    private String getMapCommand(FieldInfo field) {
        String keyGeneric = field.getGenericKeyType().getCanonicalName();
        String valueGeneric = field.getGenericeValueType().getCanonicalName();
        String getMapCommand = "(Map<" + keyGeneric;
        getMapCommand = getMapCommand + ", " + valueGeneric + ">)";
        getMapCommand = getMapCommand + this.getAccessByField("ret", field.getField(), this.cls);
        return getMapCommand;
    }

    private String getReadFromMethodCode() {
        StringBuilder code = new StringBuilder();
        code.append("public ").append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append(" readFrom(CodedInputStream input) throws IOException {").append(LINE_BREAK);
        this.getParseBytesMethodCode(code);
        return code.toString();
    }

    private void checkType(FieldType type, Field field) {
        Class<?> cls = field.getType();
        if (type == FieldType.OBJECT || type == FieldType.ENUM) {
            return;
        }
        String javaType = type.getJavaType();
        if (Integer.class.getSimpleName().equals(javaType)) {
            if (cls.getSimpleName().equals("int") || Integer.class.getSimpleName().equals(cls.getSimpleName())) {
                return;
            }
            throw new IllegalArgumentException(this.getMismatchTypeErroMessage(type, field));
        }
        if (!javaType.equalsIgnoreCase(cls.getSimpleName())) {
            throw new IllegalArgumentException(this.getMismatchTypeErroMessage(type, field));
        }
    }

    private String getMismatchTypeErroMessage(FieldType type, Field field) {
        return "Type mismatch. @Protobuf required type '" + type.getJavaType() + "' but field type is '" + field.getType().getSimpleName() + "' of field name '" + field.getName() + "' on class " + field.getDeclaringClass().getCanonicalName();
    }

    private String getEncodeMethodCode() {
        StringBuilder code = new StringBuilder();
        HashSet orders = new HashSet();
        code.append("public byte[] encode(").append(ClassHelper.getInternalName(this.cls.getCanonicalName()));
        code.append(" t) throws IOException {").append(LINE_BREAK);
        code.append("int size = 0").append(JAVA_END);
        for (FieldInfo field : this.fields) {
            boolean isList = field.isList();
            if (!isList) {
                this.checkType(field.getFieldType(), field.getField());
            }
            if (orders.contains(field.getOrder())) {
                throw new IllegalArgumentException("Field order '" + field.getOrder() + "' on field" + field.getField().getName() + " already exsit.");
            }
            code.append(CodedConstant.getMappedTypeDefined(field.getOrder(), field.getFieldType(), this.getAccessByField("t", field.getField(), this.cls), isList, field.isMap()));
            code.append("if (!CodedConstant.isNull(").append(this.getAccessByField("t", field.getField(), this.cls)).append("))").append("{").append(LINE_BREAK);
            code.append("size += ");
            code.append(CodedConstant.getMappedTypeSize(field, field.getOrder(), field.getFieldType(), isList, field.isMap(), this.debug, this.outputPath)).append(LINE_BREAK);
            code.append("}").append(LINE_BREAK);
            if (!field.isRequired()) continue;
            code.append(CodedConstant.getRequiredCheck(field.getOrder(), field.getField()));
        }
        code.append("final byte[] result = new byte[size]").append(JAVA_LINE_BREAK);
        code.append("final CodedOutputStream output = CodedOutputStream.newInstance(result)").append(JAVA_LINE_BREAK);
        code.append("writeTo(t, output)").append(JAVA_LINE_BREAK);
        code.append("return result").append(JAVA_LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        return code.toString();
    }

    private String getWriteToMethodCode() {
        boolean isList;
        StringBuilder code = new StringBuilder();
        HashSet orders = new HashSet();
        code.append("public void writeTo(").append(ClassHelper.getInternalName(this.cls.getCanonicalName())).append(" t, CodedOutputStream output) throws IOException {").append(LINE_BREAK);
        for (FieldInfo field : this.fields) {
            isList = field.isList();
            if (!isList) {
                this.checkType(field.getFieldType(), field.getField());
            }
            if (orders.contains(field.getOrder())) {
                throw new IllegalArgumentException("Field order '" + field.getOrder() + "' on field" + field.getField().getName() + " already exsit.");
            }
            code.append(CodedConstant.getMappedTypeDefined(field.getOrder(), field.getFieldType(), this.getAccessByField("t", field.getField(), this.cls), isList, field.isMap()));
            if (!field.isRequired()) continue;
            code.append(CodedConstant.getRequiredCheck(field.getOrder(), field.getField()));
        }
        for (FieldInfo field : this.fields) {
            isList = field.isList();
            code.append(CodedConstant.getMappedWriteCode(field, "output", field.getOrder(), field.getFieldType(), isList, field.isMap()));
        }
        code.append("output.flush()").append(JAVA_LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        return code.toString();
    }

    private String getSizeMethodCode() {
        StringBuilder code = new StringBuilder();
        HashSet orders = new HashSet();
        code.append("public int size(").append(ClassHelper.getInternalName(this.cls.getCanonicalName()));
        code.append(" t) throws IOException {").append(LINE_BREAK);
        code.append("int size = 0").append(JAVA_LINE_BREAK);
        for (FieldInfo field : this.fields) {
            boolean isList = field.isList();
            if (!isList) {
                this.checkType(field.getFieldType(), field.getField());
            }
            if (orders.contains(field.getOrder())) {
                throw new IllegalArgumentException("Field order '" + field.getOrder() + "' on field" + field.getField().getName() + " already exsit.");
            }
            code.append(CodedConstant.getMappedTypeDefined(field.getOrder(), field.getFieldType(), this.getAccessByField("t", field.getField(), this.cls), isList, field.isMap()));
            code.append("if (!CodedConstant.isNull(").append(this.getAccessByField("t", field.getField(), this.cls)).append("))").append("{").append(LINE_BREAK);
            code.append("size += ");
            code.append(CodedConstant.getMappedTypeSize(field, field.getOrder(), field.getFieldType(), isList, field.isMap(), this.debug, this.outputPath));
            code.append("}").append(LINE_BREAK);
            if (!field.isRequired()) continue;
            code.append(CodedConstant.getRequiredCheck(field.getOrder(), field.getField()));
        }
        code.append("return size").append(JAVA_LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        return code.toString();
    }

    protected String getAccessByField(String target, Field field, Class<?> cls) {
        if (field.getModifiers() == 1) {
            return target + PACKAGE_SPLIT + field.getName();
        }
        String getter = "boolean".equalsIgnoreCase(field.getType().getCanonicalName()) ? "is" + CodedConstant.capitalize(field.getName()) : "get" + CodedConstant.capitalize(field.getName());
        try {
            cls.getMethod(getter, new Class[0]);
            return target + PACKAGE_SPLIT + getter + "()";
        }
        catch (Exception e) {
            String type;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if ("[B".equals(type = field.getType().getCanonicalName()) || "[Ljava.lang.Byte;".equals(type) || "java.lang.Byte[]".equals(type)) {
                type = "byte[]";
            }
            String code = "(" + FieldUtils.toObjectType(type) + ") ";
            code = code + "FieldUtils.getField(" + target + ", \"" + field.getName() + "\")";
            return code;
        }
    }

    protected String getSetToField(String target, Field field, Class<?> cls, String express, boolean isList, boolean isMap, boolean packed) {
        StringBuilder ret = new StringBuilder();
        if (isList || isMap) {
            ret.append("if ((").append(this.getAccessByField(target, field, cls)).append(") == null) {").append(LINE_BREAK);
        }
        if (Modifier.isPublic(field.getModifiers())) {
            if (isList) {
                ret.append(target).append(PACKAGE_SPLIT).append(field.getName()).append("= new ArrayList()").append(JAVA_LINE_BREAK).append("}").append(LINE_BREAK);
                if (express != null) {
                    if (packed) {
                        ret.append("while (input.getBytesUntilLimit() > 0) {").append(LINE_BREAK);
                    }
                    ret.append(target).append(PACKAGE_SPLIT).append(field.getName()).append(".add(").append(express).append(")");
                    if (packed) {
                        ret.append(";}").append(LINE_BREAK);
                    }
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append(target).append(PACKAGE_SPLIT).append(field.getName()).append("= new HashMap()").append(JAVA_LINE_BREAK).append("}").append(LINE_BREAK);
                return ret.append(express).toString();
            }
            return target + PACKAGE_SPLIT + field.getName() + "=" + express + LINE_BREAK;
        }
        String setter = "set" + CodedConstant.capitalize(field.getName());
        try {
            cls.getMethod(setter, field.getType());
            if (isList) {
                ret.append("List __list = new ArrayList()").append(JAVA_LINE_BREAK);
                ret.append(target).append(PACKAGE_SPLIT).append(setter).append("(__list)").append(JAVA_LINE_BREAK).append("}").append(LINE_BREAK);
                if (express != null) {
                    if (packed) {
                        ret.append("while (input.getBytesUntilLimit() > 0) {").append(LINE_BREAK);
                    }
                    ret.append("(").append(this.getAccessByField(target, field, cls)).append(").add(").append(express).append(")");
                    if (packed) {
                        ret.append(";}").append(LINE_BREAK);
                    }
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append("Map __map = new HashMap()").append(JAVA_LINE_BREAK);
                ret.append(target).append(PACKAGE_SPLIT).append(setter).append("(__map)").append(JAVA_LINE_BREAK).append("}").append(LINE_BREAK);
                return ret + express;
            }
            return target + PACKAGE_SPLIT + setter + "(" + express + ")\n";
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (isList) {
                ret.append("List __list = new ArrayList()").append(JAVA_LINE_BREAK);
                ret.append("FieldUtils.setField(").append(target).append(", \"").append(field.getName()).append("\", __list)").append(JAVA_LINE_BREAK).append("}").append(LINE_BREAK);
                if (express != null) {
                    if (packed) {
                        ret.append("while (input.getBytesUntilLimit() > 0) {").append(LINE_BREAK);
                    }
                    ret.append("(").append(this.getAccessByField(target, field, cls)).append(").add(").append(express).append(")");
                    if (packed) {
                        ret.append(";}").append(LINE_BREAK);
                    }
                }
                return ret.toString();
            }
            if (isMap) {
                ret.append("Map __map = new HashMap()").append(JAVA_LINE_BREAK);
                ret.append("FieldUtils.setField(").append(target).append(", \"").append(field.getName()).append("\", __map)").append(JAVA_LINE_BREAK).append("}").append(LINE_BREAK);
                return ret + express;
            }
            String code = "";
            if (express != null) {
                code = "FieldUtils.setField(" + target + ", \"" + field.getName() + "\", " + express + ")" + LINE_BREAK;
            }
            return code;
        }
    }
}

