/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf;

import com.google.protobuf.WireFormat;

public enum FieldType {
    DOUBLE("Double", "double", "WIRETYPE_FIXED64", ".doubleValue()", WireFormat.FieldType.DOUBLE, "0d"),
    FLOAT("Float", "float", "WIRETYPE_FIXED32", ".floatValue()", WireFormat.FieldType.FLOAT, "0f"),
    INT64("Long", "int64", "WIRETYPE_VARINT", ".longValue()", WireFormat.FieldType.INT64, "0L"),
    UINT64("Long", "uInt64", "WIRETYPE_VARINT", ".longValue()", WireFormat.FieldType.UINT64, "0L"),
    INT32("Integer", "int32", "WIRETYPE_VARINT", ".intValue()", WireFormat.FieldType.INT32, "0"),
    FIXED64("Long", "fixed64", "WIRETYPE_FIXED64", ".longValue()", WireFormat.FieldType.FIXED64, "0L"),
    FIXED32("Integer", "fixed32", "WIRETYPE_FIXED32", ".intValue()", WireFormat.FieldType.FIXED32, "0"),
    BOOL("Boolean", "bool", "WIRETYPE_VARINT", ".booleanValue()", WireFormat.FieldType.BOOL, "false"),
    STRING("String", "string", "WIRETYPE_LENGTH_DELIMITED", "", WireFormat.FieldType.STRING, "\"\""),
    BYTES("byte[]", "bytes", "WIRETYPE_LENGTH_DELIMITED", "", WireFormat.FieldType.BYTES, "new byte[0]"),
    UINT32("Integer", "uInt32", "WIRETYPE_VARINT", ".intValue()", WireFormat.FieldType.UINT32, "0"),
    SFIXED32("Integer", "sFixed32", "WIRETYPE_FIXED32", ".intValue()", WireFormat.FieldType.SFIXED32, "0"),
    SFIXED64("Long", "sFixed64", "WIRETYPE_FIXED64", ".longValue()", WireFormat.FieldType.SFIXED64, "0L"),
    SINT32("Integer", "sInt32", "WIRETYPE_VARINT", ".intValue()", WireFormat.FieldType.SINT32, "0"),
    SINT64("Long", "sInt64", "WIRETYPE_VARINT", ".longValue()", WireFormat.FieldType.SINT64, "0L"),
    OBJECT("Object", "object", "WIRETYPE_LENGTH_DELIMITED", "", WireFormat.FieldType.MESSAGE, null),
    ENUM("Enum", "enum", "WIRETYPE_VARINT", ".ordinal()", WireFormat.FieldType.ENUM, null),
    MAP("Map", "map", "WIRETYPE_VARINT", "", WireFormat.FieldType.MESSAGE, null),
    DATE("Date", "int64", "WIRETYPE_VARINT", ".getTime()", WireFormat.FieldType.INT64, null),
    DEFAULT("", "", "", "", WireFormat.FieldType.MESSAGE, null);

    private final String javaType;
    private final String type;
    private final String wireFormat;
    private final String toPrimitiveType;
    private WireFormat.FieldType internalFieldType;
    private String defaultValue;

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public WireFormat.FieldType getInternalFieldType() {
        return this.internalFieldType;
    }

    public void setInternalFieldType(WireFormat.FieldType internalFieldType) {
        this.internalFieldType = internalFieldType;
    }

    public String getToPrimitiveType() {
        return this.toPrimitiveType;
    }

    public String getWireFormat() {
        return this.wireFormat;
    }

    public String getType() {
        return this.type;
    }

    public String getJavaType() {
        if (this == ENUM) {
            return Enum.class.getName();
        }
        return this.javaType;
    }

    private FieldType(String javaType, String type, String wireFormat, String toPrimitiveType, WireFormat.FieldType internalFieldType, String defaultValue) {
        this.javaType = javaType;
        this.type = type;
        this.wireFormat = wireFormat;
        this.toPrimitiveType = toPrimitiveType;
        this.internalFieldType = internalFieldType;
        this.defaultValue = defaultValue;
    }

    public boolean isPrimitive() {
        return this == INT32 || this == DOUBLE || this == FIXED32 || this == FIXED64 || this == FLOAT || this == INT64 || this == SFIXED32 || this == SFIXED64 || this == SINT32 || this == SINT64 || this == BOOL || this == UINT32 || this == UINT64;
    }

    public boolean isEnum() {
        return this == ENUM;
    }
}

