/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location;

public final class Address {
    public final String country;
    public final String countryCode;
    public final String province;
    public final String city;
    public final String cityCode;
    public final String district;
    public final String street;
    public final String streetNumber;
    public final String address;
    public final String adcode;
    public final String town;
    public final String townCode;

    private Address(Builder builder) {
        this.country = builder.mCountry;
        this.countryCode = builder.mCountryCode;
        this.province = builder.mProvince;
        this.city = builder.mCity;
        this.cityCode = builder.mCityCode;
        this.district = builder.mDistrict;
        this.street = builder.mStreet;
        this.streetNumber = builder.mStreetNumber;
        this.address = builder.mAddress;
        this.adcode = builder.mAdcode;
        this.town = builder.mTown;
        this.townCode = builder.mTownCode;
    }

    public static class Builder {
        private String mCountry = null;
        private String mCountryCode = null;
        private String mProvince = null;
        private String mCity = null;
        private String mCityCode = null;
        private String mDistrict = null;
        private String mStreet = null;
        private String mStreetNumber = null;
        private String mAddress = null;
        private String mAdcode = null;
        private String mTown = null;
        private String mTownCode = null;
        private static final String BEI_JING = "\u5317\u4eac";
        private static final String TIAN_JIN = "\u5929\u6d25";
        private static final String CHONG_QIN = "\u91cd\u5e86";
        private static final String SHANG_HAI = "\u4e0a\u6d77";

        public Builder country(String string) {
            this.mCountry = string;
            return this;
        }

        public Builder adcode(String string) {
            this.mAdcode = string;
            return this;
        }

        public Builder countryCode(String string) {
            this.mCountryCode = string;
            return this;
        }

        public Builder province(String string) {
            this.mProvince = string;
            return this;
        }

        public Builder city(String string) {
            this.mCity = string;
            return this;
        }

        public Builder cityCode(String string) {
            this.mCityCode = string;
            return this;
        }

        public Builder district(String string) {
            this.mDistrict = string;
            return this;
        }

        public Builder street(String string) {
            this.mStreet = string;
            return this;
        }

        public Builder streetNumber(String string) {
            this.mStreetNumber = string;
            return this;
        }

        public Builder town(String string) {
            this.mTown = string;
            return this;
        }

        public Builder townCode(String string) {
            this.mTownCode = string;
            return this;
        }

        public Address build() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.mCountry != null) {
                stringBuffer.append(this.mCountry);
            }
            if (this.mProvince != null) {
                stringBuffer.append(this.mProvince);
            }
            if (this.mProvince != null && this.mCity != null && !this.mProvince.equals(this.mCity)) {
                stringBuffer.append(this.mCity);
            }
            if (this.mDistrict != null) {
                if (this.mCity != null) {
                    if (!this.mCity.equals(this.mDistrict)) {
                        stringBuffer.append(this.mDistrict);
                    }
                } else {
                    stringBuffer.append(this.mDistrict);
                }
            }
            if (this.mTown != null) {
                stringBuffer.append(this.mTown);
            }
            if (this.mStreet != null) {
                stringBuffer.append(this.mStreet);
            }
            if (this.mStreetNumber != null) {
                stringBuffer.append(this.mStreetNumber);
            }
            if (stringBuffer.length() > 0) {
                this.mAddress = stringBuffer.toString();
            }
            return new Address(this);
        }
    }
}

