/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.support.v4.util.LongSparseArray;
import android.util.SparseIntArray;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.Gradient;
import com.baidu.mapapi.map.Tile;
import com.baidu.mapapi.map.WeightedLatLng;
import com.baidu.mapapi.map.WinRound;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.model.LatLng;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public class HeatMap {
    private static final SparseIntArray n = new SparseIntArray();
    private static final int[] o;
    private static final float[] p;
    public static final int DEFAULT_RADIUS = 12;
    public static final double DEFAULT_OPACITY = 0.6;
    public static final Gradient DEFAULT_GRADIENT;
    private static int q;
    private b<WeightedLatLng> a;
    private Collection<WeightedLatLng> b;
    private int c;
    private Gradient d;
    private double e;
    private com.baidu.mapapi.map.a f;
    private int[] g;
    private double[] h;
    private double[] i;
    private HashMap<String, Tile> j;
    private ExecutorService k;
    private HashSet<String> l;
    BaiduMap m;

    private HeatMap(Builder builder) {
        HeatMap heatMap = this;
        this.j = new HashMap();
        this.k = Executors.newFixedThreadPool(1);
        this.l = new HashSet();
        this.b = builder.a;
        this.c = builder.b;
        this.d = builder.c;
        heatMap.e = builder.d;
        int n2 = heatMap.c;
        heatMap.h = HeatMap.a(n2, (double)n2 / 3.0);
        heatMap.a(heatMap.d);
        heatMap.c(heatMap.b);
    }

    private void c(Collection<WeightedLatLng> iterator) {
        this.b = iterator;
        if (!iterator.isEmpty()) {
            HeatMap heatMap = this;
            iterator = HeatMap.b(heatMap.b);
            heatMap.f = iterator;
            heatMap.a = new b((com.baidu.mapapi.map.a)((Object)iterator));
            for (WeightedLatLng weightedLatLng : heatMap.b) {
                this.a.a(weightedLatLng);
            }
            HeatMap heatMap2 = this;
            heatMap2.i = heatMap2.a(heatMap2.c);
            return;
        }
        throw new IllegalArgumentException("BDMapSDKException: No input points.");
    }

    private static Collection<WeightedLatLng> d(Collection<LatLng> arrayList) {
        ArrayList<WeightedLatLng> arrayList2;
        ArrayList<WeightedLatLng> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<WeightedLatLng>();
        for (LatLng latLng : arrayList3) {
            arrayList.add(new WeightedLatLng(latLng));
        }
        return arrayList;
    }

    private synchronized boolean c(String string) {
        return this.l.contains(string);
    }

    private synchronized void a(String string) {
        this.l.add(string);
    }

    private synchronized Tile b(String string) {
        if (this.j.containsKey(string)) {
            this.j.remove(string);
            return this.j.get(string);
        }
        return null;
    }

    private synchronized void a(String string, Tile tile) {
        this.j.put(string, tile);
    }

    private synchronized void c() {
        this.j.clear();
    }

    private void b(int n2, int n3, int n4) {
        double d2 = n.get(n4);
        int n5 = ((HeatMap)this).c;
        double d3 = d2 * (double)n5 / 256.0;
        double d4 = (d2 + d3 * 2.0) / (double)(n5 * 2 + 256);
        if (n2 >= 0 && n3 >= 0) {
            com.baidu.mapapi.map.a a2;
            int n6 = n3;
            int n7 = n2;
            double d5 = (double)n7 * d2 - d3;
            double d6 = (double)(n7 + 1) * d2 + d3;
            double d7 = (double)n6 * d2 - d3;
            d2 = (double)(n6 + 1) * d2 + d3;
            Object object = a2;
            com.baidu.mapapi.map.a a3 = ((HeatMap)this).f;
            com.baidu.mapapi.map.a a4 = a3;
            double d8 = a4.c + d3;
            if (!new com.baidu.mapapi.map.a(d5, d6, d7, d2).b(new com.baidu.mapapi.map.a(a3.a - d3, d8, d7 = a4.b - d3, d3 = a4.d + d3))) {
                return;
            }
            if ((object = ((HeatMap)this).a.a((com.baidu.mapapi.map.a)object)).isEmpty()) {
                return;
            }
            int n8 = ((HeatMap)this).c;
            double[][] dArray = new double[n8 * 2 + 256][n8 * 2 + 256];
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                WeightedLatLng weightedLatLng = (WeightedLatLng)iterator.next();
                Point point = weightedLatLng.a();
                int n9 = (int)(((double)point.x - d5) / d4);
                int n10 = (int)((d2 - (double)point.y) / d4);
                int n11 = ((HeatMap)this).c;
                if (n9 >= n11 * 2 + 256) {
                    n9 = n11 * 2 + 256 - 1;
                }
                if (n10 >= n11 * 2 + 256) {
                    n10 = n11 * 2 + 256 - 1;
                }
                double[] dArray2 = dArray[n9];
                dArray2[n10] = dArray2[n10] + weightedLatLng.intensity;
            }
            HeatMap heatMap = this;
            Bitmap bitmap = HeatMap.a(HeatMap.a(dArray, ((HeatMap)this).h), ((HeatMap)this).g, ((HeatMap)this).i[n4 - 1]);
            Tile tile = HeatMap.a(bitmap);
            bitmap.recycle();
            heatMap.a(n2 + "_" + n3 + "_" + n4, tile);
            if (heatMap.j.size() > q) {
                ((HeatMap)this).b();
            }
            if ((this = ((HeatMap)this).m) != null) {
                ((BaiduMap)this).d();
            }
            return;
        }
    }

    private void a(Gradient gradient) {
        this.d = gradient;
        this.g = gradient.a(this.e);
    }

    private double[] a(int n2) {
        double[] dArray = new double[20];
        for (int i2 = 5; i2 < 11; ++i2) {
            com.baidu.mapapi.map.a a2 = this.f;
            double d2 = i2 - 3;
            dArray[i2] = HeatMap.a(this.b, a2, n2, (int)(Math.pow(2.0, d2) * 1280.0));
            if (i2 != 5) continue;
            for (int i3 = 0; i3 < i2; ++i3) {
                dArray[i3] = d2 = dArray[i2];
            }
        }
        for (int i4 = 11; i4 < 20; ++i4) {
            double d3;
            dArray[i4] = d3 = dArray[10];
        }
        return dArray;
    }

    private static Tile a(Bitmap object) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(object.getWidth() * object.getHeight() * 4);
        object.copyPixelsToBuffer((Buffer)byteBuffer);
        object = byteBuffer.array();
        return new Tile(256, 256, (byte[])object);
    }

    private static com.baidu.mapapi.map.a b(Collection<WeightedLatLng> object) {
        object = object.iterator();
        WeightedLatLng weightedLatLng = object.next();
        double d2 = weightedLatLng.a().x;
        double d3 = weightedLatLng.a().x;
        double d4 = weightedLatLng.a().y;
        double d5 = weightedLatLng.a().y;
        while (object.hasNext()) {
            double d6;
            WeightedLatLng weightedLatLng2 = (WeightedLatLng)object.next();
            double d7 = weightedLatLng2.a().x;
            double d8 = weightedLatLng2.a().y;
            if (d6 < d2) {
                d2 = d7;
            }
            if (!(d7 > d3)) {
                d7 = d3;
            }
            if (d8 < d4) {
                d4 = d8;
            }
            if (!(d8 > d5)) {
                d8 = d5;
            }
            d5 = d8;
            d3 = d7;
        }
        return new com.baidu.mapapi.map.a(d2, d3, d4, d5);
    }

    private static double[] a(int n2, double d2) {
        double[] dArray = new double[n2 * 2 + 1];
        for (int i2 = -(v15718); i2 <= n2; ++i2) {
            dArray[i2 + n2] = Math.exp((double)(-i2 * i2) / (d2 * 2.0 * d2));
        }
        return dArray;
    }

    private static double[][] a(double[][] dArray, double[] dArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = (int)Math.floor((double)dArray2.length / 2.0);
        int n7 = dArray.length;
        int n8 = n7 - n6 * 2;
        int n9 = n6 + n8 - 1;
        double[][] dArray3 = new double[n7][n7];
        for (n5 = 0; n5 < n7; ++n5) {
            for (int i2 = 0; i2 < n7; ++i2) {
                double d2 = dArray[n5][i2];
                if (d2 == 0.0) continue;
                n4 = n5 + n6;
                if (n9 < n4) {
                    n4 = n9;
                }
                ++n4;
                for (n3 = n6 > (n2 = n5 - n6) ? n6 : n2; n3 < n4; ++n3) {
                    double[] dArray4 = dArray3[n3];
                    dArray4[i2] = dArray4[i2] + d2 * dArray2[n3 - n2];
                }
            }
        }
        int n10 = n8;
        dArray = new double[n10][n10];
        for (n8 = n6; n8 < n9 + 1; ++n8) {
            for (n5 = 0; n5 < n7; ++n5) {
                double d3 = dArray3[n8][n5];
                if (d3 == 0.0) continue;
                int n11 = n5 + n6;
                if (n9 < n11) {
                    n11 = n9;
                }
                ++n11;
                for (n2 = n6 > (n4 = n5 - n6) ? n6 : n4; n2 < n11; ++n2) {
                    double d4;
                    double[] dArray5 = dArray[n8 - n6];
                    n3 = n2 - n6;
                    dArray5[n3] = d4 = dArray5[n3] + d3 * dArray2[n2 - n4];
                }
            }
        }
        return dArray;
    }

    private static Bitmap a(double[][] dArray, int[] nArray, double d2) {
        int n2 = nArray[nArray.length - 1];
        d2 = (double)(nArray.length - 1) / d2;
        int n3 = dArray.length;
        int[] nArray2 = new int[n3 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d3 = dArray[i3][i2];
                int n4 = i2 * n3 + i3;
                int n5 = (int)(d3 * d2);
                if (d3 != 0.0) {
                    if (n5 < nArray.length) {
                        nArray2[n4] = nArray[n5];
                        continue;
                    }
                    nArray2[n4] = n2;
                    continue;
                }
                nArray2[n4] = 0;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n3, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int n6 = n3;
        bitmap.setPixels(nArray2, 0, n3, 0, 0, n6, n6);
        return bitmap;
    }

    private static double a(Collection<WeightedLatLng> collection, com.baidu.mapapi.map.a a2, int n2, int n3) {
        LongSparseArray longSparseArray;
        double d2;
        double d3;
        com.baidu.mapapi.map.a a3 = a2;
        double d4 = a3.a;
        com.baidu.mapapi.map.a a4 = a2;
        double d5 = a4.b;
        double d6 = a4.d;
        double d7 = a3.c - d4;
        d6 -= d5;
        if (d3 > d2) {
            d6 = d7;
        }
        double d8 = (double)((int)((double)(n3 / (n2 * 2)) + 0.5)) / d6;
        LongSparseArray longSparseArray2 = longSparseArray;
        longSparseArray = new LongSparseArray();
        d6 = 0.0;
        for (WeightedLatLng object : collection) {
            long d10;
            Double d9;
            double n4 = object.a().y;
            int n5 = (int)((n4 - d5) * d8);
            long l2 = (int)(((double)object.a().x - d4) * d8);
            LongSparseArray longSparseArray3 = (LongSparseArray)longSparseArray2.get(l2);
            if (longSparseArray3 == null) {
                LongSparseArray longSparseArray4;
                longSparseArray3 = longSparseArray4;
                longSparseArray4 = new LongSparseArray();
                longSparseArray2.put(l2, (Object)longSparseArray3);
            }
            if ((d9 = (Double)longSparseArray3.get(d10 = (long)n5)) == null) {
                d9 = 0.0;
            }
            Double d11 = d9 + object.intensity;
            longSparseArray3.put(d10, (Object)d11);
            if (!(d11 > d6)) continue;
            d6 = d11;
        }
        return d6;
    }

    static {
        n.put(3, 0x800000);
        n.put(4, 0x400000);
        n.put(5, 0x200000);
        n.put(6, 0x100000);
        n.put(7, 524288);
        n.put(8, 262144);
        n.put(9, 131072);
        n.put(10, 65536);
        n.put(11, 32768);
        n.put(12, 16384);
        n.put(13, 8192);
        n.put(14, 4096);
        n.put(15, 2048);
        n.put(16, 1024);
        n.put(17, 512);
        n.put(18, 256);
        n.put(19, 128);
        n.put(20, 64);
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = Color.rgb((int)0, (int)0, (int)200);
        nArray[1] = Color.rgb((int)0, (int)225, (int)0);
        nArray[2] = Color.rgb((int)255, (int)0, (int)0);
        o = nArray;
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = 0.08f;
        fArray[1] = 0.4f;
        fArray[2] = 1.0f;
        p = fArray;
        DEFAULT_GRADIENT = new Gradient(nArray2, fArray2);
        q = 0;
    }

    public void removeHeatMap() {
        BaiduMap baiduMap = this.m;
        if (baiduMap != null) {
            baiduMap.a(this);
        }
    }

    Tile a(final int n2, final int n3, final int n4) {
        String string = n2 + "_" + n3 + "_" + n4;
        Object object = this.b(string);
        if (object != null) {
            return object;
        }
        if (!this.c(string)) {
            object = this.m;
            if (object != null && q == 0) {
                object = ((BaiduMap)object).getMapStatus().c.j;
                q = ((((WinRound)object).right - ((WinRound)object).left) / 256 + 2) * ((((WinRound)object).bottom - ((WinRound)object).top) / 256 + 2) * 4;
            }
            if (this.j.size() > q) {
                this.b();
            }
            if (!this.k.isShutdown()) {
                try {
                    this.k.execute(new Runnable(){

                        @Override
                        public void run() {
                            a a2 = this;
                            int n22 = a2.n2;
                            int n32 = a2.n3;
                            int n42 = a2.n4;
                            HeatMap.this.b(n22, n32, n42);
                        }
                    });
                    this.a(string);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    rejectedExecutionException.printStackTrace();
                }
            }
        }
        return null;
    }

    synchronized void b() {
        HeatMap heatMap = this;
        heatMap.l.clear();
        heatMap.j.clear();
    }

    void a() {
        this.c();
    }

    void d() {
        this.k.shutdownNow();
    }

    public static class Builder {
        private Collection<WeightedLatLng> a;
        private int b = 12;
        private Gradient c = DEFAULT_GRADIENT;
        private double d = 0.6;

        public Builder data(Collection<LatLng> collection) {
            if (collection != null && !collection.isEmpty()) {
                if (!collection.contains(null)) {
                    return this.weightedData(HeatMap.d(collection));
                }
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }

        public Builder weightedData(Collection<WeightedLatLng> collection) {
            if (collection != null && !collection.isEmpty()) {
                if (!collection.contains(null)) {
                    ArrayList<WeightedLatLng> arrayList;
                    ArrayList<WeightedLatLng> arrayList2 = arrayList;
                    arrayList = new ArrayList<WeightedLatLng>();
                    for (WeightedLatLng weightedLatLng : collection) {
                        double d2;
                        LatLng latLng = weightedLatLng.latLng;
                        double d3 = latLng.latitude;
                        if (!(d3 < 0.37532 || d3 > 54.562495 || (d2 = latLng.longitude) < 72.508319) && !(d2 > 135.942198)) continue;
                        arrayList2.add(weightedLatLng);
                    }
                    collection.removeAll(arrayList2);
                    this.a = collection;
                    return this;
                }
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }

        public Builder radius(int n2) {
            this.b = n2;
            if (n2 >= 10 && n2 <= 50) {
                return this;
            }
            throw new IllegalArgumentException("BDMapSDKException: Radius not within bounds.");
        }

        public Builder gradient(Gradient gradient) {
            if (gradient != null) {
                this.c = gradient;
                return this;
            }
            throw new IllegalArgumentException("BDMapSDKException: gradient can not be null");
        }

        public Builder opacity(double d2) {
            this.d = d2;
            if (!(d2 < 0.0) && !(d2 > 1.0)) {
                return this;
            }
            throw new IllegalArgumentException("BDMapSDKException: Opacity must be in range [0, 1]");
        }

        public HeatMap build() {
            if (this.a != null) {
                return new HeatMap(this);
            }
            throw new IllegalStateException("BDMapSDKException: No input data: you must use either .data or .weightedData before building");
        }
    }
}

