/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.util.LongSparseArray;
import android.util.SparseIntArray;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.Gradient;
import com.baidu.mapapi.map.HeatMapAnimation;
import com.baidu.mapapi.map.HeatMapData;
import com.baidu.mapapi.map.Tile;
import com.baidu.mapapi.map.WeightedLatLng;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.map.e;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.util.SysOSUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HeatMap {
    private static final SparseIntArray a = new SparseIntArray();
    private static final int[] b;
    private static final float[] c;
    public static final int DEFAULT_MAX_HIGH = 0;
    public static final int DEFAULT_MIN_LEVEL = 4;
    public static final int DEFAULT_MAX_LEVEL = 22;
    public static final int DEFAULT_RADIUS = 12;
    public static final double DEFAULT_OPACITY = 0.6;
    public static final Gradient DEFAULT_GRADIENT;
    private static int d;
    private int e = 200;
    private boolean f = false;
    private int g = 22;
    private int h = 4;
    private e<WeightedLatLng> i;
    private Collection<WeightedLatLng> j;
    private List<List<WeightedLatLng>> k;
    private float l;
    private float m;
    protected boolean mIsSetMaxIntensity;
    private HeatMapAnimation n;
    private HeatMapAnimation o;
    private int p;
    private int q;
    private Gradient r;
    private double s;
    private c t;
    private int[] u;
    private float[] v;
    private double[] w;
    private double[] x;
    private List<double[]> y;
    private HashMap<String, Tile> z;
    private ExecutorService A;
    private HashSet<String> B;
    BaiduMap C;
    private int D = SysOSUtil.getInstance().getScreenWidth() / 2;

    private HeatMap(Builder builder) {
        Collection collection;
        this.z = new HashMap();
        this.A = Executors.newFixedThreadPool(1);
        this.B = new HashSet();
        this.k = builder.b;
        this.p = builder.c;
        this.q = builder.d;
        this.f = builder.h;
        this.g = builder.i;
        this.h = builder.j;
        this.mIsSetMaxIntensity = builder.m;
        if (!this.mIsSetMaxIntensity && this.k != null) {
            ArrayList<double[]> arrayList;
            ArrayList<double[]> arrayList2 = arrayList;
            arrayList = new ArrayList<double[]>();
            this.y = arrayList2;
            for (int i2 = 0; i2 < this.k.size(); ++i2) {
                Collection collection2;
                HeatMap heatMap = this;
                heatMap.j = collection2 = (Collection)heatMap.k.get(i2);
                heatMap.t = HeatMap.b(collection2);
                HeatMap heatMap2 = this;
                heatMap.y.add(heatMap2.a(heatMap2.p));
            }
        }
        this.j = collection = builder.a;
        if (!this.mIsSetMaxIntensity && collection != null) {
            this.c(collection);
        }
        HeatMap heatMap = this;
        this.o = builder.n;
        this.n = builder.o;
        this.e = builder.g;
        this.l = builder.k;
        this.m = builder.l;
        this.r = builder.e;
        heatMap.s = builder.f;
        int n2 = heatMap.p;
        heatMap.w = HeatMap.a(n2, (double)n2 / 3.0);
        heatMap.a(heatMap.r);
    }

    private void c(Collection<WeightedLatLng> iterator) {
        this.j = iterator;
        if (!iterator.isEmpty()) {
            HeatMap heatMap = this;
            iterator = HeatMap.b(heatMap.j);
            heatMap.t = iterator;
            heatMap.i = new e((c)((Object)iterator));
            for (WeightedLatLng weightedLatLng : heatMap.j) {
                this.i.a(weightedLatLng);
            }
            HeatMap heatMap2 = this;
            heatMap2.x = heatMap2.a(heatMap2.p);
            return;
        }
        throw new IllegalArgumentException("BDMapSDKException: No input points.");
    }

    private static Collection<WeightedLatLng> d(Collection<LatLng> arrayList) {
        ArrayList<WeightedLatLng> arrayList2;
        ArrayList<WeightedLatLng> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<WeightedLatLng>();
        for (LatLng latLng : arrayList3) {
            arrayList.add(new WeightedLatLng(latLng));
        }
        return arrayList;
    }

    private static List<List<WeightedLatLng>> b(List<List<LatLng>> arrayList) {
        ArrayList<List<WeightedLatLng>> arrayList2;
        ArrayList<List<WeightedLatLng>> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<List<WeightedLatLng>>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            arrayList.add((List)HeatMap.d((List)iterator.next()));
        }
        return arrayList;
    }

    private HeatMapData b(int n2, int n3) {
        float f2 = 0.0f;
        Collection<WeightedLatLng> collection = ((HeatMap)object).j;
        if (collection == null) {
            return null;
        }
        Object object = ((HeatMap)object).x;
        if (((HeatMap)object).x != null) {
            f2 = (float)object[n3];
        }
        return new HeatMapData(collection, f2);
    }

    private HeatMapData a(int n2, int n3) {
        Collection<List<WeightedLatLng>> collection = this.k;
        if (collection == null) {
            return null;
        }
        if (n2 >= collection.size()) {
            return null;
        }
        HeatMap heatMap = this;
        collection = heatMap.k.get(n2);
        float f2 = 0.0f;
        List<double[]> list = heatMap.y;
        if (list != null && list.size() > n2) {
            f2 = (float)this.y.get(n2)[n3];
        }
        return new HeatMapData(collection, f2);
    }

    private synchronized void b() {
        this.z.clear();
    }

    private void a(Gradient gradient) {
        this.r = gradient;
        this.u = gradient.a(this.s);
        this.v = gradient.b();
    }

    private double[] a(int n2) {
        double[] dArray = new double[23];
        for (int i2 = 4; i2 < 11; ++i2) {
            c c2 = this.t;
            double d2 = i2 - 3;
            dArray[i2] = HeatMap.a(this.j, c2, n2, (int)(Math.pow(2.0, d2) * 1280.0));
            if (i2 != 4) continue;
            for (int i3 = 0; i3 < i2; ++i3) {
                dArray[i3] = d2 = dArray[i2];
            }
        }
        for (int i4 = 11; i4 < 23; ++i4) {
            double d3;
            dArray[i4] = d3 = dArray[10];
        }
        return dArray;
    }

    private static c b(Collection<WeightedLatLng> object) {
        object = object.iterator();
        WeightedLatLng weightedLatLng = object.next();
        double d2 = weightedLatLng.getPoint().x;
        double d3 = weightedLatLng.getPoint().x;
        double d4 = weightedLatLng.getPoint().y;
        double d5 = weightedLatLng.getPoint().y;
        while (object.hasNext()) {
            double d6;
            WeightedLatLng weightedLatLng2 = (WeightedLatLng)object.next();
            double d7 = weightedLatLng2.getPoint().x;
            double d8 = weightedLatLng2.getPoint().y;
            if (d6 < d2) {
                d2 = d7;
            }
            if (!(d7 > d3)) {
                d7 = d3;
            }
            if (d8 < d4) {
                d4 = d8;
            }
            if (!(d8 > d5)) {
                d8 = d5;
            }
            d5 = d8;
            d3 = d7;
        }
        return new c(d2, d3, d4, d5);
    }

    private static double[] a(int n2, double d2) {
        double[] dArray = new double[n2 * 2 + 1];
        for (int i2 = -(v28768); i2 <= n2; ++i2) {
            dArray[i2 + n2] = Math.exp((double)(-i2 * i2) / (d2 * 2.0 * d2));
        }
        return dArray;
    }

    private static double a(Collection<WeightedLatLng> collection, c c2, int n2, int n3) {
        LongSparseArray longSparseArray;
        double d2;
        double d3;
        c c3 = c2;
        double d4 = c3.a;
        c c4 = c2;
        double d5 = c4.b;
        double d6 = c4.d;
        double d7 = c3.c - d4;
        d6 -= d5;
        if (d3 > d2) {
            d6 = d7;
        }
        double d8 = (double)((int)((double)(n3 / (n2 * 2)) + 0.5)) / d6;
        LongSparseArray longSparseArray2 = longSparseArray;
        longSparseArray = new LongSparseArray();
        d6 = 0.0;
        for (WeightedLatLng object : collection) {
            long d10;
            Double d9;
            double n4 = object.getPoint().y;
            int n5 = (int)((n4 - d5) * d8);
            long l2 = (int)(((double)object.getPoint().x - d4) * d8);
            LongSparseArray longSparseArray3 = (LongSparseArray)longSparseArray2.get(l2);
            if (longSparseArray3 == null) {
                LongSparseArray longSparseArray4;
                longSparseArray3 = longSparseArray4;
                longSparseArray4 = new LongSparseArray();
                longSparseArray2.put(l2, (Object)longSparseArray3);
            }
            if ((d9 = (Double)longSparseArray3.get(d10 = (long)n5)) == null) {
                d9 = 0.0;
            }
            Double d11 = d9 + object.intensity;
            longSparseArray3.put(d10, (Object)d11);
            if (!(d11 > d6)) continue;
            d6 = d11;
        }
        return d6;
    }

    /* synthetic */ HeatMap(Builder builder, d d2) {
        this(builder);
    }

    static {
        a.put(3, 0x800000);
        a.put(4, 0x400000);
        a.put(5, 0x200000);
        a.put(6, 0x100000);
        a.put(7, 524288);
        a.put(8, 262144);
        a.put(9, 131072);
        a.put(10, 65536);
        a.put(11, 32768);
        a.put(12, 16384);
        a.put(13, 8192);
        a.put(14, 4096);
        a.put(15, 2048);
        a.put(16, 1024);
        a.put(17, 512);
        a.put(18, 256);
        a.put(19, 128);
        a.put(20, 64);
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = Color.rgb((int)0, (int)0, (int)200);
        nArray[1] = Color.rgb((int)0, (int)225, (int)0);
        nArray[2] = Color.rgb((int)255, (int)0, (int)0);
        b = nArray;
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = 0.08f;
        fArray[1] = 0.4f;
        fArray[2] = 1.0f;
        c = fArray;
        DEFAULT_GRADIENT = new Gradient(nArray2, fArray2);
        d = 0;
    }

    public void updateMaxIntensity(float f2) {
        if (!(f2 < 0.0f) && !(f2 <= this.m)) {
            this.l = f2;
            return;
        }
    }

    public void updateMinIntensity(float f2) {
        if (f2 < 0.0f) {
            this.m = 0.0f;
            return;
        }
        if (f2 >= this.l) {
            return;
        }
        this.m = f2;
    }

    public void updateFrameAnimation(HeatMapAnimation heatMapAnimation) {
        this.n = heatMapAnimation;
    }

    public void updateRadius(int n2) {
        if (n2 < 10) {
            this.p = 10;
            return;
        }
        if (n2 > 50) {
            this.p = 50;
            return;
        }
        this.p = n2;
    }

    public void updateRadiusMeter(int n2) {
        if (n2 < 10) {
            this.q = 10;
            return;
        }
        if (n2 > 50) {
            this.q = 50;
            return;
        }
        this.q = n2;
    }

    public void updateMaxHigh(int n2) {
        if (n2 < 0) {
            return;
        }
        if (n2 > 200) {
            this.e = 200;
            return;
        }
        this.e = n2;
    }

    public void updateIsRadiusMeter(boolean bl) {
        this.f = bl;
    }

    public void updateGradient(Gradient gradient) {
        if (gradient != null) {
            this.r = gradient;
            this.a(gradient);
            return;
        }
        throw new IllegalArgumentException("BDMapSDKException: gradient can not be null");
    }

    public void updateOpacity(double d2) {
        if (d2 < 0.0) {
            this.s = 0.0;
            return;
        }
        if (d2 > 1.0) {
            this.s = 1.0;
            return;
        }
        this.s = d2;
    }

    public void updateMaxShowLevel(int n2) {
        if (n2 < this.h) {
            return;
        }
        if (n2 > 22) {
            this.g = 22;
            return;
        }
        this.g = n2;
    }

    public void updateMinShowLevel(int n2) {
        if (n2 < 4) {
            this.h = 4;
            return;
        }
        if (n2 > this.g) {
            return;
        }
        this.h = n2;
    }

    public void updateData(Collection<LatLng> collection) {
        if (collection != null && !collection.isEmpty()) {
            if (!collection.contains(null)) {
                this.updateWeightedData(HeatMap.d(collection));
                return;
            }
            throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
        }
        throw new IllegalArgumentException("BDMapSDKException: No input points.");
    }

    public void updateDatas(List<List<LatLng>> list) {
        if (list != null && !list.isEmpty()) {
            if (!list.contains(null)) {
                this.updateWeightedDatas(HeatMap.b(list));
                return;
            }
            throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
        }
        throw new IllegalArgumentException("BDMapSDKException: No input datas.");
    }

    public void updateWeightedData(Collection<WeightedLatLng> collection) {
        if (collection != null && !collection.isEmpty()) {
            if (!collection.contains(null)) {
                this.j = collection;
                return;
            }
            throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
        }
        throw new IllegalArgumentException("BDMapSDKException: No input points.");
    }

    public void updateWeightedDatas(List<List<WeightedLatLng>> list) {
        if (list != null && !list.isEmpty()) {
            if (!list.contains(null)) {
                this.k = list;
                return;
            }
            throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
        }
        throw new IllegalArgumentException("BDMapSDKException: No input points.");
    }

    public int getMaxHigh() {
        return this.e;
    }

    public boolean isFrameAnimation() {
        HeatMapAnimation heatMapAnimation = ((HeatMap)((Object)heatMapAnimation)).n;
        if (heatMapAnimation == null) {
            return false;
        }
        return heatMapAnimation.getIsAnimation();
    }

    public boolean isInitAnimation() {
        HeatMapAnimation heatMapAnimation = ((HeatMap)((Object)heatMapAnimation)).o;
        if (heatMapAnimation == null) {
            return false;
        }
        return heatMapAnimation.getIsAnimation();
    }

    public void removeHeatMap() {
        Object object = ((HeatMap)this).C;
        if (object != null) {
            ((BaiduMap)object).a((HeatMap)this);
        }
        if ((object = ((HeatMap)this).k) != null) {
            object.clear();
        }
        if ((this = ((HeatMap)this).j) != null) {
            this.clear();
        }
    }

    protected HeatMapData getData(int n2, int n3) {
        if (n3 <= 23 && n3 >= 4) {
            List<List<WeightedLatLng>> list = this.k;
            if (list == null && this.j == null) {
                return null;
            }
            if (list != null) {
                return this.a(n2, n3);
            }
            if (this.j != null) {
                return this.b(n2, n3);
            }
            return null;
        }
        return null;
    }

    void a() {
        this.b();
    }

    void c() {
        this.A.shutdownNow();
    }

    public Bundle toBundle() {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle2.putInt("grid_size", this.D);
        bundle2.putFloat("point_size_meter", (float)(this.q * 2));
        bundle2.putFloat("point_size", (float)(this.p * 2));
        bundle2.putFloat("max_hight", (float)this.e);
        bundle.putFloat("alpha", (float)this.s);
        List<List<WeightedLatLng>> list = this.k;
        if (list != null) {
            bundle2.putInt("frame_count", list.size());
        } else if (this.j != null) {
            bundle2.putInt("frame_count", 1);
        }
        Bundle bundle3 = bundle2;
        bundle2.putIntArray("color_array", this.u);
        bundle2.putFloatArray("color_start_points", this.v);
        bundle2.putBoolean("is_need_init_animation", this.o.getIsAnimation());
        bundle2.putBoolean("is_need_frame_animation", this.n.getIsAnimation());
        bundle2.putBoolean("point_size_is_meter", this.f);
        bundle2.putInt("init_animation_duration", this.o.getDuration());
        bundle2.putInt("init_animation_type", this.o.getAnimationType());
        bundle2.putInt("frame_animation_duration", this.n.getDuration());
        bundle2.putInt("frame_animation_type", this.n.getAnimationType());
        bundle2.putFloat("max_intentity", this.l);
        bundle2.putFloat("min_intentity", this.m);
        bundle2.putFloat("max_show_level", (float)this.g);
        bundle3.putFloat("min_show_level", (float)this.h);
        return bundle3;
    }

    public static class Builder {
        private Collection<WeightedLatLng> a;
        private List<List<WeightedLatLng>> b;
        private int c = 12;
        private int d = 12;
        private Gradient e = DEFAULT_GRADIENT;
        private double f = 0.6;
        private int g = 0;
        private boolean h = false;
        private int i = 22;
        private int j = 4;
        private float k = 1.0f;
        private float l = 0.0f;
        private boolean m = false;
        private HeatMapAnimation n;
        private HeatMapAnimation o;

        public Builder() {
            Object object = HeatMapAnimation.AnimationType.Linear;
            v0.n = new HeatMapAnimation(false, 100, (HeatMapAnimation.AnimationType)((Object)object));
            v0.o = new HeatMapAnimation(false, 100, (HeatMapAnimation.AnimationType)((Object)object));
        }

        public Builder maxIntensity(float f2) {
            if (!(f2 < 0.0f) && !(f2 <= this.l)) {
                this.k = f2;
                this.m = true;
                return this;
            }
            return this;
        }

        public Builder minIntensity(float f2) {
            if (f2 < 0.0f) {
                this.l = 0.0f;
                return this;
            }
            if (f2 >= this.k) {
                return this;
            }
            this.l = f2;
            return this;
        }

        public Builder initAnimation(HeatMapAnimation heatMapAnimation) {
            this.n = heatMapAnimation;
            return this;
        }

        public Builder frameAnimation(HeatMapAnimation heatMapAnimation) {
            this.o = heatMapAnimation;
            return this;
        }

        public Builder data(Collection<LatLng> collection) {
            if (collection != null && !collection.isEmpty()) {
                if (!collection.contains(null)) {
                    return this.weightedData(HeatMap.d(collection));
                }
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }

        public Builder datas(List<List<LatLng>> list) {
            if (list != null && !list.isEmpty()) {
                if (!list.contains(null)) {
                    return this.weightedDatas(HeatMap.b(list));
                }
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            throw new IllegalArgumentException("BDMapSDKException: No input datas.");
        }

        public Builder weightedData(Collection<WeightedLatLng> collection) {
            if (collection != null && !collection.isEmpty()) {
                if (!collection.contains(null)) {
                    this.a = collection;
                    return this;
                }
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }

        public Builder weightedDatas(List<List<WeightedLatLng>> list) {
            if (list != null && !list.isEmpty()) {
                if (!list.contains(null)) {
                    this.b = list;
                    return this;
                }
                throw new IllegalArgumentException("BDMapSDKException: input points can not contain null.");
            }
            throw new IllegalArgumentException("BDMapSDKException: No input points.");
        }

        public Builder radiusMeter(int n2) {
            if (n2 < 10) {
                this.d = 10;
                return this;
            }
            if (n2 > 50) {
                this.d = 50;
                return this;
            }
            this.d = n2;
            return this;
        }

        public Builder maxShowLevel(int n2) {
            if (n2 < this.j) {
                return this;
            }
            if (n2 > 22) {
                this.i = 22;
            }
            this.i = n2;
            return this;
        }

        public Builder minShowLevel(int n2) {
            if (n2 < 4) {
                this.j = 4;
                return this;
            }
            if (n2 > this.i) {
                return this;
            }
            this.j = n2;
            return this;
        }

        public Builder radius(int n2) {
            if (n2 < 10) {
                this.c = 10;
                return this;
            }
            if (n2 > 50) {
                this.c = 50;
                return this;
            }
            this.c = n2;
            return this;
        }

        public Builder maxHigh(int n2) {
            if (n2 < 0) {
                return this;
            }
            if (n2 > 200) {
                this.g = 200;
                return this;
            }
            this.g = n2;
            return this;
        }

        public Builder isRadiusMeter(boolean bl) {
            this.h = bl;
            return this;
        }

        public Builder gradient(Gradient gradient) {
            if (gradient != null) {
                this.e = gradient;
                return this;
            }
            throw new IllegalArgumentException("BDMapSDKException: gradient can not be null");
        }

        public Builder opacity(double d2) {
            if (d2 < 0.0) {
                this.f = 0.0;
                return this;
            }
            if (d2 > 1.0) {
                this.f = 1.0;
                return this;
            }
            this.f = d2;
            return this;
        }

        public HeatMap build() {
            if (this.a == null && this.b == null) {
                throw new IllegalStateException("BDMapSDKException: No input data: you must use either .data or .weightedData before building");
            }
            return new HeatMap(this, null);
        }
    }
}

