/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.common.util;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.android.common.security.AESUtil;
import com.baidu.android.common.security.Base64;
import com.baidu.android.common.security.MD5Util;
import com.baidu.android.common.security.SHA1Util;
import com.baidu.android.common.util.CuidCertStore;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Cipher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeviceId {
    private static final String TAG = "DeviceId";
    private static final boolean DEBUG = false;
    private static final String KEY_DEVICE_ID = "com.baidu.deviceid";
    private static final String KEY_DEVICE_ID_V2 = "com.baidu.deviceid.v2";
    private static final String AES_KEY;
    private static final String OLD_EXT_DIR = "baidu";
    private static final String EXT_DIR = "backups/.SystemConfig";
    private static final String EXT_FILE = ".cuid";
    private static final String EXT_FILE_V2 = ".cuid2";
    private final Context mContext;
    private int mSaveMask = 0;
    private static final String RSA_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private PublicKey mPublicKey;
    private static final int STORAGE_SYSTEM_SETTING_V1 = 1;
    private static final int STORAGE_SYSTEM_SETTING_V2 = 2;
    private static final int STORAGE_SDCARD_V1 = 4;
    private static final int STORAGE_SDCARD_V2 = 8;
    private static final int STORAGE_SELF_FILE = 16;
    private static final String SELF_CUID_FILE = "libcuid.so";
    private static CUIDInfo sCachedCuidInfo;
    private static final String KEY_FLAG = "bd_setting_i";
    private static final String DEFAULT_TM_DEVICEID = "";
    private static final int SDK_ANDROID_M = 23;
    private static final boolean CONFIG_WRITE_V1_STORAGE = false;
    private static boolean sDataCuidInfoShable;
    private static final String sDEncoded = "ZGV2aWNlaWQ=";
    private static final String sIEncoded = "aW1laQ==";
    private static final String sVEncoded = "dmVy";
    private static final String ACTION_GLAXY_CUID = "com.baidu.intent.action.GALAXY";
    private static final String META_KEY_GLAXY_DATA = "galaxy_data";
    private static final String META_KEY_GALAXY_SF = "galaxy_sf";
    private static final int S_IRWXU = 448;
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRWXG = 56;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IRWXO = 7;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;

    private DeviceId(Context c) {
        this.mContext = c.getApplicationContext();
        this.initPublicKey();
    }

    private static String byte2hex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String hs = DEFAULT_TM_DEVICEID;
        String stmp = DEFAULT_TM_DEVICEID;
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toLowerCase();
    }

    public static void setCuidDataShable(Context context, boolean enable) {
        File myCuidFile = new File(context.getApplicationContext().getFilesDir(), SELF_CUID_FILE);
        Context appContext = context.getApplicationContext();
        if (myCuidFile.exists()) {
            if (sCachedCuidInfo == null) {
                DeviceId.tryToModifyChmodForSelfFile(appContext, enable);
            } else if (sDataCuidInfoShable != enable) {
                DeviceId.tryToModifyChmodForSelfFile(appContext, enable);
            }
        }
        sDataCuidInfoShable = enable;
    }

    private String[] formatAndroidSigArray(Signature[] signatures) {
        String[] sigs = new String[signatures.length];
        for (int i = 0; i < sigs.length; ++i) {
            sigs[i] = DeviceId.byte2hex(SHA1Util.sha1(signatures[i].toByteArray()));
        }
        return sigs;
    }

    private static byte[] decryptByPublicKey(byte[] input, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, publicKey);
        return cipher.doFinal(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPublicKey() {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(CuidCertStore.getCertBytes());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(in);
            this.mPublicKey = certificate.getPublicKey();
        }
        catch (Exception e2) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e2) {
                    DeviceId.handleThrowable(e2);
                }
            }
        }
    }

    private List<CUIDBuddyInfo> collectBuddyInfos(Intent intent, boolean checkSig) {
        ArrayList<CUIDBuddyInfo> buddyInfos = new ArrayList<CUIDBuddyInfo>();
        PackageManager pm = this.mContext.getPackageManager();
        List resolveInfos = pm.queryBroadcastReceivers(intent, 0);
        if (resolveInfos != null) {
            for (ResolveInfo resolveInfo : resolveInfos) {
                if (resolveInfo.activityInfo == null || resolveInfo.activityInfo.applicationInfo == null) continue;
                try {
                    String sf;
                    String encodedCuidValue;
                    ActivityInfo activityInfoWithMetaData = pm.getReceiverInfo(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name), 128);
                    Bundle metaData = activityInfoWithMetaData.metaData;
                    if (metaData == null || TextUtils.isEmpty((CharSequence)(encodedCuidValue = metaData.getString(META_KEY_GLAXY_DATA)))) continue;
                    byte[] galaxyDataBytes = Base64.decode(encodedCuidValue.getBytes("utf-8"));
                    String galaxyData = new String(galaxyDataBytes);
                    JSONObject jsonObj = new JSONObject(galaxyData);
                    CUIDBuddyInfo cbInfo = new CUIDBuddyInfo();
                    cbInfo.priority = jsonObj.getInt("priority");
                    cbInfo.appInfo = resolveInfo.activityInfo.applicationInfo;
                    if (this.mContext.getPackageName().equals(resolveInfo.activityInfo.applicationInfo.packageName)) {
                        cbInfo.isSelf = true;
                    }
                    if (checkSig && !TextUtils.isEmpty((CharSequence)(sf = metaData.getString(META_KEY_GALAXY_SF)))) {
                        PackageInfo pkgInfo = pm.getPackageInfo(resolveInfo.activityInfo.applicationInfo.packageName, 64);
                        JSONArray sigsJsonArray = jsonObj.getJSONArray("sigs");
                        String[] sigs = new String[sigsJsonArray.length()];
                        for (int i = 0; i < sigs.length; ++i) {
                            sigs[i] = sigsJsonArray.getString(i);
                        }
                        String[] pkgSigs = this.formatAndroidSigArray(pkgInfo.signatures);
                        if (this.isSigsEqual(sigs, pkgSigs)) {
                            boolean matched;
                            byte[] decrptSf = DeviceId.decryptByPublicKey(Base64.decode(sf.getBytes()), this.mPublicKey);
                            byte[] sha1edGalaxyData = SHA1Util.sha1(galaxyDataBytes);
                            boolean bl = matched = decrptSf != null && Arrays.equals(decrptSf, sha1edGalaxyData);
                            if (matched) {
                                cbInfo.sigMatched = true;
                            }
                        }
                    }
                    buddyInfos.add(cbInfo);
                }
                catch (Exception exception) {}
            }
        }
        Collections.sort(buddyInfos, new Comparator<CUIDBuddyInfo>(){

            @Override
            public int compare(CUIDBuddyInfo lhs, CUIDBuddyInfo rhs) {
                int vaule = rhs.priority - lhs.priority;
                if (vaule == 0) {
                    if (lhs.isSelf && rhs.isSelf) {
                        return 0;
                    }
                    if (lhs.isSelf) {
                        return -1;
                    }
                    if (rhs.isSelf) {
                        return 1;
                    }
                }
                return vaule;
            }
        });
        return buddyInfos;
    }

    private boolean isSigsEqual(String[] sigs1, String[] sigs2) {
        if (sigs1 == null || sigs2 == null || sigs1.length != sigs2.length) {
            return false;
        }
        HashSet<String> sigSet1 = new HashSet<String>();
        for (String sig : sigs1) {
            sigSet1.add(sig);
        }
        HashSet<String> sigSet2 = new HashSet<String>();
        for (String sig : sigs2) {
            sigSet2.add(sig);
        }
        return sigSet1.equals(sigSet2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private boolean writeToCuidFile(String content) {
        FileOutputStream out = null;
        int mode = 0;
        mode = sDataCuidInfoShable ? (Build.VERSION.SDK_INT >= 24 ? 0 : 1) : 0;
        try {
            out = this.mContext.openFileOutput(SELF_CUID_FILE, mode);
            out.write(content.getBytes());
            out.flush();
        }
        catch (Exception e) {
            DeviceId.handleThrowable(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e2) {
                    DeviceId.handleThrowable(e2);
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            if (mode == 0 && sDataCuidInfoShable) {
                int perms = 436;
                return TargetApiSupport.doChmodSafely(new File(this.mContext.getFilesDir(), SELF_CUID_FILE).getAbsolutePath(), perms);
            }
            if (!sDataCuidInfoShable) {
                int perms = 432;
                return TargetApiSupport.doChmodSafely(new File(this.mContext.getFilesDir(), SELF_CUID_FILE).getAbsolutePath(), perms);
            }
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    private static boolean tryToModifyChmodForSelfFile(Context context, boolean dataCuidShable) {
        File myCuidFile = new File(context.getApplicationContext().getFilesDir(), SELF_CUID_FILE);
        if (!myCuidFile.exists()) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            try {
                if (dataCuidShable) {
                    return myCuidFile.setReadable(true, false);
                }
                boolean resetResult = myCuidFile.setReadable(false, false);
                boolean setResult = myCuidFile.setReadable(true, true);
                return resetResult && setResult;
            }
            catch (Exception e) {
                DeviceId.handleThrowable(e);
                return false;
            }
        }
        int mode = dataCuidShable ? 436 : 432;
        return TargetApiSupport.doChmodSafely(myCuidFile.getAbsolutePath(), mode);
    }

    private String getSystemSettingValue(String key) {
        try {
            return Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)key);
        }
        catch (Exception e) {
            DeviceId.handleThrowable(e);
            return null;
        }
    }

    private boolean tryPutSystemSettingValue(String key, String value) {
        try {
            return Settings.System.putString((ContentResolver)this.mContext.getContentResolver(), (String)key, (String)value);
        }
        catch (Exception e) {
            DeviceId.handleThrowable(e);
            return false;
        }
    }

    private static void handleThrowable(Throwable t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, byte[] content) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(content);
            out.flush();
        }
        catch (IOException e) {
            DeviceId.handleThrowable(e);
        }
        catch (SecurityException e) {
            DeviceId.handleThrowable(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    DeviceId.handleThrowable(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(File file) {
        FileReader reader = null;
        try {
            int len;
            reader = new FileReader(file);
            char[] buf = new char[8192];
            CharArrayWriter caw = new CharArrayWriter();
            while ((len = reader.read(buf)) > 0) {
                caw.write(buf, 0, len);
            }
            String string = caw.toString();
            return string;
        }
        catch (Exception e) {
            DeviceId.handleThrowable(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e2) {
                    DeviceId.handleThrowable(e2);
                }
            }
        }
        return null;
    }

    public static String getCUID(Context c) {
        return DeviceId.getOrCreateCUIDInfo(c).getFinalCUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CUIDInfo getOrCreateCUIDInfo(Context c) {
        if (sCachedCuidInfo != null) return sCachedCuidInfo;
        Class<CUIDInfo> clazz = CUIDInfo.class;
        synchronized (CUIDInfo.class) {
            if (sCachedCuidInfo != null) return sCachedCuidInfo;
            long beginTs = SystemClock.uptimeMillis();
            sCachedCuidInfo = new DeviceId(c).getCUIDInfo();
            long l = SystemClock.uptimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sCachedCuidInfo;
        }
    }

    public static String getDeviceID(Context context) {
        return DeviceId.getOrCreateCUIDInfo((Context)context).deviceId;
    }

    private static String getAndroidId(Context context) {
        String defaultAndroidId = DEFAULT_TM_DEVICEID;
        String androidId = DEFAULT_TM_DEVICEID;
        androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (TextUtils.isEmpty((CharSequence)androidId)) {
            androidId = DEFAULT_TM_DEVICEID;
        }
        return androidId;
    }

    private CUIDInfo getCUIDInfo() {
        File myCuidFile;
        boolean checkBuddySig;
        CUIDInfo cuidInfo = null;
        String flag = null;
        List<CUIDBuddyInfo> myCuidBuddyInfos = this.collectBuddyInfos(new Intent(ACTION_GLAXY_CUID).setPackage(this.mContext.getPackageName()), true);
        if (myCuidBuddyInfos == null || myCuidBuddyInfos.size() == 0) {
            checkBuddySig = false;
            for (int i = 0; i < 3; ++i) {
                Log.w((String)TAG, (String)"galaxy lib host missing meta-data,make sure you know the right way to integrate galaxy");
            }
        } else {
            CUIDBuddyInfo myCuidBuddyInfo = myCuidBuddyInfos.get(0);
            checkBuddySig = myCuidBuddyInfo.sigMatched;
            if (!myCuidBuddyInfo.sigMatched) {
                for (int i = 0; i < 3; ++i) {
                    Log.w((String)TAG, (String)"galaxy config err, In the release version of the signature should be matched");
                }
            }
        }
        if ((myCuidFile = new File(this.mContext.getFilesDir(), SELF_CUID_FILE)).exists()) {
            cuidInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(myCuidFile)));
        }
        if (cuidInfo == null) {
            this.mSaveMask |= 0x10;
            List<CUIDBuddyInfo> buddyInfos = this.collectBuddyInfos(new Intent(ACTION_GLAXY_CUID), checkBuddySig);
            if (buddyInfos != null) {
                String filesDirName = "files";
                File myFilesDir = this.mContext.getFilesDir();
                if (!filesDirName.equals(myFilesDir.getName())) {
                    Log.e((String)TAG, (String)("fetal error:: app files dir name is unexpectedly :: " + myFilesDir.getAbsolutePath()));
                    filesDirName = myFilesDir.getName();
                }
                for (CUIDBuddyInfo cuidBuddyInfo : buddyInfos) {
                    File buddyCuidFile;
                    if (cuidBuddyInfo.isSelf || !(buddyCuidFile = new File(new File(cuidBuddyInfo.appInfo.dataDir, filesDirName), SELF_CUID_FILE)).exists() || (cuidInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(buddyCuidFile)))) == null) continue;
                    break;
                }
            }
        }
        if (cuidInfo == null) {
            cuidInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(this.getSystemSettingValue(KEY_DEVICE_ID_V2)));
        }
        boolean hasReadSdcardPermission = this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE");
        if (cuidInfo == null && hasReadSdcardPermission) {
            this.mSaveMask |= 2;
            cuidInfo = this.getCuidInfoFromExternalV2();
        }
        if (cuidInfo == null) {
            this.mSaveMask |= 8;
            cuidInfo = this.getCUidInfoFromSystemSettingV1();
        }
        boolean hasGetDefaultFlag = false;
        if (cuidInfo == null && hasReadSdcardPermission) {
            this.mSaveMask |= 1;
            flag = this.getDefaultFlag(DEFAULT_TM_DEVICEID);
            hasGetDefaultFlag = true;
            cuidInfo = this.getExternalV1DeviceId(flag);
        }
        if (cuidInfo == null) {
            String factor;
            this.mSaveMask |= 4;
            if (!hasGetDefaultFlag) {
                flag = this.getDefaultFlag(DEFAULT_TM_DEVICEID);
            }
            cuidInfo = new CUIDInfo();
            String androidId = DeviceId.getAndroidId(this.mContext);
            if (Build.VERSION.SDK_INT < 23) {
                String uuid = UUID.randomUUID().toString();
                factor = flag + androidId + uuid;
            } else {
                factor = "com.baidu" + androidId;
            }
            cuidInfo.deviceId = MD5Util.toMd5(factor.getBytes(), true);
            cuidInfo.flag = flag;
        }
        this.fixCUIDInfoByIE(cuidInfo);
        this.writeJobThread(cuidInfo);
        return cuidInfo;
    }

    private synchronized void writeJobThread(CUIDInfo cuidInfo) {
        Thread thread = new Thread(this.getWriteRunnable(cuidInfo));
        thread.start();
    }

    private boolean fixCUIDInfoByIE(CUIDInfo cuidInfo) {
        boolean needReset;
        if (cuidInfo.isIENormal()) {
            cuidInfo.flag = "O";
            needReset = true;
        } else if (cuidInfo.isIENull()) {
            cuidInfo.flag = "0";
            needReset = true;
        } else {
            needReset = false;
        }
        return needReset;
    }

    private Runnable getWriteRunnable(final CUIDInfo cuidInfo) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                File extFile;
                boolean hasSdcardWritePermission;
                String encryptCuidInfo = null;
                CUIDInfo finalCUIDInfo = new CUIDInfo();
                finalCUIDInfo.flag = cuidInfo.flag;
                finalCUIDInfo.deviceId = cuidInfo.deviceId;
                File selfCuidFile = new File(DeviceId.this.mContext.getFilesDir(), DeviceId.SELF_CUID_FILE);
                encryptCuidInfo = DeviceId.encryptCUIDInfo(finalCUIDInfo.toPersitString());
                if (!selfCuidFile.exists()) {
                    DeviceId.this.writeToCuidFile(encryptCuidInfo);
                } else {
                    CUIDInfo cuidInfoFromSelfPackage = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(selfCuidFile)));
                    if (cuidInfoFromSelfPackage != null) {
                        if (DeviceId.this.fixCUIDInfoByIE(cuidInfoFromSelfPackage)) {
                            DeviceId.this.writeToCuidFile(DeviceId.encryptCUIDInfo(cuidInfoFromSelfPackage.toPersitString()));
                        }
                    } else if (cuidInfoFromSelfPackage == null) {
                        DeviceId.this.writeToCuidFile(encryptCuidInfo);
                    }
                }
                boolean hasSysSettingWritePermission = DeviceId.this.hasWriteSettingsPermission();
                if (hasSysSettingWritePermission) {
                    String cuidStrFromV2 = DeviceId.this.getSystemSettingValue(DeviceId.KEY_DEVICE_ID_V2);
                    if (TextUtils.isEmpty((CharSequence)cuidStrFromV2)) {
                        DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_DEVICE_ID_V2, encryptCuidInfo);
                    } else {
                        CUIDInfo cuidInfoFromSettingV2 = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(cuidStrFromV2));
                        if (cuidInfoFromSettingV2 != null) {
                            if (DeviceId.this.fixCUIDInfoByIE(cuidInfoFromSettingV2)) {
                                DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_DEVICE_ID_V2, DeviceId.encryptCUIDInfo(cuidInfoFromSettingV2.toPersitString()));
                            }
                        } else if (cuidInfoFromSettingV2 == null) {
                            DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_DEVICE_ID_V2, encryptCuidInfo);
                        }
                    }
                }
                if (hasSdcardWritePermission = DeviceId.this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE")) {
                    extFile = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid2");
                    if (!extFile.exists()) {
                        DeviceId.setExternalV2DeviceId(encryptCuidInfo);
                    } else {
                        CUIDInfo cuidInfoFromSDCardV2 = DeviceId.this.getCuidInfoFromExternalV2();
                        if (cuidInfoFromSDCardV2 != null) {
                            if (DeviceId.this.fixCUIDInfoByIE(cuidInfoFromSDCardV2)) {
                                DeviceId.setExternalV2DeviceId(DeviceId.encryptCUIDInfo(cuidInfoFromSDCardV2.toPersitString()));
                            }
                        } else if (cuidInfoFromSDCardV2 == null) {
                            DeviceId.setExternalV2DeviceId(encryptCuidInfo);
                        }
                    }
                }
                if (hasSysSettingWritePermission) {
                    int length;
                    String flagFromSysSettingV1 = DeviceId.this.getSystemSettingValue(DeviceId.KEY_FLAG);
                    int n = length = TextUtils.isEmpty((CharSequence)flagFromSysSettingV1) ? 0 : flagFromSysSettingV1.length();
                    if (CUIDInfo.isIENormal(length)) {
                        DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_FLAG, "O");
                    } else if (CUIDInfo.isIENull(flagFromSysSettingV1)) {
                        DeviceId.this.tryPutSystemSettingValue(DeviceId.KEY_FLAG, "0");
                    }
                }
                if (hasSdcardWritePermission && (extFile = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid")).exists()) {
                    String flagFromSDv1 = DeviceId.this.getDefaultFlag(DeviceId.DEFAULT_TM_DEVICEID);
                    CUIDInfo cuidInfoFromSDCardV1 = DeviceId.this.getExternalV1DeviceId(flagFromSDv1);
                    if (cuidInfoFromSDCardV1 != null) {
                        if (DeviceId.this.fixCUIDInfoByIE(cuidInfoFromSDCardV1)) {
                            DeviceId.setExternalDeviceId(cuidInfoFromSDCardV1.flag, cuidInfoFromSDCardV1.deviceId);
                        }
                    } else if (cuidInfoFromSDCardV1 == null) {
                        // empty if block
                    }
                }
            }
        };
        return runnable;
    }

    private boolean hasWriteSettingsPermission() {
        return this.checkSelfPermission("android.permission.WRITE_SETTINGS");
    }

    private boolean checkSelfPermission(String permission2) {
        return this.mContext.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    private CUIDInfo getCUidInfoFromSystemSettingV1() {
        String deviceId = this.getSystemSettingValue(KEY_DEVICE_ID);
        String oldValue = this.getSystemSettingValue(KEY_FLAG);
        return CUIDInfo.createCuidInfoFromV1Cache(deviceId, oldValue);
    }

    private CUIDInfo getCuidInfoFromExternalV2() {
        String fileContent;
        File extFile = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid2");
        if (extFile.exists() && !TextUtils.isEmpty((CharSequence)(fileContent = DeviceId.getFileContent(extFile)))) {
            try {
                return CUIDInfo.createFromJson(new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(fileContent.getBytes()))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private CUIDInfo getExternalV1DeviceId(String flag) {
        String deviceId = DEFAULT_TM_DEVICEID;
        String oldeValue = DEFAULT_TM_DEVICEID;
        File extFile = new File(Environment.getExternalStorageDirectory(), "baidu/.cuid");
        if (!extFile.exists()) {
            extFile = new File(Environment.getExternalStorageDirectory(), "backups/.SystemConfig/.cuid");
        }
        try {
            FileReader fr = new FileReader(extFile);
            BufferedReader br = new BufferedReader(fr);
            StringBuilder encodeStr = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                encodeStr.append(line);
                encodeStr.append("\r\n");
            }
            br.close();
            String idStr = new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(encodeStr.toString().getBytes())));
            String[] kv = idStr.split("=");
            if (kv != null && kv.length == 2) {
                oldeValue = kv[0];
                deviceId = kv[1];
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CUIDInfo.createCuidInfoFromV1Cache(deviceId, oldeValue);
    }

    private static String encryptCUIDInfo(String org) {
        if (TextUtils.isEmpty((CharSequence)org)) {
            return null;
        }
        try {
            return Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, org.getBytes()), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            DeviceId.handleThrowable(e);
        }
        catch (Exception e) {
            DeviceId.handleThrowable(e);
        }
        return DEFAULT_TM_DEVICEID;
    }

    private static String decryptCUIDInfo(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        try {
            return new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(content.getBytes())));
        }
        catch (Exception e) {
            DeviceId.handleThrowable(e);
            return DEFAULT_TM_DEVICEID;
        }
    }

    private static void setExternalV2DeviceId(String entryptedCuidInfo) {
        File extDir = new File(Environment.getExternalStorageDirectory(), EXT_DIR);
        File extFile = new File(extDir, EXT_FILE_V2);
        try {
            if (extDir.exists() && !extDir.isDirectory()) {
                Random random = new Random();
                File tempFile = null;
                File dir = extDir.getParentFile();
                String fileName = extDir.getName();
                while ((tempFile = new File(dir, fileName + random.nextInt() + ".tmp")).exists()) {
                }
                extDir.renameTo(tempFile);
                tempFile.delete();
            }
            extDir.mkdirs();
            FileWriter fw = new FileWriter(extFile, false);
            fw.write(entryptedCuidInfo);
            fw.flush();
            fw.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setExternalDeviceId(String flag, String deviceId) {
        if (TextUtils.isEmpty((CharSequence)flag)) {
            return;
        }
        StringBuilder idSB = new StringBuilder();
        idSB.append(flag);
        idSB.append("=");
        idSB.append(deviceId);
        File extDir = new File(Environment.getExternalStorageDirectory(), EXT_DIR);
        File extFile = new File(extDir, EXT_FILE);
        try {
            if (extDir.exists() && !extDir.isDirectory()) {
                Random random = new Random();
                File tempFile = null;
                File dir = extDir.getParentFile();
                String fileName = extDir.getName();
                while ((tempFile = new File(dir, fileName + random.nextInt() + ".tmp")).exists()) {
                }
                extDir.renameTo(tempFile);
                tempFile.delete();
            }
            extDir.mkdirs();
            FileWriter fw = new FileWriter(extFile, false);
            String encoded = Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, idSB.toString().getBytes()), "utf-8");
            fw.write(encoded);
            fw.flush();
            fw.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDefaultFlag(String defValue) {
        String flag = "0";
        return flag;
    }

    private static String getBase64DecodeStr(String encoded) {
        return new String(Base64.decode(encoded.getBytes()));
    }

    static {
        sDataCuidInfoShable = true;
        String first = new String(Base64.decode(new byte[]{77, 122, 65, 121, 77, 84, 73, 120, 77, 68, 73, 61}));
        String second = new String(Base64.decode(new byte[]{90, 71, 108, 106, 100, 87, 82, 112, 89, 87, 73, 61}));
        AES_KEY = first + second;
    }

    private static class CUIDInfo {
        public String deviceId;
        public String flag;
        public int version = 2;
        public int oldValueLength = 0;
        private static final int VERSION_DEF = 2;
        public static final String I_EMPTY = "0";
        public static final String I_FIXED = "O";
        public static final int PROTOCAL_MAX_LENGTH = 14;

        private CUIDInfo() {
        }

        public boolean isIENull() {
            return CUIDInfo.isIENull(this.flag);
        }

        public boolean isIENormal() {
            return CUIDInfo.isIENormal(this.oldValueLength);
        }

        public static boolean isIENull(String i) {
            return TextUtils.isEmpty((CharSequence)i);
        }

        public static boolean isIENormal(int oldValueLength) {
            return oldValueLength >= 14;
        }

        public static CUIDInfo createFromJson(String json) {
            if (TextUtils.isEmpty((CharSequence)json)) {
                return null;
            }
            try {
                int oldValueLength;
                JSONObject jsonObj = new JSONObject(json);
                Iterator iterators = jsonObj.keys();
                String oldValue = I_EMPTY;
                while (iterators.hasNext()) {
                    String tmp_key = (String)iterators.next();
                    if (DeviceId.getBase64DecodeStr(DeviceId.sDEncoded).equals(tmp_key) || DeviceId.getBase64DecodeStr(DeviceId.sVEncoded).equals(tmp_key)) continue;
                    oldValue = jsonObj.optString(tmp_key, I_EMPTY);
                }
                String deviceId = jsonObj.getString(DeviceId.getBase64DecodeStr(DeviceId.sDEncoded));
                int version = jsonObj.getInt(DeviceId.getBase64DecodeStr(DeviceId.sVEncoded));
                int n = oldValueLength = TextUtils.isEmpty((CharSequence)oldValue) ? 0 : oldValue.length();
                if (!TextUtils.isEmpty((CharSequence)deviceId)) {
                    CUIDInfo deviceInfo = new CUIDInfo();
                    deviceInfo.deviceId = deviceId;
                    deviceInfo.version = version;
                    deviceInfo.oldValueLength = oldValueLength;
                    if (deviceInfo.oldValueLength < 14) {
                        String flagIsNullOrZeroOrO;
                        deviceInfo.flag = flagIsNullOrZeroOrO = TextUtils.isEmpty((CharSequence)oldValue) ? I_EMPTY : oldValue;
                    }
                    return deviceInfo;
                }
            }
            catch (JSONException e) {
                DeviceId.handleThrowable(e);
            }
            return null;
        }

        private static CUIDInfo createCuidInfoFromV1Cache(String device_id, String old_v) {
            if (!TextUtils.isEmpty((CharSequence)device_id)) {
                CUIDInfo cuidInfo = new CUIDInfo();
                cuidInfo.deviceId = device_id;
                int n = cuidInfo.oldValueLength = TextUtils.isEmpty((CharSequence)old_v) ? 0 : old_v.length();
                if (cuidInfo.oldValueLength < 14) {
                    String flagIsNullOrZeroOrO;
                    cuidInfo.flag = flagIsNullOrZeroOrO = TextUtils.isEmpty((CharSequence)old_v) ? I_EMPTY : old_v;
                }
                return cuidInfo;
            }
            return null;
        }

        public String toPersitString() {
            try {
                return new JSONObject().put(DeviceId.getBase64DecodeStr(DeviceId.sDEncoded), (Object)this.deviceId).put(DeviceId.getBase64DecodeStr(DeviceId.sIEncoded), (Object)this.flag).put(DeviceId.getBase64DecodeStr(DeviceId.sVEncoded), this.version).toString();
            }
            catch (JSONException e) {
                DeviceId.handleThrowable(e);
                return null;
            }
        }

        public String getFinalCUID() {
            String finalFlag = this.flag;
            if (TextUtils.isEmpty((CharSequence)finalFlag)) {
                finalFlag = I_EMPTY;
            }
            String uid = this.deviceId + "|" + finalFlag;
            return uid;
        }
    }

    static class TargetApiSupport {
        TargetApiSupport() {
        }

        static boolean doChmodSafely(String path, int perms) {
            try {
                Os.chmod((String)path, (int)perms);
            }
            catch (ErrnoException e) {
                DeviceId.handleThrowable(e);
                return false;
            }
            catch (Exception e2) {
                DeviceId.handleThrowable(e2);
                return false;
            }
            return true;
        }
    }

    private static class CUIDBuddyInfo {
        public ApplicationInfo appInfo;
        public int priority = 0;
        public boolean sigMatched = false;
        public boolean isSelf = false;

        private CUIDBuddyInfo() {
        }
    }
}

