/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.tts;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.navisdk.tts.BNTTSUtils;
import com.baidu.navisdk.tts.ITTSInitListener;
import com.baidu.navisdk.tts.OnTTSStateChangedListener;
import com.baidu.tts.chainofresponsibility.logger.LoggerProxy;
import com.baidu.tts.client.SpeechError;
import com.baidu.tts.client.SpeechSynthesizer;
import com.baidu.tts.client.SpeechSynthesizerListener;
import com.baidu.tts.client.TtsMode;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BNTTSPlayer {
    private static final String TAG = "tts";
    public static final int PLAYER_STATE_NOT_INIT = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSE = 3;
    private static final String K_TTS_DATA_FILE = "bd_etts_ch_speech.dat";
    private static final String K_TTS_TEXT_DATA_FILE = "bd_etts_ch_text_default.dat";
    public static final int INIT_STATE_NO = 0;
    public static final int INIT_STATE_INITING = 1;
    public static final int INIT_STATE_OK = 2;
    private final Object mPlayStateLock = new Object();
    private static final int MSG_RESET_TTS_FOR_TIMEOUT = 1;
    private static final int DEFAULT_SPEED = 5;
    private Context mContext;
    private SpeechSynthesizer ttsPlayer;
    private int mInitState = 0;
    private String mSDCardAPPBasePath = null;
    private String mNormalVoicePath = null;
    private boolean mIsTTSPlaying = false;
    private boolean mIsPausing = false;
    private boolean isTimeOutEnable = false;
    private int mCurrentVolume = 7;
    private boolean isLogEnable;
    private OnTTSStateChangedListener mOnTTSStateChangedListener;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            if (1 == msg.what) {
                BNTTSPlayer.this.resetTTSForTimeout();
            }
        }
    };
    private final SpeechSynthesizerListener mSpeechSynthesizerListener = new SpeechSynthesizerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSpeechStart(String arg0) {
            BNTTSPlayer.this.loge("BdTTSPlayer", "onPlayStart() arg = " + arg0);
            if (BNTTSPlayer.this.mOnTTSStateChangedListener != null) {
                BNTTSPlayer.this.mOnTTSStateChangedListener.onPlayStart();
            }
            Object object = BNTTSPlayer.this.mPlayStateLock;
            synchronized (object) {
                BNTTSPlayer.this.mIsTTSPlaying = true;
            }
        }

        public void onSynthesizeFinish(String arg0) {
        }

        public void onSynthesizeStart(String arg0) {
        }

        public void onSynthesizeDataArrived(String s, byte[] bytes, int i, int i1) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSpeechFinish(String arg0) {
            BNTTSPlayer.this.loge("BdTTSPlayer", "onPlayFinish() arg = " + arg0);
            Object object = BNTTSPlayer.this.mPlayStateLock;
            synchronized (object) {
                BNTTSPlayer.this.mIsTTSPlaying = false;
                if (BNTTSPlayer.this.mHandler.hasMessages(1)) {
                    BNTTSPlayer.this.mHandler.removeMessages(1);
                }
            }
            if (BNTTSPlayer.this.mOnTTSStateChangedListener != null) {
                BNTTSPlayer.this.mOnTTSStateChangedListener.onPlayEnd(arg0);
            }
        }

        public void onError(String arg0, SpeechError arg1) {
            BNTTSPlayer.this.loge("BdTTSPlayer", "onError() arg = " + arg1.toString());
            if (BNTTSPlayer.this.mOnTTSStateChangedListener != null) {
                BNTTSPlayer.this.mOnTTSStateChangedListener.onPlayError(arg1.code, arg1.description);
            }
        }

        public void onLipDataArrived(String s, byte[] bytes) {
        }

        public void onSpeechProgressChanged(String arg0, int arg1) {
        }
    };

    public static BNTTSPlayer getInstance() {
        return Holder.INSTANCE;
    }

    public void setTTSLogEnable(boolean enable) {
        this.isLogEnable = enable;
    }

    public int getCurrentVolume() {
        return this.mCurrentVolume;
    }

    public void setCurrentVolume(int mCurrentVolume) {
        this.mCurrentVolume = mCurrentVolume;
        if (this.ttsPlayer != null) {
            this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_VOLUME, String.valueOf(mCurrentVolume));
        }
    }

    public void initPlayer(Context context, String appKey, String secretKey, String authsn, ITTSInitListener listener) {
        if (context == null || this.mInitState != 0) {
            return;
        }
        this.mInitState = 1;
        try {
            System.loadLibrary("bd_tts_log");
            System.loadLibrary("BDSpeechDecoder_V1");
            System.loadLibrary("bd_etts");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.mContext = context.getApplicationContext();
        String sdcardRootPath = context.getExternalFilesDir(null).getPath();
        this.mSDCardAPPBasePath = sdcardRootPath + File.separator + TAG;
        this.mNormalVoicePath = context.getDir(TAG, 0).getPath();
        this.makeSureDirs();
        if (this.copyRes()) {
            this.initPlayerInner(appKey, secretKey, authsn, listener);
        } else {
            this.mInitState = 0;
        }
    }

    private void resetTTSForTimeout() {
        if (this.ttsPlayer == null || this.mInitState != 2) {
            return;
        }
        this.loge("BdTTSPlayer", "resetTTSForTimeout() ");
        this.stopTTS();
    }

    public int getInitState() {
        return this.mInitState;
    }

    private void makeSureDirs() {
        File normalFile;
        File f = new File(this.mSDCardAPPBasePath + File.separator + TAG);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(normalFile = new File(this.mNormalVoicePath)).exists()) {
            normalFile.mkdir();
        }
    }

    private synchronized boolean initPlayerInner(String appKey, String secretKey, String authsn, ITTSInitListener listener) {
        if (this.mContext == null || this.mSDCardAPPBasePath == null || this.mSDCardAPPBasePath.length() == 0) {
            this.mInitState = 0;
            return false;
        }
        long startTime = SystemClock.elapsedRealtime();
        try {
            if (this.ttsPlayer == null) {
                this.loge("BdTTSPlayer", "initPlayer() start");
                if (this.isLogEnable) {
                    LoggerProxy.printable((boolean)true);
                }
                this.ttsPlayer = SpeechSynthesizer.getInstance();
                this.ttsPlayer.setContext(this.mContext);
                this.ttsPlayer.setSpeechSynthesizerListener(this.mSpeechSynthesizerListener);
                this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_SPEED, String.valueOf(5));
                this.setCurrentVolume(7);
                String textFile = this.mNormalVoicePath + File.separator + K_TTS_TEXT_DATA_FILE;
                this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_TTS_TEXT_MODEL_FILE, textFile);
                this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_TTS_SPEECH_MODEL_FILE, this.mNormalVoicePath + File.separator + K_TTS_DATA_FILE);
                this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_AUTH_SN, authsn);
                this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_PRODUCT_ID, "90014");
                this.ttsPlayer.setAppId("90014");
                this.ttsPlayer.setApiKey(appKey, secretKey);
                this.ttsPlayer.auth(TtsMode.OFFLINE);
                int initTTSResult = this.ttsPlayer.initTts(TtsMode.OFFLINE);
                this.loge(TAG, "initResult:" + initTTSResult);
                if (initTTSResult != 0) {
                    if (this.copyRes()) {
                        this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_TTS_SPEECH_MODEL_FILE, this.mNormalVoicePath + File.separator + K_TTS_DATA_FILE);
                        this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_TTS_TEXT_MODEL_FILE, this.mNormalVoicePath + File.separator + K_TTS_TEXT_DATA_FILE);
                        initTTSResult = this.ttsPlayer.initTts(TtsMode.OFFLINE);
                        this.loge(TAG, "initPlayerInner initTts-initTTSResult = " + initTTSResult + ", init ttsPlayer init again");
                    }
                    if (initTTSResult != 0) {
                        this.ttsPlayer = null;
                        this.mInitState = 0;
                        if (listener != null) {
                            listener.onFail(initTTSResult);
                        }
                        return false;
                    }
                }
                this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_OPEN_XML, "1");
                this.ttsPlayer.setParam(SpeechSynthesizer.PARAM_CUSTOM_SYNTH, "1");
                this.loge("BdTTSPlayer", "initPlayer() end, initTime=" + (SystemClock.elapsedRealtime() - startTime) + "/ms");
            }
            this.mInitState = 2;
            if (listener != null) {
                listener.onSuccess();
            }
            return true;
        }
        catch (Throwable t) {
            this.ttsPlayer = null;
            this.mInitState = 0;
            if (listener != null) {
                listener.onFail(100);
            }
            return false;
        }
    }

    private boolean copyRes() {
        if (this.mContext == null) {
            return false;
        }
        boolean ret = this.copyAssetsFile(K_TTS_DATA_FILE, this.mNormalVoicePath, K_TTS_DATA_FILE);
        this.loge("BdTTSPlayer", "initPlayer() copy, ret=" + ret + ", path=" + this.mNormalVoicePath + "/" + K_TTS_DATA_FILE);
        this.loge("BdTTSPlayer", "initPlayer() copy text, ret=" + (ret &= this.copyAssetsFile(K_TTS_TEXT_DATA_FILE, this.mNormalVoicePath, K_TTS_TEXT_DATA_FILE)) + ", path=" + this.mNormalVoicePath + "/" + K_TTS_TEXT_DATA_FILE);
        return ret;
    }

    public void setEnableTimeOut(boolean enable) {
        this.isTimeOutEnable = enable;
        if (!this.isTimeOutEnable && this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTTSState() {
        if (this.ttsPlayer == null) {
            return 0;
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            if (this.isTimeOutEnable) {
                if (!this.mIsTTSPlaying || this.mIsPausing) {
                    if (this.mHandler.hasMessages(1)) {
                        this.mHandler.removeMessages(1);
                    }
                } else if (!this.mHandler.hasMessages(1)) {
                    this.mHandler.sendEmptyMessageDelayed(1, 20000L);
                }
            }
            int ret = this.mIsPausing ? 3 : (!this.mIsTTSPlaying ? 1 : 2);
            this.loge("BdTTSPlayer", "TTSState: " + ret + ", mIsTTSPlaying: " + this.mIsTTSPlaying + ", mIsPausing: " + this.mIsPausing + ", isTimeOutEnable: " + this.isTimeOutEnable);
            return ret;
        }
    }

    private int playTTSText(String speech, boolean bPreempt) {
        return this.playTTSText(speech, null, bPreempt);
    }

    private int playTTSText(String speech, String speechId, boolean bPreempt) {
        int result = 0;
        if (this.ttsPlayer == null || this.mInitState != 2) {
            return result;
        }
        try {
            if (!BNTTSUtils.isCalling(this.mContext)) {
                if (bPreempt && this.getTTSState() == 2) {
                    this.ttsPlayer.stop();
                }
                this.doSpeak(speech, speechId);
            } else {
                this.loge(TAG, " BdTTSPlayer playTTSText isCalling");
            }
        }
        catch (Exception e) {
            this.loge("", e.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTTS() {
        block6: {
            this.loge("BdTTSPlayer", "stopTTS");
            try {
                if (this.ttsPlayer == null) break block6;
                Object object = this.mPlayStateLock;
                synchronized (object) {
                    this.mIsTTSPlaying = false;
                    this.mIsPausing = false;
                }
                if (this.mContext != null) {
                    BNTTSUtils.releaseAudioFocus(this.mContext);
                }
                this.ttsPlayer.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pauseTTS() {
        this.loge("BdTTSPlayer", "pauseTTS");
        if (this.ttsPlayer != null) {
            Object object = this.mPlayStateLock;
            synchronized (object) {
                this.mIsPausing = true;
            }
            return this.ttsPlayer.pause();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resumeTTS() {
        this.loge("BdTTSPlayer", "resumeTTS");
        if (this.ttsPlayer != null) {
            Object object = this.mPlayStateLock;
            synchronized (object) {
                this.mIsPausing = false;
            }
            return this.ttsPlayer.resume();
        }
        return -1;
    }

    public void setOnTTSStateChangedListener(OnTTSStateChangedListener listener) {
        this.mOnTTSStateChangedListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSpeak(String speech, String speechId) {
        if (this.ttsPlayer == null) {
            return;
        }
        Object object = this.mPlayStateLock;
        synchronized (object) {
            this.mIsTTSPlaying = true;
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)speechId)) {
                this.ttsPlayer.speak(speech, speechId);
            } else {
                this.ttsPlayer.speak(speech);
            }
        }
        catch (Throwable e) {
            this.loge("BdTTSPlayer", "doSpeak Exception:" + e.getMessage());
            Object object2 = this.mPlayStateLock;
            synchronized (object2) {
                this.mIsTTSPlaying = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyAssetsFile(String assetPath, String destPath, String desFileName) {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            int len;
            is = this.openAssetRes(assetPath);
            if (is == null) {
                boolean bl = false;
                return bl;
            }
            File file = new File(destPath + File.separator + desFileName);
            long fileLen = file.length();
            int assetLen = is.available();
            if (file.exists() && fileLen == (long)assetLen) {
                boolean bl = true;
                return bl;
            }
            File out = new File(destPath);
            if (!out.exists()) {
                out.mkdirs();
            }
            File outFile = new File(destPath + "/" + desFileName);
            this.loge(TAG, "copyAssetsFile path = " + destPath + "/" + desFileName);
            if (outFile.exists()) {
                outFile.delete();
                this.loge(TAG, "copyAssetsFile file exists -> delete");
            }
            os = new FileOutputStream(outFile);
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
            this.close(is);
            this.close(os);
        }
        catch (Exception e) {
            this.loge(TAG, e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(is);
            this.close(os);
        }
        return true;
    }

    private void loge(String tag, String info) {
        if (this.isLogEnable) {
            Log.e((String)TAG, (String)(tag + ": " + info));
        }
    }

    private void close(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public InputStream openAssetRes(String assetRes) {
        if (this.mContext != null) {
            try {
                return this.mContext.getAssets().open(assetRes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static final class Holder {
        private static final BNTTSPlayer INSTANCE = new BNTTSPlayer();

        private Holder() {
        }
    }
}

