/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.tts;

import android.content.Context;
import android.media.AudioManager;
import android.util.Log;

public class BNTTSUtils {
    private static final String TAG = BNTTSUtils.class.getSimpleName();
    public static AudioManager.OnAudioFocusChangeListener sOnAudioFocusChange = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            Log.i((String)TAG, (String)("onAudioFocusChange focusChange = " + focusChange));
        }
    };

    public static AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getApplicationContext().getSystemService("audio");
    }

    public static void requestAudioFocus(Context context) {
        if (context == null) {
            return;
        }
        try {
            AudioManager am = BNTTSUtils.getAudioManager(context);
            if (am != null) {
                am.requestAudioFocus(sOnAudioFocusChange, 3, 3);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void requestAudioFocusToStopMusic(Context context) {
        if (context == null) {
            return;
        }
        try {
            AudioManager am = BNTTSUtils.getAudioManager(context);
            if (am != null) {
                am.requestAudioFocus(sOnAudioFocusChange, 3, 2);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void releaseAudioFocus(Context context) {
        if (context == null) {
            return;
        }
        AudioManager am = BNTTSUtils.getAudioManager(context);
        am.abandonAudioFocus(sOnAudioFocusChange);
    }

    public static boolean isCalling(Context context) {
        if (context == null) {
            return false;
        }
        AudioManager am = (AudioManager)context.getSystemService("audio");
        if (am == null) {
            return false;
        }
        int mode = am.getMode();
        return mode != -2 && mode != -1 && mode != 0;
    }
}

