/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.baidu.platform.comapi.util.NetworkCallbackImpl;

public class NetworkUtil {
    public static final int NETYPE_NOCON = -1;
    public static final int NETYPE_UNKNOWN = 0;
    public static final int NETYPE_WIFI = 1;
    public static final int NETYPE_2G = 2;
    public static final int NETYPE_3G = 3;
    public static final int NETYPE_4G = 4;
    public static final int NETYPE_TELECOM_2G = 5;
    public static final int NETYPE_MOBILE_UNICOM_2G = 6;
    public static final int NETYPE_TELECOM_3G = 7;
    public static final int NETYPE_MOBILE_3G = 8;
    public static final int NETYPE_UNICOM_3G = 9;
    public static final int NETYPE_4G_UNKNOWN = 10;
    public static boolean mUseProxy = false;
    public static String mProxyHost = "";
    public static int mProxyPort = 0;

    public static void updateNetworkProxy(Context context) {
    }

    public static boolean initConnectState() {
        return true;
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) != null) {
            try {
                return context.getActiveNetworkInfo();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static NetworkInfo[] getAllNetworkInfo(Context networkInfoArray) {
        if (networkInfoArray == null) {
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)networkInfoArray.getSystemService("connectivity");
        networkInfoArray = null;
        try {
            networkInfoArray = connectivityManager.getAllNetworkInfo();
        }
        catch (Exception exception) {}
        return networkInfoArray;
    }

    @SuppressLint(value={"NewApi"})
    public static void registerNetwork(Context object) {
        if (object == null) {
            return;
        }
        object = (ConnectivityManager)object.getSystemService("connectivity");
        NetworkRequest networkRequest = new NetworkRequest.Builder().build();
        if (object != null) {
            NetworkCallbackImpl networkCallbackImpl;
            Context context = object;
            object = networkCallbackImpl;
            networkCallbackImpl = new NetworkCallbackImpl();
            context.registerNetworkCallback(networkRequest, (ConnectivityManager.NetworkCallback)object);
        }
    }

    public static String getCurrentNetMode(Context object) {
        int n = -1;
        NetworkInfo networkInfo = NetworkUtil.getActiveNetworkInfo(object);
        if (networkInfo != null) {
            int n2 = networkInfo.getType();
            if (n2 == 1) {
                n = 1;
            } else if (n2 == 0 || n2 == 3 || n2 == 4 || n2 == 5) {
                if (Build.VERSION.SDK_INT > 29) {
                    Context context = object;
                    object = "mobile";
                    ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (connectivityManager == null) {
                        return object;
                    }
                    ConnectivityManager connectivityManager2 = connectivityManager;
                    return NetworkUtil.a(connectivityManager2.getNetworkCapabilities(connectivityManager2.getActiveNetwork()));
                }
                if ((object = (TelephonyManager)object.getSystemService("phone")) != null) {
                    switch (object.getNetworkType()) {
                        default: {
                            n = 0;
                            break;
                        }
                        case 14: {
                            n = 3;
                            break;
                        }
                        case 13: 
                        case 18: {
                            n = 4;
                            break;
                        }
                        case 8: 
                        case 17: {
                            n = 8;
                            break;
                        }
                        case 7: 
                        case 11: 
                        case 16: {
                            n = 2;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 12: {
                            n = 7;
                            break;
                        }
                        case 4: {
                            n = 5;
                            break;
                        }
                        case 3: 
                        case 9: 
                        case 10: 
                        case 15: {
                            n = 9;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n = 6;
                            break;
                        }
                    }
                }
            }
        } else {
            n = -1;
        }
        return Integer.toString(n);
    }

    @SuppressLint(value={"NewApi"})
    private static String a(NetworkCapabilities networkCapabilities) {
        String string = "mobile";
        if (networkCapabilities == null) {
            return string;
        }
        NetworkCapabilities networkCapabilities2 = networkCapabilities;
        boolean bl = networkCapabilities2.hasTransport(0);
        boolean bl2 = networkCapabilities2.hasTransport(3);
        boolean bl3 = networkCapabilities2.hasTransport(6);
        boolean bl4 = networkCapabilities2.hasTransport(4);
        boolean bl5 = networkCapabilities2.hasTransport(5);
        if (networkCapabilities.hasTransport(1)) {
            string = "WIFI";
        } else if (bl) {
            string = "CELLULAR";
        } else if (bl2) {
            string = "ETHERNET";
        } else if (bl3) {
            string = "LoWPAN";
        } else if (bl4) {
            string = "VPN";
        } else if (bl5) {
            string = "WifiAware";
        }
        return string;
    }

    public static boolean isNetworkAvailable(Context context) {
        boolean bl;
        block6: {
            block5: {
                block4: {
                    try {
                        if (!NetworkUtil.isWifiConnected(context)) break block4;
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
                if (context == null) break block5;
                if (!context.isConnectedOrConnecting()) break block5;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isWifiConnected(Context context) {
        boolean bl;
        block6: {
            block7: {
                ConnectivityManager connectivityManager;
                if (context == null) {
                    return false;
                }
                bl = false;
                try {
                    connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (connectivityManager == null) break block6;
                }
                catch (Exception exception) {}
                connectivityManager = connectivityManager.getActiveNetworkInfo();
                if (connectivityManager == null) break block6;
                if (1 != connectivityManager.getType()) break block7;
                if (!connectivityManager.isConnected()) break block7;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"MissingPermission"})
    public static boolean isWifiState(Context context) {
        int n;
        block5: {
            if (context == null) {
                return false;
            }
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            n = 1;
            try {
                int n2;
                if (Build.VERSION.SDK_INT >= 23) {
                    if (context.checkSelfPermission("android.permission.ACCESS_WIFI_STATE") != 0) break block5;
                    n2 = wifiManager.getWifiState();
                } else {
                    n2 = wifiManager.getWifiState();
                }
                n = n2;
            }
            catch (Exception exception) {}
        }
        if (n != 3) return false;
        return true;
    }

    public static String getNetworkOperatorInfo(Context object) {
        if ((object = (TelephonyManager)object.getSystemService("phone")) != null && !TextUtils.isEmpty((CharSequence)(object = object.getNetworkOperator()))) {
            StringBuilder stringBuilder;
            try {
                StringBuilder stringBuilder2 = new StringBuilder((String)object);
                stringBuilder = stringBuilder2;
                stringBuilder2.insert(3, ":");
            }
            catch (Exception exception) {
                return "";
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static int getNetworkOperatorType(Context object) {
        if (!TextUtils.isEmpty((CharSequence)(object = NetworkUtil.getNetworkOperatorInfo((Context)object)))) {
            if (!((String)object).startsWith("460:00") && !((String)object).startsWith("460:02")) {
                if (((String)object).startsWith("460:01")) {
                    return 1;
                }
                if (((String)object).startsWith("460:03")) {
                    return 2;
                }
            } else {
                return 0;
            }
        }
        return -1;
    }
}

