/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapauto.auth.util;

import android.text.TextUtils;
import com.baidu.mapauto.auth.org.spongycastle.asn1.b;
import com.baidu.mapauto.auth.org.spongycastle.asn1.i;
import com.baidu.mapauto.auth.org.spongycastle.asn1.pkcs.a;
import com.baidu.mapauto.auth.org.spongycastle.asn1.s;
import com.baidu.mapauto.auth.org.spongycastle.util.io.pem.c;
import com.baidu.mapauto.auth.util.Base64Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public final class RSAUtil {
    private static final String ALGORITHM_KEY = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String ALGORITHMS = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
    private static final int KEY_SIZE = 2048;
    private static KeyPair keyPair;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyPair generateKeyPair() {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM_KEY);
        }
        catch (Exception exception) {
            return null;
        }
        keyPairGenerator.initialize(2048, new SecureRandom());
        if (keyPair != null) return keyPair;
        keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static String encryptToHexStringPub(String string, PublicKey publicKey) {
        if (!TextUtils.isEmpty((CharSequence)string) && publicKey != null) {
            Cipher cipher;
            try {
                cipher = Cipher.getInstance(ALGORITHMS);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            cipher.init(1, publicKey);
            return RSAUtil.byte2Hex(cipher.doFinal(string.getBytes(StandardCharsets.UTF_8)));
        }
        return null;
    }

    public static String convertCS2Pem(byte[] object) {
        StringWriter stringWriter;
        com.baidu.mapauto.auth.org.spongycastle.util.io.pem.b b2;
        com.baidu.mapauto.auth.org.spongycastle.util.io.pem.b b3 = b2;
        try {
            b2 = new com.baidu.mapauto.auth.org.spongycastle.util.io.pem.b(com.baidu.mapauto.auth.org.spongycastle.util.io.pem.b.c, (byte[])object);
        }
        catch (IOException iOException) {
            return null;
        }
        object = stringWriter;
        stringWriter = new StringWriter();
        c c2 = new c((StringWriter)object);
        c2.a(b3);
        ((Writer)c2).close();
        return stringWriter.toString();
    }

    public static String pemString2PemFormat(String string) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (i2 != 0 && i2 % 64 == 0) {
                stringBuffer2.append('\n');
            }
            stringBuffer2.append(string.charAt(i2));
        }
        return stringBuffer2.toString();
    }

    public static String pemFormat2PemString(String string) {
        BufferedReader bufferedReader;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(string.getBytes(Charset.forName("utf8"))), Charset.forName("utf8")));
        while (true) {
            string = bufferedReader2.readLine();
            if (string == null) break;
            if (string.contains("-----END RSA PUBLIC KEY-----")) continue;
            if (string.contains("-----BEGIN RSA PUBLIC KEY-----")) continue;
            stringBuilder2.append(string);
        }
        try {
            return stringBuilder2.toString();
        }
        catch (IOException iOException) {
            return stringBuilder2.toString();
        }
    }

    public static PublicKey getPublicKeyFromPemString(String object, boolean bl) {
        if (!bl) {
            object = RSAUtil.pemString2PemFormat((String)object);
        }
        object = RSAUtil.formatPublicKeyPKCS1ToPKCS8(Base64Util.decode(((String)object).getBytes(StandardCharsets.UTF_8)));
        try {
            return KeyFactory.getInstance(ALGORITHM_KEY).generatePublic(new X509EncodedKeySpec((byte[])object));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return null;
    }

    public static PrivateKey getPrivateKeyFromPemString(String object, boolean bl) {
        if (!bl) {
            object = RSAUtil.pemString2PemFormat((String)object);
        }
        object = Base64Util.decode(((String)object).getBytes(StandardCharsets.UTF_8));
        try {
            return (PrivateKey)((Object)KeyFactory.getInstance(ALGORITHM_KEY).generatePublic(new PKCS8EncodedKeySpec((byte[])object)));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPublicKeyCS1Pem(PublicKey object) {
        Object object2;
        block15: {
            block14: {
                byte[] byArray;
                try {
                    byArray = object.getEncoded();
                }
                catch (IOException iOException) {
                    return null;
                }
                object = byArray;
                if (!(byArray instanceof com.baidu.mapauto.auth.org.spongycastle.asn1.x509.b)) break block14;
                object2 = object = (com.baidu.mapauto.auth.org.spongycastle.asn1.x509.b)object;
                break block15;
            }
            if (object != null) {
                com.baidu.mapauto.auth.org.spongycastle.asn1.x509.b b2;
                object2 = b2;
                b2 = new com.baidu.mapauto.auth.org.spongycastle.asn1.x509.b(s.a(object));
            } else {
                object2 = null;
            }
        }
        Object object3 = object2;
        Object object4 = object3;
        object3.getClass();
        object2 = ((com.baidu.mapauto.auth.org.spongycastle.asn1.x509.b)object4).b;
        if (((b)object2).b != 0) throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        Object object5 = object;
        ((i)object5)(com.baidu.mapauto.auth.org.spongycastle.util.a.a(((b)object2).a));
        byte[] byArray = ((i)object5).a().d();
        byte[] byArray2 = byArray;
        RSAUtil.formatPublicKeyPKCS1ToPKCS8(byArray);
        return RSAUtil.pemFormat2PemString(RSAUtil.convertCS2Pem(byArray2));
    }

    public static byte[] decryptHexStringBySec(String object, PrivateKey privateKey) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        try {
            object = RSAUtil.hex2Byte((String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Cipher cipher = Cipher.getInstance(ALGORITHMS);
        cipher.init(2, privateKey);
        return cipher.doFinal((byte[])object);
    }

    public static String encrypt(String object, PublicKey publicKey) throws Exception {
        MGF1ParameterSpec mGF1ParameterSpec;
        OAEPParameterSpec oAEPParameterSpec;
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING");
        object = oAEPParameterSpec;
        MGF1ParameterSpec mGF1ParameterSpec2 = mGF1ParameterSpec;
        mGF1ParameterSpec = new MGF1ParameterSpec("SHA-1");
        PSource.PSpecified pSpecified = PSource.PSpecified.DEFAULT;
        oAEPParameterSpec = new OAEPParameterSpec("SHA1", "MGF1", mGF1ParameterSpec2, pSpecified);
        cipher.init(1, (Key)publicKey, (AlgorithmParameterSpec)object);
        return RSAUtil.byte2Hex(cipher.doFinal(((String)object).getBytes("UTF-8")));
    }

    public static byte[] decode(String object, PrivateKey privateKey) {
        OAEPParameterSpec oAEPParameterSpec;
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING");
        }
        catch (Exception exception) {
            return null;
        }
        Cipher cipher2 = cipher;
        String string = object;
        object = oAEPParameterSpec;
        oAEPParameterSpec = new OAEPParameterSpec("SHA1", "MGF1", new MGF1ParameterSpec("SHA-1"), PSource.PSpecified.DEFAULT);
        cipher2.init(2, (Key)privateKey, (AlgorithmParameterSpec)object);
        return cipher.doFinal(RSAUtil.hex2Byte(string));
    }

    public static byte[] hex2Byte(String string) {
        if (string != null && string.length() >= 1) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i2 = 0; i2 < string.length() / 2; ++i2) {
                int n2 = i2 * 2;
                int n3 = n2;
                int n4 = n2 + 1;
                n3 = Integer.parseInt(string.substring(n4, n3 + 2), 16);
                byArray[i2] = (byte)(Integer.parseInt(string.substring(n2, n4), 16) * 16 + n3);
            }
            return byArray;
        }
        return null;
    }

    public static PrivateKey getPrivateKeyFrom16(String object) {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        try {
            object = RSAUtil.hex2Byte((String)object);
        }
        catch (Exception exception) {
            exception.getMessage();
            return null;
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec2 = pKCS8EncodedKeySpec;
        pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec((byte[])object);
        return KeyFactory.getInstance(ALGORITHM_KEY).generatePrivate(pKCS8EncodedKeySpec2);
    }

    public static String byte2Hex(byte[] byArray) {
        StringBuilder stringBuilder;
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuilder2.append(Integer.toString((byArray[i2] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder2.toString();
    }

    @Deprecated
    public static PublicKey getPublicKey(String object) {
        X509EncodedKeySpec x509EncodedKeySpec;
        object = Base64Util.decode(((String)object).getBytes(StandardCharsets.UTF_8));
        X509EncodedKeySpec x509EncodedKeySpec2 = x509EncodedKeySpec;
        try {
            x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object);
            return KeyFactory.getInstance(ALGORITHM_KEY).generatePublic(x509EncodedKeySpec2);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return null;
    }

    public static String getPrivateKeyStr(PrivateKey privateKey) throws Exception {
        return RSAUtil.byte2Hex(privateKey.getEncoded());
    }

    public static boolean verify(String string, PublicKey publicKey, String string2) {
        Signature signature;
        try {
            signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        signature.initVerify(publicKey);
        signature.update(string.getBytes(StandardCharsets.UTF_8));
        return signature.verify(RSAUtil.hex2Byte(string2));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] formatPublicKeyPKCS1ToPKCS8(byte[] object) {
        block8: {
            void var1_4;
            RSAPublicKeySpec rSAPublicKeySpec;
            Object object2;
            if (object instanceof a) {
                object2 = object = (Object)((a)object);
            } else if (object != null) {
                a a2;
                object2 = a2;
                a2 = new a(s.a(object));
            } else {
                object2 = null;
            }
            object = null;
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_KEY);
            RSAPublicKeySpec rSAPublicKeySpec2 = rSAPublicKeySpec;
            RSAPublicKeySpec rSAPublicKeySpec3 = rSAPublicKeySpec;
            Object object3 = object2;
            object2 = object2.a;
            try {
                rSAPublicKeySpec2((BigInteger)object2, object3.b);
                object = keyFactory.generatePublic(rSAPublicKeySpec3).getEncoded();
                break block8;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            var1_4.printStackTrace();
        }
        return object;
    }
}

