/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.location;

import com.baidu.platform.comapi.basestruct.ComplexPt;
import com.baidu.platform.comapi.basestruct.GeoPoint;
import com.baidu.platform.comapi.basestruct.Point;
import com.baidu.platform.comapi.location.CoordinateUtil;
import java.util.ArrayList;

public class CoordinateUtilEx {
    public static Point getGeoPointFromString(String string) {
        if (string != null && !string.equals("")) {
            return CoordinateUtil.geoStringToPoint(string);
        }
        return null;
    }

    public static String getStringFromGeoPoint(Point point) {
        return CoordinateUtil.pointToGeoString(point);
    }

    @Deprecated
    public static ComplexPt getGeoComplexPtBoundFromString(String string) {
        if (string != null && !string.equals("")) {
            return CoordinateUtil.geoStringToComplexPtBound(string);
        }
        return null;
    }

    @Deprecated
    public static ComplexPt getGeoComplexPointFromString(String string) {
        if (string != null && !string.equals("")) {
            return CoordinateUtil.geoStringToComplexPt(string);
        }
        return null;
    }

    public static double getDistanceByMc(Point point, Point point2) {
        Point point3 = point2;
        double d2 = point.getDoubleY();
        double d3 = point3.getDoubleX();
        double d4 = point3.getDoubleY();
        return CoordinateUtil.getDistanceByMc(point.getDoubleX(), d2, d3, d4);
    }

    public static double getDistanceByMc(GeoPoint geoPoint, GeoPoint geoPoint2) {
        GeoPoint geoPoint3 = geoPoint2;
        double d2 = geoPoint.getLatitude();
        double d3 = geoPoint3.getLongitude();
        double d4 = geoPoint3.getLatitude();
        return CoordinateUtil.getDistanceByMc(geoPoint.getLongitude(), d2, d3, d4);
    }

    public static Point getIntermediatePointByMC(Point point, Point point2, double d2) {
        Point point3 = point2;
        double d3 = point.getDoubleY();
        double d4 = point3.getDoubleX();
        double d5 = point3.getDoubleY();
        return CoordinateUtil.getIntermediatePointByMC(point.getDoubleX(), d3, d4, d5, d2);
    }

    public static Point getIntermediatePointByMC(GeoPoint geoPoint, GeoPoint geoPoint2, double d2) {
        GeoPoint geoPoint3 = geoPoint2;
        double d3 = geoPoint.getLatitude();
        double d4 = geoPoint3.getLongitude();
        double d5 = geoPoint3.getLatitude();
        return CoordinateUtil.getIntermediatePointByMC(geoPoint.getLongitude(), d3, d4, d5, d2);
    }

    public static Point Coordinate_encryptEx(float f2, float f3, String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            string = "bd09ll";
        }
        int n2 = -1;
        switch (string.hashCode()) {
            default: {
                break;
            }
            case 113079775: {
                if (!string.equals("wgs84")) break;
                n2 = 3;
                break;
            }
            case 98175376: {
                if (!string.equals("gcj02")) break;
                n2 = 2;
                break;
            }
            case -1395470175: {
                if (!string.equals("bd09mc")) break;
                n2 = 1;
                break;
            }
            case -1395470197: {
                if (!string.equals("bd09ll")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return null;
            }
            case 3: {
                return CoordinateUtil.wgs84Tobd09mc(f2, f3);
            }
            case 2: {
                return CoordinateUtil.gcj02Tobd09mc(f2, f3);
            }
            case 1: {
                double d2 = f2;
                double d3 = f3;
                return new Point(d2, d3);
            }
            case 0: 
        }
        return CoordinateUtil.bd09llTobd09mc(f2, f3);
    }

    public static ArrayList<Point> Coordinate_encryptExArray(ArrayList<Point> arrayList, String string) {
        ArrayList<Point> arrayList2;
        int n2;
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            string = "bd09ll";
        }
        if (!(string.equals("bd09ll") || string.equals("bd09mc") || string.equals("gcj02") || string.equals("wgs84"))) {
            return null;
        }
        ArrayList<Point> arrayList3 = arrayList;
        int n3 = arrayList3.size();
        float[] fArray = new float[n3];
        float[] fArray2 = new float[arrayList3.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            fArray[n2] = (float)((Point)arrayList.get(n2)).getIntX() / 100000.0f;
            fArray2[n2] = (float)arrayList.get(n2).getIntY() / 100000.0f;
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList<Point>();
        for (n2 = 0; n2 < n3; ++n2) {
            Point point = null;
            int n4 = -1;
            switch (string.hashCode()) {
                default: {
                    break;
                }
                case 113079775: {
                    if (!string.equals("wgs84")) break;
                    n4 = 3;
                    break;
                }
                case 98175376: {
                    if (!string.equals("gcj02")) break;
                    n4 = 2;
                    break;
                }
                case -1395470175: {
                    if (!string.equals("bd09mc")) break;
                    n4 = 1;
                    break;
                }
                case -1395470197: {
                    if (!string.equals("bd09ll")) break;
                    n4 = 0;
                }
            }
            switch (n4) {
                default: {
                    break;
                }
                case 3: {
                    point = CoordinateUtil.wgs84Tobd09mc(fArray[n2], fArray2[n2]);
                    break;
                }
                case 2: {
                    point = CoordinateUtil.gcj02Tobd09mc(fArray[n2], fArray2[n2]);
                    break;
                }
                case 1: {
                    Point point2;
                    point = point2;
                    double d2 = fArray[n2];
                    double d3 = fArray2[n2];
                    point2 = new Point(d2, d3);
                    break;
                }
                case 0: {
                    point = CoordinateUtil.bd09llTobd09mc(fArray[n2], fArray2[n2]);
                }
            }
            if (point == null) continue;
            arrayList.add(point);
        }
        return arrayList;
    }
}

