/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.datahub;

import com.baidu.datahub.BDLog;
import com.baidu.datahub.ShareLocationInfo;
import com.baidu.navisdk.adapter.sl.BNOrderInfo;
import com.baidu.navisdk.adapter.sl.BNShareLocationInfo;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class BDCache {
    private static final int protocol_type_one = 1;
    private static final int protocol_type_two = 2;
    private static final String TAG = "BDCache";
    private static int MAX_SIZE = 60;
    private CopyOnWriteArrayList<ShareLocationInfo> list;
    private BNOrderInfo mParentOrderInfo;

    public BDCache(BNOrderInfo bNOrderInfo) {
        CopyOnWriteArrayList copyOnWriteArrayList;
        CopyOnWriteArrayList copyOnWriteArrayList2 = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.list = copyOnWriteArrayList2;
        v1.mParentOrderInfo = bNOrderInfo;
    }

    private String getOrderStatsStr(List<BNOrderInfo> object) {
        Object object2 = ((BDCache)object2).mParentOrderInfo;
        if (object2 != null && 1 == ((BNOrderInfo)object2).orderType) {
            return "10";
        }
        if (object != null && object.size() > 0) {
            StringBuilder stringBuilder;
            object2 = object.iterator();
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            while (object2.hasNext()) {
                BNOrderInfo bNOrderInfo = (BNOrderInfo)object2.next();
                if (bNOrderInfo == null) {
                    BDLog.e(TAG, "[getOrderStatsStr]: null == orderInfo");
                    continue;
                }
                ((StringBuilder)object).append(bNOrderInfo.orderState);
                break;
            }
            return ((StringBuilder)object).toString();
        }
        BDLog.e(TAG, "[getOrderStatsStr]: orderInfos is empty");
        return String.valueOf(0);
    }

    private String calCoordinateDiff(double d3, double d4) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder.append((int)(d3 * 100000.0 - d4 * 100000.0));
        return stringBuilder.toString();
    }

    private String calSpeedDirectDiff(float f3, float f4, int n2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        float f5 = n2;
        stringBuilder.append((int)(f3 * f5 - f4 * f5));
        return stringBuilder.toString();
    }

    public int getSize() {
        return this.list.size();
    }

    public BNShareLocationInfo getLastLocation(int n2) {
        if (n2 > MAX_SIZE && n2 <= 0) {
            return null;
        }
        return this.list.get(n2 - 1).getInfo();
    }

    public synchronized void addLocationInfoToCache(ShareLocationInfo shareLocationInfo) {
        while (this.list.size() >= MAX_SIZE) {
            this.list.remove(0);
        }
        this.list.add(shareLocationInfo);
    }

    public synchronized void remove(int n2) {
        if (n2 <= MAX_SIZE && n2 > 0) {
            for (int i3 = 0; i3 < n2; ++i3) {
                this.list.remove(0);
            }
            return;
        }
    }

    public String formatPointsData(int n2) {
        if (n2 <= MAX_SIZE && n2 > 0) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2;
            StringBuffer stringBuffer3;
            StringBuffer stringBuffer4;
            StringBuffer stringBuffer5;
            StringBuffer stringBuffer6;
            StringBuffer stringBuffer7;
            StringBuffer stringBuffer8;
            Iterator<ShareLocationInfo> iterator = ((BDCache)((Object)stringBuffer16)).list.iterator();
            if (!iterator.hasNext()) {
                BDLog.e(TAG, "[formatPointsData]: !value.hasNext()");
                return null;
            }
            ShareLocationInfo shareLocationInfo = iterator.next();
            BNShareLocationInfo bNShareLocationInfo = shareLocationInfo.getInfo();
            String string2 = String.valueOf(1);
            String string3 = String.valueOf(n2--);
            StringBuffer stringBuffer9 = stringBuffer8;
            stringBuffer8 = new StringBuffer();
            StringBuffer stringBuffer10 = stringBuffer7;
            stringBuffer7 = new StringBuffer();
            StringBuffer stringBuffer11 = stringBuffer6;
            stringBuffer6 = new StringBuffer();
            StringBuffer stringBuffer12 = stringBuffer5;
            stringBuffer5 = new StringBuffer();
            StringBuffer stringBuffer13 = stringBuffer4;
            stringBuffer4 = new StringBuffer();
            StringBuffer stringBuffer14 = stringBuffer3;
            stringBuffer3 = new StringBuffer();
            StringBuffer stringBuffer15 = stringBuffer2;
            stringBuffer15();
            stringBuffer9.append(shareLocationInfo.getTimestamp());
            stringBuffer10.append(((BDCache)((Object)stringBuffer16)).getOrderStatsStr(bNShareLocationInfo.orderInfos));
            stringBuffer11.append((int)(bNShareLocationInfo.postLongitude * 100000.0) + "," + (int)(bNShareLocationInfo.postLatitude * 100000.0));
            stringBuffer12.append((int)bNShareLocationInfo.postDirection);
            stringBuffer13.append((int)(bNShareLocationInfo.gpsLongitude * 100000.0) + "," + (int)(bNShareLocationInfo.gpsLatitude * 100000.0));
            stringBuffer14.append((int)bNShareLocationInfo.gpsDirection);
            stringBuffer2.append((int)(bNShareLocationInfo.gpsSpeed * 10.0f));
            while (iterator.hasNext() && n2 != 0) {
                ShareLocationInfo shareLocationInfo2 = iterator.next();
                BNShareLocationInfo bNShareLocationInfo2 = shareLocationInfo2.getInfo();
                stringBuffer9.append("," + (shareLocationInfo2.getTimestamp() - shareLocationInfo.getTimestamp()));
                if (stringBuffer10.length() > 0) {
                    stringBuffer10.append(',');
                }
                stringBuffer10.append(super.getOrderStatsStr(bNShareLocationInfo2.orderInfos));
                double d3 = bNShareLocationInfo2.postLongitude;
                double d4 = bNShareLocationInfo.postLongitude;
                StringBuilder stringBuilder = new StringBuilder().append(";").append(super.calCoordinateDiff(d3, d4)).append(",");
                d3 = bNShareLocationInfo2.postLatitude;
                d4 = bNShareLocationInfo.postLatitude;
                stringBuffer11.append(stringBuilder.append(super.calCoordinateDiff(d3, d4)).toString());
                float f3 = bNShareLocationInfo2.postDirection;
                stringBuffer12.append("," + super.calSpeedDirectDiff(f3, bNShareLocationInfo.postDirection, 1));
                d3 = bNShareLocationInfo2.gpsLongitude;
                d4 = bNShareLocationInfo.gpsLongitude;
                StringBuilder stringBuilder2 = new StringBuilder().append(";").append(super.calCoordinateDiff(d3, d4)).append(",");
                d3 = bNShareLocationInfo2.gpsLatitude;
                d4 = bNShareLocationInfo.gpsLatitude;
                stringBuffer13.append(stringBuilder2.append(super.calCoordinateDiff(d3, d4)).toString());
                f3 = bNShareLocationInfo2.gpsDirection;
                stringBuffer14.append("," + super.calSpeedDirectDiff(f3, bNShareLocationInfo.gpsDirection, 1));
                f3 = bNShareLocationInfo2.gpsSpeed;
                stringBuffer15.append("," + super.calSpeedDirectDiff(f3, bNShareLocationInfo.gpsSpeed, 10));
                bNShareLocationInfo = shareLocationInfo2.getInfo();
                --n2;
                shareLocationInfo = shareLocationInfo2;
            }
            StringBuffer stringBuffer16 = stringBuffer;
            stringBuffer16();
            stringBuffer.append(string2).append("|").append(string3).append("|").append(stringBuffer9.toString()).append("|").append(stringBuffer10.toString()).append("|").append(stringBuffer11.toString()).append("|").append(stringBuffer12.toString()).append("|").append(stringBuffer13.toString()).append("|").append(stringBuffer14.toString()).append("|").append(stringBuffer15.toString());
            BDLog.d(TAG, "points:" + stringBuffer16.toString());
            return stringBuffer.toString();
        }
        BDLog.e(TAG, "[formatPointsData]: number > MAX_SIZE || number <= 0, number" + n2);
        return null;
    }
}

