/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.datahub;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.baidu.datahub.BDCache;
import com.baidu.datahub.BDLog;
import com.baidu.datahub.BaseRequest;
import com.baidu.datahub.DatabaseHelper;
import com.baidu.datahub.HttpClient;
import com.baidu.datahub.LogFile;
import com.baidu.datahub.MD5Util;
import com.baidu.datahub.ShareLocationInfo;
import com.baidu.navisdk.adapter.BNRoutePlanNode;
import com.baidu.navisdk.adapter.listener.IBNRequestListener;
import com.baidu.navisdk.adapter.sl.BNCarPoolManager;
import com.baidu.navisdk.adapter.sl.BNOrderInfo;
import com.baidu.navisdk.adapter.sl.BNShareETAInfo;
import com.baidu.navisdk.adapter.sl.BNShareLocationInfo;
import com.baidu.navisdk.adapter.sl.BNShareLocationManager;
import com.baidu.navisdk.adapter.sl.BNShareRouteInfo;
import com.baidu.navisdk.adapter.sl.BNTokenInfo;
import com.baidu.navisdk.adapter.sl.BNWayPointInfo;
import com.baidu.navisdk.adapter.sl.CarManagerUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareLocationManager {
    private static final String TAG = "ShareLocationManager";
    private static final int MAX_RETRY_TIMES_SERVER_ERROR = 1;
    private static final int MAX_RETRY_TIMES_NET_ERROR = 2;
    private static final int MAX_RETRY_TIMES_PART_REG_FAILED = 1;
    private static final long MAX_ORDER = 50L;
    private static final int DB_VERSION = 5;
    private static final String DEFAULT_PARENT_ORDER_ID = "-+~$#empty_parent_id#$~+-";
    private static final int CAR_POOL_PARENT_ORDER_STATUS = 10;
    private static final String ETA_PROTOCOL_V_SECOND = "v2";
    private static final String ETA_PROTOCOL_V_THIRD = "v3";
    private BDCache mCache;
    private ShareLocationHandler mShareLocationHandler;
    private int mInterval;
    private boolean mFirstInitTimer;
    private String mAuthToken;
    private String mCuid;
    private DataStatus mUploadStatus;
    private BaseRequest mBaseRequest;
    private SQLiteDatabase mDatabase;
    private int mCountRegisterNetError;
    private int mCountRegisterPartFailed;
    private int mCountRegisterServerError;
    private int mCountUpdateNetError;
    private int mCountUpdateServerError;
    private int mCountUpdateRouteInfoError;
    private int mCountUpdateDriverStatusError;
    private long mLastLocationChangeTime;
    private long mLastUpdateLocResponseTime;
    private int mLastUpdateLocationStatus;
    private boolean mIsStopSynServer;
    private boolean mIsOrderRegisted;
    private String mHashCode;
    private String mRouteID;
    private BNOrderInfo mParentOrderInfo;
    private int mOrderType;
    private HashSet<String> mUnRegisterOrderSet;
    private Timer mUpdateInfoTimer;
    private TimerTask mUpdateInfoTask;

    public ShareLocationManager(String string2, String string3, int n2) {
        ShareLocationManager shareLocationManager = this;
        this.mShareLocationHandler = new ShareLocationHandler();
        this.mInterval = 2;
        this.mFirstInitTimer = false;
        this.mUploadStatus = DataStatus.ready;
        this.mBaseRequest = new BaseRequest();
        this.mCountRegisterNetError = 0;
        this.mCountRegisterPartFailed = 0;
        this.mCountRegisterServerError = 0;
        this.mCountUpdateNetError = 0;
        this.mCountUpdateServerError = 0;
        this.mCountUpdateRouteInfoError = 0;
        this.mCountUpdateDriverStatusError = 0;
        this.mLastLocationChangeTime = 0L;
        this.mLastUpdateLocResponseTime = 0L;
        this.mLastUpdateLocationStatus = -1000;
        this.mIsStopSynServer = false;
        this.mIsOrderRegisted = false;
        this.mHashCode = "";
        this.mRouteID = null;
        this.mParentOrderInfo = new BNOrderInfo();
        this.mUnRegisterOrderSet = new HashSet();
        this.mUpdateInfoTimer = new Timer();
        this.mUpdateInfoTask = new TimerTask(){

            @Override
            public void run() {
                if (DataStatus.process != ShareLocationManager.this.mUploadStatus) {
                    1 v02 = this;
                    v02.ShareLocationManager.this.loadOrderInfo();
                    v02.ShareLocationManager.this.loadUpdateOrderInfo();
                    ShareLocationManager shareLocationManager = v02.ShareLocationManager.this;
                    shareLocationManager.loadRouteInfo(shareLocationManager.getParentOrderId());
                    ShareLocationManager shareLocationManager2 = v02.ShareLocationManager.this;
                    shareLocationManager2.updateLocationInfo(shareLocationManager2.mRouteID);
                    v02.ShareLocationManager.this.updateWayPointInfo();
                }
            }
        };
        this.mAuthToken = string2;
        this.mCuid = string3;
        shareLocationManager.mOrderType = n2;
        shareLocationManager.mCache = new BDCache(this.mParentOrderInfo);
        shareLocationManager.registerShareLocationHandler(shareLocationManager.mShareLocationHandler);
        string2 = CarManagerUtil.getApplicationContext();
        try {
            shareLocationManager.mDatabase = new DatabaseHelper((Context)string2, "drivier.db", null, 5).getWritableDatabase();
        }
        catch (Exception exception) {
            BDLog.dforce(TAG, "Get mDatabase failed, caught SQLiteException", exception);
        }
        LogFile.init((Context)string2);
        this.mHashCode = String.valueOf(this.hashCode());
        int n3 = this.mHashCode.length();
        if (n3 > 4) {
            this.mHashCode = this.mHashCode.substring(n3 - 4);
        }
        this.removeLastParentOrderReleatedInfoFromDB();
    }

    private synchronized boolean loadUpdateOrderInfo() {
        if (this.isParentOrderInfoEmpty()) {
            BDLog.e(TAG, "[loadUpdateOrderInfo]:parent order id is empty ");
            return false;
        }
        String string2 = "remark = ? AND parent_order_id = ?";
        String[] stringArray = new String[2];
        Object object = stringArray;
        object[0] = "update_order";
        stringArray[1] = this.getParentOrderId();
        Object object2 = this.mDatabase;
        if (object2 != null && object2.isOpen()) {
            if ((string2 = this.mDatabase.query("orderInfo", null, string2, object, null, null, null)) == null) {
                BDLog.e(TAG, "[loadUpdateOrderInfo]: cursor is null");
                return false;
            }
            if (this.mDatabase.isOpen() && string2.moveToFirst()) {
                do {
                    HashMap hashMap;
                    ShareLocationManager shareLocationManager = this;
                    object = hashMap;
                    String[] stringArray2 = object;
                    ShareLocationManager shareLocationManager2 = this;
                    String[] stringArray3 = object;
                    String[] stringArray4 = object;
                    String[] stringArray5 = object;
                    String[] stringArray6 = object;
                    String[] stringArray7 = object;
                    object();
                    object = string2.getString(0);
                    stringArray7.put("order_id", MD5Util.getMD5String((String)object, string2.getString(1)));
                    stringArray6.put("company", string2.getString(1));
                    stringArray5.put("order_attr", string2.getString(2));
                    stringArray4.put("status", string2.getInt(3));
                    stringArray3.put("order_type", string2.getInt(13));
                    stringArray3.put("modify_time", System.currentTimeMillis() / 1000L);
                    object2 = "token";
                    stringArray2.put(object2, shareLocationManager2.whetherToEncodeParameter(shareLocationManager2.mAuthToken, true));
                    object2 = this.getRequestData((Map<String, Object>)stringArray2, 1);
                    String string3 = "sign";
                    hashMap.put(string3, CarManagerUtil.getSignMD5String((String)object2));
                    try {
                        BDLog.e("ShareLocationManagerparamSign", (String)object2);
                        object2 = shareLocationManager.getRequestData(hashMap, 0);
                    }
                    catch (Exception exception) {
                        BDLog.dforce(TAG, "loadUpdateOrderInfo exception happened", exception);
                    }
                    BDLog.d(TAG, "loadUpdateOrderInfo Data: " + (String)object2);
                    shareLocationManager.sendUpdateOrder((String)object, (String)object2);
                } while (string2.moveToNext());
                string2.close();
                return true;
            }
            string2.close();
            return false;
        }
        BDLog.dforce(TAG, "Database error, can't read");
        return false;
    }

    private synchronized boolean updateOrder(BNOrderInfo bNOrderInfo) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        if (bNOrderInfo == null) {
            BDLog.e(TAG, "BNOrderInfo is null");
            return false;
        }
        ShareLocationManager shareLocationManager = this;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        ShareLocationManager shareLocationManager2 = this;
        HashMap<String, Object> hashMap4 = hashMap2;
        hashMap2();
        String string2 = "order_id";
        try {
            hashMap2.put(string2, this.whetherToEncodeParameter(MD5Util.getMD5String(bNOrderInfo.getOrderId(), bNOrderInfo.companyServerId), true));
        }
        catch (Exception exception) {
            BDLog.dforce(TAG, "updateOrder exception happened", exception);
            return false;
        }
        string2 = "company";
        hashMap2.put(string2, this.whetherToEncodeParameter(bNOrderInfo.companyServerId, true));
        string2 = "order_attr";
        hashMap4.put(string2, this.whetherToEncodeParameter(bNOrderInfo.driverId, true));
        hashMap4.put("status", bNOrderInfo.orderState);
        hashMap4.put("modify_time", System.currentTimeMillis() / 1000L);
        hashMap4.put("order_type", bNOrderInfo.orderType);
        string2 = "token";
        hashMap3.put(string2, shareLocationManager2.whetherToEncodeParameter(shareLocationManager2.mAuthToken, true));
        string2 = this.getRequestData(hashMap3, 1);
        Object[] objectArray = "sign";
        hashMap.put((String)objectArray, CarManagerUtil.getSignMD5String((String)string2));
        BDLog.e("ShareLocationManagerparamSign", string2);
        string2 = shareLocationManager.getRequestData(hashMap, 0);
        BDLog.d(TAG, "updateOrder data:" + string2);
        objectArray = shareLocationManager.mDatabase;
        if (objectArray != null && objectArray.isOpen()) {
            ShareLocationManager shareLocationManager3 = this;
            Object[] objectArray2 = new String[2];
            objectArray = objectArray2;
            objectArray2[0] = bNOrderInfo.getOrderId();
            objectArray2[1] = "update_order";
            shareLocationManager3.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", (String[])objectArray);
            String[] stringArray = new String[15];
            Object[] objectArray3 = objectArray = stringArray;
            objectArray[0] = bNOrderInfo.getOrderId();
            objectArray[1] = bNOrderInfo.companyServerId;
            objectArray[2] = bNOrderInfo.driverId;
            objectArray[3] = String.valueOf(bNOrderInfo.orderState);
            objectArray3[4] = (String)hashMap2.get("cur_pos");
            objectArray3[5] = "";
            objectArray3[6] = "";
            objectArray3[7] = "";
            objectArray3[8] = "";
            objectArray3[9] = "";
            objectArray3[10] = "";
            objectArray3[11] = "";
            objectArray[12] = "update_order";
            objectArray[13] = String.valueOf(bNOrderInfo.orderType);
            stringArray[14] = this.getParentOrderId();
            shareLocationManager3.mDatabase.execSQL("insert into orderInfo (orderId,companyServerId,driverId,orderState,cur_point,start_point,start_poiid,start_name,end_point,end_poiid,end_name,cuid,remark,order_type,parent_order_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", objectArray);
        }
        return this.sendUpdateOrder(bNOrderInfo.getOrderId(), string2);
    }

    private synchronized boolean sendUpdateOrder(final String string2, final String string3) {
        if (!this.mIsStopSynServer && this.mIsOrderRegisted) {
            HttpClient.ProtoResultCallBack protoResultCallBack;
            if (string3 == null) {
                return false;
            }
            HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
            protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                @Override
                public void onSuccess(String string22) {
                    2 v02 = string32;
                    BDLog.e(ShareLocationManager.TAG, "update order success");
                    v02.ShareLocationManager.this.removeNotUpdateOrder(string32.string2);
                    ShareLocationManager.access$902(v02.ShareLocationManager.this, 0);
                    String string32 = String.valueOf(v02.ShareLocationManager.this.parseResponseStatus(string22));
                    string22 = v02.ShareLocationManager.this.mHashCode;
                    CarManagerUtil.addUserOP((String)"w.1.7.6", (String)"ds", (String)string32, (String)string22);
                }

                @Override
                public void onFailed(HttpClient.HttpStateError object, String string22) {
                    BDLog.e(ShareLocationManager.TAG, "update order failed,errCode:" + (Object)object + "result:" + string22);
                    if (HttpClient.HttpStateError.SERVER_INNER == object) {
                        if (string4.ShareLocationManager.this.mCountUpdateServerError < 1) {
                            2 v02 = string4;
                            v02.ShareLocationManager.this.mCountUpdateServerError++;
                            String string32 = string4;
                            string22 = string32.string2;
                            v02.ShareLocationManager.this.sendUpdateOrder(string22, string32.string3);
                        }
                    } else if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.USER_DELETED_BY_ADMIN != object && HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT != object) {
                        if (HttpClient.HttpStateError.NETWORK_ERROR == object) {
                            if (string4.ShareLocationManager.this.mCountUpdateNetError < 2) {
                                Object object2 = string4;
                                object2.ShareLocationManager.this.mCountUpdateNetError++;
                                Object object3 = string4;
                                string22 = object3.string2;
                                object2.ShareLocationManager.this.sendUpdateOrder(string22, object3.string3);
                            } else {
                                ShareLocationManager.access$902(string4.ShareLocationManager.this, 0);
                            }
                        } else {
                            ShareLocationManager.access$902(string4.ShareLocationManager.this, 0);
                        }
                    } else {
                        ShareLocationManager.access$1402(string4.ShareLocationManager.this, true);
                    }
                    2 v4 = string4;
                    String string4 = String.valueOf(object.getValue());
                    object = v4.ShareLocationManager.this.mHashCode;
                    CarManagerUtil.addUserOP((String)"w.1.7.6", (String)"ds", (String)string4, (String)object);
                }
            };
            this.mBaseRequest.sendRequest(2, "POST", string3, protoResultCallBack2);
            return true;
        }
        BDLog.e(TAG, "[sendUpdateOrder]: User is deleted by admin or order register failedor order error");
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean updateLocationInfo(String var1_2) {
        block32: {
            block34: {
                block33: {
                    block31: {
                        block30: {
                            if (this.isParentOrderInfoEmpty()) {
                                BDLog.e("ShareLocationManager", "[updateLocationInfo]:mParentOrderInfo is empty");
                                return false;
                            }
                            this.mUploadStatus = DataStatus.process;
                            var2_3 = this.mCache.getSize();
                            if (var2_3 == 0) {
                                this.mUploadStatus = DataStatus.ready;
                                return false;
                            }
                            var3_4 = this.getETAInfos();
                            var4_5 = "";
                            if (var3_4 != null && var3_4.size() > 0) {
                                var4_5 = var3_4.get((int)0).routeID;
                            }
                            var3_4 = v0;
                            v1 = this;
                            v2 = this;
                            v3 = this;
                            v4 = this;
                            var3_4();
                            var5_6 = "order_id";
                            var3_4.put(var5_6, v4.whetherToEncodeParameter(v4.getParentOrderId(), true));
                            var5_6 = "company";
                            var3_4.put(var5_6, v3.whetherToEncodeParameter(v3.mParentOrderInfo.companyServerId, true));
                            var5_6 = "order_attr";
                            var3_4.put(var5_6, v2.whetherToEncodeParameter(v2.mParentOrderInfo.driverId, true));
                            var5_6 = "points";
                            v0.put(var5_6, v1.whetherToEncodeParameter(v1.mCache.formatPointsData(var2_3), true));
                            v0.put("modify_time", System.currentTimeMillis() / 1000L);
                            if (this.mParentOrderInfo.orderType != 0) ** GOTO lbl63
                            if (TextUtils.isEmpty((CharSequence)var1_2)) break block30;
                            v5 = var1_2;
                            var1_2 = "route_id";
                            v6 = var3_4.put(var1_2, this.whetherToEncodeParameter(v5, true));
lbl46:
                            // 2 sources

                            while (true) {
                                break block31;
                                break;
                            }
                        }
                        if (TextUtils.isEmpty((CharSequence)var4_5)) break block31;
                        var1_2 = "route_id";
                        v6 = var3_4.put(var1_2, this.whetherToEncodeParameter(var4_5, true));
                        ** continue;
                    }
                    v7 = var3_4;
                    v7.put("status", this.mParentOrderInfo.orderState);
                    this.generateRunAndRemainInfo(v7);
                    break block32;
lbl63:
                    // 1 sources

                    if (this.mParentOrderInfo.orderType != 1) break block32;
                    if (TextUtils.isEmpty((CharSequence)var1_2)) break block33;
                    var5_6 = "route_id";
                    v8 = var3_4.put(var5_6, this.whetherToEncodeParameter(var1_2, true));
lbl69:
                    // 2 sources

                    while (true) {
                        ** GOTO lbl81
                        break;
                    }
                }
                try {
                    if (TextUtils.isEmpty((CharSequence)var4_5)) ** GOTO lbl81
                    var5_6 = "route_id";
                }
                catch (Exception var0_1) {
                    BDLog.dforce("ShareLocationManager", "updateLocationInfo exception happened.", var0_1);
                    return false;
                }
                v8 = var3_4.put(var5_6, this.whetherToEncodeParameter(var4_5, true));
                ** continue;
lbl81:
                // 2 sources

                v9 = var1_2;
                var3_4.put("status", "10");
                if (!TextUtils.isEmpty((CharSequence)v9)) break block34;
                if (TextUtils.isEmpty((CharSequence)var4_5)) break block32;
            }
            this.generateRunAndRemainInfo(var3_4);
        }
        v10 = this;
        v11 = var3_4;
        v12 = this;
        v13 = var3_4;
        v14 = this;
        var3_4.put("order_type", this.mParentOrderInfo.orderType);
        this = "token";
        v13.put((String)this, v14.whetherToEncodeParameter(v14.mAuthToken, true));
        this = v12.getRequestData(v13, 1);
        var1_2 = "sign";
        v11.put(var1_2, CarManagerUtil.getSignMD5String((String)this));
        BDLog.e("ShareLocationManagerparamSign", (String)this);
        this = v10.getRequestData(v11, 0);
        BDLog.d("ShareLocationManager", "*******update location data:" + (String)this);
        return v10.sendLocationInfo((String)this, var2_3);
    }

    private void generateRunAndRemainInfo(Map<String, Object> map) {
        List<BNShareETAInfo> list = ((ShareLocationManager)((Object)stringBuilder4)).getETAInfos();
        if (list != null && list.size() > 0) {
            StringBuilder stringBuilder;
            if (((ShareLocationManager)((Object)stringBuilder4)).isParentOrderInfoEmpty()) {
                BDLog.e(TAG, "parent order info is empty");
                return;
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            if (((ShareLocationManager)((Object)stringBuilder4)).mParentOrderInfo.orderType == 1) {
                stringBuilder2.append(ETA_PROTOCOL_V_SECOND).append("|");
            } else if (((ShareLocationManager)((Object)stringBuilder4)).mParentOrderInfo.orderType == 0) {
                stringBuilder2.append(ETA_PROTOCOL_V_THIRD).append("|");
            }
            long l2 = 0L;
            long l3 = 0L;
            list = list.iterator();
            boolean bl = true;
            while (list.hasNext()) {
                BNShareETAInfo bNShareETAInfo = (BNShareETAInfo)list.next();
                if (bNShareETAInfo != null && !TextUtils.isEmpty((CharSequence)bNShareETAInfo.orderId) && !TextUtils.isEmpty((CharSequence)bNShareETAInfo.etaType)) {
                    stringBuilder2.append(bNShareETAInfo.leftDist).append(';').append(bNShareETAInfo.leftTime).append('#').append(MD5Util.getMD5String(bNShareETAInfo.orderId, ((ShareLocationManager)((Object)stringBuilder4)).mParentOrderInfo.companyServerId)).append('#').append(bNShareETAInfo.etaType);
                    if (list.hasNext()) {
                        stringBuilder2.append('|');
                    }
                    l2 += bNShareETAInfo.pastDist;
                    l3 += bNShareETAInfo.pastTime;
                    continue;
                }
                if (bNShareETAInfo != null) {
                    BDLog.e(TAG, "etainfo is error" + bNShareETAInfo.toString());
                }
                bl = false;
                break;
            }
            if (bl) {
                StringBuilder stringBuilder3;
                Map<String, Object> map2 = map;
                map2.put("remain", stringBuilder2.toString());
                StringBuilder stringBuilder4 = stringBuilder3;
                stringBuilder4();
                map2.put("run", stringBuilder3.append(l2).append(";").append(l3).toString());
            }
            return;
        }
        BDLog.e(TAG, "etaInfos is null");
    }

    private synchronized boolean sendLocationInfo(String string2, final int n2) {
        if (!this.mIsStopSynServer && this.mIsOrderRegisted) {
            if (string2 != null && !string2.isEmpty()) {
                HttpClient.ProtoResultCallBack protoResultCallBack;
                HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
                protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                    @Override
                    public void onSuccess(String string2) {
                        3 v02 = this;
                        BDLog.e(ShareLocationManager.TAG, "[sendLocationInfo] success, result:" + string2);
                        v02.ShareLocationManager.this.mCache.remove(n2);
                        ShareLocationManager.access$002(v02.ShareLocationManager.this, DataStatus.success);
                        ShareLocationManager shareLocationManager = v02.ShareLocationManager.this;
                        shareLocationManager.addLocationUpdateResponseLog(shareLocationManager.parseResponseStatus(string2));
                        v02.ShareLocationManager.this.handleEndPositionInfo(string2);
                        v02.ShareLocationManager.this.parseResponsePassengerPoint(string2);
                    }

                    @Override
                    public void onFailed(HttpClient.HttpStateError httpStateError, String string2) {
                        BDLog.e(ShareLocationManager.TAG, "[sendLocationInfo],errCode:" + (Object)((Object)httpStateError) + "result:" + string2);
                        ShareLocationManager.access$002(ShareLocationManager.this, DataStatus.error);
                        if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN == httpStateError || HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN == httpStateError || HttpClient.HttpStateError.USER_DELETED_BY_ADMIN == httpStateError || HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT == httpStateError) {
                            ShareLocationManager.access$1402(ShareLocationManager.this, true);
                        }
                        ShareLocationManager.this.addLocationUpdateResponseLog(httpStateError.getValue());
                    }
                };
                this.mBaseRequest.sendRequest(4, "POST", string2, protoResultCallBack2);
                return true;
            }
            this.mUploadStatus = DataStatus.ready;
            return false;
        }
        BDLog.e(TAG, "[sendLocationInfo]: User is deleted by admin or order register failedor order error");
        this.mUploadStatus = DataStatus.ready;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean updateRoute(BNShareRouteInfo var1_2) {
        block45: {
            block47: {
                block44: {
                    block43: {
                        block46: {
                            block42: {
                                block41: {
                                    if (var1_2 == null) {
                                        BDLog.e("ShareLocationManager", "[updateRoute]:BNShareRouteInfo is null");
                                        return false;
                                    }
                                    if (!this.isParentOrderInfoEmpty()) ** GOTO lbl24
                                    BDLog.e("ShareLocationManager", "[updateRoute]:mParentOrderInfo is null");
                                    var2_3 = var1_2.orderInfos;
                                    if (var2_3 == null || var2_3.size() <= 0) ** GOTO lbl22
                                    if ((var2_3 = (BNOrderInfo)var2_3.get(0)) == null) {
                                        BDLog.e("ShareLocationManager", "[updateRoute]:orderInfo is null");
                                        return false;
                                    }
                                    if (var2_3.getOrderId() != null && var2_3.companyServerId != null && var2_3.driverId != null && var1_2.sessionId != null) {
                                        v0 = var2_3;
                                        var3_5 = v0.companyServerId;
                                        var4_6 = v0.driverId;
                                        var5_7 = 1 == v0.orderType ? 10 : var2_3.orderState;
                                        var6_9 = 1 == var2_3.orderType ? "-+~$#empty_parent_id#$~+-_" + this.mHashCode : MD5Util.getMD5String(var2_3.getOrderId(), var3_5);
                                        var2_4 = var2_3.orderType;
                                        BDLog.e("ShareLocationManager", "[updateRoute]:mParentOrderInfo update route set data" + var6_9);
                                    } else {
                                        BDLog.e("ShareLocationManager", "[updateRoute]:must parameter is null");
                                        return false;
lbl22:
                                        // 1 sources

                                        BDLog.e("ShareLocationManager", "[updateRoute]:orderInfos is empty");
                                        return false;
lbl24:
                                        // 1 sources

                                        v1 = this;
                                        var3_5 = v1.mParentOrderInfo.companyServerId;
                                        var4_6 = v1.mParentOrderInfo.driverId;
                                        var5_7 = v1.mParentOrderInfo.orderState;
                                        var2_4 = v1.mParentOrderInfo.orderType;
                                        var6_9 = v1.getParentOrderId();
                                        BDLog.e("ShareLocationManager", "[updateRoute]:mParentOrderInfo update route get cache" + var6_9);
                                    }
                                    this.mRouteID = var1_2.curRouteMD5;
                                    v2 = var7_10 = v3;
                                    v4 = this;
                                    v5 = var4_6;
                                    var7_10();
                                    var4_6 = "";
                                    var5_8 = "";
                                    var8_11 = "order_id";
                                    var7_10.put(var8_11, this.whetherToEncodeParameter(var6_9, true));
                                    var8_11 = "company";
                                    var7_10.put(var8_11, this.whetherToEncodeParameter(var3_5, true));
                                    var8_11 = "order_attr";
                                    var7_10.put(var8_11, this.whetherToEncodeParameter(v5, true));
                                    var8_11 = "session_id";
                                    var7_10.put(var8_11, this.whetherToEncodeParameter(var1_2.sessionId, true));
                                    var8_11 = "route_id";
                                    v2.put(var8_11, v4.whetherToEncodeParameter(v4.mRouteID, true));
                                    v2.put("modify_time", System.currentTimeMillis() / 1000L);
                                    var8_11 = "status";
                                    v3.put(var8_11, var5_7);
                                    v3.put("order_type", this.mParentOrderInfo.orderType);
                                    if (1 != var2_4) break block46;
                                    v6 = this;
                                    v7 = var1_2;
                                    var1_2 = v8;
                                    v8 = new StringBuilder();
                                    if (v6.generateCarpoolOrderSubSeq(v7.wayPointInfos, var3_5, (StringBuilder)var1_2)) break block41;
                                    BDLog.e("ShareLocationManager", "generateWayPointsOrderSubSeq failed");
                                    return false;
                                }
                                var4_6 = this.whetherToEncodeParameter(var1_2.toString(), true);
                                if (!TextUtils.isEmpty((CharSequence)var4_6)) break block42;
                                BDLog.e("ShareLocationManager", "subOrdersSeq is empty");
                                return false;
                            }
                            var7_10.put("sub_orders_seq", var4_6);
                            break block47;
                        }
                        if (var2_4 != 0) break block47;
                        BDLog.e("ShareLocationManager", " [updateRoute] wayPointInfos \uff1a " + var1_2.wayPointInfos);
                        var3_5 = this.generateWayPointsOrderSubSeq(var1_2.wayPointInfos, var6_9, false);
                        if (TextUtils.isEmpty((CharSequence)var3_5)) break block43;
                        v9 = var7_10;
                        var3_5 = this.whetherToEncodeParameter(var3_5, true);
                        BDLog.e("ShareLocationManager", " [updateRoute] subOrdersSeq \uff1a " + var3_5);
                        v10 = v9.put("waypoints", var3_5);
lbl105:
                        // 2 sources

                        while (true) {
                            ** GOTO lbl111
                            break;
                        }
                    }
                    v10 = var7_10.put("waypoints", "");
                    ** continue;
lbl111:
                    // 1 sources

                    if (var1_2.endNodeInfo == null) break block44;
                    v11 = var1_2;
                    var5_8 = "end_name";
                    var7_10.put((String)var5_8, this.whetherToEncodeParameter(var1_2.endNodeInfo.getName(), true));
                    var5_8 = "end_point";
                    var7_10.put((String)var5_8, this.whetherToEncodeParameter(var1_2.endNodeInfo.getLongitude() + "," + var1_2.endNodeInfo.getLatitude(), true));
                    var1_2 = "end_poiid";
                    v12 = var7_10.put((String)var1_2, this.whetherToEncodeParameter(v11.endNodeInfo.getId(), true));
lbl124:
                    // 2 sources

                    while (true) {
                        break block45;
                        break;
                    }
                }
                try {
                    v13 = var7_10;
                    v14 = v13;
                    v15 = v13;
                    v13.put("end_name", "");
                }
                catch (Exception var0_1) {
                    BDLog.dforce("ShareLocationManager", "updateRoute exception happened.", var0_1);
                    return false;
                }
                v15.put("end_point", "");
                v12 = v14.put("end_poiid", "");
                ** continue;
            }
            var3_5 = var5_8;
        }
        v16 = this;
        v17 = var7_10;
        v18 = var7_10;
        v19 = this;
        var1_2 = "token";
        v18.put((String)var1_2, v19.whetherToEncodeParameter(v19.mAuthToken, true));
        var1_2 = this.getRequestData(v18, 1);
        var5_8 = "sign";
        v17.put((String)var5_8, CarManagerUtil.getSignMD5String((String)var1_2));
        BDLog.e("ShareLocationManager paramSign", (String)var1_2);
        var1_2 = v16.getRequestData(v17, 0);
        BDLog.d("ShareLocationManager", "*********update route data:" + (String)var1_2);
        var5_8 = v16.getOutOfRangeOrdersFromDataBase("routeInfo");
        if (var5_8 != null && !var5_8.isEmpty()) {
            this.deleteFromDB("routeInfo", (ArrayList<String>)var5_8);
        }
        if ((var5_8 = this.mDatabase) != null && var5_8.isOpen()) {
            v20 = this;
            v21 = new String[1];
            var5_8 = v21;
            v21[0] = var6_9;
            v20.mDatabase.delete("routeInfo", "orderId = ?", (String[])var5_8);
            v22 = new String[13];
            var5_8 = v22;
            var5_8[0] = var6_9;
            var5_8[1] = (String)var7_10.get("company");
            var5_8[2] = (String)var7_10.get("order_attr");
            var5_8[3] = String.valueOf(var7_10.get("status"));
            var5_8[4] = (String)var7_10.get("session_id");
            var5_8[5] = (String)var7_10.get("route_id");
            var5_8[6] = String.valueOf(var7_10.get("modify_time"));
            var5_8[7] = var4_6;
            var5_8[8] = String.valueOf(var2_4);
            var5_8[9] = String.valueOf(var7_10.get("end_name"));
            var5_8[10] = String.valueOf(var7_10.get("end_point"));
            v22[11] = String.valueOf(var7_10.get("end_poiid"));
            v22[12] = var3_5;
            v20.mDatabase.execSQL("insert into routeInfo(orderId,companyServerId,driverId,orderState,sessionId,curRouteMD5,modify_time,sub_orders_seq,order_type,end_name,end_point,end_poiid,waypoints) values(?,?,?,?,?,?,?,?,?,?,?,?,?)", var5_8);
        }
        if ("-+~$#empty_parent_id#$~+-".equals(var6_9)) {
            BDLog.e("ShareLocationManager", "[updateRoute]: parentOrderId is empty");
            return false;
        }
        return this.sendRouteInfo(var6_9, (String)var1_2, var7_10);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean generateCarpoolOrderSubSeq(List<BNWayPointInfo> iterator, String string2, StringBuilder stringBuilder) {
        if (iterator != null && iterator.size() > 0) {
            if (stringBuilder == null) {
                BDLog.e(TAG, "[generateCarpoolOrderSubSeq]:subOrdersSeq is null");
                return false;
            }
        } else {
            BDLog.e(TAG, "[generateCarpoolOrderSubSeq]:orderInfoList is empty");
            return false;
        }
        iterator = iterator.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            BNRoutePlanNode bNRoutePlanNode;
            String string3;
            BNWayPointInfo bNWayPointInfo = (BNWayPointInfo)iterator.next();
            if (bNWayPointInfo == null) return false;
            BNWayPointInfo bNWayPointInfo2 = bNWayPointInfo;
            String string4 = bNWayPointInfo2.getOrderId();
            if (!this.appendOneSubSeq(stringBuilder, string4, string3 = bNWayPointInfo2.getType(), bNRoutePlanNode = bNWayPointInfo2.getNode(), string2)) {
                return false;
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append('|');
        }
        return bl;
    }

    private String generateWayPointsOrderSubSeq(List<BNWayPointInfo> object, String string2, boolean bl) {
        if (object != null && object.size() > 0) {
            Object object2;
            Object object3;
            StringBuilder stringBuilder;
            if (string2 == null) {
                string2 = "";
            }
            List<BNWayPointInfo> list = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator<BNWayPointInfo> iterator = list.iterator();
            while (iterator.hasNext() && (object3 = iterator.next()) != null && (object2 = object3.getNode()) != null) {
                if (bl) {
                    BNWayPointInfo bNWayPointInfo = object3;
                    object3 = ((StringBuilder)object).append(((BNRoutePlanNode)object2).getLongitude()).append(',').append(((BNRoutePlanNode)object2).getLatitude()).append(';').append(this.whetherToEncodeParameter(((BNRoutePlanNode)object2).getName(), true)).append(';').append(((BNRoutePlanNode)object2).getId()).append(';');
                    object2 = bNWayPointInfo.isArrive() ? "1" : "0";
                    ((StringBuilder)object3).append((String)object2).append(';').append(string2);
                } else if (object3.getType().equals("wp")) {
                    ((StringBuilder)object).append(((BNRoutePlanNode)object2).getLongitude()).append(',').append(((BNRoutePlanNode)object2).getLatitude()).append(';').append(this.whetherToEncodeParameter(((BNRoutePlanNode)object2).getName(), true)).append(';').append(((BNRoutePlanNode)object2).getId()).append(';').append("0").append(';').append(string2);
                }
                if (!iterator.hasNext()) continue;
                ((StringBuilder)object).append('|');
            }
            if (!(((StringBuilder)object).length() <= 0 || "null".equals(((StringBuilder)object).toString()) || "".equals(((StringBuilder)object).toString()) || "|".equals(((StringBuilder)object).toString()))) {
                return ((StringBuilder)object).toString();
            }
            return "";
        }
        BDLog.e(TAG, "[generateWayPointsOrderSubSeq]:orderInfoList is empty");
        return "";
    }

    private boolean appendOneSubSeq(StringBuilder stringBuilder, String string2, String string3, BNRoutePlanNode bNRoutePlanNode, String string4) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[appendOneSubSeq]:orderId is empty");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            BDLog.e(TAG, "[appendOneSubSeq]:type is empty");
            return false;
        }
        if (bNRoutePlanNode == null) {
            BDLog.e(TAG, "[appendOneSubSeq]:routePlanNode is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            BDLog.e(TAG, "[appendOneSubSeq]:companyServerId is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = MD5Util.getMD5String(string2, string4)))) {
            BDLog.e(TAG, "[appendOneSubSeq]:encryptOrderId is empty");
            return false;
        }
        stringBuilder.append(string2).append('_').append(string3).append(';').append(bNRoutePlanNode.getLongitude()).append(',').append(bNRoutePlanNode.getLatitude()).append(';').append(this.whetherToEncodeParameter(bNRoutePlanNode.getName(), true)).append(';').append(bNRoutePlanNode.getId());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRequestData(Map<String, Object> object, int n2) {
        StringBuffer stringBuffer;
        Object object2 = object;
        object = stringBuffer;
        stringBuffer = new StringBuffer();
        for (Map.Entry entry : object2.entrySet()) {
            StringBuffer stringBuffer2;
            if (entry.getValue() != null && n2 == 0) {
                stringBuffer2 = ((StringBuffer)object).append((String)entry.getKey()).append("=").append(this.whetherToEncodeParameter(String.valueOf(entry.getValue()), true)).append("&");
                continue;
            }
            stringBuffer2 = ((StringBuffer)object).append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        Object object3 = object;
        Object object4 = object3;
        int n3 = ((StringBuffer)object3).length();
        try {
            ((StringBuffer)object4).deleteCharAt(n3 - 1);
        }
        catch (Exception exception) {
            BDLog.dforce(TAG, "getRequestData exception happened.", exception);
        }
        return ((StringBuffer)object).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> getURLEncodeRequestData(Map<String, Object> hashMap) {
        Iterator iterator;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap;
        hashMap = hashMap2;
        hashMap2 = new HashMap<String, Object>();
        try {
            iterator = hashMap3.entrySet().iterator();
        }
        catch (Exception exception) {
            BDLog.dforce(TAG, "getURLEncodeRequestData exception happened.", exception);
        }
        while (true) {
            if (!iterator.hasNext()) return hashMap;
            Map.Entry entry = iterator.next();
            if (entry.getKey() == null) continue;
            if (entry.getValue() == null) continue;
            HashMap<String, Object> hashMap4 = hashMap;
            ShareLocationManager shareLocationManager = this;
            Map.Entry entry2 = entry;
            Map.Entry entry3 = entry2;
            Object k2 = entry2.getKey();
            hashMap4.put((String)k2, shareLocationManager.whetherToEncodeParameter(String.valueOf(entry3.getValue()), true));
        }
        return hashMap;
    }

    private synchronized boolean updateWayPointInfo() {
        String string2 = ((ShareLocationManager)object2).getParentOrderId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[updateWayPointInfo]: orderId is empty");
            return false;
        }
        String[] stringArray = "orderId = ?";
        Cursor cursor = new String[1];
        Cursor cursor2 = cursor;
        cursor[0] = string2;
        Object object = ((ShareLocationManager)object2).mDatabase;
        if (object != null && object.isOpen()) {
            HashMap<String, Object> hashMap;
            if ((cursor2 = ((ShareLocationManager)object2).mDatabase.query("driverStatus", null, (String)stringArray, (String[])cursor2, null, null, null)) == null) {
                BDLog.e(TAG, "[loadWayPoint]: cursor is null 0");
                return false;
            }
            if (!((ShareLocationManager)object2).mDatabase.isOpen()) {
                cursor2.close();
                BDLog.e(TAG, "[loadWayPoint]: database is close");
                return false;
            }
            object = "-+~$#empty_parent_id#$~+-_" + ((ShareLocationManager)object2).mHashCode;
            if (!cursor2.moveToFirst()) {
                cursor2.close();
                Cursor cursor3 = new String[1];
                cursor2 = cursor3;
                cursor3[0] = object;
                cursor2 = ((ShareLocationManager)object2).mDatabase.query("driverStatus", null, (String)stringArray, (String[])cursor2, null, null, null);
                if (cursor2 == null) {
                    BDLog.e(TAG, "[loadWayPoint]: cursor is null");
                    return false;
                }
                if (!((ShareLocationManager)object2).mDatabase.isOpen() || !cursor2.moveToFirst()) {
                    cursor2.close();
                    BDLog.e(TAG, "[loadWayPoint]: Datsbase is close or cursor is empty");
                    return false;
                }
            }
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap = new HashMap<String, Object>();
            String string3 = cursor2.getString(0);
            if (((String)object).equals(string3)) {
                ContentValues contentValues;
                string3 = contentValues;
                new ContentValues().put("orderId", string2);
                String[] stringArray2 = new String[1];
                String[] stringArray3 = stringArray2;
                stringArray2[0] = object;
                ((ShareLocationManager)object2).mDatabase.update("driverStatus", (ContentValues)string3, (String)stringArray, stringArray3);
                string3 = string2;
            }
            hashMap2.put("order_id", string3);
            hashMap2.put("company", cursor2.getString(1));
            hashMap2.put("order_attr", cursor2.getString(2));
            hashMap2.put("status", cursor2.getInt(3));
            string2 = cursor2.getString(4);
            hashMap2.put("waypoints", string2);
            int n2 = 0;
            stringArray = string2.split("\\|");
            if (stringArray.length > 0) {
                n2 = stringArray.length;
            }
            ShareLocationManager shareLocationManager = object2;
            ShareLocationManager shareLocationManager2 = object2;
            HashMap<String, Object> hashMap3 = hashMap2;
            HashMap<String, Object> hashMap4 = hashMap2;
            ShareLocationManager shareLocationManager3 = object2;
            hashMap4.put("token", shareLocationManager3.whetherToEncodeParameter(shareLocationManager3.mAuthToken, true));
            Object object2 = ((ShareLocationManager)object2).getRequestData(hashMap4, 1);
            hashMap3.put("sign", CarManagerUtil.getSignMD5String((String)object2));
            BDLog.e("ShareLocationManager paramDriver", (String)object2);
            object2 = shareLocationManager2.getRequestData(hashMap3, 0);
            BDLog.d(TAG, " load waypoint driver data:" + (String)object2);
            cursor2.close();
            return shareLocationManager.requestUpdateDriverStatus(string3, (String)object2, n2);
        }
        BDLog.dforce(TAG, "Load way point info error beacause database can't error");
        return false;
    }

    private synchronized boolean loadRouteInfo(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[loadRouteInfo]: orderId is empty");
            return false;
        }
        String string3 = "orderId = ?";
        Cursor cursor = new String[1];
        Cursor cursor2 = cursor;
        cursor[0] = string2;
        Object object = ((ShareLocationManager)object3).mDatabase;
        if (object != null && object.isOpen()) {
            Object object2;
            HashMap<String, Object> hashMap;
            if ((cursor2 = ((ShareLocationManager)object3).mDatabase.query("routeInfo", null, string3, (String[])cursor2, null, null, null)) == null) {
                BDLog.e(TAG, "[loadRouteInfo]: cursor is null 0");
                return false;
            }
            if (!((ShareLocationManager)object3).mDatabase.isOpen()) {
                cursor2.close();
                BDLog.e(TAG, "[loadRouteInfo]: database is close");
                return false;
            }
            object = "-+~$#empty_parent_id#$~+-_" + ((ShareLocationManager)object3).mHashCode;
            if (!cursor2.moveToFirst()) {
                cursor2.close();
                Cursor cursor3 = new String[1];
                cursor2 = cursor3;
                cursor3[0] = object;
                cursor2 = ((ShareLocationManager)object3).mDatabase.query("routeInfo", null, string3, (String[])cursor2, null, null, null);
                if (cursor2 == null) {
                    BDLog.e(TAG, "[loadRouteInfo]: cursor is null");
                    return false;
                }
                if (!((ShareLocationManager)object3).mDatabase.isOpen() || !cursor2.moveToFirst()) {
                    cursor2.close();
                    BDLog.e(TAG, "[loadRouteInfo]: Datsbase is close or cursor is empty");
                    return false;
                }
            }
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap = new HashMap<String, Object>();
            String string4 = cursor2.getString(0);
            if (((String)object).equals(string4)) {
                ContentValues contentValues;
                string4 = contentValues;
                new ContentValues().put("orderId", string2);
                String[] stringArray = new String[1];
                object2 = stringArray;
                stringArray[0] = object;
                ((ShareLocationManager)object3).mDatabase.update("routeInfo", (ContentValues)string4, string3, object2);
                string4 = string2;
            }
            hashMap2.put("order_id", string4);
            hashMap2.put("company", cursor2.getString(1));
            hashMap2.put("order_attr", cursor2.getString(2));
            hashMap2.put("status", cursor2.getInt(3));
            hashMap2.put("session_id", cursor2.getString(4));
            hashMap2.put("route_id", cursor2.getString(5));
            hashMap2.put("modify_time", cursor2.getInt(6));
            string2 = cursor2.getString(7);
            hashMap2.put("order_type", string2);
            string3 = cursor2.getString(8);
            if (string2.equals("1")) {
                hashMap2.put("sub_orders_seq", string3);
            }
            Cursor cursor4 = cursor2;
            string3 = cursor4.getString(10);
            object = cursor4.getString(11);
            object2 = cursor4.getString(12);
            String string5 = cursor4.getString(13);
            if ("0".equals(string2)) {
                HashMap<String, Object> hashMap3 = hashMap2;
                hashMap3.put("end_name", string3);
                hashMap3.put("end_point", object);
                hashMap3.put("end_poiid", object2);
                hashMap3.put("waypoints", string5);
            }
            ShareLocationManager shareLocationManager = object3;
            ShareLocationManager shareLocationManager2 = object3;
            HashMap<String, Object> hashMap4 = hashMap2;
            ShareLocationManager shareLocationManager3 = object3;
            HashMap<String, Object> hashMap5 = hashMap2;
            ShareLocationManager shareLocationManager4 = object3;
            Object object3 = "token";
            try {
                hashMap5.put((String)object3, shareLocationManager4.whetherToEncodeParameter(shareLocationManager4.mAuthToken, true));
            }
            catch (Exception exception) {
                BDLog.dforce(TAG, "loadRouteInfo exception happened.", exception);
                return false;
            }
            object3 = shareLocationManager3.getRequestData(hashMap5, 1);
            string2 = "sign";
            hashMap4.put(string2, CarManagerUtil.getSignMD5String((String)object3));
            BDLog.e("ShareLocationManagerparamSign", (String)object3);
            object3 = shareLocationManager2.getRequestData(hashMap4, 0);
            BDLog.d(TAG, "*******load route data:" + (String)object3);
            cursor2.close();
            return shareLocationManager.sendRouteInfo(string4, (String)object3, hashMap2);
        }
        BDLog.dforce(TAG, "Load route info error beacause database can't error");
        return false;
    }

    private synchronized boolean loadOrderInfo() {
        block17: {
            String string2;
            block16: {
                JSONObject jSONObject;
                JSONArray jSONArray;
                ArrayList arrayList;
                SQLiteDatabase sQLiteDatabase;
                Object object;
                block15: {
                    ShareLocationManager shareLocationManager = this;
                    ShareLocationManager shareLocationManager2 = this;
                    string2 = "remark = ? AND orderId IN (" + shareLocationManager2.makeSqlPlacekHolder(shareLocationManager2.mUnRegisterOrderSet.size()) + ")";
                    object = shareLocationManager.getSelectArgs("register_order", shareLocationManager.mUnRegisterOrderSet);
                    sQLiteDatabase = shareLocationManager.mDatabase;
                    if (sQLiteDatabase == null || !sQLiteDatabase.isOpen()) break block17;
                    string2 = this.mDatabase.query("orderInfo", null, string2, (String[])object, null, null, null);
                    if (string2 != null) break block15;
                    BDLog.e(TAG, "[loadOrderInfo]: cursor is null");
                    return false;
                }
                if (!this.mDatabase.isOpen()) break block16;
                if (!string2.moveToFirst()) break block16;
                object = arrayList;
                arrayList = new ArrayList();
                sQLiteDatabase = jSONArray;
                jSONArray = new JSONArray();
                do {
                    HashMap<String, Object> hashMap;
                    BNOrderInfo bNOrderInfo;
                    BNOrderInfo bNOrderInfo2 = bNOrderInfo;
                    bNOrderInfo = new BNOrderInfo();
                    HashMap<String, Object> hashMap2 = hashMap;
                    BNOrderInfo bNOrderInfo3 = bNOrderInfo2;
                    hashMap2();
                    bNOrderInfo3.setOrderId(string2.getString(0));
                    hashMap2.put("order_id", MD5Util.getMD5String(bNOrderInfo3.getOrderId(), string2.getString(1)));
                    bNOrderInfo2.companyServerId = string2.getString(1);
                    hashMap2.put("company", bNOrderInfo2.companyServerId);
                    bNOrderInfo2.driverId = string2.getString(2);
                    hashMap2.put("order_attr", bNOrderInfo2.driverId);
                    bNOrderInfo2.orderState = string2.getInt(3);
                    hashMap2.put("status", bNOrderInfo2.orderState);
                    hashMap2.put("cur_point", string2.getString(4));
                    hashMap2.put("start_point", string2.getString(5));
                    hashMap2.put("start_poiid", string2.getString(6));
                    hashMap2.put("start_name", string2.getString(7));
                    hashMap2.put("end_point", string2.getString(8));
                    hashMap2.put("end_poiid", string2.getString(9));
                    hashMap.put("end_name", string2.getString(10));
                    String string3 = string2.getString(11);
                    if (!TextUtils.isEmpty((CharSequence)this.mCuid)) {
                        string3 = this.mCuid;
                    }
                    hashMap2.put("cuid", string3);
                    bNOrderInfo2.orderType = string2.getInt(13);
                    hashMap2.put("order_type", bNOrderInfo2.orderType);
                    string3 = string2.getString(14);
                    if (TextUtils.isEmpty((CharSequence)string3)) {
                        string3 = this.getParentOrderId();
                    }
                    if (bNOrderInfo2.orderType == 1 && !TextUtils.isEmpty((CharSequence)string3)) {
                        hashMap2.put("parent_order_id", string3);
                    }
                    hashMap2.put("coord_type", string2.getString(15));
                    try {
                        sQLiteDatabase.put((Object)new JSONObject(hashMap2));
                    }
                    catch (Exception exception) {
                        BDLog.dforce(TAG, "loadOrderInfo exception happened.", exception);
                    }
                    object.add(bNOrderInfo2);
                } while (string2.moveToNext());
                string2.close();
                string2 = jSONObject;
                try {
                    new JSONObject().put("order_detail", (Object)sQLiteDatabase);
                }
                catch (JSONException jSONException) {
                    BDLog.dforce(TAG, "param build error", jSONException);
                }
                if (string2.has("order_detail")) {
                    ShareLocationManager shareLocationManager = this;
                    return shareLocationManager.sendRegisterOrder(shareLocationManager.generateRegisterOrderSubUrl((JSONObject)string2), (List<BNOrderInfo>)object);
                }
                return false;
            }
            try {
                string2.close();
                BDLog.e(TAG, "[loadOrderInfo]:Database is close or cursor is empty when load order info");
                return false;
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[loadOrderInfo]:Database exception happened");
                return false;
            }
        }
        BDLog.dforce(TAG, "[loadOrderInfo]:Load order info error because database error");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BNOrderInfo loadParentOrderInfo() {
        SQLiteDatabase sQLiteDatabase = this.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            BNOrderInfo bNOrderInfo;
            sQLiteDatabase = bNOrderInfo;
            bNOrderInfo = new BNOrderInfo();
            try {
                Cursor cursor = this.mDatabase.query("parentOrderInfo", null, null, null, null, null, null);
                if (cursor == null) {
                    BDLog.e(TAG, "[loadParentOrderInfo]: cursor is null");
                    return null;
                }
                if (this.mDatabase.isOpen() && cursor.moveToFirst()) {
                    sQLiteDatabase.setOrderId(cursor.getString(0));
                    sQLiteDatabase.companyServerId = cursor.getString(1);
                    sQLiteDatabase.driverId = cursor.getString(2);
                    sQLiteDatabase.orderState = cursor.getInt(3);
                    sQLiteDatabase.orderType = cursor.getInt(4);
                    return sQLiteDatabase;
                }
                cursor.close();
                BDLog.e(TAG, "[loadParentOrderInfo]:Database is close or cursor is empty when load order info");
                return null;
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[loadParentOrderInfo]:Database exception happened");
                return null;
            }
        }
        BDLog.dforce(TAG, "[loadParentOrderInfo]:Load order info error because database error");
        return null;
    }

    private String makeSqlPlacekHolder(int n2) {
        StringBuffer stringBuffer;
        if (n2 <= 0) {
            return "";
        }
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("?");
        for (int i3 = 1; i3 < n2; ++i3) {
            stringBuffer2.append(",?");
        }
        return stringBuffer2.toString();
    }

    private String[] getSelectArgs(String object, HashSet<String> stringArray) {
        int n2 = stringArray.size() + 1;
        String[] stringArray2 = new String[n2];
        stringArray = stringArray2;
        stringArray2[0] = object;
        object = stringArray.iterator();
        int n3 = 1;
        while (object.hasNext() && n3 < n2) {
            String string2;
            stringArray[n3++] = string2 = (String)object.next();
        }
        return stringArray;
    }

    private synchronized boolean sendRouteInfo(final String string2, final String string3, final Map<String, Object> map) {
        if (!this.mIsStopSynServer && this.mIsOrderRegisted) {
            if (map != null && string3 != null && !string3.isEmpty()) {
                HttpClient.ProtoResultCallBack protoResultCallBack;
                HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
                protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                    @Override
                    public void onSuccess(String string22) {
                        4 v02 = string32;
                        BDLog.d(ShareLocationManager.TAG, "update route success");
                        ShareLocationManager.access$1902(v02.ShareLocationManager.this, 0);
                        String[] stringArray = new String[1];
                        String[] stringArray2 = stringArray;
                        stringArray[0] = string32.string2;
                        v02.ShareLocationManager.this.mDatabase.delete("routeInfo", "orderId = ?", stringArray2);
                        String string32 = String.valueOf(v02.ShareLocationManager.this.parseResponseStatus(string22));
                        string22 = v02.ShareLocationManager.this.mHashCode;
                        CarManagerUtil.addUserOP((String)"w.1.7.6", (String)"dp", (String)string32, (String)string22);
                    }

                    @Override
                    public void onFailed(HttpClient.HttpStateError object, String string22) {
                        BDLog.e(ShareLocationManager.TAG, "update route failed,errCode:" + (Object)object + "result:" + string22);
                        if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.USER_DELETED_BY_ADMIN != object && HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT != object) {
                            if (HttpClient.HttpStateError.NETWORK_ERROR == object) {
                                if (string6.ShareLocationManager.this.mCountUpdateRouteInfoError < 2) {
                                    String string32 = string6;
                                    string32.ShareLocationManager.this.mCountUpdateRouteInfoError++;
                                    String string4 = string6;
                                    string22 = string4.string2;
                                    String string5 = string4.string3;
                                    Map map2 = string4.map;
                                    string32.ShareLocationManager.this.sendRouteInfo(string22, string5, map2);
                                } else {
                                    ShareLocationManager.access$1902(string6.ShareLocationManager.this, 0);
                                }
                            } else {
                                ShareLocationManager.access$1902(string6.ShareLocationManager.this, 0);
                            }
                        } else {
                            ShareLocationManager.access$1402(string6.ShareLocationManager.this, true);
                        }
                        4 v2 = string6;
                        String string6 = String.valueOf(object.getValue());
                        object = v2.ShareLocationManager.this.mHashCode;
                        CarManagerUtil.addUserOP((String)"w.1.7.6", (String)"dp", (String)string6, (String)object);
                    }
                };
                this.mBaseRequest.sendRequest(3, "POST", string3, protoResultCallBack2);
                return true;
            }
            return false;
        }
        BDLog.e(TAG, "[sendRouteInfo]: User is deleted by admin or order register failed");
        return false;
    }

    private synchronized boolean sendRegisterOrder(final String string2, final List<BNOrderInfo> list) {
        HttpClient.ProtoResultCallBack protoResultCallBack;
        if (object.mIsStopSynServer) {
            BDLog.e(TAG, "[sendRegisterOrder]: User is deleted by admin");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
        protoResultCallBack = new HttpClient.ProtoResultCallBack(){

            @Override
            public void onSuccess(String string22) {
                5 v02 = string3;
                BDLog.d(ShareLocationManager.TAG, "register order success");
                ShareLocationManager.access$2202(v02.ShareLocationManager.this, 0);
                ShareLocationManager.access$2302(v02.ShareLocationManager.this, 0);
                ShareLocationManager.access$2402(v02.ShareLocationManager.this, 0);
                v02.ShareLocationManager.this.handleRegisterOrderResult(string22, string3.list);
                String string3 = String.valueOf(v02.ShareLocationManager.this.parseResponseStatus(string22));
                string22 = v02.ShareLocationManager.this.mHashCode;
                CarManagerUtil.addUserOP((String)"w.1.7.6", (String)"dr", (String)string3, (String)string22);
            }

            @Override
            public void onFailed(HttpClient.HttpStateError object, String string22) {
                BDLog.e(ShareLocationManager.TAG, "register order failed,errCode:" + (Object)object + "result:" + string22);
                if (HttpClient.HttpStateError.SERVER_INNER == object) {
                    if (string4.ShareLocationManager.this.mCountRegisterServerError < 1) {
                        5 v02 = string4;
                        v02.ShareLocationManager.this.mCountRegisterServerError++;
                        String string3 = string4;
                        string22 = string3.string2;
                        v02.ShareLocationManager.this.sendRegisterOrder(string22, string3.list);
                    }
                } else if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.USER_DELETED_BY_ADMIN != object && HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT != object) {
                    if (HttpClient.HttpStateError.NETWORK_ERROR == object) {
                        if (string4.ShareLocationManager.this.mCountRegisterNetError < 2) {
                            Object object2 = string4;
                            object2.ShareLocationManager.this.mCountRegisterNetError++;
                            Object object3 = string4;
                            string22 = object3.string2;
                            object2.ShareLocationManager.this.sendRegisterOrder(string22, object3.list);
                        } else {
                            BDLog.e(ShareLocationManager.TAG, "network error times:" + string4.ShareLocationManager.this.mCountRegisterNetError);
                        }
                    } else if (HttpClient.HttpStateError.PART_ORDERS_REG_FAILED == object) {
                        string4.ShareLocationManager.this.handleRegisterOrderResult(string22, string4.list);
                    } else if (HttpClient.HttpStateError.PARAM_ERROR == object && !string4.ShareLocationManager.this.isParentOrderInfoEmpty()) {
                        string4.ShareLocationManager.this.removeAllUnregisterOrder(string4.list);
                    } else if (HttpClient.HttpStateError.ORDER_ATTR_DISMATCH == object || HttpClient.HttpStateError.PARENT_ORDER_NOT_EXIST == object || HttpClient.HttpStateError.PARENT_ORDER_FINISH == object) {
                        string4.ShareLocationManager.this.removeAllUnregisterOrder(string4.list);
                    }
                } else {
                    ShareLocationManager.access$1402(string4.ShareLocationManager.this, true);
                }
                5 v4 = string4;
                String string4 = String.valueOf(object.getValue());
                object = v4.ShareLocationManager.this.mHashCode;
                CarManagerUtil.addUserOP((String)"w.1.7.6", (String)"dr", (String)string4, (String)object);
            }
        };
        Object object = HttpClient.ContentType.FORM_DATA;
        object.mBaseRequest.sendRequest(1, "POST", string2, protoResultCallBack2, (HttpClient.ContentType)((Object)object));
        return true;
    }

    private void removeAllUnregisterOrder(List<BNOrderInfo> object) {
        if (object != null && object.size() > 0) {
            SQLiteDatabase sQLiteDatabase = this.mDatabase;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                this.mUnRegisterOrderSet.clear();
                object = object.iterator();
                while (object.hasNext()) {
                    sQLiteDatabase = (BNOrderInfo)object.next();
                    if (sQLiteDatabase == null) continue;
                    String[] stringArray = new String[2];
                    String[] stringArray2 = stringArray;
                    stringArray[0] = sQLiteDatabase.getOrderId();
                    stringArray[1] = "register_order";
                    this.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", stringArray2);
                }
                return;
            }
            return;
        }
    }

    private void setCommonInfo(JSONObject jSONObject, BNOrderInfo bNOrderInfo) {
        if (bNOrderInfo == null) {
            BDLog.e(TAG, "[getParentOrderInfo]:orderIdList is null, getParentOrderInfo failed");
            return;
        }
        BNOrderInfo bNOrderInfo2 = bNOrderInfo;
        String string2 = bNOrderInfo2.preOrderId;
        if (bNOrderInfo2.orderType == 0 && !TextUtils.isEmpty((CharSequence)string2) && (string2 = this.mParentOrderInfo) != null && !string2.getOrderId().equals(bNOrderInfo.getOrderId())) {
            BDLog.e(TAG, "[getParentOrderInfo]:previousOrderId is normal");
            return;
        }
        if (this.mParentOrderInfo == null) {
            BNOrderInfo bNOrderInfo3;
            string2 = bNOrderInfo3;
            bNOrderInfo3 = new BNOrderInfo();
            this.mParentOrderInfo = string2;
        }
        this.mParentOrderInfo.orderType = bNOrderInfo.orderType;
        this.mParentOrderInfo.driverId = bNOrderInfo.driverId;
        this.mParentOrderInfo.companyServerId = bNOrderInfo.companyServerId;
        if (1 == this.mParentOrderInfo.orderType) {
            this.mParentOrderInfo.orderState = 10;
            this.mParentOrderInfo.setOrderId(jSONObject.optString("parent_order_id"));
        } else if (this.mParentOrderInfo.orderType == 0) {
            this.mParentOrderInfo.setOrderId(bNOrderInfo.getOrderId());
        }
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.insertParentOrderInfoToDataBase(shareLocationManager.mParentOrderInfo);
    }

    private boolean insertParentOrderInfoToDataBase(BNOrderInfo bNOrderInfo) {
        if (!(bNOrderInfo == null || TextUtils.isEmpty((CharSequence)bNOrderInfo.companyServerId) || TextUtils.isEmpty((CharSequence)bNOrderInfo.driverId) || TextUtils.isEmpty((CharSequence)bNOrderInfo.getOrderId()) || DEFAULT_PARENT_ORDER_ID.equals(bNOrderInfo.getOrderId()))) {
            Object[] objectArray = ((ShareLocationManager)((Object)string2)).mDatabase;
            if (((ShareLocationManager)((Object)string2)).mDatabase != null && objectArray.isOpen()) {
                ShareLocationManager shareLocationManager;
                try {
                    ShareLocationManager shareLocationManager2 = string2;
                    shareLocationManager = shareLocationManager2;
                    shareLocationManager2.mDatabase.delete("parentOrderInfo", "", null);
                }
                catch (Exception exception) {
                    BDLog.e(TAG, "[loadParentOrderInfo]:Database exception happened");
                    return false;
                }
                String string2 = "insert into parentOrderInfo (orderId,companyServerId,driverId,orderState,order_type) values(?,?,?,?,?)";
                Object[] objectArray2 = new String[5];
                objectArray = objectArray2;
                int n2 = 0;
                objectArray[n2] = bNOrderInfo.getOrderId();
                n2 = 1;
                objectArray[n2] = bNOrderInfo.companyServerId;
                n2 = 2;
                objectArray2[n2] = bNOrderInfo.driverId;
                objectArray2[3] = String.valueOf(bNOrderInfo.orderState);
                objectArray2[4] = String.valueOf(bNOrderInfo.orderType);
                shareLocationManager.mDatabase.execSQL(string2, objectArray);
                return true;
            }
            return false;
        }
        BDLog.e(TAG, "[insertParentOrderInfoToDataBase]:parent order info is empty");
        return false;
    }

    private void removeParentOrderRelatedInfoFromDB(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.removeOrderInfoFromDB(string2);
        shareLocationManager.removeRouteInfoFromDB(string2);
        shareLocationManager.removeParentOrderInfoFromDB();
    }

    private void removeLastParentOrderReleatedInfoFromDB() {
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.removeRouteInfoWithDefaultParentIDFromDB();
        BNOrderInfo bNOrderInfo = shareLocationManager.loadParentOrderInfo();
        if (bNOrderInfo == null) {
            BDLog.e(TAG, "preOrderInfo is null");
            return;
        }
        if (bNOrderInfo.orderType == 0) {
            BNOrderInfo bNOrderInfo2 = bNOrderInfo;
            bNOrderInfo2.setOrderId(MD5Util.getMD5String(bNOrderInfo2.getOrderId(), bNOrderInfo.companyServerId));
        }
        this.removeParentOrderRelatedInfoFromDB(bNOrderInfo.getOrderId());
    }

    private void removeParentOrderInfoFromDB() {
        SQLiteDatabase sQLiteDatabase = this.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            try {
                this.mDatabase.delete("parentOrderInfo", "", null);
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[removeParentOrderInfoFromDataBase]:Database exception happened");
                return;
            }
        }
    }

    private void removeOrderInfoFromDB(String string2) {
        String string3 = "parent_order_id = ?";
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = string2;
        string2 = this.mDatabase;
        if (string2 != null && string2.isOpen()) {
            try {
                this.mDatabase.delete("orderInfo", string3, stringArray2);
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[removeParentOrderInfoFromDataBase]:Database exception happened");
                return;
            }
        }
    }

    private void removeRouteInfoFromDB(String string2) {
        SQLiteDatabase sQLiteDatabase = this.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            SQLiteDatabase sQLiteDatabase2;
            try {
                sQLiteDatabase2 = this.mDatabase;
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[removeParentOrderInfoFromDataBase]:Database exception happened");
                return;
            }
            sQLiteDatabase2.delete("routeInfo", "orderId = ?", new String[]{string2});
        }
    }

    private void removeRouteInfoWithDefaultParentIDFromDB() {
        SQLiteDatabase sQLiteDatabase = this.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            SQLiteDatabase sQLiteDatabase2;
            try {
                sQLiteDatabase2 = this.mDatabase;
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[removeParentOrderInfoFromDataBase]:Database exception happened");
                return;
            }
            sQLiteDatabase2.delete("routeInfo", "orderId like ?", new String[]{"-+~$#empty_parent_id#$~+-_%"});
        }
    }

    private void handleRegisterOrderResult(String string2, List<BNOrderInfo> list) {
        JSONObject jSONObject;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[handleRegOrderResult]:result is empty");
            return;
        }
        JSONObject jSONObject2 = jSONObject;
        try {
            int n2 = new JSONObject(string2).optInt("status");
            if (HttpClient.HttpStateError.NO_ERROR.getValue() != n2 && HttpClient.HttpStateError.ORDER_EXIST.getValue() != n2) {
                this.handleNotAllRegisterSuccessResult(jSONObject2, list);
            } else {
                this.handleRegisterSuccessResult(jSONObject2, list);
                this.mIsOrderRegisted = true;
            }
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    private void handleRegisterSuccessResult(JSONObject object, List<BNOrderInfo> bNOrderInfo2) {
        if (bNOrderInfo2 != null && bNOrderInfo2.size() > 0) {
            ShareLocationManager shareLocationManager = this;
            shareLocationManager.setCommonInfo((JSONObject)object, bNOrderInfo2.get(0));
            object = shareLocationManager.mDatabase;
            if (object != null && object.isOpen()) {
                for (BNOrderInfo bNOrderInfo2 : bNOrderInfo2) {
                    if (bNOrderInfo2 == null) continue;
                    this.removeUnregisterOrder(bNOrderInfo2.getOrderId());
                }
                return;
            }
            BDLog.e(TAG, "datebase is not open");
            return;
        }
        BDLog.e(TAG, "[handleSuccessResult]:orderIdList is empty");
    }

    private void handleNotAllRegisterSuccessResult(JSONObject jSONObject, List<BNOrderInfo> list) {
        if (jSONObject == null) {
            return;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("order_detail");
        if (jSONArray == null) {
            return;
        }
        JSONObject jSONObject2 = null;
        boolean bl = false;
        for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
            try {
                jSONObject2 = (JSONObject)jSONArray.get(i3);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            if (jSONObject2 == null) continue;
            int n2 = jSONObject2.optInt("status");
            String string2 = jSONObject2.optString("order");
            if (n2 != 0) {
                if (n2 != 1000) {
                    if (n2 != 1100) {
                        continue;
                    }
                } else {
                    BNOrderInfo bNOrderInfo = this.findRegisterOrderInfo(list, string2);
                    if (bNOrderInfo == null) continue;
                    this.removeUnregisterOrder(bNOrderInfo.getOrderId());
                    continue;
                }
            }
            this.mIsOrderRegisted = true;
            BNOrderInfo bNOrderInfo = this.findRegisterOrderInfo(list, string2);
            if (bNOrderInfo == null) continue;
            this.removeUnregisterOrder(bNOrderInfo.getOrderId());
            if (bl) continue;
            this.setCommonInfo(jSONObject, bNOrderInfo);
            bl = true;
        }
        int n3 = this.mCountRegisterPartFailed;
        if (n3 < 1) {
            this.mCountRegisterPartFailed = n3 + 1;
            this.loadOrderInfo();
        }
    }

    private void removeUnregisterOrder(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        String[] stringArray = this.mDatabase;
        if (this.mDatabase != null && stringArray.isOpen()) {
            String[] stringArray2 = new String[2];
            stringArray = stringArray2;
            stringArray2[0] = string2;
            stringArray2[1] = "register_order";
            this.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", stringArray);
        }
        this.removeOrderFromUnRegisterList(string2);
    }

    private void removeNotUpdateOrder(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = stringArray2.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = string2;
            stringArray[1] = "update_order";
            stringArray2.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", stringArray2);
        }
    }

    private BNOrderInfo findRegisterOrderInfo(List<BNOrderInfo> bNOrderInfo, String string2) {
        if (bNOrderInfo != null && bNOrderInfo.size() > 0) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            Iterator<BNOrderInfo> iterator = bNOrderInfo.iterator();
            bNOrderInfo = null;
            while (iterator.hasNext()) {
                bNOrderInfo = (BNOrderInfo)iterator.next();
                if (bNOrderInfo == null) continue;
                if (string2.equals(MD5Util.getMD5String(bNOrderInfo.getOrderId(), bNOrderInfo.companyServerId))) break;
                bNOrderInfo = null;
            }
            return bNOrderInfo;
        }
        return null;
    }

    private synchronized boolean driverOrderChange(String string2, int n2) {
        HashMap<String, Object> hashMap;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "waypointsSeq is null");
            return false;
        }
        if (((ShareLocationManager)((Object)string4)).isParentOrderInfoEmpty()) {
            BDLog.e(TAG, "mParentOrderInfo is null");
            return false;
        }
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap2();
        String string3 = ((ShareLocationManager)((Object)string4)).getParentOrderId();
        hashMap2.put("order_id", string3);
        hashMap2.put("company", ((ShareLocationManager)((Object)string4)).mParentOrderInfo.companyServerId);
        hashMap2.put("order_attr", ((ShareLocationManager)((Object)string4)).mParentOrderInfo.driverId);
        hashMap.put("status", ((ShareLocationManager)((Object)string4)).mParentOrderInfo.orderState);
        hashMap.put("waypoints", string2);
        Object[] objectArray = ((ShareLocationManager)((Object)string4)).mDatabase;
        if (((ShareLocationManager)((Object)string4)).mDatabase != null && objectArray.isOpen()) {
            ShareLocationManager shareLocationManager = string4;
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = string3;
            shareLocationManager.mDatabase.delete("driverStatus", "orderId = ?", (String[])objectArray);
            String[] stringArray = new String[5];
            objectArray = stringArray;
            objectArray[0] = string3;
            objectArray[1] = (String)hashMap2.get("company");
            objectArray[2] = (String)hashMap2.get("order_attr");
            stringArray[3] = String.valueOf(hashMap2.get("status"));
            stringArray[4] = string2;
            shareLocationManager.mDatabase.execSQL("insert into driverStatus (orderId,companyServerId,driverId,orderState,waypoints)values(?,?,?,?,?)", objectArray);
        }
        ShareLocationManager shareLocationManager = string4;
        String string4 = ((ShareLocationManager)((Object)string4)).getRequestData(hashMap2, 0);
        BDLog.e("ShareLocationManager driver data request", string4);
        return shareLocationManager.requestUpdateDriverStatus(string3, string4, n2);
    }

    private synchronized boolean registerOrder(List<BNOrderInfo> list) {
        if (list != null && list.size() > 0) {
            JSONObject jSONObject;
            ShareLocationManager shareLocationManager;
            ShareLocationManager shareLocationManager2;
            JSONArray jSONArray;
            JSONArray jSONArray2 = jSONArray;
            jSONArray = new JSONArray();
            String string2 = this.getCoordTypeStr();
            int n2 = 0;
            while (true) {
                block13: {
                    if (n2 >= list.size()) break;
                    Object object = list.get(n2);
                    if (object == null) break block13;
                    Object object2 = this.generateOneRegParam((BNOrderInfo)object, string2);
                    if (object2 == null) break block13;
                    this.addOrderToUnRegisterList(object.getOrderId());
                    jSONArray2.put(n2, (Object)new JSONObject(object2));
                    ShareLocationManager shareLocationManager3 = this;
                    BNOrderInfo bNOrderInfo = object;
                    BNOrderInfo bNOrderInfo2 = bNOrderInfo;
                    object = bNOrderInfo.getOrderId();
                    object2 = bNOrderInfo2.driverId;
                    String string3 = shareLocationManager3.mHashCode;
                    CarManagerUtil.addUserOP((String)"w.1.7.1", (String)object, (String)object2, (String)string3);
                }
                ++n2;
            }
            try {
                ShareLocationManager shareLocationManager4 = this;
                shareLocationManager2 = shareLocationManager4;
                shareLocationManager = shareLocationManager4;
                JSONObject jSONObject2 = new JSONObject();
                jSONObject = jSONObject2;
                jSONObject2.put("order_detail", (Object)jSONArray2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return false;
            }
            return shareLocationManager.sendRegisterOrder(shareLocationManager2.generateRegisterOrderSubUrl(jSONObject), list);
        }
        BDLog.e(TAG, "BNOrderInfo is null");
        return false;
    }

    private String generateRegisterOrderSubUrl(JSONObject object) {
        ShareLocationManager shareLocationManager = this;
        object = object.toString();
        String string2 = shareLocationManager.whetherToEncodeParameter(shareLocationManager.mAuthToken, true);
        object = shareLocationManager.whetherToEncodeParameter((String)object, true);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)object)) {
            String string3 = CarManagerUtil.getSignMD5String((String)("orders=" + (String)object + "&token=" + string2));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                BDLog.e(TAG, "[generateRegisterOrderSubUrl]: sign is null");
                return "";
            }
            String string4 = "orders=" + this.whetherToEncodeParameter((String)object, true) + "&token=" + this.whetherToEncodeParameter(string2, true) + "&sign=" + this.whetherToEncodeParameter(string3, true);
            BDLog.d(TAG, string4);
            return string4;
        }
        return "";
    }

    private Map<String, Object> generateOneRegParam(BNOrderInfo bNOrderInfo, String object) {
        if (bNOrderInfo == null) {
            return null;
        }
        if (bNOrderInfo.getOrderId() != null && bNOrderInfo.companyServerId != null && bNOrderInfo.driverId != null) {
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap = new HashMap<String, Object>();
            String string2 = "0,0";
            String string3 = "0,0";
            String string4 = "";
            String string5 = "";
            String string6 = "0,0";
            String string7 = "";
            String string8 = "";
            if (bNOrderInfo.endNode != null) {
                BNOrderInfo bNOrderInfo2 = bNOrderInfo;
                string3 = bNOrderInfo.endNode.getLongitude() + "," + bNOrderInfo.endNode.getLatitude();
                string4 = bNOrderInfo2.endNode.getId();
                string5 = objectArray2.whetherToEncodeParameter(bNOrderInfo2.endNode.getName(), true);
            }
            if (bNOrderInfo.pickupNode != null) {
                BNOrderInfo bNOrderInfo3 = bNOrderInfo;
                string6 = bNOrderInfo.pickupNode.getLongitude() + "," + bNOrderInfo.pickupNode.getLatitude();
                string8 = bNOrderInfo3.pickupNode.getId();
                string7 = objectArray2.whetherToEncodeParameter(bNOrderInfo3.pickupNode.getName(), true);
            }
            if (bNOrderInfo.curLocationNode != null) {
                string2 = bNOrderInfo.curLocationNode.getLongitude() + "," + bNOrderInfo.curLocationNode.getLatitude();
            }
            HashMap<String, Object> hashMap3 = hashMap2;
            HashMap<String, Object> hashMap4 = hashMap2;
            hashMap2.put("order_id", MD5Util.getMD5String(bNOrderInfo.getOrderId(), bNOrderInfo.companyServerId));
            hashMap2.put("company", bNOrderInfo.companyServerId);
            hashMap2.put("origin_oid", bNOrderInfo.getOrderId());
            hashMap2.put("order_attr", bNOrderInfo.driverId);
            hashMap4.put("status", bNOrderInfo.orderState);
            hashMap4.put("cur_point", string2);
            hashMap4.put("start_point", string6);
            hashMap4.put("start_poiid", string8);
            hashMap4.put("end_point", string3);
            hashMap4.put("end_poiid", string4);
            hashMap4.put("start_name", string7);
            hashMap4.put("end_name", string5);
            hashMap2.put("cuid", objectArray2.mCuid);
            hashMap3.put("order_type", bNOrderInfo.orderType);
            hashMap3.put("coord_type", object);
            object = objectArray2.mParentOrderInfo;
            if (object != null && !TextUtils.isEmpty((CharSequence)object.getOrderId()) && objectArray2.mParentOrderInfo.orderType == 1) {
                hashMap2.put("parent_order_id", objectArray2.getParentOrderId());
            }
            if (bNOrderInfo.orderType == 0 && bNOrderInfo.preOrderId != null) {
                hashMap2.put("previous_order_id", MD5Util.getMD5String(bNOrderInfo.preOrderId, bNOrderInfo.companyServerId));
            } else {
                hashMap2.put("previous_order_id", "");
            }
            object = objectArray2.getOutOfRangeOrdersFromDataBase("orderInfo");
            if (object != null && !((ArrayList)object).isEmpty()) {
                objectArray2.deleteFromDB("orderInfo", (ArrayList<String>)object);
            }
            if ((object = objectArray2.mDatabase) != null && object.isOpen()) {
                Object[] objectArray = new String[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = bNOrderInfo.getOrderId();
                objectArray[1] = "register_order";
                objectArray2.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", (String[])objectArray2);
                String[] stringArray = new String[17];
                objectArray2 = stringArray;
                objectArray2[0] = bNOrderInfo.getOrderId();
                objectArray2[1] = (String)hashMap2.get("company");
                objectArray2[2] = (String)hashMap2.get("order_attr");
                objectArray2[3] = String.valueOf(hashMap2.get("status"));
                objectArray2[4] = (String)hashMap2.get("cur_point");
                objectArray2[5] = (String)hashMap2.get("start_point");
                objectArray2[6] = (String)hashMap2.get("start_poiid");
                objectArray2[7] = (String)hashMap2.get("start_name");
                objectArray2[8] = (String)hashMap2.get("end_point");
                objectArray2[9] = (String)hashMap2.get("end_poiid");
                objectArray2[10] = (String)hashMap2.get("end_name");
                objectArray2[11] = (String)hashMap2.get("cuid");
                objectArray2[12] = "register_order";
                objectArray2[13] = String.valueOf(hashMap2.get("order_type"));
                objectArray2[14] = (String)hashMap2.get("parent_order_id");
                objectArray2[15] = (String)hashMap2.get("coord_type");
                stringArray[16] = (String)hashMap2.get("previous_order_id");
                objectArray2.mDatabase.execSQL("insert into orderInfo (orderId,companyServerId,driverId,orderState,cur_point,start_point,start_poiid,start_name,end_point,end_poiid,end_name,cuid,remark,order_type,parent_order_id,coord_type,previous_order_id)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", objectArray2);
            }
            return hashMap2;
        }
        return null;
    }

    private String getCoordTypeStr() {
        ShareLocationManager shareLocationManager = CarManagerUtil.getCoordType();
        if (shareLocationManager == null) {
            return "";
        }
        String string2 = "gcj02";
        int n2 = 11.$SwitchMap$com$baidu$mapapi$CoordType[shareLocationManager.ordinal()];
        if (n2 != 1) {
            if (n2 == 2) {
                string2 = "bd09ll";
            }
        } else {
            string2 = "gcj02";
        }
        return string2;
    }

    private int parseResponseStatus(String string2) {
        int n2;
        block5: {
            block4: {
                JSONObject jSONObject;
                ShareLocationManager shareLocationManager = jSONObject;
                try {
                    if (!new JSONObject(string2).has("status")) break block4;
                }
                catch (JSONException jSONException) {
                    BDLog.dforce(TAG, "ParseResponseStatus json happened exception", jSONException);
                    return -1;
                }
                n2 = shareLocationManager.getInt("status");
                break block5;
            }
            n2 = -1;
        }
        return n2;
    }

    private synchronized void handleEndPositionInfo(String string2) {
        BNOrderInfo bNOrderInfo = this.mParentOrderInfo;
        if (bNOrderInfo != null && bNOrderInfo.orderType == 0 && !TextUtils.isEmpty((CharSequence)this.mParentOrderInfo.getOrderId())) {
            block6: {
                JSONObject jSONObject;
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return;
                }
                bNOrderInfo = jSONObject;
                try {
                    if (new JSONObject(string2).has("data")) break block6;
                    return;
                }
                catch (JSONException jSONException) {
                    BDLog.dforce(TAG, "Parse endPosition info happened exception", jSONException);
                    return;
                }
            }
            string2 = bNOrderInfo.optJSONObject("data");
            if (string2 != null && string2.length() != 0) {
                this.parseResponseExtDestination((JSONObject)string2);
                return;
            }
            return;
        }
    }

    private void parseResponsePassengerPoint(String string2) {
        Object object = shareLocationManager.mParentOrderInfo;
        if (object != null && ((BNOrderInfo)object).orderType == 0 && !TextUtils.isEmpty((CharSequence)shareLocationManager.mParentOrderInfo.getOrderId())) {
            ShareLocationManager shareLocationManager;
            block9: {
                JSONObject jSONObject;
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return;
                }
                shareLocationManager = jSONObject;
                try {
                    if (new JSONObject(string2).has("data")) break block9;
                    return;
                }
                catch (JSONException jSONException) {
                    BDLog.dforce(TAG, "Parse endPosition info happened exception", jSONException);
                    return;
                }
            }
            shareLocationManager = shareLocationManager.optJSONObject("data");
            if (shareLocationManager != null && shareLocationManager.length() != 0 && shareLocationManager.has("pass_position")) {
                if ((shareLocationManager = shareLocationManager.optJSONObject("pass_position")) != null && shareLocationManager.length() != 0) {
                    BNRoutePlanNode.Builder builder;
                    ShareLocationManager shareLocationManager2 = shareLocationManager;
                    string2 = shareLocationManager2.optString("coord_type");
                    object = shareLocationManager2.optString("point");
                    double d3 = 0.0;
                    double d4 = 0.0;
                    long l2 = 0L;
                    if (!TextUtils.isEmpty((CharSequence)object) && (object = ((String)object).split("\\|")) != null && ((Object)object).length >= 2) {
                        Object object2 = object;
                        l2 = Long.valueOf((String)object2[0]);
                        object = String.valueOf(object2[1]).split(",");
                        if (object != null && ((Object)object).length == 2) {
                            Object object3 = object;
                            d4 = Double.valueOf((String)object3[0]);
                            d3 = Double.valueOf((String)object3[1]);
                        }
                    }
                    boolean bl = shareLocationManager.optInt("a") == 1;
                    object = builder;
                    ((BNRoutePlanNode.Builder)object)();
                    BNShareLocationManager.getInstance().setUserLocation(builder.latitude(d3).longitude(d4).build(), string2, l2, bl);
                    return;
                }
                return;
            }
            return;
        }
    }

    private void parseResponseExtDestination(JSONObject object) {
        if (object.length() != 0 && object.has("ext_destination")) {
            if ((object = object.optJSONObject("ext_destination")).length() == 0) {
                return;
            }
            JSONObject jSONObject = object;
            String string2 = jSONObject.optString("name");
            Object object2 = jSONObject.optString("point");
            double d3 = 0.0;
            double d4 = 0.0;
            if (!TextUtils.isEmpty((CharSequence)object2) && (object2 = object2.split(",")) != null && ((String[])object2).length == 2) {
                d4 = Double.valueOf(object2[0]);
                d3 = Double.valueOf(object2[1]);
            }
            JSONObject jSONObject2 = object;
            object = jSONObject2.optString("poiid");
            object2 = jSONObject2.optString("coord_type");
            long l2 = 0L;
            if (TextUtils.isEmpty((CharSequence)jSONObject2.optString("modify_time_ms"))) {
                l2 = l2;
            }
            object = new BNRoutePlanNode.Builder().id((String)object).latitude(d3).longitude(d4).name(string2).build();
            BNShareLocationManager.getInstance().updateOrderEndPosition(this.mParentOrderInfo.getOrderId(), (BNRoutePlanNode)object, l2, (String)object2);
            return;
        }
    }

    private synchronized ArrayList<String> getOutOfRangeOrdersFromDataBase(String string2) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        SQLiteDatabase sQLiteDatabase = this.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            ShareLocationManager shareLocationManager = this;
            sQLiteDatabase = shareLocationManager.mDatabase.rawQuery("select count(*) from " + string2, null);
            if (shareLocationManager.mDatabase.isOpen() && sQLiteDatabase.moveToFirst()) {
                long l2 = 0L;
                if (this.mDatabase.isOpen()) {
                    l2 = sQLiteDatabase.getLong(0);
                }
                if (l2 < 50L) {
                    sQLiteDatabase.close();
                    return arrayList2;
                }
                ShareLocationManager shareLocationManager2 = this;
                long l3 = l2 - 50L + 1L;
                string2 = shareLocationManager2.mDatabase.query(string2, null, null, null, null, null, null);
                if (shareLocationManager2.mDatabase.isOpen() && string2.moveToFirst()) {
                    do {
                        arrayList2.add(string2.getString(0));
                    } while (this.mDatabase.isOpen() && string2.moveToNext() && --l3 > 0L);
                }
                string2.close();
                return arrayList2;
            }
            sQLiteDatabase.close();
            BDLog.dforce(TAG, "Database is close");
            return arrayList2;
        }
        return arrayList2;
    }

    private synchronized void deleteFromDB(String string2, ArrayList<String> object) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            String[] stringArray = this.mDatabase;
            if (this.mDatabase == null || !stringArray.isOpen()) continue;
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
            this.mDatabase.delete(string2, "orderId = ?", stringArray);
        }
    }

    private void addUserOp(List<BNOrderInfo> object, Map<String, String> map) {
        if (object != null && object.size() > 0 && map != null && map.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                BNOrderInfo bNOrderInfo = (BNOrderInfo)object.next();
                if (bNOrderInfo == null) continue;
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (entry == null) continue;
                    entry = entry.getValue();
                    String string2 = bNOrderInfo.getOrderId();
                    String string3 = this.mHashCode;
                    CarManagerUtil.addUserOP((String)entry.getKey(), (String)string2, (String)((Object)entry), (String)string3);
                }
            }
            return;
        }
    }

    private void addLocationUpdateResponseLog(int n2) {
        Object object;
        if (n2 != ((ShareLocationManager)object).mLastUpdateLocationStatus) {
            ShareLocationManager shareLocationManager = object;
            ShareLocationManager shareLocationManager2 = object;
            object = String.valueOf(n2);
            String string2 = shareLocationManager2.mHashCode;
            CarManagerUtil.addUserOP((String)"w.1.7.6", (String)"dl", (String)object, (String)string2);
            shareLocationManager.mLastUpdateLocationStatus = n2;
            shareLocationManager.mLastUpdateLocResponseTime = System.currentTimeMillis();
            return;
        }
        if (System.currentTimeMillis() - ((ShareLocationManager)object).mLastUpdateLocResponseTime >= 60000L) {
            Object object2 = object;
            object = String.valueOf(n2);
            String string3 = ((ShareLocationManager)object2).mHashCode;
            CarManagerUtil.addUserOP((String)"w.1.7.6", (String)"dl", (String)object, (String)string3);
            ((ShareLocationManager)object2).mLastUpdateLocResponseTime = System.currentTimeMillis();
        }
    }

    private synchronized boolean requestUpdateDriverStatus(final String string2, final String string3, final int n2) {
        if (!this.mIsStopSynServer && this.mIsOrderRegisted) {
            if (string3 != null && !string3.isEmpty()) {
                HttpClient.ProtoResultCallBack protoResultCallBack;
                HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
                protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                    @Override
                    public void onSuccess(String object) {
                        8 v02 = string22;
                        BDLog.d(ShareLocationManager.TAG, "update driver status success");
                        ShareLocationManager.access$3002(v02.ShareLocationManager.this, 0);
                        String[] stringArray = new String[1];
                        object = stringArray;
                        stringArray[0] = string22.string2;
                        v02.ShareLocationManager.this.mDatabase.delete("driverStatus", "orderId = ?", object);
                        String string22 = v02.string2;
                        object = String.valueOf(v02.n2);
                        String string32 = v02.ShareLocationManager.this.mHashCode;
                        CarManagerUtil.addUserOP((String)"w.1.7.7", (String)string22, (String)object, (String)string32);
                    }

                    @Override
                    public void onFailed(HttpClient.HttpStateError object, String string22) {
                        BDLog.e(ShareLocationManager.TAG, "update driver status failed,errCode:" + (Object)object + "result:" + string22);
                        if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.USER_DELETED_BY_ADMIN != object && HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT != object) {
                            if (HttpClient.HttpStateError.NETWORK_ERROR == object) {
                                if (string5.ShareLocationManager.this.mCountUpdateDriverStatusError < 2) {
                                    String string32 = string5;
                                    string32.ShareLocationManager.this.mCountUpdateDriverStatusError++;
                                    String string4 = string5;
                                    object = string4.string2;
                                    string22 = string4.string3;
                                    int n22 = string4.n2;
                                    string32.ShareLocationManager.this.requestUpdateDriverStatus((String)object, string22, n22);
                                } else {
                                    ShareLocationManager.access$3002(string5.ShareLocationManager.this, 0);
                                }
                            } else {
                                ShareLocationManager.access$3002(string5.ShareLocationManager.this, 0);
                            }
                        } else {
                            ShareLocationManager.access$1402(string5.ShareLocationManager.this, true);
                        }
                        8 v2 = string5;
                        String string5 = v2.string2;
                        object = String.valueOf(v2.n2);
                        string22 = v2.ShareLocationManager.this.mHashCode;
                        CarManagerUtil.addUserOP((String)"w.1.7.7", (String)string5, (String)object, (String)string22);
                    }
                };
                this.mBaseRequest.sendRequest(7, "POST", string3, protoResultCallBack2);
                return true;
            }
            return false;
        }
        BDLog.e(TAG, "[requestUpdateDriverStatus]: User is deleted by admin or order register failed");
        return false;
    }

    private void notifyBNListener(HttpClient.HttpStateError httpStateError, String string2, IBNRequestListener iBNRequestListener) {
        if (httpStateError != HttpClient.HttpStateError.NETWORK_ERROR && httpStateError != HttpClient.HttpStateError.INNER_ERROR && httpStateError != HttpClient.HttpStateError.URL_ERROR) {
            iBNRequestListener.onRequestResult(200, "\u8bf7\u6c42\u6210\u529f", string2);
        } else {
            String string3 = httpStateError.getValue() >= 500 ? "\u670d\u52a1\u5f02\u5e38" : (httpStateError.getValue() >= 400 ? "\u8bf7\u6c42\u5f02\u5e38" : (httpStateError.getValue() == -2 ? "\u7f51\u7edc\u5f02\u5e38" : "\u672a\u77e5\u5f02\u5e38"));
            iBNRequestListener.onRequestResult(httpStateError.getValue(), string3, string2);
        }
    }

    private void registerShareLocationHandler(Handler handler) {
        int n2 = this.mOrderType;
        if (n2 == 0) {
            BNShareLocationManager.getInstance().registerShareLocationHandler(handler);
        } else if (1 == n2) {
            BNCarPoolManager.getInstance().registerShareLocationHandler(handler);
        }
    }

    private void addOrderToUnRegisterList(final String string2) {
        Runnable runnable;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[addOrderToUnRegisterList]: orderId is empty");
            return;
        }
        Object object = this.mShareLocationHandler;
        if (object == null) {
            BDLog.e(TAG, "[addOrderToUnRegisterList]: mHandler is null");
            return;
        }
        ShareLocationHandler shareLocationHandler = object;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                ShareLocationManager.this.mUnRegisterOrderSet.add(string2);
            }
        };
        shareLocationHandler.post((Runnable)object);
    }

    private void removeOrderFromUnRegisterList(final String string2) {
        Runnable runnable;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[addOrderToUnRegisterList]: orderId is empty");
            return;
        }
        Object object = this.mShareLocationHandler;
        if (object == null) {
            BDLog.e(TAG, "[removeOrderFromUnRegisterList]: mHandler is null");
            return;
        }
        ShareLocationHandler shareLocationHandler = object;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                ShareLocationManager.this.mUnRegisterOrderSet.remove(string2);
            }
        };
        shareLocationHandler.post((Runnable)object);
    }

    private boolean isParentOrderInfoEmpty() {
        BNOrderInfo bNOrderInfo;
        if (this.mParentOrderInfo == null) {
            BNOrderInfo bNOrderInfo2;
            bNOrderInfo = bNOrderInfo2;
            bNOrderInfo2 = new BNOrderInfo();
            this.mParentOrderInfo = bNOrderInfo;
        }
        if (TextUtils.isEmpty((CharSequence)this.mParentOrderInfo.companyServerId) || TextUtils.isEmpty((CharSequence)this.mParentOrderInfo.driverId) || TextUtils.isEmpty((CharSequence)this.mParentOrderInfo.getOrderId()) || this.mParentOrderInfo.orderState == 0 || DEFAULT_PARENT_ORDER_ID.equals(this.mParentOrderInfo.getOrderId())) {
            bNOrderInfo = this.loadParentOrderInfo();
            if (bNOrderInfo == null) {
                return true;
            }
            this.mParentOrderInfo = bNOrderInfo;
        }
        return (bNOrderInfo = this.mParentOrderInfo) == null || TextUtils.isEmpty((CharSequence)bNOrderInfo.companyServerId) || TextUtils.isEmpty((CharSequence)this.mParentOrderInfo.driverId) || TextUtils.isEmpty((CharSequence)this.mParentOrderInfo.getOrderId()) || this.mParentOrderInfo.orderState == 0 || DEFAULT_PARENT_ORDER_ID.equals(this.mParentOrderInfo.getOrderId());
        {
        }
    }

    private String getParentOrderId() {
        BNOrderInfo bNOrderInfo = this.mParentOrderInfo;
        if (bNOrderInfo != null && !TextUtils.isEmpty((CharSequence)bNOrderInfo.getOrderId())) {
            if (this.mParentOrderInfo.orderType == 0) {
                return MD5Util.getMD5String(this.mParentOrderInfo.getOrderId(), this.mParentOrderInfo.companyServerId);
            }
            return this.mParentOrderInfo.getOrderId();
        }
        return "";
    }

    static /* synthetic */ int access$902(ShareLocationManager shareLocationManager, int n2) {
        shareLocationManager.mCountUpdateNetError = n2;
        return n2;
    }

    static /* synthetic */ boolean access$1402(ShareLocationManager shareLocationManager, boolean bl) {
        shareLocationManager.mIsStopSynServer = bl;
        return bl;
    }

    static /* synthetic */ DataStatus access$002(ShareLocationManager shareLocationManager, DataStatus dataStatus) {
        shareLocationManager.mUploadStatus = dataStatus;
        return dataStatus;
    }

    static /* synthetic */ int access$1902(ShareLocationManager shareLocationManager, int n2) {
        shareLocationManager.mCountUpdateRouteInfoError = n2;
        return n2;
    }

    static /* synthetic */ int access$2202(ShareLocationManager shareLocationManager, int n2) {
        shareLocationManager.mCountRegisterNetError = n2;
        return n2;
    }

    static /* synthetic */ int access$2302(ShareLocationManager shareLocationManager, int n2) {
        shareLocationManager.mCountRegisterPartFailed = n2;
        return n2;
    }

    static /* synthetic */ int access$2402(ShareLocationManager shareLocationManager, int n2) {
        shareLocationManager.mCountRegisterServerError = n2;
        return n2;
    }

    static /* synthetic */ int access$3002(ShareLocationManager shareLocationManager, int n2) {
        shareLocationManager.mCountUpdateDriverStatusError = n2;
        return n2;
    }

    static /* synthetic */ int access$3702(ShareLocationManager shareLocationManager, int n2) {
        shareLocationManager.mInterval = n2;
        return n2;
    }

    static /* synthetic */ TimerTask access$3802(ShareLocationManager shareLocationManager, TimerTask timerTask) {
        shareLocationManager.mUpdateInfoTask = timerTask;
        return timerTask;
    }

    static /* synthetic */ boolean access$4002(ShareLocationManager shareLocationManager, boolean bl) {
        shareLocationManager.mFirstInitTimer = bl;
        return bl;
    }

    static /* synthetic */ long access$4202(ShareLocationManager shareLocationManager, long l2) {
        shareLocationManager.mLastLocationChangeTime = l2;
        return l2;
    }

    static /* synthetic */ String access$4502(ShareLocationManager shareLocationManager, String string2) {
        shareLocationManager.mAuthToken = string2;
        return string2;
    }

    public void retryRegisterShareLocationHandler() {
        if (this.mShareLocationHandler == null) {
            ShareLocationHandler shareLocationHandler;
            ShareLocationHandler shareLocationHandler2 = shareLocationHandler;
            shareLocationHandler = new ShareLocationHandler();
            this.mShareLocationHandler = shareLocationHandler2;
        }
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.registerShareLocationHandler(shareLocationManager.mShareLocationHandler);
    }

    public void setLogEnable(boolean bl) {
        BDLog.setLogEnable(bl);
    }

    public synchronized void onFinish(List<BNOrderInfo> object) {
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.loadOrderInfo();
        shareLocationManager.loadRouteInfo(shareLocationManager.getParentOrderId());
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                BNOrderInfo bNOrderInfo = (BNOrderInfo)object.next();
                if (bNOrderInfo == null) continue;
                this.updateOrder(bNOrderInfo);
            }
        }
        ShareLocationManager shareLocationManager2 = this;
        shareLocationManager2.updateLocationInfo(shareLocationManager2.mRouteID);
        shareLocationManager2.updateWayPointInfo();
        shareLocationManager2.removeRouteInfoWithDefaultParentIDFromDB();
        if (shareLocationManager2.isParentOrderInfoEmpty()) {
            return;
        }
        ShareLocationManager shareLocationManager3 = this;
        shareLocationManager3.removeParentOrderRelatedInfoFromDB(shareLocationManager3.getParentOrderId());
    }

    public synchronized void onDestory() {
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.unregisterShareLocationHandler(shareLocationManager.mShareLocationHandler);
        Object object = shareLocationManager.mUpdateInfoTask;
        if (object != null) {
            ((TimerTask)object).cancel();
            this.mUpdateInfoTask = null;
        }
        if ((object = this.mUpdateInfoTimer) != null) {
            ((Timer)object).cancel();
            this.mUpdateInfoTimer = null;
        }
        if ((object = this.mDatabase) != null) {
            if (object.isOpen()) {
                this.mDatabase.close();
            }
            this.mDatabase = null;
        }
    }

    public boolean isHttpsEnable() {
        return HttpClient.isHttpsEnable;
    }

    public void setHttpsEnable(boolean bl) {
        HttpClient.isHttpsEnable = bl;
    }

    public boolean uploadRouteInfo(BNShareRouteInfo object, final IBNRequestListener iBNRequestListener) {
        if (object != null && iBNRequestListener != null) {
            Object object2 = object.orderInfos;
            if (object2 != null && object2.size() >= 1) {
                HttpClient.ProtoResultCallBack protoResultCallBack;
                HashMap<String, Object> hashMap;
                HashMap<String, Object> hashMap2;
                if ((object2 = (BNOrderInfo)object2.get(0)) == null) {
                    BDLog.dforce(TAG, "bnOrderInfo is null");
                    return false;
                }
                ShareLocationManager shareLocationManager = this;
                HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
                HashMap<String, Object> hashMap4 = hashMap2;
                hashMap2();
                hashMap2.put("order_id", MD5Util.getMD5String(object2.getOrderId(), ((BNOrderInfo)object2).companyServerId));
                hashMap2.put("company", ((BNOrderInfo)object2).companyServerId);
                hashMap2.put("order_attr", ((BNOrderInfo)object2).driverId);
                hashMap2.put("status", ((BNOrderInfo)object2).orderState);
                hashMap2.put("session_id", object.sessionId);
                hashMap2.put("mrsl", object.mrsl);
                hashMap2.put("route_id", object.curRouteMD5);
                hashMap2.put("start_point", object.startNode);
                hashMap2.put("end_point", object.endNode);
                hashMap4.put("preference", object.preference);
                hashMap4.put("coord_type", "gcj02");
                object = "token";
                try {
                    hashMap3.put((String)object, this.mAuthToken);
                }
                catch (Exception exception) {
                    BDLog.dforce(TAG, "uploadRouteInfo exception happened.", exception);
                    return false;
                }
                object = this.getRequestData(hashMap3, 0);
                object2 = "sign";
                hashMap.put((String)object2, CarManagerUtil.getSignMD5String((String)object));
                BDLog.e("ShareLocationManagerparamSign", (String)object);
                object = shareLocationManager.getRequestData(shareLocationManager.getURLEncodeRequestData(hashMap), 0);
                BDLog.e("ShareLocationManageruploadRoute data = ", (String)object);
                if (object.isEmpty()) {
                    BDLog.dforce(TAG, "uploadRoute data isEmpty");
                    return false;
                }
                object2 = protoResultCallBack;
                protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                    @Override
                    public void onSuccess(String string2) {
                        iBNRequestListener.onRequestResult(200, "\u8bf7\u6c42\u6210\u529f", string2);
                    }

                    @Override
                    public void onFailed(HttpClient.HttpStateError httpStateError, String string2) {
                        ShareLocationManager.this.notifyBNListener(httpStateError, string2, iBNRequestListener);
                    }
                };
                this.mBaseRequest.sendRequest(5, "POST", (String)object, (HttpClient.ProtoResultCallBack)object2);
                return true;
            }
            BDLog.dforce(TAG, "orderInfos is null");
            return false;
        }
        BDLog.dforce(TAG, "BNShareRouteInfo or listener is null");
        return false;
    }

    public void requestRouteInfo(BNOrderInfo object, final IBNRequestListener iBNRequestListener) {
        if (object != null && iBNRequestListener != null) {
            HttpClient.ProtoResultCallBack protoResultCallBack;
            HashMap<String, Object> hashMap;
            Object object2 = hashMap;
            HashMap<String, Object> hashMap2 = object2;
            ((HashMap)object2)();
            object2.put("order_id", MD5Util.getMD5String(object.getOrderId(), object.companyServerId));
            object2.put("company", object.companyServerId);
            object2.put("order_attr", object.driverId);
            object2.put("status", object.orderState);
            object = "token";
            hashMap2.put((String)object, this.mAuthToken);
            object = this.getRequestData(hashMap2, 0);
            String string2 = "sign";
            hashMap.put(string2, CarManagerUtil.getSignMD5String((String)object));
            try {
                BDLog.e("ShareLocationManagerparamSign", (String)object);
            }
            catch (Exception exception) {
                BDLog.dforce(TAG, "requestRouteInfo exception happened.", exception);
            }
            object = this.getRequestData((Map<String, Object>)object2, 0);
            BDLog.e("ShareLocationManagerrequestRoute data = ", (String)object);
            if (TextUtils.isEmpty((CharSequence)object)) {
                BDLog.dforce(TAG, "requestRoute data isEmpty");
                return;
            }
            object2 = protoResultCallBack;
            protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                @Override
                public void onSuccess(String string2) {
                    iBNRequestListener.onRequestResult(200, "\u8bf7\u6c42\u6210\u529f", string2);
                }

                @Override
                public void onFailed(HttpClient.HttpStateError httpStateError, String string2) {
                    ShareLocationManager.this.notifyBNListener(httpStateError, string2, iBNRequestListener);
                }
            };
            this.mBaseRequest.sendRequest(6, "GET", (String)object, (HttpClient.ProtoResultCallBack)object2);
            return;
        }
        BDLog.dforce(TAG, "BNOrderInfo or listener is null");
    }

    public List<BNShareETAInfo> getETAInfos() {
        ShareLocationManager shareLocationManager = object;
        Object object = null;
        int n2 = shareLocationManager.mOrderType;
        if (1 == n2) {
            BDLog.e(TAG, "getETAInfos CAR_POOL_ORDER");
            object = BNCarPoolManager.getInstance().getETAInfos();
        } else if (n2 == 0) {
            BDLog.e(TAG, "getETAInfos NORMAL_ORDER");
            object = BNShareLocationManager.getInstance().getETAInfos();
        }
        return object;
    }

    public void unregisterShareLocationHandler(Handler handler) {
        int n2 = this.mOrderType;
        if (n2 == 0) {
            BNShareLocationManager.getInstance().unregisterShareLocationHandler(handler);
        } else if (1 == n2) {
            BNCarPoolManager.getInstance().unregisterShareLocationHandler(handler);
        }
    }

    public String whetherToEncodeParameter(String string2, boolean bl) {
        block4: {
            try {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return "";
                }
                if (!bl) break block4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                BDLog.e(TAG, "encode encodeStr failed:" + unsupportedEncodingException.toString());
                return "";
            }
            return URLEncoder.encode(string2, "utf-8");
        }
        return string2;
    }

    public class ShareLocationHandler
    extends Handler {
        private boolean handleRegisterOrder(Message object) {
            if (object != null && (object = object.obj) != null) {
                if ((object = (List)object) == null) {
                    BDLog.e(ShareLocationManager.TAG, "[handleRegisterOrder]: orderInfoList is null");
                    return false;
                }
                return ShareLocationManager.this.registerOrder((List)object);
            }
            BDLog.e(ShareLocationManager.TAG, "[handleRegisterOrder]: msg is null");
            return false;
        }

        private boolean handleUpdateOrder(Message object) {
            if (object != null && (object = ((Message)object).obj) != null) {
                if ((object = (List)object) != null && object.size() > 0) {
                    ShareLocationHandler shareLocationHandler = this;
                    ShareLocationHandler shareLocationHandler2 = this;
                    shareLocationHandler2.updateParentOrderState((BNOrderInfo)object.get(0));
                    shareLocationHandler2.ShareLocationManager.this.loadOrderInfo();
                    ShareLocationManager shareLocationManager = shareLocationHandler2.ShareLocationManager.this;
                    shareLocationManager.loadRouteInfo(shareLocationManager.getParentOrderId());
                    shareLocationHandler.handleOrderUpdateImp((List<BNOrderInfo>)object);
                    ShareLocationManager shareLocationManager2 = shareLocationHandler.ShareLocationManager.this;
                    shareLocationManager2.updateLocationInfo(shareLocationManager2.mRouteID);
                    shareLocationHandler.ShareLocationManager.this.updateWayPointInfo();
                    return true;
                }
                BDLog.e(ShareLocationManager.TAG, "[handleUpdateOrder]: orderInfos is null");
                return false;
            }
            BDLog.e(ShareLocationManager.TAG, "[handleUpdateOrder]: msg is null");
            return false;
        }

        private void updateParentOrderState(BNOrderInfo bNOrderInfo) {
            if (ShareLocationManager.this.mParentOrderInfo != null && ((ShareLocationManager)ShareLocationManager.this).mParentOrderInfo.orderType == 0 && bNOrderInfo != null) {
                BDLog.e(ShareLocationManager.TAG, " [updateParentOrderState]: mParentOrderInfo is null");
                if (!TextUtils.isEmpty((CharSequence)bNOrderInfo.preOrderId) && !ShareLocationManager.this.mParentOrderInfo.getOrderId().equals(bNOrderInfo.getOrderId())) {
                    return;
                }
                BDLog.e(ShareLocationManager.TAG, " [updateParentOrderState]: orderState is set");
                ((ShareLocationManager)ShareLocationManager.this).mParentOrderInfo.orderState = bNOrderInfo.orderState;
                ShareLocationManager shareLocationManager = ShareLocationManager.this;
                shareLocationManager.insertParentOrderInfoToDataBase(shareLocationManager.mParentOrderInfo);
            }
        }

        private void handleOrderUpdateImp(List<BNOrderInfo> object) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (BNOrderInfo)object.next();
                if (object2 == null) continue;
                BNOrderInfo bNOrderInfo = object2;
                ShareLocationManager.this.updateOrder(object2);
                object2 = bNOrderInfo.getOrderId();
                String string2 = bNOrderInfo.driverId;
                String string3 = ShareLocationManager.this.mHashCode;
                CarManagerUtil.addUserOP((String)"w.1.7.2", (String)object2, (String)string2, (String)string3);
            }
        }

        private boolean handleUpdatePosUploadInterval(Message message) {
            Date date;
            if (message == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleUpdatePosUploadInterval]: msg is null");
                return false;
            }
            int n2 = message.arg1;
            if (n2 <= 0) {
                BDLog.e(ShareLocationManager.TAG, "[handleUpdatePosUploadInterval]: msg.arg1 <= 0");
                return false;
            }
            ShareLocationHandler shareLocationHandler = object;
            ShareLocationManager.access$3702(shareLocationHandler.ShareLocationManager.this, n2);
            shareLocationHandler.ShareLocationManager.this.mUpdateInfoTask.cancel();
            if (shareLocationHandler.ShareLocationManager.this.mIsStopSynServer) {
                object.ShareLocationManager.this.mUpdateInfoTimer.cancel();
                BDLog.d(ShareLocationManager.TAG, "[handleUpdatePosUploadInterval]: cancel mUpdateInfoTimer");
                return false;
            }
            ShareLocationHandler shareLocationHandler2 = object;
            ShareLocationManager.access$3802(shareLocationHandler2.ShareLocationManager.this, new TimerTask(){

                @Override
                public void run() {
                    if (DataStatus.process != ShareLocationManager.this.mUploadStatus) {
                        1 v02 = this;
                        v02.ShareLocationManager.this.loadOrderInfo();
                        v02.ShareLocationManager.this.loadUpdateOrderInfo();
                        ShareLocationManager shareLocationManager = v02.ShareLocationManager.this;
                        shareLocationManager.loadRouteInfo(shareLocationManager.getParentOrderId());
                        ShareLocationManager shareLocationManager2 = v02.ShareLocationManager.this;
                        shareLocationManager2.updateLocationInfo(shareLocationManager2.mRouteID);
                        v02.ShareLocationManager.this.updateWayPointInfo();
                    }
                }
            });
            ShareLocationHandler shareLocationHandler3 = object;
            Object object = date;
            date = new Date();
            long l2 = shareLocationHandler3.ShareLocationManager.this.mInterval * 1000;
            shareLocationHandler2.ShareLocationManager.this.mUpdateInfoTimer.schedule(object.ShareLocationManager.this.mUpdateInfoTask, (Date)object, l2);
            ShareLocationManager.access$4002(shareLocationHandler2.ShareLocationManager.this, true);
            return true;
        }

        private boolean handleLocationChange(Message message) {
            if (message != null && message.obj != null) {
                ShareLocationInfo shareLocationInfo;
                Object object;
                if (ShareLocationManager.this.mIsStopSynServer) {
                    ShareLocationHandler shareLocationHandler = this;
                    shareLocationHandler.ShareLocationManager.this.mUpdateInfoTask.cancel();
                    shareLocationHandler.ShareLocationManager.this.mUpdateInfoTimer.cancel();
                    return false;
                }
                if (!ShareLocationManager.this.mFirstInitTimer) {
                    Date date;
                    ShareLocationHandler shareLocationHandler = this;
                    object = date;
                    date = new Date();
                    long l2 = ShareLocationManager.this.mInterval * 1000;
                    shareLocationHandler.ShareLocationManager.this.mUpdateInfoTimer.schedule(ShareLocationManager.this.mUpdateInfoTask, (Date)object, l2);
                    ShareLocationManager.access$4002(shareLocationHandler.ShareLocationManager.this, true);
                }
                if (ShareLocationManager.this.isParentOrderInfoEmpty()) {
                    BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: mParentOrderInfo is null");
                    return false;
                }
                message = (BNShareLocationInfo)message.obj;
                if (message == null) {
                    BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: locationInfo is null");
                    return false;
                }
                if (((ShareLocationManager)ShareLocationManager.this).mParentOrderInfo.orderType == 0) {
                    BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: BNOrderInfo.OrderType.NORMAL_ORDER == mParentOrderInfo.orderType");
                    if (message.orderInfos != null && message.orderInfos.size() > 0) {
                        object = (BNOrderInfo)message.orderInfos.get(0);
                        if (object == null) {
                            BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]:orderInfo is null");
                            return false;
                        }
                        if (((BNOrderInfo)object).orderState != ((ShareLocationManager)ShareLocationManager.this).mParentOrderInfo.orderState) {
                            BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]:orderState not match parent order");
                            return false;
                        }
                    } else {
                        BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]:locationInfo.orderInfos is empty");
                        return false;
                    }
                }
                object = shareLocationInfo;
                shareLocationInfo = new ShareLocationInfo();
                if (!(Math.abs(message.gpsLatitude) > 90.0 || Math.abs(message.gpsLongitude) > 180.0 || Math.abs(message.postLatitude) > 90.0 || Math.abs(message.postLongitude) > 180.0)) {
                    HashMap<String, Object> hashMap;
                    HashMap<String, Object> hashMap2;
                    ((ShareLocationInfo)object).setTimestamp(System.currentTimeMillis() / 1000L);
                    ((ShareLocationInfo)object).setInfo((BNShareLocationInfo)message);
                    ShareLocationManager.this.mCache.addLocationInfoToCache((ShareLocationInfo)object);
                    object = (int)(message.postLongitude * 100000.0) + "," + (int)(message.postLatitude * 100000.0);
                    HashMap<String, Object> hashMap3 = hashMap2;
                    hashMap3();
                    ShareLocationManager.this.generateRunAndRemainInfo(hashMap3);
                    String string2 = "";
                    if (hashMap2.containsKey("remain")) {
                        string2 = (String)hashMap3.get("remain");
                    }
                    hashMap3 = hashMap;
                    new HashMap<String, Object>().put("w.1.7.5", object);
                    hashMap3.put("w.1.7.3", string2);
                    if (ShareLocationManager.this.mLastLocationChangeTime != 0L) {
                        if (System.currentTimeMillis() - ShareLocationManager.this.mLastLocationChangeTime >= 60000L) {
                            ShareLocationHandler shareLocationHandler = this;
                            ShareLocationManager.access$4202(shareLocationHandler.ShareLocationManager.this, System.currentTimeMillis());
                            shareLocationHandler.ShareLocationManager.this.addUserOp(message.orderInfos, hashMap3);
                        }
                    } else {
                        ShareLocationHandler shareLocationHandler = this;
                        ShareLocationManager.access$4202(shareLocationHandler.ShareLocationManager.this, System.currentTimeMillis());
                        shareLocationHandler.ShareLocationManager.this.addUserOp(message.orderInfos, hashMap3);
                    }
                    return true;
                }
                BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: gps info invalid, gpsLatitude:" + message.gpsLatitude + "gpsLongitude:" + message.gpsLongitude + "postLatitude:" + message.postLatitude + "postLongitude:" + message.postLongitude);
                return false;
            }
            BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: msg is null");
            return false;
        }

        private boolean handleRougeChanged(Message message) {
            HashMap hashMap;
            if (message == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleRougeChanged]: msg is null");
                return false;
            }
            message = (BNShareRouteInfo)message.obj;
            if (message == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleRougeChanged]: routeInfo is null");
                return false;
            }
            ShareLocationHandler shareLocationHandler = object;
            shareLocationHandler.ShareLocationManager.this.loadOrderInfo();
            shareLocationHandler.ShareLocationManager.this.updateRoute((BNShareRouteInfo)message);
            shareLocationHandler.ShareLocationManager.this.updateLocationInfo(message.curRouteMD5);
            shareLocationHandler.ShareLocationManager.this.updateWayPointInfo();
            Object object = hashMap;
            ((HashMap)object)();
            hashMap.put("w.1.7.4", message.curRouteMD5);
            shareLocationHandler.ShareLocationManager.this.addUserOp(message.orderInfos, (Map)object);
            return true;
        }

        private boolean handleTokenChanged(Message object) {
            object = object.obj;
            if (object == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleTokenChanged]: msg is null");
                return false;
            }
            boolean bl = false;
            BNTokenInfo bNTokenInfo = (BNTokenInfo)object;
            if (!TextUtils.isEmpty((CharSequence)bNTokenInfo.token)) {
                ShareLocationManager.access$4502(ShareLocationManager.this, bNTokenInfo.token);
                BDLog.d(ShareLocationManager.TAG, "orderId:" + bNTokenInfo.orderInfo.getOrderId() + "   orderState:" + bNTokenInfo.orderInfo.orderState);
                bl = true;
            }
            return bl;
        }

        private boolean handlerWayPointStatusChanged(Message object) {
            object = ((Message)object).obj;
            if (object == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleTokenChanged]: msg is null");
                return false;
            }
            if ((object = (List)object) != null && object.size() > 0) {
                String string2 = "";
                if (!ShareLocationManager.this.isParentOrderInfoEmpty()) {
                    string2 = ShareLocationManager.this.getParentOrderId();
                }
                if (TextUtils.isEmpty((CharSequence)(string2 = ShareLocationManager.this.generateWayPointsOrderSubSeq((List)object, string2, true)))) {
                    BDLog.e(ShareLocationManager.TAG, "generateWayPointsOrderSubSeq empty");
                    return false;
                }
                if (TextUtils.isEmpty((CharSequence)(string2 = ShareLocationManager.this.whetherToEncodeParameter(string2, true)))) {
                    BDLog.e(ShareLocationManager.TAG, "subRowOrdersSeq is empty");
                    return false;
                }
                return ShareLocationManager.this.driverOrderChange(string2, object.size());
            }
            BDLog.e(ShareLocationManager.TAG, "[handlerDriverChanged]: wayPointInfos is null");
            return false;
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            int n2 = message.what;
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 30) {
                            switch (n2) {
                                default: {
                                    break;
                                }
                                case 12: {
                                    BDLog.d(ShareLocationManager.TAG, "MSG_SL_TOKEN_CHANGED");
                                    this.handleTokenChanged(message);
                                    break;
                                }
                                case 11: {
                                    BDLog.d(ShareLocationManager.TAG, "MSG_SL_ORDER_UPDATE");
                                    this.handleUpdateOrder(message);
                                    break;
                                }
                                case 10: {
                                    BDLog.d(ShareLocationManager.TAG, "MSG_SL_ORDER_REGISTER");
                                    this.handleRegisterOrder(message);
                                    break;
                                }
                            }
                        } else {
                            BDLog.d(ShareLocationManager.TAG, "MSG_SL_DRIVER_CHANGED");
                            this.handlerWayPointStatusChanged(message);
                        }
                    } else {
                        BDLog.d(ShareLocationManager.TAG, "MSG_SL_SET_DRIVER_POSITION_UPLOAD_INTERVAL");
                        this.handleUpdatePosUploadInterval(message);
                    }
                } else {
                    BDLog.d(ShareLocationManager.TAG, "MSG_SL_ROUTE_CHANGED");
                    this.handleRougeChanged(message);
                }
            } else {
                BDLog.d(ShareLocationManager.TAG, "MSG_SL_LOCATION_CHANGED");
                this.handleLocationChange(message);
            }
        }
    }

    private static final class DataStatus
    extends Enum<DataStatus> {
        public static final /* enum */ DataStatus ready;
        public static final /* enum */ DataStatus success;
        public static final /* enum */ DataStatus error;
        public static final /* enum */ DataStatus process;
        private static final /* synthetic */ DataStatus[] $VALUES;

        public static DataStatus[] values() {
            return (DataStatus[])$VALUES.clone();
        }

        public static DataStatus valueOf(String string2) {
            return Enum.valueOf(DataStatus.class, string2);
        }

        static {
            DataStatus dataStatus;
            ready = new DataStatus();
            success = new DataStatus();
            error = new DataStatus();
            DataStatus dataStatus2 = dataStatus;
            process = new DataStatus();
            $VALUES = new DataStatus[]{ready, success, error, dataStatus2};
        }
    }
}

