/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapframework.nirvana;

import com.baidu.mapframework.common.logger.Level;
import com.baidu.mapframework.common.logger.LogManager;
import com.baidu.mapframework.common.logger.Logger;
import com.baidu.mapframework.nirvana.ThreadPoolProfile;
import com.baidu.mapframework.nirvana.Utils;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class NirvanaThreadPoolExecutor
extends ThreadPoolExecutor {
    public static final String TAG = "NirvanaThreadPool";
    private static final ConcurrentMap<String, ThreadPoolProfile> d = new ConcurrentHashMap<String, ThreadPoolProfile>();
    private final ThreadLocal<Long> a;
    private final AtomicLong b;
    private final AtomicLong c;

    public NirvanaThreadPoolExecutor(int n2, int n3, long l2, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n2, n3, l2, timeUnit, blockingQueue, threadFactory);
        AtomicLong atomicLong;
        AtomicLong atomicLong2;
        ThreadLocal threadLocal;
        Object object = threadLocal;
        threadLocal = new ThreadLocal();
        v1.a = object;
        object = atomicLong2;
        atomicLong2 = new AtomicLong();
        v1.b = object;
        object = atomicLong;
        atomicLong = new AtomicLong();
        v1.c = object;
    }

    public static void dumpProfile() {
        Logger logger = LogManager.getLogger((Level)Level.DEBUG, (String)"Profile");
        for (Map.Entry entry : d.entrySet()) {
            logger.debug(String.valueOf(entry.getKey()) + ":" + entry.getValue() + "\n");
        }
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        NirvanaThreadPoolExecutor nirvanaThreadPoolExecutor = threadPoolProfile2;
        super.beforeExecute(thread, runnable);
        nirvanaThreadPoolExecutor.a.set(System.nanoTime());
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = thread;
        objectArray[1] = runnable;
        objectArray[2] = TimeUnit.NANOSECONDS.toMillis(((NirvanaThreadPoolExecutor)((Object)threadPoolProfile2)).a.get());
        Utils.logi(TAG, String.format("Thread %s : start task %s at: %s", objectArray2) + "");
        if ((ThreadPoolProfile)d.get(thread.getName()) == null) {
            ThreadPoolProfile threadPoolProfile;
            ThreadPoolProfile threadPoolProfile2 = threadPoolProfile;
            threadPoolProfile = new ThreadPoolProfile();
            d.put(thread.getName(), threadPoolProfile2);
        }
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        block12: {
            ThreadPoolProfile.ProfileItem profileItem;
            long l2;
            NirvanaThreadPoolExecutor nirvanaThreadPoolExecutor;
            NirvanaThreadPoolExecutor nirvanaThreadPoolExecutor2;
            try {
                NirvanaThreadPoolExecutor nirvanaThreadPoolExecutor3 = this;
                nirvanaThreadPoolExecutor2 = nirvanaThreadPoolExecutor3;
                nirvanaThreadPoolExecutor = nirvanaThreadPoolExecutor3;
                l2 = System.nanoTime();
            }
            catch (Throwable throwable2) {
                super.afterExecute(runnable, throwable);
                throw throwable2;
            }
            long l3 = l2 - this.a.get();
            nirvanaThreadPoolExecutor2.b.incrementAndGet();
            nirvanaThreadPoolExecutor.c.addAndGet(l3);
            Locale locale = Locale.getDefault();
            Object[] objectArray = new Object[4];
            objectArray[0] = Thread.currentThread();
            objectArray[1] = runnable;
            objectArray[2] = TimeUnit.NANOSECONDS.toMillis(l3);
            objectArray[3] = this.b.get();
            Utils.logi(TAG, String.format(locale, "Thread %s : end task %s, time = %d ms, executed task num: %d", objectArray));
            Object object = (ThreadPoolProfile)d.get(Thread.currentThread().getName());
            if (object == null) break block12;
            ThreadPoolProfile threadPoolProfile = object;
            object = profileItem;
            ((ThreadPoolProfile.ProfileItem)object)();
            ((ThreadPoolProfile.ProfileItem)object).name = runnable.toString();
            ((ThreadPoolProfile.ProfileItem)object).startTime = this.a.get();
            profileItem.endTime = l2;
            threadPoolProfile.a.add((ThreadPoolProfile.ProfileItem)object);
        }
        super.afterExecute(runnable, throwable);
    }

    @Override
    protected void terminated() {
        block6: {
            try {
                if (this.b.get() == 0L) break block6;
            }
            catch (Throwable throwable) {
                super.terminated();
                throw throwable;
            }
            Locale locale = Locale.getDefault();
            Object[] objectArray = new Object[2];
            objectArray[0] = this.c.get();
            objectArray[1] = this.c.get() / this.b.get();
            Utils.logi(TAG, String.format(locale, "Terminated : total time=%d, avg time=%dns", objectArray));
        }
        super.terminated();
    }
}

