/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapframework.nirvana.network;

import android.support.annotation.NonNull;
import com.baidu.mapframework.nirvana.ExceptionCallback;
import com.baidu.mapframework.nirvana.NirvanaExecutors;
import com.baidu.mapframework.nirvana.NirvanaFramework;
import com.baidu.mapframework.nirvana.Utils;
import com.baidu.mapframework.nirvana.module.Module;
import com.baidu.mapframework.nirvana.monitor.RecordType;
import com.baidu.mapframework.nirvana.network.NetworkTask;
import com.baidu.mapframework.nirvana.schedule.ScheduleConfig;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class NetworkManager {
    private static final ExecutorService a = NirvanaExecutors.newDefaultThreadPool("NetworkManager");

    public static void executeTask(@NonNull Module module, final @NonNull NetworkTask networkTask, @NonNull ScheduleConfig scheduleConfig) {
        if (!Utils.executeParamCheck(module, networkTask, scheduleConfig)) {
            return;
        }
        NirvanaFramework.getMonitor().markSubmit(RecordType.NETWORK, networkTask, module, scheduleConfig);
        a.execute(new Runnable(){

            @Override
            public void run() {
                NirvanaFramework.getMonitor().markRunning(networkTask);
                try {
                    networkTask.a.run();
                }
                catch (Exception exception) {
                    Utils.loge("NetworkManager executeTask exception", exception);
                    ExceptionCallback exceptionCallback = networkTask.getExceptionCallback();
                    if (exceptionCallback != null) {
                        exceptionCallback.onException(exception);
                    }
                    NirvanaFramework.onUncaughtException("NetworkManager", exception);
                }
                NirvanaFramework.getMonitor().markFinish(networkTask);
            }
        });
    }

    public static Future executeCallble(@NonNull Module object, @NonNull Callable callable, @NonNull ScheduleConfig scheduleConfig) {
        try {
            return a.submit(callable);
        }
        catch (Exception exception) {
            Callable callable2;
            object = callable2;
            callable2 = new Callable(){

                public Object call() throws Exception {
                    return null;
                }
            };
            return new FutureTask(object);
        }
    }

    public static void excuteRunnable(final @NonNull Runnable runnable) {
        a.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception exception) {
                    Utils.loge("NetworkManager executeTask exception", exception);
                }
            }
        });
    }

    public static ExecutorService getAppNetworkThreadPool() {
        return a;
    }
}

