/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk;

import android.location.Location;
import android.util.Log;
import com.baidu.navisdk.comapi.geolocate.c;
import com.baidu.navisdk.h;
import com.baidu.navisdk.model.datastruct.d;
import com.baidu.navisdk.util.common.t;
import com.baidu.navisdk.util.logic.j;
import com.baidu.platform.comapi.exception.ComInitException;
import com.baidu.platform.comapi.exception.InvalidComException;
import com.baidu.platform.comapi.longlink.ELongLinkStatus;
import com.baidu.platform.comapi.longlink.LongLinkClient;
import com.baidu.platform.comapi.longlink.LongLinkDataCallback;
import com.baidu.platform.comapi.longlink.LongLinkFileData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class GpsRealTime {
    private float maxV = 0.0f;
    private float maxAcc = 0.0f;
    private long lastGpsTime = 0L;
    private long firstPointTime = 0L;
    private Location lastGps = null;
    private Location lastLastGps = null;
    private byte[] cuidByte = null;
    private byte[] versionByte = new byte[4];
    private List<Byte> mGpsData = null;
    private int mGpsNum = 0;
    private boolean isStarted = false;
    private boolean inBackground = false;
    private LongLinkClient mLongLinkClient = null;
    private LongLinkDataCallback mLongLinkDataCallback = null;
    private c mLocationListener = new c(){

        @Override
        public void onLocationChange(d d3) {
        }

        @Override
        public void onWGS84LocationChange(d d3, d d4) {
            Location location;
            1 v02 = this;
            1 v12 = this = location;
            v12("GPS");
            v12.setTime(System.currentTimeMillis());
            this.setLongitude(d3.b);
            this.setLatitude(d3.a);
            this.setSpeed(d3.c);
            location.setBearing(d3.d);
            v02.GpsRealTime.this.updateLocation((Location)this);
        }

        @Override
        public void onGpsStatusChange(boolean bl, boolean bl2) {
        }
    };

    private void init() {
        String[] stringArray = h.b().split("\\.");
        int n2 = stringArray.length;
        byte[] byArray = this.versionByte;
        byte[] byArray2 = this.versionByte;
        byArray[0] = 0;
        byArray2[1] = 0;
        byArray[2] = 0;
        byArray2[3] = 0;
        if (n2 >= 4) {
            n2 = 4;
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            byte[] byArray3 = this.versionByte;
            int n3 = 255;
            int n4 = Integer.valueOf(stringArray[i3]);
            try {
                byArray3[i3] = (byte)(n4 & n3);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
        }
        this.cuidByte = this.encode(t.i() + ":" + t.g());
    }

    private synchronized void releaseLinkClient() {
        LongLinkClient longLinkClient = this.mLongLinkClient;
        if (longLinkClient != null) {
            GpsRealTime gpsRealTime = this;
            GpsRealTime gpsRealTime2 = gpsRealTime;
            GpsRealTime gpsRealTime3 = gpsRealTime;
            GpsRealTime gpsRealTime4 = gpsRealTime;
            longLinkClient.unRegister(this.mLongLinkDataCallback);
            gpsRealTime3.mLongLinkClient.stop();
            gpsRealTime4.mLongLinkClient.release();
            try {
                gpsRealTime2.mLongLinkClient = null;
            }
            catch (InvalidComException invalidComException) {
                invalidComException.printStackTrace();
            }
        }
    }

    private void updateLocation(Location location) {
        if (!this.isStarted) {
            this.start();
        }
        GpsRealTime gpsRealTime = this;
        gpsRealTime.recordLocation(location);
        gpsRealTime.checkNetwork();
    }

    private void reset() {
        GpsRealTime gpsRealTime = this;
        gpsRealTime.mGpsData = null;
        gpsRealTime.firstPointTime = 0L;
        gpsRealTime.mGpsNum = 0;
        gpsRealTime.lastGps = null;
        gpsRealTime.lastLastGps = null;
        gpsRealTime.maxV = 0.0f;
        gpsRealTime.maxAcc = 0.0f;
    }

    private void checkNetwork() {
        if (this.firstPointTime != 0L && System.currentTimeMillis() - this.firstPointTime >= 15000L) {
            List<Byte> list = this.mGpsData;
            if (list != null) {
                int n2 = list.size();
                GpsRealTime gpsRealTime = this;
                gpsRealTime.mGpsData.set(0, (byte)(n2 & 0xFF));
                gpsRealTime.mGpsData.set(1, (byte)((n2 & 0xFF00) >> 8));
                gpsRealTime.mGpsData.set(3, (byte)(this.mGpsNum & 0xFF));
                byte[] byArray = new byte[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    byArray[i3] = this.mGpsData.get(i3);
                }
                GpsRealTime gpsRealTime2 = this;
                gpsRealTime2.uploadData(byArray);
                gpsRealTime2.reset();
            }
            return;
        }
    }

    private void uploadData(byte[] object) {
        LongLinkFileData longLinkFileData;
        ArrayList<LongLinkFileData> arrayList;
        if (((byte[])object).length <= 0) {
            return;
        }
        GpsRealTime gpsRealTime = arrayList2;
        GpsRealTime gpsRealTime2 = gpsRealTime;
        gpsRealTime.initLinkClient();
        ArrayList<LongLinkFileData> arrayList2 = arrayList;
        arrayList = new ArrayList<LongLinkFileData>();
        LongLinkFileData longLinkFileData2 = longLinkFileData;
        byte[] byArray = object;
        byte[] byArray2 = object;
        longLinkFileData2();
        longLinkFileData2.fileName = "location.dat";
        object = "filename=" + longLinkFileData2.fileName;
        longLinkFileData.binData = Arrays.copyOf(byArray2, byArray.length);
        arrayList.add(longLinkFileData);
        try {
            gpsRealTime2.mLongLinkClient.sendFileData((String)object, (ArrayList)arrayList2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void initLinkClient() throws ComInitException, InvalidComException {
        if (this.mLongLinkClient == null) {
            this.mLongLinkClient = LongLinkClient.create((int)6);
            this.mLongLinkClient.start();
            if (this.mLongLinkDataCallback == null) {
                LongLinkDataCallback longLinkDataCallback;
                LongLinkDataCallback longLinkDataCallback2 = longLinkDataCallback;
                longLinkDataCallback = new LongLinkDataCallback(){

                    public boolean onReceiveData(ELongLinkStatus eLongLinkStatus, int n2, byte[] byArray, boolean bl) {
                        Log.e((String)"GpsRealTime", (String)("onReceiveData:reqId:" + n2 + " status:" + eLongLinkStatus + " data: " + new String(byArray)));
                        return true;
                    }
                };
                this.mLongLinkDataCallback = longLinkDataCallback2;
            }
            this.mLongLinkClient.register(this.mLongLinkDataCallback);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recordLocation(Location location) {
        if (System.currentTimeMillis() - this.lastGpsTime < 1000L) return;
        if (location == null) {
            return;
        }
        this.lastGpsTime = System.currentTimeMillis();
        if (location.hasSpeed() && location.getSpeed() > this.maxV) {
            this.maxV = location.getSpeed();
        }
        try {
            if (this.mGpsData == null) {
                this.mGpsData = new ArrayList<Byte>();
                this.initGpsData();
                this.addFirstGps(location);
            } else {
                this.addNextGps(location);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ++this.mGpsNum;
    }

    private void initGpsData() {
        GpsRealTime gpsRealTime = this;
        gpsRealTime.mGpsData.add((byte)0);
        gpsRealTime.mGpsData.add((byte)0);
        if (gpsRealTime.inBackground) {
            this.mGpsData.add((byte)-73);
        } else {
            this.mGpsData.add((byte)-66);
        }
        GpsRealTime gpsRealTime2 = this;
        gpsRealTime2.mGpsData.add((byte)0);
        gpsRealTime2.mGpsData.add(this.versionByte[0]);
        gpsRealTime2.mGpsData.add(this.versionByte[1]);
        gpsRealTime2.mGpsData.add(this.versionByte[2]);
        gpsRealTime2.mGpsData.add(this.versionByte[3]);
        int n2 = gpsRealTime2.cuidByte.length;
        gpsRealTime2.mGpsData.add((byte)(n2 + 1 & 0xFF));
        for (int i3 = 0; i3 < n2; ++i3) {
            this.mGpsData.add(this.cuidByte[i3]);
        }
    }

    private byte[] intToByte(int n2) {
        byte[] byArray = new byte[4];
        Object object = byArray;
        object[0] = (byte)(n2 & 0xFF);
        object[1] = (byte)((n2 & 0xFF00) >> 8);
        object[2] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[3] = (byte)((n2 & 0xFF000000) >> 24);
        return byArray;
    }

    private void addFirstGps(Location location) {
        this.firstPointTime = System.currentTimeMillis();
        this.addInt((int)(location.getTime() / 1000L));
        this.addInt((int)(location.getLongitude() * 1000000.0));
        this.addInt((int)(location.getLatitude() * 1000000.0));
        byte by = location.hasSpeed() ^ 1;
        if ((location.hasBearing() ^ 1) > 0) {
            this.mGpsData.add((byte)32);
        } else {
            byte by2 = (byte)((byte)((int)(location.getBearing() / 15.0f) & 0xFF) & 0xFFFFFFDF);
            this.mGpsData.add(by2);
        }
        if (by > 0) {
            this.mGpsData.add((byte)-128);
        } else {
            by = (byte)((byte)((int)((double)location.getSpeed() * 3.6 / 4.0) & 0xFF) & 0x7F);
            this.mGpsData.add(by);
        }
        this.lastGps = location;
    }

    private void addNextGps(Location location) {
        if (location == null) {
            return;
        }
        byte by = (byte)((location.getLongitude() - this.lastGps.getLongitude()) * 1000000.0);
        Location location2 = location;
        int n2 = (int)((location2.getLatitude() - this.lastGps.getLatitude()) * 1000000.0);
        int n3 = location2.hasBearing() ^ 1;
        int n4 = location2.hasSpeed() ^ 1;
        int n5 = by > 0 ? 0 : 1;
        by = Math.abs(by);
        int n6 = n2 > 0 ? 0 : 1;
        n2 = Math.abs(n2);
        if (this.mGpsNum > 1) {
            this.lastLastGps = null;
            this.lastLastGps = this.lastGps;
        }
        this.lastGps = location;
        if (this.lastLastGps != null && location.getTime() > this.lastLastGps.getTime() && this.lastGps.getTime() - this.lastLastGps.getTime() < 5000L) {
            double d3;
            long l2 = this.lastGps.getTime() - this.lastLastGps.getTime();
            float[] fArray = new float[2];
            GpsRealTime gpsRealTime = this;
            double d4 = gpsRealTime.lastLastGps.getLatitude();
            double d5 = gpsRealTime.lastLastGps.getLongitude();
            Location.distanceBetween((double)this.lastGps.getAltitude(), (double)this.lastGps.getLongitude(), (double)d4, (double)d5, (float[])fArray);
            long l3 = l2;
            double d6 = (fArray[0] - this.lastLastGps.getSpeed() * (float)l2) * 2.0f / (float)(l3 * l3);
            if (d3 > (double)this.maxAcc) {
                this.maxAcc = (float)d6;
            }
        }
        GpsRealTime gpsRealTime = this;
        gpsRealTime.mGpsData.add((byte)(by & 0xFF));
        gpsRealTime.mGpsData.add((byte)((by & 0xFF00) >> 8));
        gpsRealTime.mGpsData.add((byte)(n2 & 0xFF));
        gpsRealTime.mGpsData.add((byte)((n2 & 0xFF00) >> 8));
        if (n3 > 0) {
            by = 32;
            if (n6 > 0) {
                by = (byte)96;
            }
            if (n5 > 0) {
                by = (byte)(by | 0xFFFFFF80);
            }
            this.mGpsData.add(by);
        } else {
            by = (byte)((byte)((int)(location.getBearing() / 15.0f) & 0xFF) & 0x1F);
            if (n6 > 0) {
                by = (byte)(by | 0x40);
            }
            if (n5 > 0) {
                by = (byte)(by | 0xFFFFFF80);
            }
            this.mGpsData.add(by);
        }
        if (n4 > 0) {
            this.mGpsData.add((byte)-128);
        } else {
            byte by2 = (byte)((byte)((int)((double)location.getSpeed() * 3.6 / 4.0) & 0xFF) & 0x7F);
            this.mGpsData.add(by2);
        }
    }

    private void addInt(int n2) {
        byte[] byArray = this.intToByte(n2);
        for (int i3 = 0; i3 < 4; ++i3) {
            this.mGpsData.add(byArray[i3]);
        }
    }

    private byte[] encode(String string2) {
        if (string2 == null) {
            return null;
        }
        byte[] byArray = string2.getBytes();
        Object object = byArray;
        byte by = (byte)new Random().nextInt(255);
        byte by2 = (byte)new Random().nextInt(255);
        byte[] byArray2 = new byte[byArray.length + 2];
        int n2 = 0;
        int n3 = byArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            byArray2[n2++] = (byte)(object[i3] ^ by);
        }
        byte[] byArray3 = byArray2;
        int n4 = n2 + 1;
        byArray3[n2] = by;
        byArray3[n4] = by2;
        return byArray2;
    }

    public void start() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.init();
        j.p().a(this.mLocationListener);
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        GpsRealTime gpsRealTime = this;
        gpsRealTime.isStarted = false;
        gpsRealTime.reset();
        gpsRealTime.releaseLinkClient();
        j.p().b(this.mLocationListener);
    }

    public void setInBackground(boolean bl) {
        this.inBackground = bl;
    }
}

