/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.comapi.tts;

import android.os.SystemClock;
import android.text.TextUtils;
import com.baidu.navisdk.comapi.tts.IBNTTSPlayerListener;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.framework.a;
import com.baidu.navisdk.framework.interfaces.p;
import com.baidu.navisdk.jni.nativeif.JNIGuidanceControl;
import com.baidu.navisdk.jni.nativeif.JNIStatisticsControl;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.b0;
import com.baidu.navisdk.util.worker.f;
import com.baidu.navisdk.util.worker.h;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TTSPlayerControl {
    private static String TAG = "TTS";
    private static final String DINGVOICEBUFFER = "\u53ee";
    private static final String HIGHTWAYVOICEPREFIX = "\u5600\u5600\u5600";
    private static final String CRUISERVOICEPREFIX = "\u55d2\u55d2\u55d2";
    private static final String OVER_SPEED_VOICE = "\u5f53\u5f53";
    private static final String MULTI_ROUTE_VOICE = "\u5600\u5495";
    private static IBNTTSPlayerListener mTtsPlayerListener;
    private static boolean mIsFellowSpeaking = false;
    private static boolean mIsTTSPlaying = false;
    private static boolean bStopVoiceOutput = false;
    private static boolean mPlayYawSound = true;
    private static b0 mDingSound;
    private static b0 mFastRouteSound;
    private static b0 mBlankSound;
    private static HashMap<String, String> stasStrTagMap;
    private static final String TTS_RES_FAIL = "Fail";
    private static final String TTS_RES_SUCCESS = "Success";
    private static ArrayList<e> mOnTTSStateListenerList;
    private static ArrayList<c> sTTSBreakListenerList;
    private static List<d> sTTSInitList;
    public static final int PER_TTS_DEFAULT_SPEED = 5;
    public static final int PER_TTS_DEFAULT_VOL = 9;
    public static final String CAR_LIMIT_VOICE_TAG = "CarLimitVoice-";

    public static void init() {
        f f3;
        Object object = mTtsPlayerListener;
        if (object != null) {
            object.initTTSPlayer();
        }
        object = f3;
        f3 = new f(2, 0);
        com.baidu.navisdk.util.worker.d.a().submitMainThreadTask(new h<String, String>("InitFastRouteVoice", null){

            @Override
            protected String execute() {
                TTSPlayerControl.initDingVoice();
                TTSPlayerControl.initFastRouteVoice();
                TTSPlayerControl.initBluetoothBlankVoice();
                return null;
            }
        }, (f)object);
    }

    private static void initDingVoice() {
        mDingSound = new b0(a.c().a(), R.raw.ding);
    }

    private static void initFastRouteVoice() {
        mFastRouteSound = new b0(a.c().a(), R.raw.fast_route_ding);
    }

    private static void initBluetoothBlankVoice() {
    }

    public static void playFastRouteVoice() {
        LogUtil.e(TAG, "playFastRouteVoice");
        p p2 = com.baidu.navisdk.framework.interfaces.c.o().l();
        if (mFastRouteSound != null && p2 != null && p2.m() != 2) {
            mFastRouteSound.a();
        }
    }

    public static void playBluetoothBlankVoice() {
        Object object = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("playBluetoothBlankVoice,mBlankSound is null:");
        boolean bl = mBlankSound == null;
        LogUtil.e((String)object, stringBuilder.append(bl).toString());
        object = com.baidu.navisdk.framework.interfaces.c.o().l();
        if (mBlankSound != null && object != null && object.m() != 2) {
            mBlankSound.a();
        }
    }

    public static void setYawSoundEnable(boolean bl) {
        mPlayYawSound = bl;
    }

    public static void setFellowSpeakStatus(boolean bl) {
        mIsFellowSpeaking = bl;
    }

    public static boolean getFellowSpeakStatus() {
        return mIsFellowSpeaking;
    }

    public static void addTTSBreakListener(c c3) {
        ArrayList<c> arrayList = sTTSBreakListenerList;
        if (arrayList != null && c3 != null) {
            if (arrayList.contains(c3)) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "addTTSBreakListener,already added!!!," + c3);
                }
                return;
            }
            sTTSBreakListenerList.add(c3);
        }
    }

    public static void removeTTSBreakListener(c c3) {
        ArrayList<c> arrayList = sTTSBreakListenerList;
        if (arrayList != null && c3 != null) {
            arrayList.remove(c3);
        }
    }

    public static void addTTSPlayStateListener(e e3) {
        ArrayList<e> arrayList = mOnTTSStateListenerList;
        if (arrayList != null && e3 != null) {
            if (arrayList.contains(e3)) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "addTTSPlayStateListener,already added!!!," + e3);
                }
                return;
            }
            mOnTTSStateListenerList.add(e3);
        }
    }

    public static void addTTSInitCallback(d d3) {
        List<d> list = sTTSInitList;
        if (list != null && d3 != null) {
            if (list.contains(d3)) {
                if (com.baidu.navisdk.util.common.e.l.c()) {
                    com.baidu.navisdk.util.common.e.l.c(TAG, "addTTSInitCallback,already added!!!," + d3);
                }
                return;
            }
            sTTSInitList.add(d3);
        }
    }

    public static List<d> getTTSInitCallbackLIst() {
        return sTTSInitList;
    }

    public static void removeTTSInitCallback(d d3) {
        List<d> list = sTTSInitList;
        if (list != null && d3 != null) {
            list.remove(d3);
        }
    }

    public static void removeTTSPlayStateListener(e e3) {
        ArrayList<e> arrayList = mOnTTSStateListenerList;
        if (arrayList != null && e3 != null) {
            arrayList.remove(e3);
        }
    }

    public static ArrayList<e> getTTSPlayStateListener() {
        return mOnTTSStateListenerList;
    }

    public static boolean getTTSPlayStatus() {
        return mIsTTSPlaying;
    }

    public static void setTTSPlayStatus(boolean bl) {
        mIsTTSPlaying = bl;
    }

    public static boolean getMapTTSPlayStatus() {
        return TTSPlayerControl.getTTSState() == 2;
    }

    public static void unInit() {
        Object object = mDingSound;
        if (object != null) {
            ((b0)object).b();
        }
        if ((object = mFastRouteSound) != null) {
            ((b0)object).b();
        }
        if ((object = mTtsPlayerListener) != null) {
            object.releaseTTSPlayer();
        }
    }

    public static void stopSound() {
        b0 b02 = mFastRouteSound;
        if (b02 != null) {
            b02.c();
        }
    }

    public static void setTTSPlayerListener(IBNTTSPlayerListener iBNTTSPlayerListener) {
        mTtsPlayerListener = iBNTTSPlayerListener;
    }

    public static IBNTTSPlayerListener getTTSPlayerListener() {
        return mTtsPlayerListener;
    }

    public static void stopVoiceTTSOutput() {
        IBNTTSPlayerListener iBNTTSPlayerListener;
        LogUtil.e("TTSPlayerControl", "stopVoiceTTSOutput()");
        if (TTSPlayerControl.getTTSState() == 2 && (iBNTTSPlayerListener = mTtsPlayerListener) != null) {
            iBNTTSPlayerListener.stopTTS();
        }
    }

    public static void pauseVoiceTTSOutput() {
        LogUtil.e(TAG, "pauseVoiceTTSOutput! mTtsPlayerListener = " + mTtsPlayerListener);
        TTSPlayerControl.setStopVoiceOutput(true);
        IBNTTSPlayerListener iBNTTSPlayerListener = mTtsPlayerListener;
        if (iBNTTSPlayerListener != null) {
            iBNTTSPlayerListener.pauseTTS();
        }
        com.baidu.navisdk.util.statistic.userop.a.s().a("d.1.1", "1", null, null);
    }

    public static void resumeVoiceTTSOutput() {
        LogUtil.e(TAG, "resumeVoiceTTSOutput! mTtsPlayerListener = " + mTtsPlayerListener);
        TTSPlayerControl.setStopVoiceOutput(false);
        IBNTTSPlayerListener iBNTTSPlayerListener = mTtsPlayerListener;
        if (iBNTTSPlayerListener != null) {
            iBNTTSPlayerListener.resumeTTS();
        }
        com.baidu.navisdk.util.statistic.userop.a.s().a("d.1.1", "2", null, null);
    }

    public static void setStopVoiceOutput(boolean bl) {
        LogUtil.e(TAG, "setStopVoiceOutput " + bl);
        bStopVoiceOutput = bl;
    }

    public static void setPhoneIn(boolean bl) {
        IBNTTSPlayerListener iBNTTSPlayerListener = mTtsPlayerListener;
        if (iBNTTSPlayerListener != null) {
            if (bl) {
                iBNTTSPlayerListener.phoneCalling();
            } else {
                iBNTTSPlayerListener.phoneHangUp();
            }
        }
    }

    public static boolean hasInitialized() {
        IBNTTSPlayerListener iBNTTSPlayerListener = mTtsPlayerListener;
        if (iBNTTSPlayerListener != null) {
            boolean bl = iBNTTSPlayerListener.hasInitialized();
            LogUtil.e(TAG, "hasInitialized =  " + bl);
            return bl;
        }
        return false;
    }

    public static int getTTSState() {
        IBNTTSPlayerListener iBNTTSPlayerListener = mTtsPlayerListener;
        if (iBNTTSPlayerListener != null) {
            int n2 = iBNTTSPlayerListener.getTTSState();
            LogUtil.e(TAG, "getTTSState =  " + n2);
            return n2;
        }
        return 1;
    }

    public static int playTTS(String string2, int n2) {
        return TTSPlayerControl.playTTS(string2, n2, null);
    }

    public static int playTTS(String string2, int n2, String string3) {
        LogUtil.e(TAG, "playTTSText from SDK. speech=" + string2 + ", bPreempt=" + n2 + ", bStopVoiceOutput=" + bStopVoiceOutput + ", mTtsPlayerListener=" + mTtsPlayerListener);
        return TTSPlayerControl.commonPlayTTS(string2, null, n2, string3);
    }

    @Deprecated
    public static int playTTSText(String string2, int n2) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "playTTSText from JNI. with 2 params");
        }
        return TTSPlayerControl.playTTSText(string2, null, n2);
    }

    @Deprecated
    public static int playTTSText(String string2, String string3, int n2) {
        String string4 = "NaviEngine-";
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            string4 = string4 + SystemClock.elapsedRealtime();
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "playTTSText from JNI. speech=" + string2 + "pStrTag=" + string3 + ", speechId=" + string4 + ", bPreempt=" + n2 + ", bStopVoiceOutput=" + bStopVoiceOutput + ", mTtsPlayerListener=" + mTtsPlayerListener);
        }
        try {
            return TTSPlayerControl.commonPlayTTS(string2, string3, n2, string4);
        }
        catch (Exception exception) {
            if (LogUtil.LOGGABLE) {
                LogUtil.printException("playTTSText", exception);
            }
            return 0;
        }
    }

    private static int commonPlayTTS(String string2, final String string3, int n2, final String string4) {
        Object object;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "TTSPlayerControl.playTTSText(). speech=" + string2 + ", bPreempt=" + n2 + ", bStopVoiceOutput=" + bStopVoiceOutput + ", mTtsPlayerListener=" + mTtsPlayerListener + ",pStrTag=" + string3 + ", speechId=" + string4);
        }
        if (TextUtils.isEmpty((CharSequence)string4) || !string4.startsWith("NaviEngine-")) {
            string2 = JNIGuidanceControl.getInstance().getSpecTagInText(5, string2);
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "commonPlayTTS(),getSpecTagInText newSpeech = " + string2);
        }
        Object object2 = sTTSBreakListenerList.iterator();
        while (object2.hasNext()) {
            if (!object2.next().a(string2, string4)) continue;
            return 0;
        }
        object2 = com.baidu.navisdk.framework.interfaces.c.o().l();
        if (object2 != null && object2.m() == 3 && !TTSPlayerControl.isContainWarningVoice(string2)) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "just play warn, return");
            }
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            LogUtil.e("playTTSText", "pStrTag is null");
        } else {
            f f3;
            object = f3;
            f3 = new f(99, 0);
            com.baidu.navisdk.util.worker.d.a().submitMainThreadTask(new h<String, String>("commonPlayTTS-stasStrTagMap" + TTSPlayerControl.class.getSimpleName(), null){

                @Override
                protected String execute() {
                    if (stasStrTagMap == null) {
                        stasStrTagMap = new LinkedHashMap();
                    }
                    b b3 = string2;
                    String string2 = b3.string4;
                    stasStrTagMap.put(string2, b3.string3);
                    return null;
                }
            }, (f)object);
        }
        if (!bStopVoiceOutput && mTtsPlayerListener != null) {
            boolean bl = com.baidu.navisdk.framework.b.E();
            String[] stringArray = TTSPlayerControl.trimBlankVoiceStr(string2, bl);
            object = stringArray[0];
            String string5 = stringArray[1];
            com.baidu.navisdk.framework.interfaces.h h3 = com.baidu.navisdk.framework.interfaces.c.o().i();
            if (h3 != null && h3.i()) {
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    if (((String)object).startsWith(DINGVOICEBUFFER)) {
                        if (mPlayYawSound && mDingSound != null && object2 != null && object2.m() != 2) {
                            mDingSound.a();
                        }
                        object = ((String)object).substring(1);
                    } else {
                        if (((String)object).startsWith(CRUISERVOICEPREFIX)) {
                            return 0;
                        }
                        if (((String)object).startsWith(HIGHTWAYVOICEPREFIX)) {
                            object = ((String)object).substring(3);
                        }
                    }
                }
                if (((String)object).startsWith("\u3002")) {
                    object = ((String)object).substring(1);
                }
                if (TextUtils.isEmpty((CharSequence)object)) {
                    return 0;
                }
            } else {
                h3 = com.baidu.navisdk.framework.interfaces.c.o().f();
                boolean bl2 = false;
                if (h3 != null) {
                    bl2 = ((com.baidu.navisdk.framework.interfaces.pronavi.b)h3).S();
                }
                if (object2 != null && object2.m() == 2 && bl2) {
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(TAG, "Quiet, return");
                    }
                    return 0;
                }
                if (((String)object).startsWith(DINGVOICEBUFFER) && !TextUtils.isEmpty((CharSequence)object) && !mPlayYawSound) {
                    object = ((String)object).substring(1);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)string5) && bl) {
                object = string5 + (String)object;
            }
            return mTtsPlayerListener.playTTSText(TTSPlayerControl.getModule(), (String)object, string3, n2, string4);
        }
        if (com.baidu.navisdk.util.common.e.l.a()) {
            com.baidu.navisdk.util.common.e.l.a("TTSPlayerControl end. speech=" + string2 + ", bPreempt=" + n2 + ", bStopVoiceOutput=" + bStopVoiceOutput + ", mTtsPlayerListener=" + mTtsPlayerListener + ",pStrTag" + string3);
        }
        return 0;
    }

    public static int playXDTTSText(String string2, int n2) {
        return TTSPlayerControl.playXDTTSTextForResult(string2, n2, null);
    }

    public static int playXDTTSTextForResult(String string2, int n2, String string3) {
        IBNTTSPlayerListener iBNTTSPlayerListener;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "TTSPlayerControl.playXDTTSText(). speech=" + string2 + ", bPreempt=" + n2 + ", bStopVoiceOutput=" + bStopVoiceOutput + " , speechId = " + string3 + ", mTtsPlayerListener=" + mTtsPlayerListener + ",pStrTagnull");
        }
        string2 = !TextUtils.isEmpty((CharSequence)string3) && string3.startsWith("scenic_broadcast") ? JNIGuidanceControl.getInstance().getSpecTagInText(4, string2) : JNIGuidanceControl.getInstance().getSpecTagInText(1, string2);
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "playXDTTSTextForResult(),getSpecTagInText newSpeech = " + string2);
        }
        Iterator<c> iterator = sTTSBreakListenerList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().a(string2, string3)) continue;
            return 0;
        }
        com.baidu.navisdk.asr.c.y().a(string2);
        int n3 = TTSPlayerControl.getModule();
        if (!bStopVoiceOutput && (iBNTTSPlayerListener = mTtsPlayerListener) != null) {
            return iBNTTSPlayerListener.playXDTTSText(n3, string2, null, n2, string3);
        }
        if (com.baidu.navisdk.util.common.e.l.a()) {
            com.baidu.navisdk.util.common.e.l.a("TTSPlayerControl end. speech=" + string2 + ", bPreempt=" + n2 + ", bStopVoiceOutput=" + bStopVoiceOutput + ", mTtsPlayerListener=" + mTtsPlayerListener + ",pStrTagnull");
        }
        return 0;
    }

    public static void setTTSTextPlayResult(String string2) {
        Object object;
        if (LogUtil.LOGGABLE) {
            LogUtil.e("setTTSTextPlayResult:", "speechId" + string2);
            object = stasStrTagMap;
            if (object != null) {
                LogUtil.e("stasStrTagMap:", ((AbstractMap)object).toString());
            }
        }
        if (stasStrTagMap != null && !TextUtils.isEmpty((CharSequence)string2)) {
            if (!stasStrTagMap.containsKey(string2)) {
                return;
            }
            object = stasStrTagMap.entrySet().iterator();
            while (object.hasNext()) {
                Object object2 = object;
                Object object3 = (Map.Entry)object2.next();
                object2.remove();
                String string3 = (String)object3.getKey();
                object3 = (String)object3.getValue();
                if (!string2.equals(string3)) {
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e("setTTSTextPlayResult result:", string3 + ", " + (String)object3 + ":" + TTS_RES_FAIL);
                    }
                    JNIStatisticsControl.sInstance.setTTSTextPlayResult((String)object3, TTS_RES_FAIL);
                    continue;
                }
                if (LogUtil.LOGGABLE) {
                    LogUtil.e("setTTSTextPlayResult result:", string3 + ", " + (String)object3 + ":" + TTS_RES_SUCCESS);
                }
                JNIStatisticsControl.sInstance.setTTSTextPlayResult((String)object3, TTS_RES_SUCCESS);
                break;
            }
            return;
        }
    }

    public static void clearTagMap() {
        HashMap<String, String> hashMap = stasStrTagMap;
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    public static int playAudio(String string2, IBNTTSPlayerListener.a a3) {
        IBNTTSPlayerListener iBNTTSPlayerListener = mTtsPlayerListener;
        if (iBNTTSPlayerListener != null) {
            return iBNTTSPlayerListener.playAudio(string2, a3);
        }
        return -1;
    }

    public static int cancelAudio() {
        IBNTTSPlayerListener iBNTTSPlayerListener;
        if (TTSPlayerControl.getTTSState() == 2 && (iBNTTSPlayerListener = mTtsPlayerListener) != null) {
            return iBNTTSPlayerListener.cancelAudio();
        }
        return -1;
    }

    public static int getCurrentVolume() {
        IBNTTSPlayerListener iBNTTSPlayerListener = mTtsPlayerListener;
        if (iBNTTSPlayerListener != null) {
            return iBNTTSPlayerListener.getCurrentVolume();
        }
        return -1;
    }

    public static void setTTSVolume(int n2) {
        IBNTTSPlayerListener iBNTTSPlayerListener;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setTTSVolume: " + n2);
        }
        if ((iBNTTSPlayerListener = mTtsPlayerListener) != null) {
            iBNTTSPlayerListener.setTTSVolume(n2);
        }
    }

    public static void setEnableTimeOut(boolean bl) {
        IBNTTSPlayerListener iBNTTSPlayerListener = mTtsPlayerListener;
        if (iBNTTSPlayerListener != null) {
            iBNTTSPlayerListener.setEnableTimeOut(bl);
        }
    }

    public static boolean isContainWarningVoice(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.startsWith(DINGVOICEBUFFER) || string2.startsWith(HIGHTWAYVOICEPREFIX) || string2.startsWith(CRUISERVOICEPREFIX) || string2.startsWith(OVER_SPEED_VOICE) || string2.startsWith(MULTI_ROUTE_VOICE);
        {
        }
    }

    public static String[] trimBlankVoiceStr(String string2, boolean bl) {
        String string3 = "";
        String[] stringArray = new String[2];
        if (!TextUtils.isEmpty((CharSequence)string2) && bl) {
            Matcher matcher;
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "before_filter_blankStr:" + string2);
            }
            if ((matcher = Pattern.compile("<usraud>.*</usraud>").matcher(string2)).lookingAt()) {
                string3 = matcher.group();
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "blankStr:" + string3);
                }
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    string2 = string2.replace(string3, "");
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(TAG, "after_filter_blankStr:" + string2);
                    }
                }
            }
        }
        String[] stringArray2 = stringArray;
        stringArray2[0] = string2;
        stringArray2[1] = string3;
        return stringArray;
    }

    private static int getModule() {
        com.baidu.navisdk.framework.interfaces.h h3 = com.baidu.navisdk.framework.interfaces.c.o().f();
        if (h3 != null && ((com.baidu.navisdk.framework.interfaces.pronavi.b)h3).S() && (h3 = com.baidu.navisdk.framework.interfaces.c.o().c()) != null) {
            if (h3.a() == 2) {
                return 2;
            }
            if (h3.a() == 3) {
                return 3;
            }
            return 1;
        }
        h3 = com.baidu.navisdk.framework.interfaces.c.o().d();
        if (h3 != null && h3.c()) {
            return 4;
        }
        return 0;
    }

    static {
        mOnTTSStateListenerList = new ArrayList();
        sTTSBreakListenerList = new ArrayList();
        sTTSInitList = new ArrayList<d>();
    }

    public static interface e {
        public void a(String var1);

        public void onPlayEnd(String var1);
    }

    public static interface c {
        public boolean a(String var1, String var2);
    }

    public static interface d {
    }
}

