/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.database.Observable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.baidu.navisdk.util.common.e;
import java.util.ArrayList;

public class BNFixedItemLayout<VH extends ViewHolder>
extends FrameLayout {
    private static final String TAG = "BNFixedItemLayout";
    private LayoutManager mLayoutManager;
    private Adapter<VH> mAdapter;
    private OnItemClickListener mOnItemClickListener;
    private ArrayList<VH> mItemViewList;
    private boolean isNeedUpdate = false;
    private final AdapterDataObserver observer;
    private int mItemWidth;
    private int mItemHeight;
    private int mRemainderPadding;

    public BNFixedItemLayout(@NonNull Context context) {
        this(context, null);
    }

    public BNFixedItemLayout(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BNFixedItemLayout(@NonNull Context object, @Nullable AttributeSet attributeSet, int n2) {
        super(object, attributeSet, n2);
        AdapterDataObserver adapterDataObserver;
        object = adapterDataObserver;
        adapterDataObserver = new AdapterDataObserver(){

            @Override
            public void updateAllView() {
                BNFixedItemLayout.this.updateAllView();
            }

            @Override
            public void updateView(int n2) {
                BNFixedItemLayout.this.updateView(n2);
            }

            @Override
            public void updateLayout() {
                BNFixedItemLayout.this.onOrientationChange();
            }
        };
        this.observer = object;
        this.mRemainderPadding = 0;
    }

    @RequiresApi(api=21)
    public BNFixedItemLayout(@NonNull Context object, @Nullable AttributeSet attributeSet, int n2, int n3) {
        super(object, attributeSet, n2, n3);
        AdapterDataObserver adapterDataObserver;
        object = adapterDataObserver;
        adapterDataObserver = new /* invalid duplicate definition of identical inner class */;
        this.observer = object;
        this.mRemainderPadding = 0;
    }

    private void updateWidthHeight() {
        BNFixedItemLayout bNFixedItemLayout = this;
        int n2 = bNFixedItemLayout.mLayoutManager.getColTotal();
        if (bNFixedItemLayout.mItemWidth == -1) {
            int n3;
            int n4 = this.getWidth() - this.getPaddingEnd() - this.getPaddingStart() - (n2 - 1) * this.mLayoutManager.getColMargin();
            this.mItemWidth = n3 = n4 / n2;
            this.mRemainderPadding = n4 - n3 * n2;
            if (this.mRemainderPadding > 0 && e.b.d()) {
                e.b.e(TAG, "mRemainderPadding:" + this.mRemainderPadding);
            }
        }
        if (this.mItemHeight == -1) {
            this.mItemHeight = this.mItemWidth;
        }
        if (e.c.d()) {
            e.c.e(TAG, "setLayoutManager: " + this.mItemWidth + ", " + this.mItemHeight);
        }
        if (this.isNeedUpdate) {
            this.updateAllView();
        }
    }

    private void updateAllView() {
        if (this.mItemHeight > 0 && this.mItemWidth > 0) {
            this.isNeedUpdate = false;
            Adapter<VH> adapter = this.mAdapter;
            if (adapter != null && adapter.getItemCount() > 0) {
                int n2;
                if (this.mItemViewList == null) {
                    this.mItemViewList = new ArrayList(this.mAdapter.getItemCount());
                }
                int n3 = this.mAdapter.getItemCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    ViewHolder viewHolder;
                    if (n2 < this.mItemViewList.size()) {
                        viewHolder = (ViewHolder)this.mItemViewList.get(n2);
                    } else {
                        BNFixedItemLayout bNFixedItemLayout = this;
                        viewHolder = bNFixedItemLayout.mAdapter.onCreateViewHolder((ViewGroup)this);
                        bNFixedItemLayout.addView(viewHolder.itemView);
                        bNFixedItemLayout.mItemViewList.add(viewHolder);
                    }
                    int n4 = n2 / this.mLayoutManager.getColTotal();
                    int n5 = n2 % this.mLayoutManager.getColTotal();
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)viewHolder.itemView.getLayoutParams();
                    layoutParams.width = this.mItemWidth;
                    layoutParams.height = this.mItemHeight;
                    ((FrameLayout.LayoutParams)viewHolder.itemView.getLayoutParams()).topMargin = (this.mLayoutManager.getRowMargin() + this.mItemHeight) * n4;
                    if (n5 == this.mLayoutManager.getColTotal() - 1) {
                        layoutParams.setMarginStart((this.mLayoutManager.getColMargin() + this.mItemWidth) * n5 + this.mRemainderPadding);
                    } else {
                        layoutParams.setMarginStart((this.mLayoutManager.getColMargin() + this.mItemWidth) * n5);
                    }
                    ViewHolder viewHolder2 = viewHolder;
                    viewHolder.itemView.requestLayout();
                    this.mAdapter.onBindViewHolder(viewHolder, n2);
                    viewHolder2.itemView.setTag((Object)n2);
                    viewHolder2.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (BNFixedItemLayout.this.mOnItemClickListener != null) {
                                BNFixedItemLayout.this.mOnItemClickListener.onClickItem((Integer)view.getTag(), view);
                            }
                        }
                    });
                }
                while (n2 < this.mItemViewList.size()) {
                    ViewHolder viewHolder = (ViewHolder)this.mItemViewList.remove(n2);
                    if (viewHolder != null && (viewHolder = viewHolder.itemView) != null) {
                        this.removeView((View)viewHolder);
                    }
                    ++n2;
                }
                return;
            }
            if (e.b.d()) {
                e.b.e(TAG, "updateAllView mAdapter == null || 0");
            }
            return;
        }
        this.isNeedUpdate = true;
    }

    private void onOrientationChange() {
        LayoutManager layoutManager;
        if (e.c.d()) {
            e.c.e(TAG, "onOrientationChange: ");
        }
        if ((layoutManager = this.mLayoutManager) == null) {
            if (e.c.c()) {
                e.c.c(TAG, "onOrientationChange mLayoutManager == null ");
            }
            return;
        }
        BNFixedItemLayout bNFixedItemLayout = this;
        bNFixedItemLayout.mItemHeight = layoutManager.getItemHeight();
        bNFixedItemLayout.mItemWidth = bNFixedItemLayout.mLayoutManager.getItemWidth();
        int n2 = bNFixedItemLayout.getWidth();
        if (bNFixedItemLayout.mItemWidth <= 0 && n2 <= 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (e.c.d()) {
                        e.c.e(BNFixedItemLayout.TAG, "onOrientationChange onGlobalLayout: ");
                    }
                    4 v02 = this;
                    v02.BNFixedItemLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    v02.BNFixedItemLayout.this.updateWidthHeight();
                    v02.BNFixedItemLayout.this.updateLayout();
                }
            });
        } else {
            BNFixedItemLayout bNFixedItemLayout2 = this;
            bNFixedItemLayout2.updateWidthHeight();
            bNFixedItemLayout2.updateLayout();
        }
    }

    private void updateLayout() {
        for (int i3 = 0; i3 < this.mItemViewList.size(); ++i3) {
            BNFixedItemLayout bNFixedItemLayout = this;
            ViewHolder viewHolder = (ViewHolder)bNFixedItemLayout.mItemViewList.get(i3);
            int n2 = i3 / bNFixedItemLayout.mLayoutManager.getColTotal();
            int n3 = i3 % this.mLayoutManager.getColTotal();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)viewHolder.itemView.getLayoutParams();
            layoutParams.width = this.mItemWidth;
            layoutParams.height = this.mItemHeight;
            ((FrameLayout.LayoutParams)viewHolder.itemView.getLayoutParams()).topMargin = (this.mLayoutManager.getRowMargin() + this.mItemHeight) * n2;
            if (n3 == this.mLayoutManager.getColTotal() - 1) {
                layoutParams.setMarginStart((this.mLayoutManager.getColMargin() + this.mItemWidth) * n3 + this.mRemainderPadding);
            } else {
                layoutParams.setMarginStart((this.mLayoutManager.getColMargin() + this.mItemWidth) * n3);
            }
            viewHolder.itemView.requestLayout();
        }
    }

    public void setAdapter(Adapter<VH> adapter) {
        this.mAdapter = adapter;
        adapter.registerAdapterDataObserver(this.observer);
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        BNFixedItemLayout bNFixedItemLayout = this;
        this.mLayoutManager = layoutManager;
        bNFixedItemLayout.mItemHeight = layoutManager.getItemHeight();
        bNFixedItemLayout.mItemWidth = bNFixedItemLayout.mLayoutManager.getItemWidth();
        int n2 = bNFixedItemLayout.getWidth();
        if (bNFixedItemLayout.mItemWidth <= 0 && n2 <= 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (e.c.d()) {
                        e.c.e(BNFixedItemLayout.TAG, "setLayoutManager onGlobalLayout: ");
                    }
                    2 v02 = this;
                    v02.BNFixedItemLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    v02.BNFixedItemLayout.this.updateWidthHeight();
                }
            });
        } else {
            this.updateWidthHeight();
        }
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    @Nullable
    public VH getViewHolder(int n2) {
        ArrayList<VH> arrayList;
        if (e.b.d()) {
            e.b.e(TAG, "getViewHolder: " + n2);
        }
        if ((arrayList = this.mItemViewList) != null && arrayList.size() != 0 && n2 < this.mItemViewList.size()) {
            return (VH)((ViewHolder)this.mItemViewList.get(n2));
        }
        return null;
    }

    public void updateView(int n2) {
        Adapter<VH> adapter;
        if (e.b.d()) {
            e.b.e(TAG, "updateView: " + n2);
        }
        if ((adapter = object.mItemViewList) != null && ((ArrayList)((Object)adapter)).size() != 0 && n2 < object.mItemViewList.size()) {
            BNFixedItemLayout bNFixedItemLayout = object;
            Object object = (ViewHolder)bNFixedItemLayout.mItemViewList.get(n2);
            adapter = bNFixedItemLayout.mAdapter;
            if (adapter != null) {
                adapter.onBindViewHolder(object, n2);
            }
            return;
        }
        if (e.b.d()) {
            e.b.e(TAG, "updateView mItemViewList == null ");
        }
    }

    public static interface OnItemClickListener {
        public void onClickItem(int var1, View var2);
    }

    public static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        public void updateAllView() {
            for (int i3 = this.mObservers.size() - 1; i3 >= 0; --i3) {
                ((AdapterDataObserver)this.mObservers.get(i3)).updateAllView();
            }
        }

        public void updateView(int n2) {
            for (int i3 = this.mObservers.size() - 1; i3 >= 0; --i3) {
                ((AdapterDataObserver)this.mObservers.get(i3)).updateView(n2);
            }
        }

        public void updateLayout() {
            for (int i3 = this.mObservers.size() - 1; i3 >= 0; --i3) {
                ((AdapterDataObserver)this.mObservers.get(i3)).updateLayout();
            }
        }
    }

    public static interface AdapterDataObserver {
        public void updateAllView();

        public void updateView(int var1);

        public void updateLayout();
    }

    public static abstract class ViewHolder {
        public final View itemView;

        public ViewHolder(View view) {
            this.itemView = view;
        }
    }

    public static abstract class LayoutManager {
        public abstract int getColTotal();

        public abstract int getColMargin();

        public abstract int getRowMargin();

        public abstract int getItemWidth();

        public abstract int getItemHeight();
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        private AdapterDataObservable observable;

        public Adapter() {
            AdapterDataObservable adapterDataObservable;
            Object object = adapterDataObservable;
            adapterDataObservable = new AdapterDataObservable();
            v1.observable = object;
        }

        @NonNull
        public abstract VH onCreateViewHolder(@NonNull ViewGroup var1);

        public abstract void onBindViewHolder(@NonNull VH var1, int var2);

        public abstract int getItemCount();

        public void updateAllView() {
            this.observable.updateAllView();
        }

        public void updateView(int n2) {
            this.observable.updateView(n2);
        }

        public void updateLayout() {
            this.observable.updateLayout();
        }

        void registerAdapterDataObserver(@NonNull AdapterDataObserver adapterDataObserver) {
            this.observable.registerObserver(adapterDataObserver);
        }
    }
}

