/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.util.common.LogUtil;

public final class BNRoundProgress
extends View {
    private static final String TAG = "BNRoundProgress";
    @ColorInt
    private int mRoundColor;
    private int mRoundWidth;
    @ColorInt
    private int mProgressColor;
    private int max;
    private int style;
    private int mStartAngle;
    private int mTextColor;
    private int mTextSize;
    private String mText;
    private int mProgress;
    private Paint mPaint;
    private int mCenter;
    private int mRadius;
    private RectF mOval;

    public BNRoundProgress(Context context) {
        this(context, null);
    }

    public BNRoundProgress(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BNRoundProgress(Context context, @Nullable AttributeSet attributeSet, int n2) {
        BNRoundProgress bNRoundProgress = this;
        super(context, attributeSet, n2);
        bNRoundProgress.mCenter = 0;
        bNRoundProgress.mRadius = 0;
        bNRoundProgress.init(context, attributeSet);
    }

    @RequiresApi(api=21)
    public BNRoundProgress(Context context, @Nullable AttributeSet attributeSet, int n2, int n3) {
        BNRoundProgress bNRoundProgress = this;
        super(context, attributeSet, n2, n3);
        bNRoundProgress.mCenter = 0;
        bNRoundProgress.mRadius = 0;
        bNRoundProgress.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        Paint paint;
        Paint paint2 = paint;
        paint2();
        this.mPaint = paint2;
        paint.setAntiAlias(true);
        if (attributeSet == null) {
            BNRoundProgress bNRoundProgress = this;
            bNRoundProgress.mRoundColor = 0x979797;
            bNRoundProgress.mProgressColor = 0xFFFFFF;
            bNRoundProgress.mTextColor = 0xFFFFFF;
            bNRoundProgress.mTextSize = 15;
            bNRoundProgress.mRoundWidth = 5;
            bNRoundProgress.max = 100;
            bNRoundProgress.style = 0;
            bNRoundProgress.mStartAngle = -90;
        } else {
            context = context.obtainStyledAttributes(attributeSet, R.styleable.BNRoundProgress);
            this.mRoundColor = context.getColor(R.styleable.BNRoundProgress_nsdk_bn_round_color, 0x979797);
            this.mProgressColor = context.getColor(R.styleable.BNRoundProgress_nsdk_bn_progress_color, 0xFFFFFF);
            this.mTextColor = context.getColor(R.styleable.BNRoundProgress_nsdk_round_text_color, 0xFFFFFF);
            this.mTextSize = context.getDimensionPixelSize(R.styleable.BNRoundProgress_nsdk_round_text_size, 15);
            this.mRoundWidth = context.getDimensionPixelSize(R.styleable.BNRoundProgress_nsdk_bn_round_width, 5);
            this.max = context.getInteger(R.styleable.BNRoundProgress_nsdk_round_max_value, 100);
            this.style = context.getInt(R.styleable.BNRoundProgress_nsdk_bn_round_style, 0);
            this.mStartAngle = context.getInt(R.styleable.BNRoundProgress_nsdk_round_start_angle, -90);
            context.recycle();
        }
    }

    protected void onDraw(Canvas canvas) {
        int n2;
        Paint paint;
        BNRoundProgress bNRoundProgress = this;
        super.onDraw(canvas);
        if (bNRoundProgress.mCenter <= 0) {
            this.mCenter = this.getWidth() / 2;
        }
        if (this.mRadius <= 0) {
            this.mRadius = (int)((float)this.mCenter - (float)this.mRoundWidth / 2.0f);
        }
        if ((paint = this.mPaint) == null) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "mPaint == null");
            }
            return;
        }
        BNRoundProgress bNRoundProgress2 = this;
        BNRoundProgress bNRoundProgress3 = this;
        paint.setColor(this.mRoundColor);
        bNRoundProgress3.mPaint.setStyle(Paint.Style.STROKE);
        bNRoundProgress3.mPaint.setStrokeWidth((float)this.mRoundWidth);
        float f3 = bNRoundProgress3.mCenter;
        float f4 = bNRoundProgress3.mRadius;
        Paint paint2 = bNRoundProgress3.mPaint;
        float f5 = f3;
        canvas.drawCircle(f5, f5, f4, paint2);
        bNRoundProgress2.mPaint.setStrokeWidth((float)this.mRoundWidth);
        bNRoundProgress2.mPaint.setColor(this.mProgressColor);
        if (bNRoundProgress2.mOval == null) {
            int n3 = this.mCenter;
            int n4 = this.mRadius;
            f4 = n3 - n4;
            f3 = n3 + n4;
            float f6 = f4;
            float f7 = f3;
            this.mOval = new RectF(f6, f6, f7, f7);
        }
        if ((n2 = this.style) != 0) {
            if (n2 == 1) {
                BNRoundProgress bNRoundProgress4 = this;
                bNRoundProgress4.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                n2 = bNRoundProgress4.mProgress;
                if (n2 != 0) {
                    BNRoundProgress bNRoundProgress5 = this;
                    RectF rectF = bNRoundProgress5.mOval;
                    f4 = bNRoundProgress5.mStartAngle;
                    float f8 = n2 * 360 / this.max;
                    Paint paint3 = this.mPaint;
                    canvas.drawArc(rectF, f4, f8, true, paint3);
                }
            }
        } else {
            BNRoundProgress bNRoundProgress6 = this;
            bNRoundProgress6.mPaint.setStyle(Paint.Style.STROKE);
            RectF rectF = bNRoundProgress6.mOval;
            f4 = bNRoundProgress6.mStartAngle;
            float f9 = bNRoundProgress6.mProgress * 360 / this.max;
            Paint paint4 = bNRoundProgress6.mPaint;
            canvas.drawArc(rectF, f4, f9, false, paint4);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            BNRoundProgress bNRoundProgress7 = this;
            bNRoundProgress7.mPaint.setStrokeWidth(0.0f);
            bNRoundProgress7.mPaint.setColor(this.mTextColor);
            bNRoundProgress7.mPaint.setTextSize((float)this.mTextSize);
            bNRoundProgress7.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            bNRoundProgress7.mPaint.setTypeface(Typeface.DEFAULT_BOLD);
            float f10 = bNRoundProgress7.mPaint.measureText(this.mText);
            String string2 = bNRoundProgress7.mText;
            int n5 = bNRoundProgress7.mCenter;
            float f11 = (float)n5 - f10 / 2.0f;
            f10 = n5 + this.mTextSize / 2;
            Paint paint5 = bNRoundProgress7.mPaint;
            canvas.drawText(string2, f11, f10, paint5);
        }
    }

    public synchronized void setProgress(int n2) {
        if (n2 >= 0) {
            int n3 = this.max;
            if (n2 <= n3) {
                n3 = n2;
            }
            this.mProgress = n3;
            this.postInvalidate();
            return;
        }
        throw new IllegalArgumentException("progress not < 0");
    }

    public synchronized void setProgressAndText(int n2, String string2) {
        if (n2 >= 0) {
            int n3 = this.max;
            if (n2 <= n3) {
                n3 = n2;
            }
            this.mProgress = n3;
            this.mText = string2;
            this.postInvalidate();
            return;
        }
        throw new IllegalArgumentException("progress not < 0");
    }

    public void onDestroy() {
        BNRoundProgress bNRoundProgress = this;
        bNRoundProgress.mPaint = null;
        bNRoundProgress.mOval = null;
    }

    public static interface Stype {
        public static final int STROKE = 0;
        public static final int FILL = 1;
    }
}

