/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.baidu.navisdk.comapi.mapcontrol.BNMapController;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.h;
import com.baidu.navisdk.ui.util.a;
import com.baidu.navisdk.ui.widget.BNScaleLevelViewPlugin;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.ScreenUtil;
import com.baidu.navisdk.util.jar.JarUtils;

public class BNScaleLevelView {
    private static final String TAG = "BNScaleLevelView";
    private Context mContext;
    private View mContentView;
    private TextView mScaleTitle = null;
    private TextView mScaleIndicator = null;
    private ImageView mScaleLogo = null;
    private boolean visibility;
    private View mAppNameIV = null;
    private View mScaleView = null;
    private View mScaleInnerView = null;
    private BNScaleLevelViewPlugin mBNScaleLevelViewPlugin;

    private View inflateView(Context context, int n2, boolean bl) {
        if (bl) {
            return a.a(context, n2, null);
        }
        return JarUtils.inflate(context, n2, null);
    }

    private boolean init(Context context, View view) {
        if (view != null && context != null) {
            this.mContentView = view;
            this.mContext = context;
            this.mScaleTitle = (TextView)view.findViewById(R.id.scale_title);
            this.mScaleIndicator = (TextView)view.findViewById(R.id.scale_indicator);
            this.mAppNameIV = view.findViewById(R.id.app_name);
            this.mScaleLogo = (ImageView)view.findViewById(R.id.baidu_map_logo);
            this.mScaleInnerView = view.findViewById(R.id.scale_inner_container);
            this.mScaleView = view.findViewById(R.id.map_scale_level_layout);
            if (this.mAppNameIV != null && h.c()) {
                this.mAppNameIV.setVisibility(8);
            }
            return true;
        }
        return false;
    }

    private void onSwitchMode(int n2) {
        if (n2 == 1) {
            BNScaleLevelView bNScaleLevelView = this;
            bNScaleLevelView.mScaleInnerView.setVisibility(8);
            bNScaleLevelView.mScaleLogo.setVisibility(0);
        } else {
            BNScaleLevelView bNScaleLevelView = this;
            bNScaleLevelView.mScaleInnerView.setVisibility(0);
            bNScaleLevelView.mScaleLogo.setVisibility(8);
        }
    }

    public View onCreateView(Context context) {
        View view = a.a(context, R.layout.nsdk_layout_scale_level, null);
        this.initView(context, view);
        return view;
    }

    public View onCreateView(Context context, boolean bl) {
        View view = this.inflateView(context, R.layout.nsdk_layout_scale_level, bl);
        this.initView(context, view);
        return view;
    }

    public void initView(Context object, View object2) {
        BNScaleLevelViewPlugin.SwitchModeCallback switchModeCallback;
        BNScaleLevelViewPlugin bNScaleLevelViewPlugin;
        if (!this.init((Context)object, (View)object2)) {
            return;
        }
        object = bNScaleLevelViewPlugin;
        object2 = switchModeCallback;
        switchModeCallback = new BNScaleLevelViewPlugin.SwitchModeCallback(){

            @Override
            public void switchMode(int n2) {
                BNScaleLevelView.this.onSwitchMode(n2);
            }
        };
        bNScaleLevelViewPlugin = new BNScaleLevelViewPlugin((BNScaleLevelViewPlugin.SwitchModeCallback)object2);
        this.mBNScaleLevelViewPlugin = object;
    }

    public void initView(Context object, View object2, long l2) {
        BNScaleLevelViewPlugin.SwitchModeCallback switchModeCallback;
        BNScaleLevelViewPlugin bNScaleLevelViewPlugin;
        if (!this.init((Context)object, (View)object2)) {
            return;
        }
        object = bNScaleLevelViewPlugin;
        object2 = switchModeCallback;
        switchModeCallback = new BNScaleLevelViewPlugin.SwitchModeCallback(){

            @Override
            public void switchMode(int n2) {
                BNScaleLevelView.this.onSwitchMode(n2);
            }
        };
        bNScaleLevelViewPlugin = new BNScaleLevelViewPlugin((BNScaleLevelViewPlugin.SwitchModeCallback)object2, l2);
        this.mBNScaleLevelViewPlugin = object;
    }

    public void updateScaleViewMode(int n2) {
        this.mBNScaleLevelViewPlugin.switchScaleViewMode(n2);
    }

    public void updateScaleView(String string2, int n2) {
        BNScaleLevelView bNScaleLevelView = this;
        bNScaleLevelView.mScaleTitle.setText((CharSequence)string2);
        bNScaleLevelView.mScaleIndicator.setWidth(n2);
    }

    public boolean updateScaleView() {
        int n2 = BNMapController.getInstance().getScreenWidth();
        if (n2 <= 0) {
            LogUtil.e(TAG, "updateScaleView,scrWidth-0=" + n2);
            n2 = ScreenUtil.getInstance().getWidthPixels();
        }
        if (n2 <= 0) {
            LogUtil.e(TAG, "updateScaleView,scrWidth-1=" + n2);
            return false;
        }
        int n3 = BNMapController.getInstance().getZoomLevel();
        double d3 = BNMapController.getInstance().getZoomUnitsInMeter();
        int n4 = com.baidu.nplatform.comapi.map.h.n(n3);
        LogUtil.e(TAG, "updateScaleView,dis=" + n4 + " level=" + n3 + " scrWidht=" + n2 + " u=" + d3);
        int n5 = (int)Math.ceil((double)n4 / d3);
        while (n5 > n2 / 2 && n3 >= 3 && n3 <= 21) {
            n4 = com.baidu.nplatform.comapi.map.h.n(++n3);
            n5 = (int)Math.ceil((double)n4 / d3);
        }
        String string2 = n4 >= 1000 ? n4 / 1000 + JarUtils.getResources().getString(R.string.nsdk_string_mapcontrol_panel_kilometer) : n4 + JarUtils.getResources().getString(R.string.nsdk_string_mapcontrol_panel_meter);
        this.updateScaleView(string2, n5);
        return true;
    }

    public void show() {
        this.mScaleView.setVisibility(8);
        this.visibility = true;
    }

    public void hide() {
        this.mScaleView.setVisibility(8);
        this.visibility = false;
    }

    @SuppressLint(value={"NewApi"})
    public void onUpdateStyle(boolean bl) {
        TextView textView = this.mScaleTitle;
        if (textView != null) {
            int n2 = bl ? -13223362 : -1052432;
            textView.setTextColor(n2);
        }
        if ((this = this.mScaleIndicator) != null) {
            this.setBackgroundDrawable(a.c(R.drawable.nsdk_common_ic_scale_indicator, bl));
        }
    }

    public void release() {
        BNScaleLevelViewPlugin bNScaleLevelViewPlugin = ((BNScaleLevelView)((Object)bNScaleLevelViewPlugin)).mBNScaleLevelViewPlugin;
        if (bNScaleLevelViewPlugin != null) {
            bNScaleLevelViewPlugin.release();
        }
    }

    public boolean isShown() {
        BNScaleLevelView bNScaleLevelView = bNScaleLevelView.mContentView;
        return bNScaleLevelView != null && bNScaleLevelView.isShown();
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setLogoMargin(int n2, int n3, int n4, int n5) {
        BNScaleLevelView bNScaleLevelView = bNScaleLevelView2;
        BNScaleLevelView bNScaleLevelView2 = (LinearLayout.LayoutParams)bNScaleLevelView.mScaleLogo.getLayoutParams();
        ((LinearLayout.LayoutParams)bNScaleLevelView2).leftMargin = n2;
        ((LinearLayout.LayoutParams)bNScaleLevelView2).rightMargin = n3;
        ((LinearLayout.LayoutParams)bNScaleLevelView2).topMargin = n4;
        ((LinearLayout.LayoutParams)bNScaleLevelView.mScaleLogo.getLayoutParams()).bottomMargin = n5;
        bNScaleLevelView.mScaleLogo.setLayoutParams((ViewGroup.LayoutParams)bNScaleLevelView2);
    }
}

