/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import com.baidu.navisdk.embed.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;

public class CircleProgressBar
extends ProgressBar {
    private static final int LINE = 0;
    private static final int SOLID = 1;
    private static final int SOLID_LINE = 2;
    private static final int LINEAR = 0;
    private static final int RADIAL = 1;
    private static final int SWEEP = 2;
    private static final float DEFAULT_START_DEGREE = -90.0f;
    private static final int DEFAULT_LINE_COUNT = 45;
    private static final float DEFAULT_LINE_WIDTH = 4.0f;
    private static final float DEFAULT_PROGRESS_TEXT_SIZE = 11.0f;
    private static final float DEFAULT_PROGRESS_STROKE_WIDTH = 1.0f;
    private static final String COLOR_FFF2A670 = "#fff2a670";
    private static final String COLOR_FFD3D3D5 = "#ffe3e3e5";
    private static final String DEFAULT_PATTERN = "%d%%";
    private final RectF mProgressRectF;
    private final Rect mProgressTextRect;
    private final Paint mProgressPaint;
    private final Paint mBackgroundPaint;
    private final Paint mProgressTextPaint;
    private float mRadius;
    private float mCenterX;
    private float mCenterY;
    private int mLineCount;
    private float mLineWidth;
    private float mProgressStrokeWidth;
    private float mProgressTextSize;
    private int mProgressStartColor;
    private int mProgressEndColor;
    private int mProgressTextColor;
    private int mProgressBackgroundColor;
    private boolean mDrawProgressText;
    private String mProgressTextFormatPattern;
    private int mStyle;
    private int mShader;
    private Paint.Cap mCap;

    public CircleProgressBar(Context context) {
        this(context, null);
    }

    public CircleProgressBar(Context context, AttributeSet attributeSet) {
        Paint paint;
        Paint paint2;
        Paint paint3;
        Rect rect;
        RectF rectF;
        CircleProgressBar circleProgressBar = circleProgressBar2;
        super(context, attributeSet);
        CircleProgressBar circleProgressBar2 = rectF;
        rectF = new RectF();
        circleProgressBar.mProgressRectF = circleProgressBar2;
        circleProgressBar2 = rect;
        rect = new Rect();
        circleProgressBar.mProgressTextRect = circleProgressBar2;
        circleProgressBar2 = paint3;
        paint3 = new Paint(1);
        circleProgressBar.mProgressPaint = circleProgressBar2;
        circleProgressBar2 = paint2;
        paint2 = new Paint(1);
        circleProgressBar.mBackgroundPaint = circleProgressBar2;
        circleProgressBar2 = paint;
        paint = new Paint(1);
        circleProgressBar.mProgressTextPaint = circleProgressBar2;
        circleProgressBar.adjustIndeterminate();
        circleProgressBar.initFromAttributes(context, attributeSet);
        circleProgressBar.initPaint();
    }

    private int dip2px(Context context, float f3) {
        return (int)(f3 * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    private void initFromAttributes(Context context, AttributeSet object) {
        context = context.obtainStyledAttributes(object, R.styleable.BNCircleProgressBar);
        this.mDrawProgressText = context.getBoolean(R.styleable.BNCircleProgressBar_nsdk_bn_draw_progress_text, true);
        this.mLineCount = context.getInt(R.styleable.BNCircleProgressBar_nsdk_bn_line_count, 45);
        object = context.hasValue(R.styleable.BNCircleProgressBar_nsdk_bn_progress_text_format_pattern) ? context.getString(R.styleable.BNCircleProgressBar_nsdk_bn_progress_text_format_pattern) : DEFAULT_PATTERN;
        this.mProgressTextFormatPattern = object;
        this.mStyle = context.getInt(R.styleable.BNCircleProgressBar_nsdk_bn_style, 0);
        this.mShader = context.getInt(R.styleable.BNCircleProgressBar_nsdk_bn_progress_shader, 0);
        object = context.hasValue(R.styleable.BNCircleProgressBar_nsdk_bn_progress_stroke_cap) ? Paint.Cap.values()[context.getInt(R.styleable.BNCircleProgressBar_nsdk_bn_progress_stroke_cap, 0)] : Paint.Cap.BUTT;
        CircleProgressBar circleProgressBar = this;
        CircleProgressBar circleProgressBar2 = this;
        CircleProgressBar circleProgressBar3 = this;
        circleProgressBar3.mCap = object;
        int n2 = R.styleable.BNCircleProgressBar_nsdk_bn_line_width;
        circleProgressBar2.mLineWidth = context.getDimensionPixelSize(n2, circleProgressBar3.dip2px(circleProgressBar3.getContext(), 4.0f));
        n2 = R.styleable.BNCircleProgressBar_nsdk_bn_progress_text_size;
        circleProgressBar.mProgressTextSize = context.getDimensionPixelSize(n2, circleProgressBar2.dip2px(circleProgressBar2.getContext(), 11.0f));
        n2 = R.styleable.BNCircleProgressBar_nsdk_bn_progress_stroke_width;
        this.mProgressStrokeWidth = context.getDimensionPixelSize(n2, circleProgressBar.dip2px(circleProgressBar.getContext(), 1.0f));
        this.mProgressStartColor = context.getColor(R.styleable.BNCircleProgressBar_nsdk_bn_progress_start_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressEndColor = context.getColor(R.styleable.BNCircleProgressBar_nsdk_bn_progress_end_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressTextColor = context.getColor(R.styleable.BNCircleProgressBar_nsdk_bn_progress_text_color, Color.parseColor((String)COLOR_FFF2A670));
        this.mProgressBackgroundColor = context.getColor(R.styleable.BNCircleProgressBar_nsdk_bn_progress_background_color, Color.parseColor((String)COLOR_FFD3D3D5));
        context.recycle();
    }

    private void initPaint() {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressTextPaint.setTextAlign(Paint.Align.CENTER);
        circleProgressBar.mProgressTextPaint.setTextSize(this.mProgressTextSize);
        Paint paint = circleProgressBar.mProgressPaint;
        Paint.Style style2 = circleProgressBar.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE;
        CircleProgressBar circleProgressBar2 = this;
        paint.setStyle(style2);
        circleProgressBar2.mProgressPaint.setStrokeWidth(this.mProgressStrokeWidth);
        circleProgressBar2.mProgressPaint.setColor(this.mProgressStartColor);
        circleProgressBar2.mProgressPaint.setStrokeCap(this.mCap);
        paint = circleProgressBar2.mBackgroundPaint;
        style2 = circleProgressBar2.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE;
        CircleProgressBar circleProgressBar3 = this;
        paint.setStyle(style2);
        circleProgressBar3.mBackgroundPaint.setStrokeWidth(this.mProgressStrokeWidth);
        circleProgressBar3.mBackgroundPaint.setColor(this.mProgressBackgroundColor);
        circleProgressBar3.mBackgroundPaint.setStrokeCap(this.mCap);
    }

    private void updateProgressShader() {
        if (this.mProgressStartColor != this.mProgressEndColor) {
            LinearGradient linearGradient;
            Object var1_1 = null;
            int n2 = this.mShader;
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 != 2) {
                        linearGradient = var1_1;
                    } else {
                        Matrix matrix;
                        SweepGradient sweepGradient;
                        CircleProgressBar circleProgressBar = this;
                        float f3 = (float)((double)circleProgressBar.mProgressStrokeWidth / Math.PI * 2.0 / (double)this.mRadius);
                        double d3 = -90.0;
                        double d4 = circleProgressBar.mCap == Paint.Cap.BUTT && this.mStyle == 2 ? 0.0 : Math.toDegrees(f3);
                        f3 = (float)(d3 - d4);
                        linearGradient = sweepGradient;
                        CircleProgressBar circleProgressBar2 = this;
                        float f4 = circleProgressBar2.mCenterX;
                        float f5 = circleProgressBar2.mCenterY;
                        int[] nArray = new int[2];
                        Object object = nArray;
                        object[0] = this.mProgressStartColor;
                        nArray[1] = this.mProgressEndColor;
                        float[] fArray = new float[2];
                        float[] fArray2 = fArray;
                        fArray[0] = 0.0f;
                        fArray[1] = 1.0f;
                        sweepGradient = new SweepGradient(f4, f5, object, fArray2);
                        object = matrix;
                        float f6 = f3;
                        CircleProgressBar circleProgressBar3 = this;
                        object();
                        f3 = circleProgressBar3.mCenterX;
                        matrix.postRotate(f6, f3, circleProgressBar3.mCenterY);
                        sweepGradient.setLocalMatrix(matrix);
                    }
                } else {
                    RadialGradient radialGradient;
                    linearGradient = radialGradient;
                    CircleProgressBar circleProgressBar = this;
                    float f7 = circleProgressBar.mCenterX;
                    float f8 = circleProgressBar.mCenterY;
                    float f9 = circleProgressBar.mRadius;
                    int n3 = circleProgressBar.mProgressStartColor;
                    int n4 = circleProgressBar.mProgressEndColor;
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    radialGradient = new RadialGradient(f7, f8, f9, n3, n4, tileMode);
                }
            } else {
                LinearGradient linearGradient2;
                linearGradient = linearGradient2;
                CircleProgressBar circleProgressBar = this;
                RectF rectF = circleProgressBar.mProgressRectF;
                float f10 = rectF.left;
                float f11 = rectF.top;
                float f12 = rectF.bottom;
                int n5 = circleProgressBar.mProgressStartColor;
                int n6 = circleProgressBar.mProgressEndColor;
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                linearGradient2 = new LinearGradient(f10, f11, f10, f12, n5, n6, tileMode);
            }
            this.mProgressPaint.setShader((Shader)linearGradient);
        } else {
            CircleProgressBar circleProgressBar = this;
            circleProgressBar.mProgressPaint.setShader(null);
            circleProgressBar.mProgressPaint.setColor(this.mProgressStartColor);
        }
    }

    private void adjustIndeterminate() {
        Field field = ProgressBar.class.getDeclaredField("mOnlyIndeterminate");
        field.setAccessible(true);
        field.set((Object)this, false);
        Field field2 = ProgressBar.class.getDeclaredField("mIndeterminate");
        field2.setAccessible(true);
        field2.set((Object)this, false);
        Field field3 = ProgressBar.class.getDeclaredField("mCurrentDrawable");
        try {
            field3.setAccessible(true);
            field3.set((Object)this, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
    }

    private void drawProgressText(Canvas object) {
        if (!this.mDrawProgressText) {
            return;
        }
        Canvas canvas = object;
        CircleProgressBar circleProgressBar = this;
        object = String.format(circleProgressBar.mProgressTextFormatPattern, this.getProgress());
        circleProgressBar.mProgressTextPaint.setTextSize(this.mProgressTextSize);
        circleProgressBar.mProgressTextPaint.setColor(this.mProgressTextColor);
        int n2 = ((String)object).length();
        Rect rect = this.mProgressTextRect;
        circleProgressBar.mProgressTextPaint.getTextBounds((String)object, 0, n2, rect);
        float f3 = circleProgressBar.mCenterX;
        float f4 = circleProgressBar.mCenterY + (float)(this.mProgressTextRect.height() / 2);
        rect = circleProgressBar.mProgressTextPaint;
        canvas.drawText((String)object, f3, f4, (Paint)rect);
    }

    private void drawProgress(Canvas canvas) {
        int n2 = this.mStyle;
        if (n2 != 1) {
            if (n2 != 2) {
                this.drawLineProgress(canvas);
            } else {
                this.drawSolidLineProgress(canvas);
            }
        } else {
            this.drawSolidProgress(canvas);
        }
    }

    private void drawLineProgress(Canvas canvas) {
        CircleProgressBar circleProgressBar = this;
        double d3 = circleProgressBar.mLineCount;
        float f3 = (float)(Math.PI * 2 / d3);
        float f4 = circleProgressBar.mRadius;
        float f5 = f4 - this.mLineWidth;
        int n2 = (int)((float)circleProgressBar.getProgress() / (float)this.getMax() * (float)this.mLineCount);
        for (int i3 = 0; i3 < this.mLineCount; ++i3) {
            Paint paint;
            CircleProgressBar circleProgressBar2 = this;
            float f6 = (float)i3 * f3;
            double d4 = f6;
            float f7 = circleProgressBar2.mCenterX + (float)Math.sin(d4) * f5;
            float f8 = circleProgressBar2.mCenterX - (float)Math.cos(d4) * f5;
            float f9 = circleProgressBar2.mCenterX + (float)Math.sin(d4) * f4;
            f6 = circleProgressBar2.mCenterX - (float)Math.cos(d4) * f4;
            if (i3 < n2) {
                paint = this.mProgressPaint;
                canvas.drawLine(f7, f8, f9, f6, paint);
                continue;
            }
            paint = this.mBackgroundPaint;
            canvas.drawLine(f7, f8, f9, f6, paint);
        }
    }

    private void drawSolidProgress(Canvas canvas) {
        Canvas canvas2 = canvas;
        CircleProgressBar circleProgressBar = this;
        Canvas canvas3 = canvas;
        CircleProgressBar circleProgressBar2 = this;
        canvas = circleProgressBar2.mProgressRectF;
        Paint paint = circleProgressBar2.mBackgroundPaint;
        canvas3.drawArc((RectF)canvas, -90.0f, 360.0f, false, paint);
        canvas = circleProgressBar.mProgressRectF;
        float f3 = (float)circleProgressBar.getProgress() * 360.0f / (float)this.getMax();
        paint = circleProgressBar.mProgressPaint;
        canvas2.drawArc((RectF)canvas, -90.0f, f3, true, paint);
    }

    private void drawSolidLineProgress(Canvas canvas) {
        Canvas canvas2 = canvas;
        CircleProgressBar circleProgressBar = this;
        Canvas canvas3 = canvas;
        CircleProgressBar circleProgressBar2 = this;
        canvas = circleProgressBar2.mProgressRectF;
        Paint paint = circleProgressBar2.mBackgroundPaint;
        canvas3.drawArc((RectF)canvas, -90.0f, 360.0f, false, paint);
        canvas = circleProgressBar.mProgressRectF;
        float f3 = (float)circleProgressBar.getProgress() * 360.0f / (float)this.getMax();
        paint = circleProgressBar.mProgressPaint;
        canvas2.drawArc((RectF)canvas, -90.0f, f3, false, paint);
    }

    protected synchronized void onDraw(Canvas canvas) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.drawProgress(canvas);
        circleProgressBar.drawProgressText(canvas);
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        float f3;
        CircleProgressBar circleProgressBar = this;
        super.onSizeChanged(n2, n3, n4, n5);
        float f4 = n2 / 2;
        this.mCenterX = f3 = f4;
        this.mCenterY = f3 = (float)(n3 / 2);
        circleProgressBar.mRadius = f3 = Math.min(f4, f3);
        RectF rectF = circleProgressBar.mProgressRectF;
        float f5 = this.mCenterY;
        rectF.top = f5 - f3;
        rectF.bottom = f5 + f3;
        f5 = this.mCenterX;
        rectF.left = f5 - f3;
        circleProgressBar.mProgressRectF.right = f5 + f3;
        circleProgressBar.updateProgressShader();
        float f6 = this.mProgressStrokeWidth / 2.0f;
        circleProgressBar.mProgressRectF.inset(f6, f6);
    }

    public void setProgressTextFormatPattern(String string2) {
        this.mProgressTextFormatPattern = string2;
        this.invalidate();
    }

    public String getProgressTextFormatPattern() {
        return this.mProgressTextFormatPattern;
    }

    public void setProgressStrokeWidth(float f3) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressStrokeWidth = f3;
        float f4 = f3 / 2.0f;
        circleProgressBar.mProgressRectF.inset(f4, f4);
        circleProgressBar.invalidate();
    }

    public float getProgressStrokeWidth() {
        return this.mProgressStrokeWidth;
    }

    public void setProgressTextSize(float f3) {
        this.mProgressTextSize = f3;
        this.invalidate();
    }

    public float getProgressTextSize() {
        return this.mProgressTextSize;
    }

    public void setProgressStartColor(int n2) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressStartColor = n2;
        circleProgressBar.updateProgressShader();
        circleProgressBar.invalidate();
    }

    public int getProgressStartColor() {
        return this.mProgressStartColor;
    }

    public void setProgressEndColor(int n2) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressEndColor = n2;
        circleProgressBar.updateProgressShader();
        circleProgressBar.invalidate();
    }

    public int getProgressEndColor() {
        return this.mProgressEndColor;
    }

    public void setProgressTextColor(int n2) {
        this.mProgressTextColor = n2;
        this.invalidate();
    }

    public int getProgressTextColor() {
        return this.mProgressTextColor;
    }

    public void setProgressBackgroundColor(int n2) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mProgressBackgroundColor = n2;
        circleProgressBar.mBackgroundPaint.setColor(n2);
        circleProgressBar.invalidate();
    }

    public int getProgressBackgroundColor() {
        return this.mProgressBackgroundColor;
    }

    public int getLineCount() {
        return this.mLineCount;
    }

    public void setLineCount(int n2) {
        this.mLineCount = n2;
        this.invalidate();
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public void setLineWidth(float f3) {
        this.mLineWidth = f3;
        this.invalidate();
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void setStyle(int n2) {
        this.mStyle = n2;
        Paint paint = this.mProgressPaint;
        Paint.Style style2 = n2 == 1 ? Paint.Style.FILL : Paint.Style.STROKE;
        CircleProgressBar circleProgressBar = this;
        paint.setStyle(style2);
        paint = circleProgressBar.mBackgroundPaint;
        style2 = circleProgressBar.mStyle == 1 ? Paint.Style.FILL : Paint.Style.STROKE;
        paint.setStyle(style2);
        this.invalidate();
    }

    public int getShader() {
        return this.mShader;
    }

    public void setShader(int n2) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mShader = n2;
        circleProgressBar.updateProgressShader();
        circleProgressBar.invalidate();
    }

    public Paint.Cap getCap() {
        return this.mCap;
    }

    public void setCap(Paint.Cap cap) {
        CircleProgressBar circleProgressBar = this;
        circleProgressBar.mCap = cap;
        circleProgressBar.mProgressPaint.setStrokeCap(cap);
        circleProgressBar.mBackgroundPaint.setStrokeCap(cap);
        circleProgressBar.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ShaderMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Style {
    }
}

