/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.LinearLayout;
import android.widget.Scroller;
import com.baidu.navisdk.comapi.setting.BNSettingManager;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.function.b;
import com.baidu.navisdk.util.common.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class CustomLinearScrollView
extends LinearLayout {
    private static final String TAG = "CustomLinearScrollView";
    public static final int STATUS_TOP = 0;
    public static final int STATUS_BOTTOM = 1;
    private int mScrollStart;
    private int mScrollEnd;
    private int mLastY;
    private Scroller mScroller;
    private boolean isScrolling;
    private VelocityTracker mVelocityTracker;
    private boolean interruptCurTouchEvent;
    private List<OnStatusChangeListener> mStatusChangeListeners;
    private int bottomHight;
    private int topHight;
    private int status;
    private int button;
    private boolean statusChange;
    private boolean needScroll;
    private boolean hasMoveScroll;
    public boolean mLastEventIsScroll;
    private int mFirstInitStatus;
    private int mTouchSlop;
    private boolean isBreakCallback;
    boolean mIsBeingDragged;
    private EventCatchListener mEventCatchListener;

    public CustomLinearScrollView(Context context) {
        CustomLinearScrollView customLinearScrollView = this;
        customLinearScrollView(context, null);
        customLinearScrollView.initScroller(context);
    }

    public CustomLinearScrollView(Context context, AttributeSet attributeSet) {
        ArrayList arrayList;
        CustomLinearScrollView customLinearScrollView = object;
        super(context, attributeSet);
        Object object = arrayList;
        arrayList = new ArrayList();
        customLinearScrollView.mStatusChangeListeners = object;
        customLinearScrollView.bottomHight = 0;
        customLinearScrollView.status = 0;
        customLinearScrollView.statusChange = false;
        customLinearScrollView.needScroll = true;
        customLinearScrollView.hasMoveScroll = false;
        customLinearScrollView.mLastEventIsScroll = false;
        customLinearScrollView.mFirstInitStatus = 1;
        customLinearScrollView.isBreakCallback = false;
        customLinearScrollView.mIsBeingDragged = false;
        customLinearScrollView.mEventCatchListener = null;
        customLinearScrollView.initScroller(context);
    }

    @TargetApi(value=11)
    public CustomLinearScrollView(Context context, AttributeSet attributeSet, int n2) {
        ArrayList arrayList;
        CustomLinearScrollView customLinearScrollView = object;
        super(context, attributeSet, n2);
        Object object = arrayList;
        arrayList = new ArrayList();
        customLinearScrollView.mStatusChangeListeners = object;
        customLinearScrollView.bottomHight = 0;
        customLinearScrollView.status = 0;
        customLinearScrollView.statusChange = false;
        customLinearScrollView.needScroll = true;
        customLinearScrollView.hasMoveScroll = false;
        customLinearScrollView.mLastEventIsScroll = false;
        customLinearScrollView.mFirstInitStatus = 1;
        customLinearScrollView.isBreakCallback = false;
        customLinearScrollView.mIsBeingDragged = false;
        customLinearScrollView.mEventCatchListener = null;
        customLinearScrollView.initScroller(context);
    }

    private void initScroller(Context context) {
        this.mScroller = new Scroller(context);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    /*
     * WARNING - void declaration
     */
    private boolean gotoTop(boolean bl, boolean bl2) {
        void var2_4;
        if (this.status == 0) {
            LogUtil.e(TAG, "status == STATUS_TOP,return");
            return false;
        }
        if (this.mScroller == null) {
            LogUtil.e(TAG, "mScroller == null,return");
            return false;
        }
        if (this.bottomHight == 0) {
            LogUtil.e(TAG, "bottomHight == 0,return");
            return false;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "gotoTop showAnim:" + bl + " needCallback" + (boolean)var2_4 + " getScrollY\uff1a" + this.getScrollY() + " bottomHight\uff1a" + this.bottomHight);
        }
        if (bl) {
            CustomLinearScrollView customLinearScrollView = this;
            int n2 = customLinearScrollView.getScrollY();
            int n3 = customLinearScrollView.bottomHight;
            customLinearScrollView.startScroll(0, n2, 0, n3);
        } else {
            CustomLinearScrollView customLinearScrollView = this;
            int n4 = customLinearScrollView.getScrollY();
            int n5 = customLinearScrollView.bottomHight;
            customLinearScrollView.startScroll(0, n4, 0, n5, 0);
        }
        CustomLinearScrollView customLinearScrollView = this;
        customLinearScrollView.status = 0;
        customLinearScrollView.statusChange = true;
        customLinearScrollView.isScrolling = true;
        this.isBreakCallback = var2_4 ^ 1;
        this.hasMoveScroll = true;
        this.mLastEventIsScroll = false;
        this.postInvalidate();
        return true;
    }

    private void gotoBottom(boolean n2, boolean bl) {
        if (LogUtil.LOGGABLE) {
            String string2 = TAG;
            StringBuilder stringBuilder = new StringBuilder().append("gotoBottom return : mScroller \uff1a ");
            boolean bl2 = this.mScroller == null;
            LogUtil.e(string2, stringBuilder.append(bl2).append(" bottomHight = ").append(this.bottomHight).toString());
        }
        if (this.mScroller != null && this.bottomHight != 0) {
            int n3;
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "gotoBottom showAnim:" + (n2 != 0) + " needCallback" + bl + ", getScrollY() = " + this.getScrollY());
            }
            if ((n3 = -this.bottomHight - this.getScrollY()) == 0) {
                LogUtil.e(TAG, "gotoBottom retuen : already on the bottom!");
                return;
            }
            if (n2 != 0) {
                CustomLinearScrollView customLinearScrollView = this;
                customLinearScrollView.startScroll(0, customLinearScrollView.getScrollY(), 0, n3);
            } else {
                CustomLinearScrollView customLinearScrollView = this;
                customLinearScrollView.startScroll(0, customLinearScrollView.getScrollY(), 0, n3, 0);
                if (bl && !this.mStatusChangeListeners.isEmpty()) {
                    for (n2 = 0; n2 < this.mStatusChangeListeners.size(); ++n2) {
                        OnStatusChangeListener onStatusChangeListener = this.mStatusChangeListeners.get(n2);
                        onStatusChangeListener.onStatusChange(1);
                        onStatusChangeListener.onProgressChange(100);
                    }
                }
            }
            CustomLinearScrollView customLinearScrollView = this;
            customLinearScrollView.status = 1;
            customLinearScrollView.interruptCurTouchEvent = true;
            customLinearScrollView.statusChange = true;
            customLinearScrollView.isScrolling = true;
            this.isBreakCallback = bl ^ true;
            this.hasMoveScroll = true;
            this.mLastEventIsScroll = false;
            this.postInvalidate();
            return;
        }
        LogUtil.e(TAG, "mScroller == null ");
    }

    private void startScroll(int n2, int n3, int n4, int n5) {
        CustomLinearScrollView customLinearScrollView = customLinearScrollView.mScroller;
        if (customLinearScrollView != null) {
            customLinearScrollView.startScroll(n2, n3, n4, n5);
        }
    }

    private void startScroll(int n2, int n3, int n4, int n5, int n6) {
        CustomLinearScrollView customLinearScrollView = customLinearScrollView.mScroller;
        if (customLinearScrollView != null) {
            customLinearScrollView.startScroll(n2, n3, n4, n5, n6);
        }
    }

    private int getVelocity() {
        CustomLinearScrollView customLinearScrollView = this;
        customLinearScrollView.mVelocityTracker.computeCurrentVelocity(1000);
        return (int)customLinearScrollView.mVelocityTracker.getYVelocity();
    }

    private void recycleVelocity() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void obtainVelocity(MotionEvent motionEvent) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        CustomLinearScrollView customLinearScrollView = this;
        super.onLayout(bl, n2, n3, n4, n5);
        if (customLinearScrollView.bottomHight == 0) {
            try {
                CustomLinearScrollView customLinearScrollView2 = this;
                customLinearScrollView2.bottomHight = customLinearScrollView2.findViewById(R.id.sub_scroll_layout).getHeight();
                View view = customLinearScrollView2.findViewById(R.id.sub_fade_layer);
                this.button = view != null ? view.getHeight() : 0;
                this.topHight = this.getHeight() - this.button;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.mFirstInitStatus == 1) {
                this.gotoBottom(false, true);
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e("CustomLinearScrollView: onLayout", " bottomHight:" + this.bottomHight + " button:" + this.button + "topHight: " + this.topHight);
            }
        }
    }

    public void setScrollSupport(boolean bl) {
        LogUtil.e(TAG, "setScrollSupport needScroll:" + bl);
        this.needScroll = bl;
    }

    public void setInitScrollStatus(int n2) {
        this.mFirstInitStatus = n2;
    }

    public boolean gotoTop() {
        if (b.F.a() && BNSettingManager.isBottomBarOpen()) {
            return this.gotoTop(true, true);
        }
        return false;
    }

    public boolean gotoTopWithOutAnim() {
        if (b.F.a() && BNSettingManager.isBottomBarOpen()) {
            return this.gotoTop(false, true);
        }
        return false;
    }

    public void gotoBottom() {
        if (b.F.a() && BNSettingManager.isBottomBarOpen()) {
            this.gotoBottom(true, true);
            return;
        }
    }

    public void gotoBottomWithOutAnim() {
        this.gotoBottom(false, true);
    }

    public int getCurStatus() {
        if (this.bottomHight == 0) {
            return this.mFirstInitStatus;
        }
        return this.status;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (b.F.a() && BNSettingManager.isBottomBarOpen()) {
            if (!this.needScroll) {
                return super.onInterceptTouchEvent(motionEvent);
            }
            int n2 = motionEvent.getAction();
            if (n2 == 2 && this.mIsBeingDragged) {
                return true;
            }
            if ((n2 &= 0xFF) != 0) {
                if (n2 == 2 && Math.abs((int)motionEvent.getY() - this.mLastY) > this.mTouchSlop) {
                    this.mIsBeingDragged = true;
                    return true;
                }
            } else {
                this.mLastY = (int)motionEvent.getY();
                this.mScrollStart = n2 = this.getScrollY();
                this.status = n2 < -this.bottomHight / 2 ? 1 : 0;
            }
            return super.onInterceptTouchEvent(motionEvent);
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (b.F.a() && BNSettingManager.isBottomBarOpen()) {
            if (!this.needScroll) {
                return super.onTouchEvent(motionEvent);
            }
            if (this.isScrolling) {
                super.onTouchEvent(motionEvent);
                return true;
            }
            if (this.interruptCurTouchEvent) {
                return true;
            }
            MotionEvent motionEvent2 = motionEvent;
            motionEvent2.getX();
            int n2 = (int)motionEvent2.getY();
            int n3 = motionEvent2.getAction();
            this.obtainVelocity(motionEvent);
            switch (n3) {
                default: {
                    break;
                }
                case 2: {
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    CustomLinearScrollView customLinearScrollView = this;
                    int n4 = customLinearScrollView.mLastY - n2;
                    int n5 = customLinearScrollView.getScrollY();
                    int n6 = (int)((float)n5 / (float)this.bottomHight * 100.0f);
                    if (!customLinearScrollView.mStatusChangeListeners.isEmpty()) {
                        for (int i3 = 0; i3 < this.mStatusChangeListeners.size(); ++i3) {
                            this.mStatusChangeListeners.get(i3).onProgressChange(Math.abs(n6));
                        }
                    }
                    if (n4 > 0 && n4 + n5 > 0) {
                        LogUtil.e(TAG, "onTouchEvent ACTION_MOVE break move1 dy:" + n4 + " scrollY:" + n5);
                        break;
                    }
                    if (-(n5 + n4) > this.bottomHight) {
                        LogUtil.e(TAG, "onTouchEvent ACTION_MOVE break move2 " + n4 + "  " + n5);
                        break;
                    }
                    this.scrollBy(0, n4);
                    this.mLastY = n2;
                    break;
                }
                case 1: 
                case 3: {
                    int n7;
                    if (!this.mIsBeingDragged) break;
                    CustomLinearScrollView customLinearScrollView = this;
                    customLinearScrollView.mIsBeingDragged = false;
                    this.mScrollEnd = n7 = customLinearScrollView.getScrollY();
                    LogUtil.e(TAG, "onTouchEvent ACTION_UP " + this.mScrollEnd + "  " + this.mScrollStart + "  " + (n7 -= this.mScrollStart));
                    if (customLinearScrollView.status == 0) {
                        if (-(this.mScrollEnd - this.mScrollStart) > this.bottomHight / 3) {
                            CustomLinearScrollView customLinearScrollView2 = this;
                            n2 = customLinearScrollView2.getScrollY();
                            n7 = -(customLinearScrollView2.bottomHight + n7);
                            customLinearScrollView2.startScroll(0, n2, 0, n7);
                            LogUtil.e(TAG, "onTouchEvent ACTION_UP 1");
                            customLinearScrollView2.status = 1;
                            customLinearScrollView2.statusChange = true;
                            customLinearScrollView2.hasMoveScroll = true;
                        } else {
                            int n8 = n7;
                            n7 = this.getScrollY();
                            n2 = -n8;
                            this.startScroll(0, n7, 0, n2);
                            this.hasMoveScroll = true;
                            LogUtil.e(TAG, "onTouchEvent ACTION_UP 2");
                        }
                    } else if (this.mScrollEnd - this.mScrollStart > (this.topHight - this.bottomHight) / 3) {
                        CustomLinearScrollView customLinearScrollView3 = this;
                        customLinearScrollView3.status = 0;
                        customLinearScrollView3.statusChange = true;
                        customLinearScrollView3.hasMoveScroll = true;
                        n2 = customLinearScrollView3.getScrollY();
                        n7 = customLinearScrollView3.bottomHight - n7;
                        customLinearScrollView3.startScroll(0, n2, 0, n7);
                        LogUtil.e(TAG, "onTouchEvent ACTION_UP 3");
                    } else {
                        int n9 = n7;
                        n7 = this.getScrollY();
                        n2 = -n9;
                        this.startScroll(0, n7, 0, n2);
                        this.hasMoveScroll = true;
                        LogUtil.e(TAG, "onTouchEvent ACTION_UP 4");
                    }
                    CustomLinearScrollView customLinearScrollView4 = this;
                    customLinearScrollView4.isScrolling = true;
                    customLinearScrollView4.mLastEventIsScroll = true;
                    customLinearScrollView4.postInvalidate();
                    customLinearScrollView4.recycleVelocity();
                    break;
                }
                case 0: {
                    if (this.status == 1) {
                        if (n2 < this.bottomHight + this.button) {
                            LogUtil.e(TAG, "onTouchEvent ACTION_DOWN return status_bottom getY:" + n2);
                            return false;
                        }
                    } else if (n2 < this.button) {
                        LogUtil.e(TAG, "onTouchEvent ACTION_DOWN return status_top getY:" + n2);
                        return false;
                    }
                    LogUtil.e(TAG, "onTouchEvent ACTION_DOWN status " + this.status + "  " + this.mScrollStart + "  ");
                    this.mIsBeingDragged = true;
                    this.mLastY = n2;
                }
            }
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void computeScroll() {
        CustomLinearScrollView customLinearScrollView = this;
        super.computeScroll();
        if (customLinearScrollView.mScroller.computeScrollOffset()) {
            CustomLinearScrollView customLinearScrollView2 = this;
            customLinearScrollView2.scrollTo(0, customLinearScrollView2.mScroller.getCurrY());
            customLinearScrollView2.invalidate();
        } else {
            LogUtil.e(TAG, "computeScroll statusChange :" + this.statusChange);
            if (this.statusChange) {
                if (this.getScrollY() < -this.bottomHight / 2) {
                    if (!this.mStatusChangeListeners.isEmpty() && !this.isBreakCallback) {
                        for (int i3 = 0; i3 < this.mStatusChangeListeners.size(); ++i3) {
                            OnStatusChangeListener onStatusChangeListener = this.mStatusChangeListeners.get(i3);
                            onStatusChangeListener.onStatusChange(1);
                            onStatusChangeListener.onProgressChange(100);
                        }
                    }
                    this.status = 1;
                    LogUtil.e(TAG, "STATUS_BOTTOM");
                } else {
                    if (!this.mStatusChangeListeners.isEmpty() && !this.isBreakCallback) {
                        for (int i4 = 0; i4 < this.mStatusChangeListeners.size(); ++i4) {
                            OnStatusChangeListener onStatusChangeListener = this.mStatusChangeListeners.get(i4);
                            onStatusChangeListener.onStatusChange(0);
                            onStatusChangeListener.onProgressChange(0);
                        }
                    }
                    this.status = 0;
                    LogUtil.e(TAG, "STATUS_TOP");
                }
                this.statusChange = false;
            } else if (!this.mIsBeingDragged) {
                if (this.getScrollY() < -this.bottomHight / 2) {
                    if (!this.mStatusChangeListeners.isEmpty() && !this.isBreakCallback) {
                        for (int i5 = 0; i5 < this.mStatusChangeListeners.size(); ++i5) {
                            CustomLinearScrollView customLinearScrollView3 = this;
                            OnStatusChangeListener onStatusChangeListener = customLinearScrollView3.mStatusChangeListeners.get(i5);
                            if (customLinearScrollView3.status != 1) {
                                LogUtil.e(TAG, "statusChange STATUS_BOTTOM");
                                onStatusChangeListener.onStatusChange(1);
                            }
                            onStatusChangeListener.onProgressChange(100);
                        }
                    }
                    this.status = 1;
                    LogUtil.e(TAG, "STATUS_BOTTOM");
                } else {
                    if (!this.mStatusChangeListeners.isEmpty() && !this.isBreakCallback) {
                        for (int i6 = 0; i6 < this.mStatusChangeListeners.size(); ++i6) {
                            CustomLinearScrollView customLinearScrollView4 = this;
                            OnStatusChangeListener onStatusChangeListener = customLinearScrollView4.mStatusChangeListeners.get(i6);
                            if (customLinearScrollView4.status != 0) {
                                LogUtil.e(TAG, "statusChange STATUS_TOP");
                                onStatusChangeListener.onStatusChange(0);
                            }
                            onStatusChangeListener.onProgressChange(0);
                        }
                    }
                    this.status = 0;
                    LogUtil.e(TAG, "STATUS_TOP");
                }
            }
            this.isScrolling = false;
            if (this.hasMoveScroll) {
                if (this.status == 1) {
                    CustomLinearScrollView customLinearScrollView5 = this;
                    customLinearScrollView5.scrollTo(0, -customLinearScrollView5.bottomHight);
                } else {
                    this.scrollTo(0, 0);
                }
                this.hasMoveScroll = false;
            }
            this.isBreakCallback = false;
        }
    }

    public boolean onInterceptHoverEvent(MotionEvent motionEvent) {
        return this.mIsBeingDragged;
    }

    public void addOnStatusChangeListener(OnStatusChangeListener onStatusChangeListener) {
        if (!this.mStatusChangeListeners.contains(onStatusChangeListener)) {
            this.mStatusChangeListeners.add(onStatusChangeListener);
        }
    }

    public void removeOnStatusChangeListener(OnStatusChangeListener onStatusChangeListener) {
        if (this.mStatusChangeListeners.contains(onStatusChangeListener)) {
            this.mStatusChangeListeners.remove(onStatusChangeListener);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        EventCatchListener eventCatchListener;
        if (motionEvent.getAction() == 0) {
            this.interruptCurTouchEvent = false;
        }
        if ((eventCatchListener = this.mEventCatchListener) != null) {
            eventCatchListener.onEventCatch(motionEvent);
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public void setOnEventCatchListener(EventCatchListener eventCatchListener) {
        this.mEventCatchListener = eventCatchListener;
    }

    public boolean isScrolling() {
        return this.isScrolling;
    }

    public static interface EventCatchListener {
        public void onEventCatch(MotionEvent var1);
    }

    public static interface OnStatusChangeListener {
        public void onStatusChange(int var1);

        public void onProgressChange(int var1);
    }
}

