/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class MatrixImageView
extends ImageView {
    private static final String TAG = "MatrixImageView";
    private GestureDetector mGestureDetector;
    private Matrix mMatrix;
    public float mImageWidth;
    public float mImageHeight;

    public MatrixImageView(Context context, AttributeSet attributeSet) {
        MatrixImageView matrixImageView = this;
        super(context, attributeSet);
        matrixImageView.mMatrix = new Matrix();
        matrixImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
    }

    public void setImageBitmap(Bitmap bitmap) {
        MatrixImageView matrixImageView = object;
        super.setImageBitmap(bitmap);
        matrixImageView.mMatrix.set(object.getImageMatrix());
        Object object = new float[9];
        matrixImageView.mMatrix.getValues((float[])object);
        matrixImageView.mImageWidth /= object[0];
        matrixImageView.mImageHeight = (matrixImageView.mImageHeight - object[5] * 2.0f) / object[4];
    }

    public void start(float f3, float f4, float f5) {
        GestureListener gestureListener;
        GestureDetector gestureDetector;
        MatrixTouchListener matrixTouchListener;
        MatrixTouchListener matrixTouchListener2 = matrixTouchListener;
        (MatrixImageView)this.new MatrixTouchListener().mMaxScale = f3;
        (MatrixImageView)this.new MatrixTouchListener().mDobleClickScale = f5;
        (MatrixImageView)this.new MatrixTouchListener().mMinScale = f4;
        this.setOnTouchListener(matrixTouchListener2);
        GestureDetector gestureDetector2 = gestureDetector;
        Context context = this.getContext();
        GestureListener gestureListener2 = gestureListener;
        gestureListener = new GestureListener(matrixTouchListener2);
        gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)gestureListener2);
        this.mGestureDetector = gestureDetector2;
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final MatrixTouchListener listener;

        public GestureListener(MatrixTouchListener matrixTouchListener) {
            this.listener = matrixTouchListener;
        }

        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }

        public boolean onDoubleTap(MotionEvent motionEvent) {
            return true;
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return super.onSingleTapUp(motionEvent);
        }

        public void onLongPress(MotionEvent motionEvent) {
            super.onLongPress(motionEvent);
        }

        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f3, float f4) {
            return super.onScroll(motionEvent, motionEvent2, f3, f4);
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f3, float f4) {
            return super.onFling(motionEvent, motionEvent2, f3, f4);
        }

        public void onShowPress(MotionEvent motionEvent) {
            super.onShowPress(motionEvent);
        }

        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            return super.onDoubleTapEvent(motionEvent);
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            return super.onSingleTapConfirmed(motionEvent);
        }
    }

    public class MatrixTouchListener
    implements View.OnTouchListener {
        private static final int MODE_DRAG = 1;
        private static final int MODE_ZOOM = 2;
        private static final int MODE_UNABLE = 3;
        float mMaxScale = 6.0f;
        float mDobleClickScale = 2.0f;
        float mMinScale = 1.0f;
        private int mMode = 0;
        private float mStartDis;
        private Matrix mCurrentMatrix;
        private PointF startPoint;

        public MatrixTouchListener() {
            PointF pointF;
            Matrix matrix;
            MatrixTouchListener matrixTouchListener = matrix;
            matrix = new Matrix();
            v1.mCurrentMatrix = matrixTouchListener;
            matrixTouchListener = pointF;
            pointF = new PointF();
            v1.startPoint = matrixTouchListener;
        }

        private boolean isZoomChanged() {
            float[] fArray = new float[9];
            MatrixImageView.this.getImageMatrix().getValues(fArray);
            float f3 = fArray[0];
            MatrixImageView.this.mMatrix.getValues(fArray);
            return f3 != fArray[0];
        }

        private float checkDyBound(float[] fArray, float f3) {
            float f4;
            MatrixTouchListener matrixTouchListener = this;
            float f5 = matrixTouchListener.MatrixImageView.this.getHeight();
            float f6 = matrixTouchListener.MatrixImageView.this.mImageHeight;
            if (f4 * fArray[4] < f5) {
                return 0.0f;
            }
            if (fArray[5] + f3 > 0.0f) {
                f3 = -fArray[5];
            } else if (fArray[5] + f3 < -(f6 * fArray[4] - f5)) {
                f3 = -(f6 * fArray[4] - f5) - fArray[5];
            }
            return f3;
        }

        private float checkDxBound(float[] fArray, float f3) {
            float f4;
            MatrixTouchListener matrixTouchListener = this;
            float f5 = matrixTouchListener.MatrixImageView.this.getWidth();
            float f6 = matrixTouchListener.MatrixImageView.this.mImageWidth;
            if (f4 * fArray[0] < f5) {
                return 0.0f;
            }
            if (fArray[2] + f3 > 0.0f) {
                f3 = -fArray[2];
            } else if (fArray[2] + f3 < -(f6 * fArray[0] - f5)) {
                f3 = -(f6 * fArray[0] - f5) - fArray[2];
            }
            return f3;
        }

        private void setZoomMatrix(MotionEvent motionEvent) {
            float f3;
            if (motionEvent.getPointerCount() < 2) {
                return;
            }
            float f4 = this.distance(motionEvent);
            if (f3 > 10.0f) {
                MatrixTouchListener matrixTouchListener = this;
                float f5 = f4;
                f4 = f5 / this.mStartDis;
                matrixTouchListener.mStartDis = f5;
                MatrixTouchListener matrixTouchListener2 = this;
                matrixTouchListener2.mCurrentMatrix.set(MatrixImageView.this.getImageMatrix());
                float[] fArray = new float[9];
                matrixTouchListener2.mCurrentMatrix.getValues(fArray);
                matrixTouchListener.checkMaxScale(f4, fArray);
                matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
                matrixTouchListener.center(true, true);
            }
        }

        private float checkMaxScale(float f3, float[] fArray) {
            float f4;
            float f5 = this.mMaxScale;
            if (f3 * fArray[0] > f4) {
                f3 = f5 / fArray[0];
            } else {
                float f6;
                f5 = this.mMinScale;
                if (f3 * fArray[0] < f6) {
                    float f7 = f5 / fArray[0];
                    float f8 = f5;
                    this.mCurrentMatrix.setScale(f8, f8);
                    return f7;
                }
            }
            MatrixTouchListener matrixTouchListener = this;
            float f9 = matrixTouchListener.MatrixImageView.this.getWidth() / 2;
            float f10 = matrixTouchListener.MatrixImageView.this.getHeight() / 2;
            this.mCurrentMatrix.postScale(f3, f3, f9, f10);
            return f3;
        }

        private void reSetMatrix() {
            if (this.checkRest()) {
                MatrixTouchListener matrixTouchListener = this;
                matrixTouchListener.mCurrentMatrix.set(MatrixImageView.this.mMatrix);
                matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
            }
        }

        private boolean checkRest() {
            float[] fArray = new float[9];
            MatrixImageView.this.getImageMatrix().getValues(fArray);
            float f3 = fArray[0];
            MatrixImageView.this.mMatrix.getValues(fArray);
            return f3 < fArray[0];
        }

        private void isMatrixEnable() {
            if (MatrixImageView.this.getScaleType() != ImageView.ScaleType.CENTER) {
                MatrixImageView.this.setScaleType(ImageView.ScaleType.MATRIX);
            } else {
                this.mMode = 3;
            }
        }

        private float distance(MotionEvent motionEvent) {
            float f3;
            float f4 = motionEvent.getX(1) - motionEvent.getX(0);
            float f5 = f3 = motionEvent.getY(1) - motionEvent.getY(0);
            return (float)Math.sqrt(f4 * f4 + f5 * f5);
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            switch (motionEvent.getActionMasked()) {
                default: {
                    break;
                }
                case 5: {
                    if (this.mMode == 3) {
                        return true;
                    }
                    this.mMode = 2;
                    this.mStartDis = this.distance(motionEvent);
                    break;
                }
                case 2: {
                    int n2 = this.mMode;
                    if (n2 == 2) {
                        this.setZoomMatrix(motionEvent);
                        break;
                    }
                    if (n2 != 1) break;
                    this.setDragMatrix(motionEvent);
                    break;
                }
                case 1: 
                case 3: {
                    this.reSetMatrix();
                    break;
                }
                case 0: {
                    MatrixTouchListener matrixTouchListener = this;
                    matrixTouchListener.mMode = 1;
                    MotionEvent motionEvent2 = motionEvent;
                    float f3 = motionEvent2.getX();
                    matrixTouchListener.startPoint.set(f3, motionEvent2.getY());
                    matrixTouchListener.isMatrixEnable();
                }
            }
            return MatrixImageView.this.mGestureDetector.onTouchEvent(motionEvent);
        }

        protected void center(boolean bl, boolean bl2) {
            RectF rectF;
            RectF rectF2;
            Matrix matrix;
            Matrix matrix2 = matrix;
            matrix2();
            matrix.set(this.mCurrentMatrix);
            RectF rectF3 = rectF2 = rectF;
            MatrixImageView matrixImageView = MatrixImageView.this;
            float f3 = matrixImageView.mImageWidth;
            float f4 = matrixImageView.mImageHeight;
            rectF3(0.0f, 0.0f, f3, f4);
            matrix2.mapRect(rectF3);
            f3 = rectF.height();
            f4 = rectF.width();
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (bl2) {
                float f7;
                float f8 = MatrixImageView.this.getHeight();
                if (f3 < f7) {
                    f6 = (f8 - f3) / 2.0f - rectF2.top;
                } else {
                    float f9;
                    f3 = rectF2.top;
                    if (f9 > 0.0f) {
                        f6 = -f3;
                    } else {
                        float f10;
                        f3 = rectF2.bottom;
                        if (f10 < f8) {
                            f6 = f8 - f3;
                        }
                    }
                }
            }
            if (bl) {
                float f11;
                float f12 = MatrixImageView.this.getWidth();
                if (f4 < f11) {
                    f5 = (f12 - f4) / 2.0f - rectF2.left;
                } else {
                    float f13;
                    f3 = rectF2.left;
                    if (f13 > 0.0f) {
                        f5 = -f3;
                    } else {
                        float f14;
                        f3 = rectF2.right;
                        if (f14 < f12) {
                            f5 = f12 - f3;
                        }
                    }
                }
            }
            MatrixTouchListener matrixTouchListener = this;
            matrixTouchListener.mCurrentMatrix.postTranslate(f5, f6);
            matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
        }

        public void setDragMatrix(MotionEvent motionEvent) {
            if (this.isZoomChanged()) {
                float f3;
                float f4;
                float f5 = motionEvent.getX() - this.startPoint.x;
                float f6 = f4 = motionEvent.getY() - this.startPoint.y;
                if (Math.sqrt(f3 * f3 + f6 * f6) > 10.0) {
                    MatrixTouchListener matrixTouchListener = this;
                    MotionEvent motionEvent2 = motionEvent;
                    float f7 = motionEvent2.getX();
                    matrixTouchListener.startPoint.set(f7, motionEvent2.getY());
                    matrixTouchListener.mCurrentMatrix.set(MatrixImageView.this.getImageMatrix());
                    float[] fArray = new float[9];
                    this.mCurrentMatrix.getValues(fArray);
                    f5 = matrixTouchListener.checkDxBound(fArray, f5);
                    float f8 = matrixTouchListener.checkDyBound(fArray, f4);
                    matrixTouchListener.mCurrentMatrix.postTranslate(f5, f8);
                    matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
                }
            }
        }

        public void onDoubleClick() {
            float f3 = this.isZoomChanged() ? 1.0f : this.mDobleClickScale;
            MatrixTouchListener matrixTouchListener = this;
            matrixTouchListener.mCurrentMatrix.set(MatrixImageView.this.mMatrix);
            MatrixTouchListener matrixTouchListener2 = this;
            float f4 = matrixTouchListener2.MatrixImageView.this.getWidth() / 2;
            float f5 = matrixTouchListener2.MatrixImageView.this.getHeight() / 2;
            matrixTouchListener.mCurrentMatrix.postScale(f3, f3, f4, f5);
            matrixTouchListener.MatrixImageView.this.setImageMatrix(this.mCurrentMatrix);
        }
    }
}

