/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.util.jar.JarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NavMultiSeekBar
extends View {
    private static final int mTrackHeight = JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_2dp);
    private AccessibilityNodeProvider mAccessibilityNodeProvider;
    private OnThumbValueChangeListener mOnThumbValueChangeListener;
    int mMinWidth;
    int mMaxWidth;
    int mMinHeight;
    int mMaxHeight;
    private int mScaleMin;
    private int mScaleMax;
    private int mStep;
    private int mStepsThumbsApart;
    private boolean mDrawThumbsApart;
    private Drawable mTrack;
    boolean mMirrorForRtl;
    private final LinkedList<Thumb> mThumbs;
    private int mKeyProgressIncrement;
    private int mScaledTouchSlop;
    private float mTouchDownX;
    private final List<Thumb> mDraggingThumbs;
    LinkedList<Thumb> exactTouched;
    private Drawable defThumbDrawable;
    private int defThumbColor;
    private Drawable defRangeDrawable;
    private int defRangeColor;
    private final TypedArray a;

    public NavMultiSeekBar(Context context) {
        this(context, null);
    }

    public NavMultiSeekBar(Context context, AttributeSet attributeSet) {
        int n2 = R.attr.nsdk_multiSeekBarStyle;
        this(context, attributeSet, n2);
    }

    public NavMultiSeekBar(Context context, AttributeSet attributeSet, int n2) {
        this(context, attributeSet, n2, 0);
    }

    public NavMultiSeekBar(Context context, AttributeSet attributeSet, int n2, int n3) {
        NavMultiSeekBar navMultiSeekBar = this;
        super(context, attributeSet, n2);
        this.mMirrorForRtl = true;
        this.mThumbs = new LinkedList();
        this.mKeyProgressIncrement = 1;
        this.mDraggingThumbs = new LinkedList<Thumb>();
        this.exactTouched = null;
        this.defThumbColor = 0;
        this.defRangeColor = 0;
        this.a = context.obtainStyledAttributes(attributeSet, R.styleable.NavMultiSeekBar, n2, n3);
        navMultiSeekBar.initMultiSlider(this.a.getInt(R.styleable.NavMultiSeekBar_nsdk_thumbNumber, 2));
        attributeSet = navMultiSeekBar.a.getDrawable(R.styleable.NavMultiSeekBar_android_track);
        if (attributeSet == null) {
            attributeSet = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.bnav_common_seekbar_track_bg);
        }
        NavMultiSeekBar navMultiSeekBar2 = this;
        navMultiSeekBar2.setTrackDrawable(navMultiSeekBar2.getTintedDrawable((Drawable)attributeSet, this.a.getColor(R.styleable.NavMultiSeekBar_nsdk_trackColor, 0)));
        int n4 = R.styleable.NavMultiSeekBar_nsdk_scaleStep;
        navMultiSeekBar2.setStep(navMultiSeekBar2.a.getInt(n4, this.mStep));
        n4 = R.styleable.NavMultiSeekBar_nsdk_stepsThumbsApart;
        navMultiSeekBar2.setStepsThumbsApart(navMultiSeekBar2.a.getInt(n4, this.mStepsThumbsApart));
        n4 = R.styleable.NavMultiSeekBar_nsdk_drawThumbsApart;
        navMultiSeekBar2.setDrawThumbsApart(navMultiSeekBar2.a.getBoolean(n4, this.mDrawThumbsApart));
        n4 = R.styleable.NavMultiSeekBar_nsdk_scaleMax;
        navMultiSeekBar2.setMax(navMultiSeekBar2.a.getInt(n4, this.mScaleMax), true);
        n4 = R.styleable.NavMultiSeekBar_nsdk_scaleMin;
        navMultiSeekBar2.setMin(navMultiSeekBar2.a.getInt(n4, this.mScaleMin), true);
        n4 = R.styleable.NavMultiSeekBar_nsdk_mirrorForRTL;
        navMultiSeekBar2.mMirrorForRtl = navMultiSeekBar2.a.getBoolean(n4, this.mMirrorForRtl);
        this.defThumbDrawable = navMultiSeekBar2.a.getDrawable(R.styleable.NavMultiSeekBar_android_thumb);
        if (this.defThumbDrawable == null) {
            this.defThumbDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.nsdk_drawable_seekbar_thumb);
        }
        if ((this.defRangeDrawable = this.a.getDrawable(R.styleable.NavMultiSeekBar_nsdk_range)) == null) {
            this.defRangeDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.bnav_common_seekbar_track_bg);
        }
        Context context2 = context;
        NavMultiSeekBar navMultiSeekBar3 = this;
        context = navMultiSeekBar3.a.getDrawable(R.styleable.NavMultiSeekBar_nsdk_range1);
        Drawable drawable2 = navMultiSeekBar3.a.getDrawable(R.styleable.NavMultiSeekBar_nsdk_range2);
        navMultiSeekBar3.defRangeColor = navMultiSeekBar3.a.getColor(R.styleable.NavMultiSeekBar_nsdk_rangeColor, 0);
        navMultiSeekBar3.defThumbColor = navMultiSeekBar3.a.getColor(R.styleable.NavMultiSeekBar_nsdk_thumbColor, 0);
        Drawable drawable3 = navMultiSeekBar3.defThumbDrawable;
        navMultiSeekBar3.setThumbDrawables(drawable3, navMultiSeekBar3.defRangeDrawable, (Drawable)context, drawable2);
        navMultiSeekBar3.setThumbOffset(navMultiSeekBar3.a.getDimensionPixelOffset(R.styleable.NavMultiSeekBar_android_thumbOffset, this.defThumbDrawable.getIntrinsicWidth() / 2));
        navMultiSeekBar3.repositionThumbs();
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context2).getScaledTouchSlop();
        this.a.recycle();
    }

    private void initMultiSlider(int n2) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.mStep = 1;
        navMultiSeekBar.mStepsThumbsApart = 0;
        navMultiSeekBar.mDrawThumbsApart = false;
        navMultiSeekBar.mScaleMin = 0;
        navMultiSeekBar.mScaleMax = 100;
        navMultiSeekBar.mMinWidth = 24;
        navMultiSeekBar.mMaxWidth = 48;
        navMultiSeekBar.mMinHeight = 24;
        navMultiSeekBar.mMaxHeight = 48;
        for (int i3 = 0; i3 < n2; ++i3) {
            this.mThumbs.add(new Thumb(this).setMin(this.mScaleMin).setMax(this.mScaleMax).setTag("thumb " + i3));
        }
    }

    private int optThumbValue(Thumb thumb, int n2) {
        if (thumb != null && thumb.getThumb() != null) {
            int n3;
            NavMultiSeekBar navMultiSeekBar = this;
            int n4 = navMultiSeekBar.mThumbs.indexOf(thumb);
            int n5 = n4 + 1;
            if (navMultiSeekBar.mThumbs.size() > n5 && n2 > this.mThumbs.get(n5).getValue() - this.mStepsThumbsApart * this.mStep) {
                n2 = this.mThumbs.get(n5).getValue() - this.mStepsThumbsApart * this.mStep;
            }
            if (n4 > 0 && n2 < this.mThumbs.get(--n4).getValue() + this.mStepsThumbsApart * this.mStep) {
                n2 = this.mThumbs.get(n4).getValue() + this.mStepsThumbsApart * this.mStep;
            }
            if ((n2 - (n4 = this.mScaleMin)) % (n3 = this.mStep) != 0) {
                n2 += n3 - (n2 - n4) % n3;
            }
            if (n2 < thumb.getMin()) {
                n2 = thumb.getMin();
            }
            if (n2 > thumb.getMax()) {
                n2 = thumb.getMax();
            }
            return n2;
        }
        return n2;
    }

    private synchronized void setThumbValue(Thumb thumb, int n2, boolean bl) {
        if (thumb != null && thumb.getThumb() != null) {
            if ((n2 = this.optThumbValue(thumb, n2)) != thumb.getValue()) {
                thumb.value = n2;
            }
            if (this.hasOnThumbValueChangeListener()) {
                n2 = this.mThumbs.indexOf(thumb);
                int n3 = thumb.getValue();
                this.mOnThumbValueChangeListener.onValueChanged(this, thumb, n2, n3);
            }
            NavMultiSeekBar navMultiSeekBar = this;
            int n3 = navMultiSeekBar.getWidth() - JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_25dp) * 2;
            this.updateThumb(thumb, n3, navMultiSeekBar.getHeight());
            return;
        }
    }

    private synchronized void setThumbValue(int n2, int n3, boolean bl) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.setThumbValue(navMultiSeekBar.mThumbs.get(n2), n3, bl);
    }

    private void updateTrackBounds(int n2, int n3) {
        n2 -= this.getPaddingRight() + this.getPaddingLeft();
        int n4 = n3 - (this.getPaddingTop() + this.getPaddingBottom());
        Drawable drawable2 = this.mTrack;
        if (drawable2 != null) {
            int n5 = n4 / 2;
            n4 = mTrackHeight;
            int n6 = n5 - n4;
            n4 = n5 + n4;
            drawable2.setBounds(0, n6, n2, n4);
        }
    }

    private void updateTrackState() {
        NavMultiSeekBar navMultiSeekBar = this;
        int[] nArray = navMultiSeekBar.getDrawableState();
        Drawable drawable2 = navMultiSeekBar.mTrack;
        if (drawable2 != null && drawable2.isStateful()) {
            this.mTrack.setState(nArray);
        }
    }

    private void setThumbDrawables(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        if (drawable2 == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (Thumb thumb : this.mThumbs) {
            Drawable drawable6;
            int n4;
            ++n2;
            if (thumb.getThumb() != null && drawable2 != thumb.getThumb()) {
                thumb.getThumb().setCallback(null);
            }
            if (n2 == 1 && drawable4 != null) {
                n4 = this.a.getColor(R.styleable.NavMultiSeekBar_nsdk_range1Color, 0);
                drawable6 = drawable4;
            } else if (n2 == 2 && drawable5 != null) {
                n4 = this.a.getColor(R.styleable.NavMultiSeekBar_nsdk_range2Color, 0);
                drawable6 = drawable5;
            } else {
                n4 = this.defRangeColor;
                drawable6 = drawable3;
            }
            NavMultiSeekBar navMultiSeekBar = this;
            navMultiSeekBar.setRangeDrawable(thumb, drawable6, n4);
            this.setThumbDrawable(thumb, drawable2, navMultiSeekBar.defThumbColor);
            n3 = Math.max(n3, thumb.getThumbOffset());
        }
        NavMultiSeekBar navMultiSeekBar = this;
        int n5 = navMultiSeekBar.getPaddingTop();
        int n6 = navMultiSeekBar.getPaddingBottom();
        navMultiSeekBar.setPadding(n3, n5, n3, n6);
    }

    private void setThumbDrawable(Thumb thumb, Drawable drawable2, int n2) {
        Thumb thumb2 = thumb;
        Drawable drawable3 = drawable2;
        drawable2 = this.getTintedDrawable(drawable2.getConstantState().newDrawable(), n2);
        drawable2.setCallback((Drawable.Callback)this);
        thumb2.setThumbOffset(drawable3.getIntrinsicWidth() / 2);
        if (thumb2.getThumb() != null && (drawable2.getIntrinsicWidth() != thumb.getThumb().getIntrinsicWidth() || drawable2.getIntrinsicHeight() != thumb.getThumb().getIntrinsicHeight())) {
            this.requestLayout();
        }
        thumb.setThumb(drawable2);
        this.invalidate();
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    private void setRangeDrawable(Thumb thumb, Drawable drawable2, int n2) {
        thumb.setRange(this.getTintedDrawable(drawable2, n2));
    }

    private void updateThumb(Thumb thumb, int n2, int n3) {
        Drawable drawable2;
        Drawable drawable3;
        if (thumb == null) {
            return;
        }
        int n4 = thumb.getThumb().getIntrinsicHeight();
        int n5 = n3 - this.getPaddingTop() - this.getPaddingBottom();
        float f3 = this.getScaleSize() > 0 ? (float)thumb.getValue() / (float)this.getScaleSize() : 0.0f;
        Drawable drawable4 = null;
        int n6 = this.mThumbs.indexOf(thumb);
        if (n6 > 0) {
            drawable4 = this.mThumbs.get(n6 - 1).getThumb();
        }
        if (n4 > n5) {
            if (thumb != null) {
                NavMultiSeekBar navMultiSeekBar = this;
                Thumb thumb2 = thumb;
                drawable3 = thumb2.getThumb();
                drawable2 = thumb2.getRange();
                int n7 = navMultiSeekBar.getThumbOptOffset(thumb);
                navMultiSeekBar.setThumbPos(n2, n3, drawable3, drawable4, drawable2, f3, 0, n7);
            }
            int cfr_ignored_0 = (n4 - n5) / 2;
            thumb = this.mTrack;
            if (thumb != null) {
                int n8 = n3 / 2;
                int n9 = mTrackHeight;
                int n10 = n8 - n9;
                n9 = n8 + n9;
                thumb.setBounds(0, n10, n2, n9);
            }
        } else {
            Drawable drawable5 = this.mTrack;
            if (drawable5 != null) {
                int n11 = n3 / 2;
                int n12 = mTrackHeight;
                int n13 = n11 - n12;
                n12 = n11 + n12;
                drawable5.setBounds(0, n13, n2, n12);
            }
            int n14 = (n5 - n4) / 2;
            if (thumb != null) {
                NavMultiSeekBar navMultiSeekBar = this;
                Thumb thumb3 = thumb;
                drawable2 = thumb3.getThumb();
                Drawable drawable6 = thumb3.getRange();
                int n15 = navMultiSeekBar.getThumbOptOffset(thumb);
                navMultiSeekBar.setThumbPos(n2, n3, drawable2, drawable4, drawable6, f3, n14, n15);
            }
        }
        for (int i3 = n6 + 1; i3 < this.mThumbs.size(); ++i3) {
            int n16 = (n5 - n4) / 2;
            float f4 = this.getScaleSize() > 0 ? (float)this.mThumbs.get(i3).getValue() / (float)this.getScaleSize() : 0.0f;
            NavMultiSeekBar navMultiSeekBar = this;
            Drawable drawable7 = navMultiSeekBar.mThumbs.get(i3).getThumb();
            drawable3 = navMultiSeekBar.mThumbs.get(i3 - 1).getThumb();
            drawable2 = navMultiSeekBar.mThumbs.get(i3).getRange();
            int n17 = navMultiSeekBar.getThumbOptOffset(navMultiSeekBar.mThumbs.get(i3));
            this.setThumbPos(n2, n3, drawable7, drawable3, drawable2, f4, n16, n17);
        }
    }

    private void setThumbPos(int n2, int n3, Drawable drawable2, Drawable drawable3, Drawable drawable4, float f3, int n4, int n5) {
        Drawable drawable5 = drawable2;
        n2 = this.getAvailable();
        int n6 = drawable5.getIntrinsicWidth();
        int n7 = drawable5.getIntrinsicHeight();
        float f4 = this.getScaleSize() > 0 ? (float)this.mScaleMin / (float)this.getScaleSize() : 0.0f;
        float f5 = f3;
        f3 = n2;
        int n8 = (int)(f5 * f3 - f4 * f3 + 0.5f);
        if (n4 == Integer.MIN_VALUE) {
            Rect rect = drawable2.getBounds();
            n4 = rect.top;
            n7 = rect.bottom;
        } else {
            n7 = n4 + n7;
        }
        n8 = this.isLayoutRtl() && this.mMirrorForRtl ? n2 - n8 + n5 : (n8 += n5);
        NavMultiSeekBar navMultiSeekBar = this;
        int n9 = n8;
        drawable2.setBounds(n9, n4, n9 + n6, n7);
        navMultiSeekBar.getPaddingTop();
        navMultiSeekBar.getPaddingBottom();
        int n10 = 0;
        if (navMultiSeekBar.isLayoutRtl() && this.mMirrorForRtl) {
            n10 = n2;
        }
        if (drawable3 != null) {
            n10 = drawable3.getBounds().left;
        }
        if (drawable4 != null) {
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                int n11 = n3 / 2;
                n2 = mTrackHeight;
                n3 = n11 - n2;
                n2 = n11 + n2;
                drawable4.setBounds(n8, n3, n10 += n5, n2);
            } else {
                int n12 = n3 / 2;
                n2 = mTrackHeight;
                n3 = n12 - n2;
                n2 = n12 + n2;
                drawable4.setBounds(n10, n3, n8, n2);
            }
        }
        this.invalidate();
    }

    private int getAvailable() {
        NavMultiSeekBar navMultiSeekBar = this;
        int n2 = navMultiSeekBar.getWidth() - JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_25dp) * 2;
        LinkedList<Thumb> linkedList = navMultiSeekBar.mThumbs;
        if (linkedList != null && linkedList.size() > 0) {
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                NavMultiSeekBar navMultiSeekBar2 = this;
                n2 -= navMultiSeekBar2.getThumbOptOffset(navMultiSeekBar2.mThumbs.getFirst());
            } else {
                NavMultiSeekBar navMultiSeekBar3 = this;
                n2 -= navMultiSeekBar3.getThumbOptOffset(navMultiSeekBar3.mThumbs.getLast());
            }
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private LinkedList<Thumb> getClosestThumb(int var1_1) {
        v0 = this;
        var2_2 = v1;
        v1 = new LinkedList<Thumb>();
        var3_3 = null;
        var4_4 = v0.getAvailable() + 1;
        for (Thumb var6_6 : v0.mThumbs) {
            block6: {
                block5: {
                    block4: {
                        if (var6_6.getThumb() == null || !var6_6.isEnabled() || this.mDraggingThumbs.contains(var6_6)) continue;
                        var7_7 = var1_1 - var6_6.getThumb().getIntrinsicWidth();
                        var8_8 = var1_1 + var6_6.getThumb().getIntrinsicWidth();
                        if (var6_6.getThumb().getBounds().centerX() < var7_7 || var6_6.getThumb().getBounds().centerX() > var8_8) break block4;
                        var2_2.add(var6_6);
                        ** GOTO lbl-1000
                    }
                    if (Math.abs(var6_6.getThumb().getBounds().centerX() - var1_1) > var4_4) ** GOTO lbl-1000
                    if (Math.abs(var6_6.getThumb().getBounds().centerX() - var1_1) != var4_4) break block5;
                    if (var1_1 <= this.getWidth() / 2) ** GOTO lbl-1000
                    break block6;
                }
                if (var6_6.getThumb() != null) {
                    var4_4 = Math.abs(var6_6.getThumb().getBounds().centerX() - var1_1);
                } else lbl-1000:
                // 4 sources

                {
                    var6_6 = var3_3;
                }
            }
            var3_3 = var6_6;
        }
        if (var2_2.isEmpty() && var3_3 != null) {
            var2_2.add(var3_3);
        }
        return var2_2;
    }

    private Thumb getMostMovable(LinkedList<Thumb> linkedList, MotionEvent motionEvent) {
        Thumb thumb = null;
        int n2 = 0;
        if (linkedList != null && !linkedList.isEmpty()) {
            if (linkedList.getFirst().getValue() == this.getValue(motionEvent, linkedList.getFirst())) {
                return null;
            }
            for (Thumb thumb2 : linkedList) {
                if (thumb2.getThumb() == null || !thumb2.isEnabled() || this.mDraggingThumbs.contains(thumb2)) continue;
                int n3 = this.getValue(motionEvent, linkedList.getFirst()) > thumb2.getValue() ? this.mScaleMax : this.mScaleMin;
                n3 = Math.abs(thumb2.getValue() - this.optThumbValue(thumb2, n3));
                if (n3 <= n2) {
                    n3 = n2;
                    thumb2 = thumb;
                }
                n2 = n3;
                thumb = thumb2;
            }
        }
        return thumb;
    }

    private Thumb getMostMovableThumb(MotionEvent motionEvent) {
        LinkedList<Thumb> linkedList = this.exactTouched;
        if (linkedList != null && linkedList.size() >= 1) {
            if (this.exactTouched.size() == 1) {
                return this.exactTouched.getFirst();
            }
            NavMultiSeekBar navMultiSeekBar = this;
            return navMultiSeekBar.getMostMovable(navMultiSeekBar.exactTouched, motionEvent);
        }
        return null;
    }

    private int getValue(MotionEvent motionEvent, Thumb thumb) {
        MotionEvent motionEvent2 = motionEvent;
        return this.getValue(motionEvent2, motionEvent2.getActionIndex(), thumb);
    }

    private void setHotspot(float f3, float f4, Thumb thumb) {
        if (thumb != null && thumb.getThumb() != null) {
            Drawable drawable2 = this.getBackground();
            if (Build.VERSION.SDK_INT >= 21 && drawable2 != null) {
                drawable2.setHotspot(f3, f4);
                Rect rect = thumb.getThumb().getBounds();
                int n2 = this.getPaddingTop();
                int n3 = rect.left;
                int n4 = rect.top + n2;
                int n5 = rect.right;
                n2 = rect.bottom + n2;
                drawable2.setHotspotBounds(n3, n4, n5, n2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getValue(MotionEvent motionEvent, int n2, Thumb thumb) {
        float f3;
        float f4;
        block8: {
            int n3;
            int n4;
            int n5;
            block9: {
                block7: {
                    block6: {
                        NavMultiSeekBar navMultiSeekBar = this;
                        int n6 = n2;
                        NavMultiSeekBar navMultiSeekBar2 = this;
                        n5 = navMultiSeekBar2.getWidth();
                        n2 = navMultiSeekBar2.getAvailable();
                        n4 = this.getThumbOptOffset(thumb);
                        n3 = (int)motionEvent.getX(n6);
                        f4 = navMultiSeekBar.mScaleMin;
                        if (!navMultiSeekBar.isLayoutRtl() || !this.mMirrorForRtl) break block6;
                        if (n3 > n5 - this.getPaddingRight()) break block7;
                        if (n3 >= this.getPaddingLeft()) {
                            f3 = (float)(n2 - n3 + this.getPaddingLeft() + n4) / (float)n2;
                            f4 = this.mScaleMin;
                            return Math.round(f4 + f3 * (float)this.getScaleSize());
                        }
                        break block8;
                    }
                    if (n3 >= this.getPaddingLeft()) break block9;
                }
                f3 = 0.0f;
                return Math.round(f4 + f3 * (float)this.getScaleSize());
            }
            if (n3 <= n5 - this.getPaddingRight()) {
                f3 = (float)(n3 - this.getPaddingLeft() - n4) / (float)n2;
                f4 = this.mScaleMin;
                return Math.round(f4 + f3 * (float)this.getScaleSize());
            }
        }
        f3 = 1.0f;
        return Math.round(f4 + f3 * (float)this.getScaleSize());
    }

    private void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }

    private boolean hasOnThumbValueChangeListener() {
        return this.mOnThumbValueChangeListener != null;
    }

    private Drawable getTintedDrawable(Drawable drawable2, int n2) {
        if (drawable2 != null && n2 != 0) {
            Drawable drawable3 = DrawableCompat.wrap((Drawable)drawable2.mutate());
            DrawableCompat.setTint((Drawable)drawable3, (int)n2);
            return drawable3;
        }
        return drawable2;
    }

    public int getStepsThumbsApart() {
        return this.mStepsThumbsApart;
    }

    public void setStepsThumbsApart(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.mStepsThumbsApart = n2;
    }

    public int getStep() {
        return this.mStep;
    }

    public void setStep(int n2) {
        this.mStep = n2;
    }

    public int getScaleSize() {
        return this.mScaleMax - this.mScaleMin;
    }

    public void repositionThumbs() {
        LinkedList<Thumb> linkedList = this.mThumbs;
        if (linkedList != null && !linkedList.isEmpty()) {
            if (this.mThumbs.size() > 0) {
                this.mThumbs.getFirst().setValue(this.mScaleMin);
            }
            if (this.mThumbs.size() > 1) {
                this.mThumbs.getLast().setValue(this.mScaleMax);
            }
            if (this.mThumbs.size() > 2) {
                NavMultiSeekBar navMultiSeekBar = this;
                int n2 = (navMultiSeekBar.mScaleMax - this.mScaleMin) / (this.mThumbs.size() - 1);
                int n3 = navMultiSeekBar.mScaleMax - n2;
                for (int i3 = (v897624).mThumbs.size() - 2; i3 > 0; --i3) {
                    this.mThumbs.get(i3).setValue(n3);
                    n3 -= n2;
                }
            }
            return;
        }
    }

    public void setOnThumbValueChangeListener(OnThumbValueChangeListener onThumbValueChangeListener) {
        this.mOnThumbValueChangeListener = onThumbValueChangeListener;
    }

    public boolean isDrawThumbsApart() {
        return this.mDrawThumbsApart;
    }

    public void setDrawThumbsApart(boolean bl) {
        this.mDrawThumbsApart = bl;
    }

    public NavMultiSeekBar setNumberOfThumbs(int n2) {
        return this.setNumberOfThumbs(n2, true);
    }

    public NavMultiSeekBar setNumberOfThumbs(int n2, boolean bl) {
        this.clearThumbs();
        for (int i3 = 0; i3 < n2; ++i3) {
            this.addThumb(0);
        }
        if (bl) {
            this.repositionThumbs();
        }
        return this;
    }

    public boolean addThumb(Thumb thumb) {
        return this.addThumbOnPos(thumb, this.mThumbs.size());
    }

    public boolean addThumbOnPos(Thumb thumb, int n2) {
        int n3;
        if (this.mThumbs.contains(thumb)) {
            return false;
        }
        if (thumb.getThumb() == null) {
            NavMultiSeekBar navMultiSeekBar = this;
            Drawable drawable2 = navMultiSeekBar.defThumbDrawable;
            n3 = navMultiSeekBar.defThumbColor;
            navMultiSeekBar.setThumbDrawable(thumb, drawable2, n3);
        }
        NavMultiSeekBar navMultiSeekBar = this;
        int n4 = Math.max(navMultiSeekBar.getPaddingLeft(), thumb.getThumbOffset());
        n3 = Math.max(navMultiSeekBar.getPaddingRight(), thumb.getThumbOffset());
        int n5 = navMultiSeekBar.getPaddingTop();
        int n6 = navMultiSeekBar.getPaddingBottom();
        navMultiSeekBar.setPadding(n4, n5, n3, n6);
        if (thumb.getRange() == null) {
            NavMultiSeekBar navMultiSeekBar2 = this;
            Drawable drawable3 = navMultiSeekBar2.defRangeDrawable;
            n3 = navMultiSeekBar2.defRangeColor;
            navMultiSeekBar2.setRangeDrawable(thumb, drawable3, n3);
        }
        Thumb thumb2 = thumb;
        this.mThumbs.add(n2, thumb);
        this.setThumbValue(thumb2, thumb2.value, false);
        return true;
    }

    public Thumb addThumb(int n2) {
        Thumb thumb;
        Thumb thumb2 = thumb;
        thumb2(this);
        this.addThumb(thumb2);
        thumb.setValue(n2);
        return thumb;
    }

    public Thumb addThumb() {
        Thumb thumb;
        Thumb thumb2 = thumb;
        thumb2(this);
        this.addThumb(thumb2);
        return thumb;
    }

    public Thumb addThumbOnPos(int n2, int n3) {
        Thumb thumb;
        Thumb thumb2 = thumb;
        thumb2(this);
        this.addThumbOnPos(thumb2, n2);
        thumb.setValue(n3);
        return thumb;
    }

    public Thumb addThumbOnPos(int n2) {
        Thumb thumb;
        Thumb thumb2 = thumb;
        thumb2(this);
        this.addThumbOnPos(thumb2, n2);
        return thumb;
    }

    public boolean removeThumb(Thumb thumb) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.mDraggingThumbs.remove(thumb);
        boolean bl = navMultiSeekBar.mThumbs.remove(thumb);
        this.invalidate();
        return bl;
    }

    public Thumb removeThumb(int n2) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.mDraggingThumbs.remove(this.mThumbs.get(n2));
        navMultiSeekBar.invalidate();
        this.invalidate();
        return navMultiSeekBar.mThumbs.remove(n2);
    }

    public void clearThumbs() {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.mThumbs.clear();
        navMultiSeekBar.mDraggingThumbs.clear();
        navMultiSeekBar.invalidate();
    }

    public void setThumbOffset(int n2) {
        Iterator iterator = this.mThumbs.iterator();
        while (iterator.hasNext()) {
            ((Thumb)iterator.next()).setThumbOffset(n2);
        }
        this.invalidate();
    }

    public void setTrackDrawable(Drawable drawable2) {
        boolean bl;
        Drawable drawable3 = this.mTrack;
        if (drawable3 != null && drawable2 != drawable3) {
            drawable3.setCallback(null);
            bl = true;
        } else {
            bl = false;
        }
        if (drawable2 != null) {
            Drawable drawable4 = drawable2;
            drawable4.setCallback((Drawable.Callback)this);
            int n2 = drawable4.getMinimumHeight();
            if (this.mMaxHeight < n2) {
                this.mMaxHeight = n2;
                this.requestLayout();
            }
        }
        this.mTrack = drawable2;
        if (bl) {
            NavMultiSeekBar navMultiSeekBar = this;
            int n3 = navMultiSeekBar.getWidth();
            navMultiSeekBar.updateTrackBounds(n3, navMultiSeekBar.getHeight());
            navMultiSeekBar.updateTrackState();
        }
    }

    public Thumb getThumb(int n2) {
        return this.mThumbs.get(n2);
    }

    public void setKeyProgressIncrement(int n2) {
        if (n2 < 0) {
            n2 = -n2;
        }
        this.mKeyProgressIncrement = n2;
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    public synchronized void setMax(int n2) {
        this.setMax(n2, true, false);
    }

    public synchronized void setMax(int n2, boolean bl) {
        this.setMax(n2, bl, false);
    }

    public synchronized void setMax(int n2, boolean bl, boolean bl2) {
        if (n2 >= this.mScaleMin) {
            if (n2 != this.mScaleMax) {
                this.mScaleMax = n2;
                for (Thumb thumb : this.mThumbs) {
                    if (bl) {
                        thumb.setMax(n2);
                    } else if (thumb.getMax() > n2) {
                        thumb.setMax(n2);
                    }
                    if (thumb.getValue() <= n2) continue;
                    this.setThumbValue(thumb, n2, false);
                }
                if (bl2) {
                    this.repositionThumbs();
                }
                this.postInvalidate();
            }
            if ((n2 = this.mKeyProgressIncrement) == 0 || this.mScaleMax / n2 > 20) {
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.setKeyProgressIncrement(Math.max(1, Math.round((float)navMultiSeekBar.mScaleMax / 20.0f)));
            }
            return;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray[1] = this.mScaleMin;
        throw new IllegalArgumentException(String.format("setMax(%d) < Min(%d)", objectArray2));
    }

    public int getMax() {
        return this.mScaleMax;
    }

    public synchronized void setMin(int n2) {
        this.setMin(n2, true, false);
    }

    public synchronized void setMin(int n2, boolean bl) {
        this.setMin(n2, bl, false);
    }

    public synchronized void setMin(int n2, boolean bl, boolean bl2) {
        if (n2 <= this.mScaleMax) {
            if (n2 != this.mScaleMin) {
                this.mScaleMin = n2;
                for (Thumb thumb : this.mThumbs) {
                    if (bl) {
                        thumb.setMin(n2);
                    } else if (thumb.getMin() < n2) {
                        thumb.setMin(n2);
                    }
                    if (thumb.getValue() >= n2) continue;
                    this.setThumbValue(thumb, n2, false);
                }
                if (bl2) {
                    this.repositionThumbs();
                }
                this.postInvalidate();
            }
            if ((n2 = this.mKeyProgressIncrement) == 0 || this.mScaleMax / n2 > 20) {
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.setKeyProgressIncrement(Math.max(1, Math.round((float)navMultiSeekBar.mScaleMax / 20.0f)));
            }
            return;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray[1] = this.mScaleMax;
        throw new IllegalArgumentException(String.format("setMin(%d) > Max(%d)", objectArray2));
    }

    public int getMin() {
        return this.mScaleMin;
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null || drawable2 != thumb.getThumb()) continue;
            return true;
        }
        return drawable2 == this.mTrack || super.verifyDrawable(drawable2);
    }

    public void jumpDrawablesToCurrentState() {
        NavMultiSeekBar navMultiSeekBar = this;
        super.jumpDrawablesToCurrentState();
        for (Thumb thumb : navMultiSeekBar.mThumbs) {
            if (thumb.getThumb() == null) continue;
            thumb.getThumb().jumpToCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void drawableStateChanged() {
        v0 = this;
        var1_1 = v0.mDraggingThumbs;
        synchronized (var1_1) {
            if (v0.mDraggingThumbs.isEmpty()) ** GOTO lbl46
            v1 = this;
            v2 = v1;
            var2_2 = v1.getDrawableState();
            var3_4 = v2.mDraggingThumbs.iterator();
            while (true) {
                if (!var3_4.hasNext()) break;
                var4_6 = var3_4.next();
                if (var4_6.getThumb() == null) continue;
                var4_6.getThumb().setState((int[])var2_2);
            }
            var2_2 = this.mThumbs.iterator();
            block26: while (true) {
                if (!var2_2.hasNext()) ** GOTO lbl65
                v3 = this;
                var3_4 = (Thumb)var2_2.next();
                if (v3.mDraggingThumbs.contains(var3_4)) continue;
                if (var3_4.getThumb() == null) continue;
                if (!var3_4.getThumb().isStateful()) continue;
                if (!var3_4.isEnabled()) break;
                v4 = var3_4.getThumb().setState(new int[]{16842910, -16842919});
lbl41:
                // 2 sources

                continue block26;
                break;
            }
            v4 = var3_4.getThumb().setState(new int[]{-16842910});
            ** continue;
lbl46:
            // 1 sources

            var2_3 = this.mThumbs.iterator();
            block28: while (true) {
                if (!var2_3.hasNext()) ** GOTO lbl65
                var3_5 = (Thumb)var2_3.next();
                if (var3_5.getThumb() == null) continue;
                if (!var3_5.getThumb().isStateful()) continue;
                if (!var3_5.isEnabled()) break;
                v5 = var3_5.getThumb().setState(new int[]{16842910, -16842919});
lbl60:
                // 2 sources

                continue block28;
                break;
            }
            v5 = var3_5.getThumb().setState(new int[]{-16842910});
            ** continue;
lbl65:
            // 2 sources

            // MONITOREXIT @DISABLED, blocks:[22, 23] lbl65 : MonitorExitStatement: MONITOREXIT : var1_1
            super.drawableStateChanged();
            return;
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        NavMultiSeekBar navMultiSeekBar = this;
        super.onDraw(canvas);
        int n2 = JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_25dp);
        if (navMultiSeekBar.mTrack != null) {
            canvas.save();
            canvas.translate((float)n2, (float)this.getPaddingTop());
            this.mTrack.draw(canvas);
            canvas.restore();
        }
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getRange() == null) continue;
            canvas.save();
            canvas.translate((float)n2, (float)(this.getPaddingTop() - this.getPaddingBottom()));
            thumb.getRange().draw(canvas);
            canvas.restore();
        }
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null || thumb.isInvisibleThumb()) continue;
            canvas.save();
            canvas.translate((float)(n2 - thumb.getThumbOffset()), (float)this.getPaddingTop());
            thumb.getThumb().draw(canvas);
            canvas.restore();
        }
    }

    protected synchronized void onMeasure(int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        for (Thumb thumb : this.mThumbs) {
            if (thumb.getThumb() == null) continue;
            Thumb thumb2 = thumb;
            n4 = Math.max(thumb2.getThumb().getIntrinsicHeight(), n4);
            n5 = Math.max(thumb2.getThumb().getIntrinsicHeight(), n5);
        }
        int n6 = 0;
        int n7 = 0;
        Drawable drawable2 = this.mTrack;
        if (drawable2 != null) {
            NavMultiSeekBar navMultiSeekBar = this;
            n6 = Math.max(navMultiSeekBar.mMinWidth, Math.min(this.mMaxWidth, drawable2.getIntrinsicWidth()));
            n7 = Math.max(n4, Math.max(n5, Math.max(navMultiSeekBar.mMinHeight, Math.min(this.mMaxHeight, this.mTrack.getIntrinsicHeight()))));
        }
        n4 = n6 + (this.getPaddingLeft() + this.getPaddingRight());
        int n8 = View.resolveSizeAndState((int)n4, (int)n2, (int)0);
        this.setMeasuredDimension(n8, View.resolveSizeAndState((int)(n7 + (this.getPaddingTop() + this.getPaddingBottom())), (int)n3, (int)0));
    }

    public boolean isInScrollingContainer() {
        for (NavMultiSeekBar navMultiSeekBar = navMultiSeekBar.getParent(); navMultiSeekBar != null && navMultiSeekBar instanceof ViewGroup; navMultiSeekBar = navMultiSeekBar.getParent()) {
            if (!((ViewGroup)navMultiSeekBar).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        LinkedList<Thumb> linkedList;
        if (!this.isEnabled()) {
            return false;
        }
        MotionEvent motionEvent2 = motionEvent;
        int n2 = Math.round(motionEvent2.getX());
        int n3 = Math.round(motionEvent2.getY());
        int n4 = motionEvent2.getActionIndex();
        Thumb thumb = null;
        if (motionEvent2.getActionMasked() != 0 && motionEvent.getActionMasked() != 5) {
            if (motionEvent.getActionMasked() == 2) {
                linkedList = this.exactTouched;
                if (linkedList != null && !linkedList.isEmpty()) {
                    thumb = this.getMostMovableThumb(motionEvent);
                } else if (this.mDraggingThumbs.size() > n4) {
                    thumb = this.mDraggingThumbs.get(n4);
                }
            } else if (motionEvent.getActionMasked() == 1 || motionEvent.getActionMasked() == 6) {
                if (this.mDraggingThumbs.size() > n4) {
                    thumb = this.mDraggingThumbs.get(n4);
                } else {
                    linkedList = this.exactTouched;
                    if (linkedList != null && linkedList.size() > 0) {
                        thumb = this.getMostMovableThumb(motionEvent);
                        this.exactTouched = null;
                    }
                }
            }
        } else {
            LinkedList<Thumb> linkedList2;
            NavMultiSeekBar navMultiSeekBar = this;
            linkedList = navMultiSeekBar.getClosestThumb((int)motionEvent.getX(n4));
            if (navMultiSeekBar.isInScrollingContainer() && this.mDraggingThumbs.size() == 0 && (linkedList2 = this.exactTouched) != null && n4 > 0) {
                this.onStartTrackingTouch(linkedList2.getFirst());
                this.exactTouched = null;
            }
            if (linkedList != null && !linkedList.isEmpty()) {
                if (linkedList.size() == 1) {
                    thumb = linkedList.getFirst();
                    if (this.isInScrollingContainer() && this.mDraggingThumbs.size() == 0) {
                        this.exactTouched = linkedList;
                    }
                } else {
                    this.exactTouched = linkedList;
                }
            }
        }
        switch (motionEvent.getActionMasked()) {
            default: {
                break;
            }
            case 3: {
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.onStopTrackingTouch();
                navMultiSeekBar.invalidate();
                break;
            }
            case 2: {
                if (this.mDraggingThumbs.contains(thumb)) {
                    for (n4 = 0; n4 < this.mDraggingThumbs.size(); ++n4) {
                        if (this.mDraggingThumbs.get(n4) != null && this.mDraggingThumbs.get(n4).getThumb() != null) {
                            NavMultiSeekBar navMultiSeekBar = this;
                            navMultiSeekBar.invalidate(navMultiSeekBar.mDraggingThumbs.get(n4).getThumb().getBounds());
                        }
                        NavMultiSeekBar navMultiSeekBar = this;
                        NavMultiSeekBar navMultiSeekBar2 = this;
                        linkedList = navMultiSeekBar2.mDraggingThumbs.get(n4);
                        navMultiSeekBar.setThumbValue((Thumb)((Object)linkedList), navMultiSeekBar.getValue(motionEvent, n4, navMultiSeekBar2.mDraggingThumbs.get(n4)), true);
                    }
                    float f3 = n2;
                    this.setHotspot(f3, n3, thumb);
                    break;
                }
                if (!(Math.abs(motionEvent.getX(n4) - this.mTouchDownX) > (float)this.mScaledTouchSlop)) break;
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.onStartTrackingTouch(thumb);
                navMultiSeekBar.exactTouched = null;
                navMultiSeekBar.setThumbValue(thumb, navMultiSeekBar.getValue(motionEvent, thumb), true);
                float f4 = n2;
                this.setHotspot(f4, n3, thumb);
                break;
            }
            case 1: 
            case 6: {
                if (thumb != null) {
                    NavMultiSeekBar navMultiSeekBar = this;
                    this.setThumbValue(thumb, this.getValue(motionEvent, thumb), true);
                    float f5 = n2;
                    navMultiSeekBar.setHotspot(f5, n3, thumb);
                    if (!navMultiSeekBar.isPressed()) {
                        this.setPressed(true);
                    }
                    this.onStopTrackingTouch(thumb);
                }
                this.invalidate();
                break;
            }
            case 0: 
            case 5: {
                if (this.isInScrollingContainer() && this.mDraggingThumbs.size() == 0) {
                    this.mTouchDownX = motionEvent.getX(n4);
                    break;
                }
                NavMultiSeekBar navMultiSeekBar = this;
                navMultiSeekBar.onStartTrackingTouch(thumb);
                navMultiSeekBar.setThumbValue(thumb, navMultiSeekBar.getValue(motionEvent, thumb), true);
                float f6 = n2;
                this.setHotspot(f6, n3, thumb);
            }
        }
        return true;
    }

    int getThumbOptOffset(Thumb thumb) {
        if (!this.mDrawThumbsApart) {
            return 0;
        }
        if (thumb != null && thumb.getThumb() != null) {
            int n2;
            NavMultiSeekBar navMultiSeekBar = this;
            int n3 = navMultiSeekBar.mThumbs.indexOf(thumb);
            if (navMultiSeekBar.isLayoutRtl() && this.mMirrorForRtl) {
                int n4;
                if (n3 == this.mThumbs.size() - 1) {
                    n4 = 0;
                } else {
                    NavMultiSeekBar navMultiSeekBar2 = this;
                    n4 = navMultiSeekBar2.getThumbOptOffset(navMultiSeekBar2.mThumbs.get(n3 + 1)) + thumb.getThumb().getIntrinsicWidth();
                }
                return n4;
            }
            if (n3 == 0) {
                n2 = 0;
            } else {
                NavMultiSeekBar navMultiSeekBar3 = this;
                n2 = navMultiSeekBar3.getThumbOptOffset(navMultiSeekBar3.mThumbs.get(n3 - 1)) + thumb.getThumb().getIntrinsicWidth();
            }
            return n2;
        }
        return 0;
    }

    void onStartTrackingTouch(Thumb thumb) {
        if (thumb != null) {
            NavMultiSeekBar navMultiSeekBar = this;
            navMultiSeekBar.mDraggingThumbs.add(thumb);
            if (navMultiSeekBar.isPressed()) {
                this.drawableStateChanged();
            } else {
                this.setPressed(true);
            }
            if (thumb.getThumb() != null) {
                this.invalidate(thumb.getThumb().getBounds());
            }
            this.attemptClaimDrag();
        }
    }

    void onStopTrackingTouch(Thumb thumb) {
        if (thumb != null) {
            NavMultiSeekBar navMultiSeekBar = this;
            navMultiSeekBar.mDraggingThumbs.remove(thumb);
            if (navMultiSeekBar.mDraggingThumbs.size() == 0) {
                this.setPressed(false);
            } else {
                this.drawableStateChanged();
            }
        }
    }

    void onStopTrackingTouch() {
        for (Thumb thumb : this.mDraggingThumbs) {
            this.mDraggingThumbs.remove(thumb);
        }
        this.setPressed(false);
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mAccessibilityNodeProvider == null) {
            VirtualTreeProvider virtualTreeProvider;
            VirtualTreeProvider virtualTreeProvider2 = virtualTreeProvider;
            virtualTreeProvider = new VirtualTreeProvider();
            this.mAccessibilityNodeProvider = virtualTreeProvider2;
        }
        return this.mAccessibilityNodeProvider;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)NavMultiSeekBar.class.getName());
    }

    public void onRtlPropertiesChanged(int n2) {
        if (Build.VERSION.SDK_INT >= 17) {
            NavMultiSeekBar navMultiSeekBar = this;
            super.onRtlPropertiesChanged(n2);
            navMultiSeekBar.invalidate();
        }
    }

    public boolean isLayoutRtl() {
        if (Build.VERSION.SDK_INT >= 17) {
            return this.getLayoutDirection() == 1;
        }
        return false;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        NavMultiSeekBar navMultiSeekBar = this;
        navMultiSeekBar.updateTrackBounds(n2, n3);
        for (Thumb thumb : navMultiSeekBar.mThumbs) {
            this.updateThumb(thumb, n2 - JarUtils.getResources().getDimensionPixelSize(R.dimen.navi_dimens_25dp) * 2, n3);
        }
    }

    @TargetApi(value=16)
    class VirtualTreeProvider
    extends AccessibilityNodeProvider {
        static final int ACT_SET_PROGRESS = 16908349;
        final AccessibilityNodeInfo.AccessibilityAction ACTION_SET_PROGRESS;

        public VirtualTreeProvider() {
            if (Build.VERSION.SDK_INT >= 21) {
                AccessibilityNodeInfo.AccessibilityAction accessibilityAction;
                VirtualTreeProvider virtualTreeProvider = virtualTreeProvider2;
                VirtualTreeProvider virtualTreeProvider2 = accessibilityAction;
                accessibilityAction = new AccessibilityNodeInfo.AccessibilityAction(16908349, null);
                virtualTreeProvider.ACTION_SET_PROGRESS = virtualTreeProvider2;
            } else {
                virtualTreeProvider2.ACTION_SET_PROGRESS = null;
            }
        }

        public AccessibilityNodeInfo createAccessibilityNodeInfo(int n2) {
            AccessibilityNodeInfo accessibilityNodeInfo;
            if (n2 == -1) {
                VirtualTreeProvider virtualTreeProvider = object;
                AccessibilityNodeInfo accessibilityNodeInfo2 = AccessibilityNodeInfo.obtain((View)virtualTreeProvider.NavMultiSeekBar.this);
                virtualTreeProvider.NavMultiSeekBar.this.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo2);
                int n3 = virtualTreeProvider.NavMultiSeekBar.this.mThumbs.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    accessibilityNodeInfo2.addChild((View)object.NavMultiSeekBar.this, i3);
                }
                if (object.NavMultiSeekBar.this.mThumbs.size() == 1) {
                    accessibilityNodeInfo2.setScrollable(true);
                    if (Build.VERSION.SDK_INT >= 21) {
                        AccessibilityNodeInfo accessibilityNodeInfo3 = accessibilityNodeInfo2;
                        accessibilityNodeInfo3.addAction(object.ACTION_SET_PROGRESS);
                        accessibilityNodeInfo3.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                        accessibilityNodeInfo3.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                    } else {
                        AccessibilityNodeInfo accessibilityNodeInfo4 = accessibilityNodeInfo2;
                        accessibilityNodeInfo4.addAction(8192);
                        accessibilityNodeInfo4.addAction(4096);
                    }
                }
                accessibilityNodeInfo = accessibilityNodeInfo2;
            } else {
                Thumb thumb = (Thumb)object.NavMultiSeekBar.this.mThumbs.get(n2);
                if (thumb == null) {
                    return null;
                }
                accessibilityNodeInfo = AccessibilityNodeInfo.obtain((View)object.NavMultiSeekBar.this, (int)n2);
                accessibilityNodeInfo.setClassName((CharSequence)thumb.getClass().getName());
                accessibilityNodeInfo.setParent((View)object.NavMultiSeekBar.this);
                accessibilityNodeInfo.setSource((View)object.NavMultiSeekBar.this, n2);
                accessibilityNodeInfo.setContentDescription((CharSequence)("Multi-Slider thumb no:" + n2));
                if (Build.VERSION.SDK_INT >= 21) {
                    accessibilityNodeInfo.addAction(object.ACTION_SET_PROGRESS);
                    if (thumb.getPossibleMax() > thumb.value) {
                        accessibilityNodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                    }
                    if (thumb.getPossibleMax() > thumb.value) {
                        accessibilityNodeInfo.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                    }
                } else {
                    if (thumb.getPossibleMin() > thumb.value) {
                        accessibilityNodeInfo.addAction(8192);
                    }
                    if (thumb.getPossibleMax() > thumb.value) {
                        accessibilityNodeInfo.addAction(4096);
                    }
                }
                if (thumb.getThumb() != null) {
                    VirtualTreeProvider virtualTreeProvider = object;
                    Object object = new int[2];
                    virtualTreeProvider.NavMultiSeekBar.this.getLocationOnScreen((int[])object);
                    Rect rect = thumb.getThumb().copyBounds();
                    rect.top += object[1];
                    rect.left += object[0];
                    rect.right += object[0];
                    rect.bottom += object[1];
                    accessibilityNodeInfo.setBoundsInScreen(rect);
                }
                accessibilityNodeInfo.setText((CharSequence)(thumb.tag + ": " + thumb.value));
                accessibilityNodeInfo.setEnabled(thumb.isEnabled());
                if (Build.VERSION.SDK_INT >= 24) {
                    accessibilityNodeInfo.setImportantForAccessibility(true);
                }
                AccessibilityNodeInfo accessibilityNodeInfo5 = accessibilityNodeInfo;
                accessibilityNodeInfo5.setVisibleToUser(true);
                accessibilityNodeInfo5.setScrollable(true);
            }
            return accessibilityNodeInfo;
        }

        public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String string2, int n2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return Collections.emptyList();
            }
            string2 = string2.toLowerCase();
            ArrayList<AccessibilityNodeInfo> arrayList = null;
            if (n2 == -1) {
                n2 = NavMultiSeekBar.this.mThumbs.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (!((Thumb)((NavMultiSeekBar)NavMultiSeekBar.this).mThumbs.get((int)i3)).tag.toLowerCase().contains(string2)) continue;
                    if (arrayList == null) {
                        ArrayList<AccessibilityNodeInfo> arrayList2;
                        arrayList = arrayList2;
                        arrayList2 = new ArrayList<AccessibilityNodeInfo>();
                    }
                    arrayList.add(this.createAccessibilityNodeInfo(i3));
                }
            } else {
                Thumb thumb = (Thumb)NavMultiSeekBar.this.mThumbs.get(n2);
                if (thumb != null && thumb.tag.toLowerCase().contains(string2)) {
                    ArrayList<AccessibilityNodeInfo> arrayList3;
                    arrayList = arrayList3;
                    arrayList();
                    arrayList3.add(this.createAccessibilityNodeInfo(n2));
                }
            }
            if (arrayList == null) {
                return Collections.emptyList();
            }
            return arrayList;
        }

        public AccessibilityNodeInfo findFocus(int n2) {
            return super.findFocus(n2);
        }

        public boolean performAction(int n2, int n3, Bundle bundle) {
            if (n2 == -1) {
                return false;
            }
            if (n2 >= NavMultiSeekBar.this.mThumbs.size()) {
                return false;
            }
            Thumb thumb = (Thumb)NavMultiSeekBar.this.mThumbs.get(n2);
            if (thumb == null) {
                return false;
            }
            if (n3 != 4096) {
                if (n3 != 8192) {
                    if (n3 != 16908349) {
                        return false;
                    }
                    thumb.setValue(bundle.getInt("value"));
                    return true;
                }
                Thumb thumb2 = thumb;
                thumb2.setValue(thumb2.value - NavMultiSeekBar.this.getStep());
                return true;
            }
            Thumb thumb3 = thumb;
            thumb3.setValue(thumb3.value + NavMultiSeekBar.this.getStep());
            return true;
        }
    }

    public static class SimpleChangeListener
    implements OnThumbValueChangeListener {
        @Override
        public void onValueChanged(NavMultiSeekBar navMultiSeekBar, Thumb thumb, int n2, int n3) {
        }
    }

    public class Thumb {
        int min;
        int max;
        int value;
        String tag;
        Drawable thumb;
        Drawable range;
        int thumbOffset;
        private boolean isInvisible;
        private boolean isEnabled;
        final /* synthetic */ NavMultiSeekBar this$0;

        public Thumb(NavMultiSeekBar navMultiSeekBar) {
            int n2;
            Thumb thumb = this;
            this.this$0 = navMultiSeekBar;
            this.tag = "thumb";
            this.isInvisible = false;
            this.isEnabled = true;
            this.min = navMultiSeekBar.mScaleMin;
            thumb.max = n2 = navMultiSeekBar.mScaleMax;
            thumb.value = n2;
        }

        public Drawable getRange() {
            return this.range;
        }

        public final Thumb setRange(Drawable drawable2) {
            this.range = drawable2;
            return this;
        }

        public boolean isEnabled() {
            return !this.isInvisibleThumb() && this.isEnabled;
        }

        public Thumb setEnabled(boolean bl) {
            this.isEnabled = bl;
            if (this.getThumb() != null) {
                if (this.isEnabled()) {
                    this.getThumb().setState(new int[]{16842910});
                } else {
                    this.getThumb().setState(new int[]{-16842910});
                }
            }
            return this;
        }

        public boolean isInvisibleThumb() {
            return this.isInvisible;
        }

        public void setInvisibleThumb(boolean bl) {
            this.isInvisible = bl;
        }

        public int getPossibleMin() {
            return this.min + this.this$0.mThumbs.indexOf(this) * this.this$0.mStepsThumbsApart;
        }

        public int getPossibleMax() {
            return this.max - (this.this$0.mThumbs.size() - 1 - this.this$0.mThumbs.indexOf(this)) * this.this$0.mStepsThumbsApart;
        }

        public int getMin() {
            return this.min;
        }

        public Thumb setMin(int n2) {
            int n3 = this.max;
            if (n2 <= n3) {
                n3 = n2;
            }
            if (n3 < this.this$0.mScaleMin) {
                n3 = this.this$0.mScaleMin;
            }
            if (this.min != n3) {
                this.min = n3;
                if (this.value < n3) {
                    this.value = n3;
                    this.this$0.invalidate();
                }
            }
            return this;
        }

        public int getMax() {
            return this.max;
        }

        public Thumb setMax(int n2) {
            int n3 = this.min;
            if (n2 >= n3) {
                n3 = n2;
            }
            if (n3 > this.this$0.mScaleMax) {
                n3 = this.this$0.mScaleMax;
            }
            if (this.max != n3) {
                this.max = n3;
                if (this.value > n3) {
                    this.value = n3;
                    this.this$0.invalidate();
                }
            }
            return this;
        }

        public int getValue() {
            return this.value;
        }

        public Thumb setValue(int n2) {
            if (this.this$0.mThumbs.contains(this)) {
                this.this$0.setThumbValue(this, n2, false);
            } else {
                this.value = n2;
            }
            return this;
        }

        public String getTag() {
            return this.tag;
        }

        public Thumb setTag(String string2) {
            this.tag = string2;
            return this;
        }

        public Drawable getThumb() {
            return this.thumb;
        }

        public Thumb setThumb(Drawable drawable2) {
            this.thumb = drawable2;
            return this;
        }

        public int getThumbOffset() {
            return this.thumbOffset;
        }

        public Thumb setThumbOffset(int n2) {
            this.thumbOffset = n2;
            return this;
        }
    }

    public static interface OnThumbValueChangeListener {
        public void onValueChanged(NavMultiSeekBar var1, Thumb var2, int var3, int var4);
    }
}

