/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.i;
import com.baidu.navisdk.model.datastruct.l;
import com.baidu.navisdk.ui.util.a;
import com.baidu.navisdk.util.common.LogUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RoadCondBar
extends View {
    private static final String TAG = "RoadCondBar";
    private float colorBarEdgeWidth = 16.0f;
    private float colorBarMarginTop = 13.34f;
    private float carPointSize = 54.6f;
    private float carPointEdgeWidth = 0.0f;
    private float carPointPlaintEdge = 6.0f;
    private double mCurCarProgress = 0.0;
    private List<l> mRoadConditionItems = new ArrayList<l>();
    private int mItemTotalIndex = 0;
    private Paint mBGPaint = null;
    private Paint[] mPaints = new Paint[5];
    private Paint mPassPaint = null;
    private Bitmap mCacheBitmap = null;
    private Canvas mCacheCanvas = null;
    private int mLastW = 0;
    private int mLastH = 0;
    private int height = 0;
    private int width = 0;
    private NinePatchDrawable bgBitmap = null;
    private Bitmap carPointBitmap = null;
    private boolean hasSetData = false;

    public RoadCondBar(Context context) {
        super(context);
        this.init(context);
    }

    public RoadCondBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    private void init(Context context) {
        RoadCondBar roadCondBar = this;
        this.initPaints();
        roadCondBar.initSize(context);
        roadCondBar.bgBitmap = (NinePatchDrawable)a.f(R.drawable.nsdk_drawable_roadcondition_fg);
        roadCondBar.carPointBitmap = a.a(R.drawable.nsdk_drawable_roadcondition_carpoint);
        roadCondBar.setBackgroundDrawable(null);
        Log.e((String)TAG, (String)("graphics.Bitmap \u521d\u59cb\u5316 -> viewHash= " + ((Object)((Object)this)).hashCode() + ",BitmapHash = " + this.carPointBitmap.hashCode()));
    }

    private void initSize(Context context) {
        this.colorBarEdgeWidth = context.getResources().getDimensionPixelOffset(R.dimen.navi_dimens_8dp);
        this.carPointSize = context.getResources().getDimensionPixelOffset(R.dimen.navi_dimens_27dp);
        this.colorBarMarginTop = context.getResources().getDimensionPixelOffset(R.dimen.navi_dimens_7dp);
        this.carPointPlaintEdge = context.getResources().getDimensionPixelOffset(R.dimen.navi_dimens_3dp);
    }

    private void initPaints() {
        Paint paint;
        Paint paint2;
        Paint paint3;
        Paint paint4;
        Paint paint5;
        RoadCondBar roadCondBar = roadCondBar2;
        roadCondBar2.mBGPaint = new Paint();
        roadCondBar2.mBGPaint.setAntiAlias(true);
        roadCondBar2.mPassPaint = new Paint();
        roadCondBar2.mPassPaint.setColor(-3158065);
        RoadCondBar roadCondBar2 = paint5;
        paint5 = new Paint();
        roadCondBar.mPaints[0] = roadCondBar2;
        roadCondBar.mPaints[0].setColor(l.a(0));
        roadCondBar2 = paint4;
        paint4 = new Paint();
        roadCondBar.mPaints[1] = roadCondBar2;
        roadCondBar.mPaints[1].setColor(l.a(1));
        roadCondBar2 = paint3;
        paint3 = new Paint();
        roadCondBar.mPaints[2] = roadCondBar2;
        roadCondBar.mPaints[2].setColor(l.a(2));
        roadCondBar2 = paint2;
        paint2 = new Paint();
        roadCondBar.mPaints[3] = roadCondBar2;
        roadCondBar.mPaints[3].setColor(l.a(3));
        roadCondBar2 = paint;
        paint = new Paint();
        roadCondBar.mPaints[4] = roadCondBar2;
        roadCondBar.mPaints[4].setColor(l.a(4));
    }

    private boolean isDataValid() {
        List<l> list = ((RoadCondBar)((Object)list)).mRoadConditionItems;
        return list != null && list.size() > 0;
    }

    private float getRoadConditionItemDrawHeight(int n2, int n3, int n4) {
        int n5 = this.mItemTotalIndex;
        if (n5 <= 0) {
            return 0.0f;
        }
        return (float)((double)((float)n4 - this.colorBarMarginTop) * 1.0 * (double)(n3 - n2) * 1.0 / (double)n5);
    }

    protected void onMeasure(int n2, int n3) {
        RoadCondBar roadCondBar = this;
        super.onMeasure(n2, n3);
        long l2 = roadCondBar.getMeasuredHeight();
        long l3 = this.getMeasuredWidth();
        long l4 = l2 * l3 * 16L;
        if (l2 <= 10000L && l3 <= 10000L && l4 <= Integer.MAX_VALUE) {
            int n4;
            RoadCondBar roadCondBar2 = this;
            this.width = n4 = (int)l3;
            roadCondBar2.height = (int)l2;
            roadCondBar2.carPointEdgeWidth = (int)(((float)n4 - this.carPointSize) / 2.0f);
            return;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "---> BNRoadConditionView: cacheBitmapSize is " + l4 + ", cacheBitmapSize exceeds 32 bits ");
        }
    }

    protected void onDraw(Canvas canvas) {
        block44: {
            block45: {
                block43: {
                    RectF rectF;
                    float f3;
                    float f4;
                    block42: {
                        RectF rectF2;
                        Paint paint;
                        Rect rect;
                        int n2;
                        RoadCondBar roadCondBar = this;
                        super.onDraw(canvas);
                        int n3 = roadCondBar.width;
                        if (n3 <= 0 || (n2 = this.height) <= 0) break block44;
                        if (!this.hasSetData) {
                            if (LogUtil.LOGGABLE) {
                                LogUtil.e(TAG, "onDraw-> hasSetData false");
                            }
                            return;
                        }
                        if (this.mCacheBitmap == null || this.mCacheCanvas == null || n3 != this.mLastW || n2 != this.mLastH) {
                            Bitmap bitmap;
                            if (i.a && (bitmap = this.mCacheBitmap) != null && !bitmap.isRecycled()) {
                                this.mCacheBitmap.recycle();
                            }
                            this.mCacheBitmap = null;
                            int n4 = this.width;
                            this.mLastW = n3 = n4;
                            this.mLastH = n3 = this.height;
                            this.mCacheBitmap = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_4444);
                            this.mCacheBitmap.eraseColor(0);
                            this.mCacheCanvas = new Canvas(this.mCacheBitmap);
                        }
                        if (this.mCacheBitmap == null || this.mCacheCanvas == null) break block45;
                        RoadCondBar roadCondBar2 = this;
                        RoadCondBar roadCondBar3 = this;
                        float f5 = (float)roadCondBar3.height - this.carPointSize;
                        n2 = 0;
                        Rect rect2 = rect;
                        RoadCondBar roadCondBar4 = this;
                        int n5 = roadCondBar4.width;
                        int n6 = (int)((float)roadCondBar4.height - this.carPointSize + this.colorBarMarginTop);
                        rect = new Rect(0, 0, n5, n6);
                        roadCondBar3.bgBitmap.setBounds(rect2);
                        roadCondBar3.bgBitmap.draw(canvas);
                        float f6 = roadCondBar3.width;
                        float f7 = roadCondBar3.height;
                        Paint paint2 = roadCondBar3.mBGPaint;
                        canvas.saveLayer(0.0f, 0.0f, f6, f7, paint2, 31);
                        RoadCondBar roadCondBar5 = this;
                        f6 = roadCondBar5.colorBarEdgeWidth;
                        f7 = roadCondBar5.colorBarMarginTop;
                        float f8 = f6;
                        RoadCondBar roadCondBar6 = this;
                        f6 = (float)roadCondBar6.width - f6;
                        paint2 = roadCondBar6.mPaints[0];
                        roadCondBar2.mCacheCanvas.drawRect(f8, f7, f6, f5, paint2);
                        if (roadCondBar2.isDataValid()) {
                            for (int i3 = 0; i3 < this.mRoadConditionItems.size(); ++i3) {
                                float f9;
                                RoadCondBar roadCondBar7 = this;
                                l l2 = roadCondBar7.mRoadConditionItems.get(i3);
                                int n7 = l2.c;
                                f7 = f5 - this.getRoadConditionItemDrawHeight(n2, n7, (int)((float)roadCondBar7.height - this.carPointSize));
                                if (this.mRoadConditionItems.size() != 1) {
                                    float f10 = this.colorBarEdgeWidth;
                                    f9 = f10;
                                    RoadCondBar roadCondBar8 = this;
                                    f9 = (float)roadCondBar8.width - f9;
                                    paint = roadCondBar8.mPaints[l2.b];
                                    this.mCacheCanvas.drawRect(f10, f7, f9, f5, paint);
                                } else {
                                    RoadCondBar roadCondBar9 = this;
                                    f9 = roadCondBar9.colorBarEdgeWidth;
                                    float f11 = roadCondBar9.colorBarMarginTop;
                                    float f12 = f9;
                                    RoadCondBar roadCondBar10 = this;
                                    f9 = (float)roadCondBar10.width - f9;
                                    Paint paint3 = roadCondBar10.mPaints[l2.b];
                                    this.mCacheCanvas.drawRect(f12, f11, f9, f5, paint3);
                                }
                                n2 = l2.c;
                                f5 = f7;
                            }
                        }
                        f5 = this.colorBarMarginTop;
                        double d3 = this.mCurCarProgress;
                        int n8 = (int)((double)((float)this.height - this.carPointSize - f5) * (1.0 - d3) + (double)f5);
                        if (LogUtil.LOGGABLE) {
                            LogUtil.e(TAG, "onDraw-> mCurCarProgress=" + this.mCurCarProgress + ", curCarPointH=" + n8);
                        }
                        RoadCondBar roadCondBar11 = this;
                        RoadCondBar roadCondBar12 = this;
                        RoadCondBar roadCondBar13 = this;
                        RoadCondBar roadCondBar14 = this;
                        float f13 = this.colorBarEdgeWidth;
                        f4 = n8;
                        f3 = (float)roadCondBar14.width - f13;
                        f7 = (float)roadCondBar14.height - this.carPointSize;
                        Paint paint4 = roadCondBar14.mPassPaint;
                        roadCondBar13.mCacheCanvas.drawRect(f13, f4, f3, f7, paint4);
                        RectF rectF3 = rectF2;
                        RoadCondBar roadCondBar15 = this;
                        RoadCondBar roadCondBar16 = roadCondBar15;
                        f3 = roadCondBar15.colorBarEdgeWidth;
                        float f14 = roadCondBar16.colorBarMarginTop;
                        float f15 = f3;
                        RoadCondBar roadCondBar17 = this;
                        RoadCondBar roadCondBar18 = roadCondBar17;
                        float f16 = roadCondBar17.width;
                        f3 = f16 - this.colorBarEdgeWidth;
                        float f17 = roadCondBar18.height;
                        float f18 = f17 - this.carPointSize;
                        rectF2 = new RectF(f15, f14, f3, f18);
                        float f19 = roadCondBar13.width;
                        f3 = 2.0f;
                        f3 = (f19 - this.colorBarEdgeWidth * f3) / 2.0f;
                        float f20 = roadCondBar13.width;
                        f7 = 2.0f;
                        f7 = (f20 - this.colorBarEdgeWidth * f7) / 2.0f;
                        paint4 = roadCondBar13.mBGPaint;
                        canvas.drawRoundRect(rectF3, f3, f7, paint4);
                        roadCondBar12.mBGPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                        rectF3 = roadCondBar12.mCacheBitmap;
                        f3 = 0.0f;
                        f7 = 0.0f;
                        paint4 = roadCondBar12.mBGPaint;
                        canvas.drawBitmap((Bitmap)rectF3, f3, f7, paint4);
                        roadCondBar11.mBGPaint.setXfermode(null);
                        float f21 = 0.0f;
                        f3 = 0.0f;
                        f7 = roadCondBar11.width;
                        float f22 = roadCondBar11.height;
                        paint = roadCondBar11.mBGPaint;
                        try {
                            canvas.saveLayer(f21, f3, f7, f22, paint, 31);
                        }
                        catch (Exception exception) {
                            if (!LogUtil.LOGGABLE) break block42;
                            LogUtil.printException("RoadCondBar_onDraw", exception);
                        }
                    }
                    Canvas canvas2 = canvas;
                    Canvas canvas3 = canvas2;
                    Canvas canvas4 = canvas2;
                    RoadCondBar roadCondBar = this;
                    RoadCondBar roadCondBar19 = roadCondBar;
                    RoadCondBar roadCondBar20 = roadCondBar;
                    canvas = rectF;
                    float f23 = f4;
                    RoadCondBar roadCondBar21 = this;
                    RoadCondBar roadCondBar22 = roadCondBar21;
                    RoadCondBar roadCondBar23 = roadCondBar21;
                    float f24 = f4;
                    RoadCondBar roadCondBar24 = this;
                    RoadCondBar roadCondBar25 = roadCondBar24;
                    float f25 = roadCondBar24.carPointEdgeWidth;
                    f4 = f24 - roadCondBar25.carPointPlaintEdge;
                    float f26 = roadCondBar22.width;
                    f3 = f26 - this.carPointEdgeWidth;
                    float f27 = f23 + roadCondBar23.carPointSize;
                    float f28 = f27 - this.carPointPlaintEdge;
                    rectF = new RectF(f25, f4, f3, f28);
                    Bitmap bitmap = roadCondBar19.carPointBitmap;
                    Rect rect = null;
                    Paint paint = roadCondBar20.mBGPaint;
                    try {
                        canvas3.drawBitmap(bitmap, rect, (RectF)canvas, paint);
                        canvas4.restore();
                    }
                    catch (Exception exception) {
                        if (!LogUtil.LOGGABLE) break block43;
                        LogUtil.printException("RoadCondBar_onDraw", exception);
                    }
                }
                return;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onDraw-> mCacheBitmap= " + this.mCacheBitmap + ", mCacheCanvas= " + this.mCacheCanvas);
            }
            return;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onDraw-> width= " + this.width + ", height= " + this.height);
        }
    }

    public void updateProgress(double d3) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "updateProgress-> carProgress=" + d3);
        }
        this.mCurCarProgress = d3;
        this.invalidate();
    }

    public void resetData() {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "resetData-> ");
        }
        if ((this = ((RoadCondBar)((Object)this)).mRoadConditionItems) != null) {
            this.clear();
        }
    }

    public void updateData(List<l> list) {
        List<l> list2;
        this.hasSetData = true;
        if (LogUtil.LOGGABLE) {
            StringBuilder stringBuilder;
            list2 = stringBuilder;
            stringBuilder = new StringBuilder("data:");
            if (list != null) {
                if (list.size() <= 0) {
                    LogUtil.e(TAG, "updateData data is empty");
                } else {
                    Iterator<l> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        List<l> list3 = list2;
                        l l2 = iterator.next();
                        ((StringBuilder)((Object)list3)).append("\n\t----");
                        ((StringBuilder)((Object)list3)).append(l2.toString());
                    }
                    LogUtil.e(TAG, "updateData->" + ((StringBuilder)((Object)list2)).toString());
                }
            } else {
                LogUtil.e(TAG, "updateData data is null");
            }
        }
        if (list != null && list.size() != 0) {
            list2 = this.mRoadConditionItems;
            if (list2 != null) {
                list2.clear();
            }
            RoadCondBar roadCondBar = this;
            roadCondBar.mRoadConditionItems.addAll(list);
            List<l> list4 = roadCondBar.mRoadConditionItems;
            roadCondBar.mItemTotalIndex = list4.get((int)(list4.size() - 1)).c;
            return;
        }
    }

    public void recycle() {
        Object object;
        if (LogUtil.LOGGABLE) {
            Log.e((String)TAG, (String)"recycle ->");
        }
        if ((object = this.mCacheBitmap) != null) {
            if (i.a && Build.VERSION.SDK_INT < 28) {
                object.recycle();
            }
            this.mCacheBitmap = null;
        }
        if (this.bgBitmap != null) {
            this.bgBitmap = null;
        }
        if (LogUtil.LOGGABLE) {
            object = TAG;
            StringBuilder stringBuilder = new StringBuilder().append("graphics.Bitmap recycle -> viewHash= ").append(((Object)((Object)this)).hashCode()).append(",BitmapHash = ");
            Object object2 = this.carPointBitmap;
            object2 = object2 == null ? "null" : Integer.valueOf(object2.hashCode());
            Log.e((String)object, (String)stringBuilder.append(object2).toString());
        }
        if ((object = this.carPointBitmap) != null) {
            if (i.a && Build.VERSION.SDK_INT < 28) {
                object.recycle();
            }
            this.carPointBitmap = null;
        }
    }

    public void dispose() {
        if (LogUtil.LOGGABLE) {
            Log.e((String)TAG, (String)"dispose ->");
        }
        RoadCondBar roadCondBar = this;
        roadCondBar.recycle();
        List<l> list = roadCondBar.mRoadConditionItems;
        if (list != null) {
            list.clear();
        }
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
    }
}

