/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.baidu.navisdk.embed.R;

public class RoundImageView
extends ImageView {
    private Path mClipPath;
    private float mRadio = 1.0f;
    private float mRadius = 0.0f;

    public RoundImageView(Context context) {
        this(context, null);
    }

    public RoundImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public RoundImageView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        if (attributeSet != null) {
            context = context.obtainStyledAttributes(attributeSet, R.styleable.RoundedImageView);
            int n3 = R.styleable.RoundedImageView_roundedImageViewSizeRadio;
            this.mRadio = context.getFloat(n3, this.mRadio);
            this.mRadius = context.getDimensionPixelSize(R.styleable.RoundedImageView_roundedImageViewCornerRadius, (int)this.mRadius);
            context.recycle();
        }
    }

    public void setRadio(float f3) {
        this.mRadio = f3;
    }

    public void setRadius(float f3) {
        this.mRadius = f3;
    }

    protected void onMeasure(int n2, int n3) {
        if (this.mRadio <= 0.0f) {
            super.onMeasure(n2, n3);
        } else {
            n2 = View.MeasureSpec.getSize((int)n2);
            int n4 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
            super.onMeasure(n4, View.MeasureSpec.makeMeasureSpec((int)((int)((float)n2 / this.mRadio)), (int)0x40000000));
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mClipPath == null) {
            this.mClipPath = new Path();
            RoundImageView roundImageView = this;
            float f3 = roundImageView.getWidth();
            float f4 = roundImageView.getHeight();
            RectF rectF = new RectF(0.0f, 0.0f, f3, f4);
            float[] fArray = new float[8];
            float[] fArray2 = fArray;
            fArray[0] = f4 = this.mRadius;
            fArray[1] = f4;
            fArray[2] = f4;
            fArray[3] = f4;
            fArray[4] = f4;
            fArray[5] = f4;
            fArray[6] = f4;
            fArray[7] = f4;
            this.mClipPath.addRoundRect(rectF, fArray2, Path.Direction.CW);
        }
        Canvas canvas2 = canvas;
        canvas2.clipPath(this.mClipPath);
        super.onDraw(canvas2);
    }

    public static final class Size {
        public final float width;
        public final float height;

        public Size(float f3, float f4) {
            this.width = f3;
            this.height = f4;
        }
    }
}

