/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import java.util.ArrayList;
import java.util.List;

public class SoftKeyboardStateHelper
implements ViewTreeObserver.OnGlobalLayoutListener {
    public static final int SOFT_KEYBOARD_HEIGHT_MIN = 200;
    private final List<SoftKeyboardStateListener> listeners = new ArrayList<SoftKeyboardStateListener>(4);
    private final View viewRoot;
    private int windowHeight = 0;
    private int lastSoftKeyboardHeightInPx;
    private boolean isSoftKeyboardOpened;
    private Activity mActivity;
    private Rect mRect = new Rect();

    public SoftKeyboardStateHelper(Activity activity, View view) {
        this(activity, view, false);
    }

    public SoftKeyboardStateHelper(Activity activity, View view, boolean bl) {
        this.viewRoot = view;
        this.isSoftKeyboardOpened = bl;
        this.mActivity = activity;
        view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private void notifyOnSoftKeyboardOpened(int n2) {
        ((SoftKeyboardStateHelper)this).lastSoftKeyboardHeightInPx = n2;
        for (SoftKeyboardStateListener softKeyboardStateListener : ((SoftKeyboardStateHelper)this).listeners) {
            if (softKeyboardStateListener == null) continue;
            softKeyboardStateListener.onSoftKeyboardOpened(n2);
        }
    }

    private void notifyOnSoftKeyboardClosed() {
        for (SoftKeyboardStateListener softKeyboardStateListener : ((SoftKeyboardStateHelper)this).listeners) {
            if (softKeyboardStateListener == null) continue;
            softKeyboardStateListener.onSoftKeyboardClosed();
        }
    }

    public void onGlobalLayout() {
        Activity activity = this.mActivity;
        if (activity != null && this.viewRoot != null) {
            if (this.windowHeight <= 0) {
                this.windowHeight = activity.getWindow().getDecorView().getRootView().getHeight();
            }
            SoftKeyboardStateHelper softKeyboardStateHelper = this;
            softKeyboardStateHelper.mRect.setEmpty();
            softKeyboardStateHelper.viewRoot.getWindowVisibleDisplayFrame(this.mRect);
            int n2 = softKeyboardStateHelper.windowHeight - this.mRect.bottom;
            if (!softKeyboardStateHelper.isSoftKeyboardOpened && n2 > 200) {
                this.isSoftKeyboardOpened = true;
                this.notifyOnSoftKeyboardOpened(n2);
            } else if (this.isSoftKeyboardOpened && n2 < 200) {
                this.isSoftKeyboardOpened = false;
                this.notifyOnSoftKeyboardClosed();
            }
            return;
        }
    }

    public void setIsSoftKeyboardOpened(boolean bl) {
        this.isSoftKeyboardOpened = bl;
    }

    public boolean isSoftKeyboardOpened() {
        return this.isSoftKeyboardOpened;
    }

    public int getLastSoftKeyboardHeightInPx() {
        return this.lastSoftKeyboardHeightInPx;
    }

    public void addSoftKeyboardStateListener(SoftKeyboardStateListener softKeyboardStateListener) {
        this.listeners.add(softKeyboardStateListener);
    }

    public void removeSoftKeyboardStateListener(SoftKeyboardStateListener softKeyboardStateListener) {
        this.listeners.remove(softKeyboardStateListener);
    }

    public void onDestroy() {
        this.mActivity = null;
        View view = this.viewRoot;
        if (view != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        this.listeners.clear();
        this.mRect = null;
    }

    public static interface SoftKeyboardStateListener {
        public void onSoftKeyboardOpened(int var1);

        public void onSoftKeyboardClosed();
    }
}

