/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.routeguide.subview.widget.a;
import com.baidu.navisdk.util.common.ScreenUtil;
import com.baidu.navisdk.util.jar.JarUtils;
import com.baidu.navisdk.util.worker.d;
import com.baidu.navisdk.util.worker.f;
import com.baidu.navisdk.util.worker.h;

public class SwitchButton
extends CheckBox {
    private static final int MAX_ALPHA = 255;
    private static final float VELOCITY = 350.0f;
    private static final float EXTENDED_OFFSET_Y = 15.0f;
    private Paint mPaint;
    private ViewParent mParent;
    private Context mContext;
    private Bitmap mBottom;
    private Bitmap mCurBtnPic;
    private Bitmap mBtnPressed;
    private Bitmap mBtnNormal;
    private Bitmap mFrame;
    private Bitmap mMask;
    private RectF mSaveLayerRectF;
    private PorterDuffXfermode mXfermode;
    private float mFirstDownY;
    private float mFirstDownX;
    private float mRealPos;
    private float mBtnPos;
    private float mBtnOnPos;
    private float mBtnOffPos;
    private float mMaskWidth;
    private float mMaskHeight;
    private float mBtnWidth;
    private int mClickTimeout;
    private int mTouchSlop;
    private int mAlpha;
    private boolean mChecked;
    private boolean mBroadcasting;
    private CompoundButton.OnCheckedChangeListener mOnCheckedChangeListener;
    private CompoundButton.OnCheckedChangeListener mOnCheckedChangeWidgetListener;
    private boolean mAnimating;
    private float mVelocity;
    private float mExtendOffsetY;
    private float mAnimationPosition;
    private float mAnimatedVelocity;
    private boolean mDayStyle;

    public SwitchButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842860);
    }

    public SwitchButton(Context context) {
        this(context, null);
    }

    public SwitchButton(Context context, AttributeSet attributeSet, int n2) {
        SwitchButton switchButton = this;
        super(context, attributeSet, n2);
        switchButton.mAlpha = 255;
        switchButton.mChecked = false;
        switchButton.mDayStyle = true;
        switchButton.initView(context);
    }

    private void initView(Context context) {
        float f3;
        float f4;
        Context context2 = context;
        SwitchButton switchButton = this;
        switchButton.mContext = context;
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        context = JarUtils.getResources();
        switchButton.mClickTimeout = ViewConfiguration.getPressedStateDuration() + ViewConfiguration.getTapTimeout();
        this.mTouchSlop = ViewConfiguration.get((Context)context2).getScaledTouchSlop();
        if (this.mDayStyle) {
            this.mBottom = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_switch_bottom);
            if (this.mChecked) {
                this.mBtnPressed = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_btn_switch_off_pressed);
                this.mBtnNormal = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_btn_switch_off_normal);
            } else {
                this.mBtnPressed = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_btn_switch_on_pressed);
                this.mBtnNormal = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_btn_switch_on_normal);
            }
            this.mFrame = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_switch_frame);
            this.mMask = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_switch_mask);
        } else {
            this.mBottom = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_switch_bottom_night);
            if (this.mChecked) {
                this.mBtnPressed = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_btn_switch_off_pressed_night);
                this.mBtnNormal = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_btn_switch_off_normal_night);
            } else {
                this.mBtnPressed = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_btn_switch_on_pressed_night);
                this.mBtnNormal = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_btn_switch_on_normal_night);
            }
            this.mFrame = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_switch_frame_night);
            this.mMask = BitmapFactory.decodeResource((Resources)context, (int)R.drawable.nsdk_drawable_rg_switch_mask_night);
        }
        SwitchButton switchButton2 = this;
        switchButton2.mCurBtnPic = switchButton2.mBtnNormal;
        switchButton2.mBtnWidth = switchButton2.mBtnPressed.getWidth();
        switchButton2.mMaskWidth = switchButton2.mMask.getWidth();
        switchButton2.mMaskHeight = switchButton2.mMask.getHeight();
        switchButton2.mBtnOffPos = f4 = switchButton2.mBtnWidth / 2.0f;
        switchButton2.mBtnOnPos = f3 = switchButton2.mMaskWidth - f4;
        if (!switchButton2.mChecked) {
            f3 = f4;
        }
        this.mBtnPos = f3;
        this.mRealPos = this.getRealPos(f3);
        this.mVelocity = ScreenUtil.getInstance().dip2px(350.0f);
        this.mExtendOffsetY = ScreenUtil.getInstance().dip2px(15.0f);
        SwitchButton switchButton3 = this;
        f4 = switchButton3.mExtendOffsetY;
        f3 = switchButton3.mMask.getWidth();
        float f5 = (float)switchButton3.mMask.getHeight() + this.mExtendOffsetY;
        this.mSaveLayerRectF = new RectF(0.0f, f4, f3, f5);
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
    }

    private void setCheckedDelayed(final boolean bl) {
        d.a().submitMainThreadTaskDelay(new h<String, String>("setCheckedDelayed-" + SwitchButton.class.getSimpleName(), null){

            @Override
            protected String execute() {
                SwitchButton.this.setInternalChecked(bl);
                return null;
            }
        }, new f(99, 0), 10L);
    }

    private void setInternalChecked(boolean bl) {
        this.mChecked = bl;
        float f3 = bl ? this.mBtnOnPos : this.mBtnOffPos;
        SwitchButton switchButton = this;
        this.mBtnPos = f3;
        switchButton.mRealPos = switchButton.getRealPos(f3);
        switchButton.invalidate();
        if (switchButton.mBroadcasting) {
            return;
        }
        this.mBroadcasting = true;
        Resources resources = JarUtils.getResources();
        if (this.mDayStyle) {
            if (this.mChecked) {
                SwitchButton switchButton2 = this;
                this.mBtnPressed = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.nsdk_drawable_rg_btn_switch_off_pressed);
                resources = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.nsdk_drawable_rg_btn_switch_off_normal);
                switchButton2.mBtnNormal = resources;
                switchButton2.mCurBtnPic = resources;
            } else {
                SwitchButton switchButton3 = this;
                this.mBtnPressed = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.nsdk_drawable_rg_btn_switch_on_pressed);
                resources = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.nsdk_drawable_rg_btn_switch_on_normal);
                switchButton3.mBtnNormal = resources;
                switchButton3.mCurBtnPic = resources;
            }
        } else if (this.mChecked) {
            SwitchButton switchButton4 = this;
            this.mBtnPressed = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.nsdk_drawable_rg_btn_switch_off_pressed_night);
            resources = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.nsdk_drawable_rg_btn_switch_off_normal_night);
            switchButton4.mBtnNormal = resources;
            switchButton4.mCurBtnPic = resources;
        } else {
            SwitchButton switchButton5 = this;
            this.mBtnPressed = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.nsdk_drawable_rg_btn_switch_on_pressed_night);
            resources = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.nsdk_drawable_rg_btn_switch_on_normal_night);
            switchButton5.mBtnNormal = resources;
            switchButton5.mCurBtnPic = resources;
        }
        SwitchButton switchButton6 = this;
        switchButton6.invalidate();
        resources = switchButton6.mOnCheckedChangeListener;
        if (resources != null) {
            SwitchButton switchButton7 = this;
            resources.onCheckedChanged((CompoundButton)switchButton7, switchButton7.mChecked ^ true);
        }
        if ((resources = this.mOnCheckedChangeWidgetListener) != null) {
            resources.onCheckedChanged((CompoundButton)this, this.mChecked);
        }
        this.mBroadcasting = false;
    }

    private void attemptClaimDrag() {
        ViewParent viewParent;
        this.mParent = viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    private float getRealPos(float f3) {
        return f3 - this.mBtnWidth / 2.0f;
    }

    private void startAnimation(boolean bl) {
        this.mAnimating = true;
        float f3 = bl ? -this.mVelocity : this.mVelocity;
        this.mAnimatedVelocity = f3;
        this.mAnimationPosition = this.mBtnPos;
        new SwitchAnimation().run();
    }

    private void stopAnimation() {
        this.mAnimating = false;
    }

    private void doAnimation() {
        SwitchButton switchButton;
        float f3;
        float f4;
        this.mAnimationPosition = f4 = this.mAnimationPosition + this.mAnimatedVelocity * 16.0f / 1000.0f;
        if (f3 <= switchButton.mBtnOnPos - 8.0f) {
            SwitchButton switchButton2 = this;
            switchButton2.stopAnimation();
            switchButton2.mAnimationPosition = switchButton2.mBtnOnPos - 8.0f;
            switchButton2.setCheckedDelayed(true);
        } else if (f4 >= this.mBtnOffPos + 8.0f) {
            SwitchButton switchButton3 = this;
            switchButton3.stopAnimation();
            switchButton3.mAnimationPosition = switchButton3.mBtnOffPos + 8.0f;
            switchButton3.setCheckedDelayed(false);
        }
        SwitchButton switchButton4 = this;
        switchButton4.moveView(switchButton4.mAnimationPosition);
    }

    private void moveView(float f3) {
        SwitchButton switchButton = this;
        this.mBtnPos = f3;
        switchButton.mRealPos = switchButton.getRealPos(f3);
        switchButton.invalidate();
    }

    public void setEnabled(boolean bl) {
        int n2 = bl ? 255 : 127;
        this.mAlpha = n2;
        super.setEnabled(bl);
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        SwitchButton switchButton = this;
        switchButton.setInternalChecked(switchButton.mChecked ^ true);
    }

    public void setChecked(boolean bl) {
        this.setInternalChecked(bl ^ true);
    }

    public void setOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeListener = onCheckedChangeListener;
    }

    void setOnCheckedChangeWidgetListener(CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeWidgetListener = onCheckedChangeListener;
    }

    public boolean performClick() {
        SwitchButton switchButton = this;
        switchButton.startAnimation(switchButton.mChecked ^ true);
        return true;
    }

    protected void onDraw(Canvas canvas) {
        SwitchButton switchButton;
        float f3;
        SwitchButton switchButton2 = switchButton;
        SwitchButton switchButton3 = switchButton;
        SwitchButton switchButton4 = switchButton;
        RectF rectF = switchButton4.mSaveLayerRectF;
        canvas.saveLayerAlpha(rectF, switchButton4.mAlpha);
        rectF = switchButton3.mMask;
        float f4 = switchButton3.mExtendOffsetY;
        Paint paint = switchButton3.mPaint;
        canvas.drawBitmap((Bitmap)rectF, 0.0f, f4, paint);
        switchButton2.mPaint.setXfermode((Xfermode)switchButton.mXfermode);
        if (switchButton2.mChecked) {
            SwitchButton switchButton5 = switchButton;
            rectF = switchButton5.mBottom;
            f4 = switchButton5.mRealPos - 4.0f;
            f3 = switchButton5.mExtendOffsetY;
            Paint paint2 = switchButton5.mPaint;
            canvas.drawBitmap((Bitmap)rectF, f4, f3, paint2);
        } else {
            SwitchButton switchButton6 = switchButton;
            rectF = switchButton6.mBottom;
            f4 = switchButton6.mRealPos + 4.0f;
            f3 = switchButton6.mExtendOffsetY;
            Paint paint3 = switchButton6.mPaint;
            canvas.drawBitmap((Bitmap)rectF, f4, f3, paint3);
        }
        SwitchButton switchButton7 = switchButton;
        switchButton7.mPaint.setXfermode(null);
        rectF = switchButton7.mFrame;
        f4 = switchButton7.mExtendOffsetY;
        Paint paint4 = switchButton7.mPaint;
        canvas.drawBitmap((Bitmap)rectF, 0.0f, f4, paint4);
        if (switchButton.mChecked) {
            SwitchButton switchButton8 = switchButton;
            switchButton = switchButton8.mCurBtnPic;
            float f5 = switchButton8.mRealPos - 4.0f;
            f4 = switchButton8.mExtendOffsetY;
            paint4 = switchButton8.mPaint;
            canvas.drawBitmap((Bitmap)switchButton, f5, f4, paint4);
        } else {
            SwitchButton switchButton9 = switchButton;
            switchButton = switchButton9.mCurBtnPic;
            float f6 = switchButton9.mRealPos + 4.0f;
            f4 = switchButton9.mExtendOffsetY;
            paint4 = switchButton9.mPaint;
            canvas.drawBitmap((Bitmap)switchButton, f6, f4, paint4);
        }
        canvas.restore();
    }

    protected void onMeasure(int n2, int n3) {
        SwitchButton switchButton = this;
        switchButton.setMeasuredDimension((int)switchButton.mMaskWidth, (int)(this.mMaskHeight + this.mExtendOffsetY * 2.0f));
    }

    public void setDayStyle(boolean bl) {
        SwitchButton switchButton = this;
        switchButton.mDayStyle = bl;
        try {
            switchButton.initView(switchButton.mContext);
            switchButton.invalidate();
        }
        catch (Exception exception) {}
    }

    private final class SwitchAnimation
    implements Runnable {
        private SwitchAnimation() {
        }

        @Override
        public void run() {
            if (!SwitchButton.this.mAnimating) {
                return;
            }
            SwitchAnimation switchAnimation = this;
            switchAnimation.SwitchButton.this.doAnimation();
            a.a(switchAnimation);
        }
    }

    private final class PerformClick
    implements Runnable {
        private PerformClick() {
        }

        @Override
        public void run() {
            SwitchButton.this.performClick();
        }
    }
}

