/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.dragbtn;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.util.common.LogUtil;

public class DraggingButton
extends FrameLayout {
    private static final String TAG = "DraggingButton";
    private ImageView mImageBtn;
    private ImageView mCloseBtn;
    private float mLastRawX;
    private float mLastRawY;
    private boolean isDragging;
    private boolean isDragged;
    private int mRootMeasuredWidth;
    private int mRootMeasuredHeight;
    private int mRootTopY;
    private boolean attachable;
    private boolean draggable;
    private int attachMarginLeft;
    private int attachMarginRight;
    private int attachMarginTop;
    private int attachMarginBottom;

    public DraggingButton(Context context) {
        this(context, null);
    }

    public DraggingButton(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DraggingButton(Context context, @Nullable AttributeSet attributeSet, int n2) {
        DraggingButton draggingButton = this;
        super(context, attributeSet, n2);
        draggingButton.isDragging = false;
        draggingButton.isDragged = false;
        draggingButton.mRootMeasuredWidth = 0;
        draggingButton.mRootMeasuredHeight = 0;
        draggingButton.mRootTopY = 0;
        draggingButton.initAttrs(context, attributeSet);
    }

    private void initAttrs(Context context, AttributeSet attributeSet) {
        DraggingButton draggingButton = this;
        LayoutInflater.from((Context)context).inflate(R.layout.nsdk_layout_dragging_button_layout, (ViewGroup)this);
        draggingButton.mCloseBtn = (ImageView)draggingButton.findViewById(R.id.close_btn);
        draggingButton.mImageBtn = (ImageView)draggingButton.findViewById(R.id.dragging_image);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.DraggingButton);
        this.attachable = context.getBoolean(R.styleable.DraggingButton_nsdk_attachable, true);
        this.draggable = context.getBoolean(R.styleable.DraggingButton_nsdk_draggable, true);
        this.attachMarginLeft = context.getDimensionPixelSize(R.styleable.DraggingButton_nsdk_attach_margin_left, 0);
        this.attachMarginRight = context.getDimensionPixelSize(R.styleable.DraggingButton_nsdk_attach_margin_right, 0);
        this.attachMarginTop = context.getDimensionPixelSize(R.styleable.DraggingButton_nsdk_attach_margin_top, 0);
        this.attachMarginBottom = context.getDimensionPixelSize(R.styleable.DraggingButton_nsdk_attach_margin_bottom, 0);
        context.recycle();
    }

    private void autoLeft() {
        this.animate().setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(100L).x((float)this.attachMarginLeft).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (DraggingButton.this.mCloseBtn != null) {
                    1 v02 = this;
                    v02.DraggingButton.this.mCloseBtn.setVisibility(0);
                    v02.DraggingButton.this.mCloseBtn.setRotation(180.0f);
                    ((RelativeLayout.LayoutParams)v02.DraggingButton.this.mCloseBtn.getLayoutParams()).removeRule(11);
                    ((RelativeLayout.LayoutParams)v02.DraggingButton.this.mCloseBtn.getLayoutParams()).addRule(9);
                    v02.DraggingButton.this.mCloseBtn.requestLayout();
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private void autoRight() {
        this.animate().setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(100L).x((float)(this.mRootMeasuredWidth - this.getWidth() - this.attachMarginRight)).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (DraggingButton.this.mCloseBtn != null) {
                    2 v02 = this;
                    v02.DraggingButton.this.mCloseBtn.setVisibility(0);
                    v02.DraggingButton.this.mCloseBtn.setRotation(0.0f);
                    ((RelativeLayout.LayoutParams)v02.DraggingButton.this.mCloseBtn.getLayoutParams()).removeRule(9);
                    ((RelativeLayout.LayoutParams)v02.DraggingButton.this.mCloseBtn.getLayoutParams()).addRule(11);
                    v02.DraggingButton.this.mCloseBtn.requestLayout();
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private boolean isBtnAttachLeft() {
        return this.getX() - (float)this.attachMarginLeft < (float)(this.mRootMeasuredWidth - this.getWidth() - this.attachMarginRight) - this.getX();
    }

    private void initParentView() {
        ViewGroup viewGroup = (ViewGroup)this.getParent();
        if (viewGroup != null) {
            int[] nArray = new int[2];
            ViewGroup viewGroup2 = viewGroup;
            viewGroup2.getLocationInWindow(nArray);
            this.mRootMeasuredHeight = viewGroup2.getMeasuredHeight();
            this.mRootMeasuredWidth = viewGroup.getMeasuredWidth();
            this.mRootTopY = nArray[1];
        }
    }

    public ImageView getDraggingImageView() {
        return this.mImageBtn;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        super.dispatchTouchEvent(motionEvent);
        return true;
    }

    public void setOnCloseClickListener(View.OnClickListener onClickListener) {
        DraggingButton draggingButton = draggingButton.mCloseBtn;
        if (draggingButton != null) {
            draggingButton.setOnClickListener(onClickListener);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.draggable) {
            MotionEvent motionEvent2 = motionEvent;
            float f3 = motionEvent2.getRawX();
            float f4 = motionEvent2.getRawY();
            int n2 = motionEvent2.getAction();
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 == 2 && f3 >= 0.0f && f3 <= (float)this.mRootMeasuredWidth) {
                        int n3;
                        n2 = this.mRootTopY;
                        if (f4 >= (float)n3 && f4 <= (float)(this.mRootMeasuredHeight + n2)) {
                            int n4;
                            int n5;
                            float f5;
                            float f6 = f3 - this.mLastRawX;
                            float f7 = f4 - this.mLastRawY;
                            if (!this.isDragging) {
                                float f8 = f6;
                                float f9 = f7;
                                boolean bl = !(Math.sqrt(f8 * f8 + f9 * f9) < 2.0);
                                this.isDragging = bl;
                                if (LogUtil.LOGGABLE) {
                                    LogUtil.e(TAG, "onTouchEvent() --> isDragging = " + this.isDragging);
                                }
                                if (this.isDragging) {
                                    ImageView imageView = this.mCloseBtn;
                                    if (imageView != null) {
                                        imageView.setVisibility(8);
                                    }
                                    this.isDragged = true;
                                }
                            }
                            float f10 = f6;
                            f6 = this.getY();
                            float f11 = this.getX() + f10;
                            DraggingButton draggingButton = this;
                            f6 += f7;
                            f7 = draggingButton.mRootMeasuredWidth - this.getWidth() - this.attachMarginRight;
                            float f12 = draggingButton.mRootMeasuredHeight - this.getHeight() - this.attachMarginBottom;
                            int n6 = draggingButton.attachMarginLeft;
                            f7 = f5 < (float)n5 ? (float)n6 : Math.min(f11, f7);
                            int n7 = this.attachMarginTop;
                            f6 = f6 < (float)n4 ? (float)n7 : Math.min(f6, f12);
                            DraggingButton draggingButton2 = this;
                            draggingButton2.setX(f7);
                            draggingButton2.setY(f6);
                            draggingButton2.mLastRawX = f3;
                            draggingButton2.mLastRawY = f4;
                        }
                    }
                } else if (this.attachable && this.isDragging) {
                    DraggingButton draggingButton = this;
                    f3 = (float)draggingButton.mRootMeasuredWidth / 2.0f;
                    if (draggingButton.mLastRawX <= f3) {
                        this.autoLeft();
                    } else {
                        this.autoRight();
                    }
                }
            } else {
                this.isDragging = false;
                this.mLastRawX = f3;
                this.mLastRawY = f4;
                this.initParentView();
            }
        }
        return this.isDragging || super.onTouchEvent(motionEvent);
    }

    public boolean isDragged() {
        return this.draggable && this.isDragged;
    }

    public void setAttachable(boolean bl) {
        this.attachable = bl;
    }

    public void setDraggable(boolean bl) {
        this.draggable = bl;
    }

    public void setAttachMarginLeft(final int n2) {
        Runnable runnable;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setAttachMarginLeft() --> attachMarginLeft = " + n2);
        }
        this.attachMarginLeft = n2;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                3 v02 = this;
                v02.DraggingButton.this.initParentView();
                if (v02.DraggingButton.this.mRootMeasuredWidth > 0 && DraggingButton.this.isBtnAttachLeft()) {
                    DraggingButton.this.setX(n2);
                }
            }
        };
        this.post(runnable2);
    }

    public void setAttachMarginRight(final int n2) {
        Runnable runnable;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setAttachMarginRight() --> attachMarginRight = " + n2);
        }
        this.attachMarginRight = n2;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                4 v02 = this;
                v02.DraggingButton.this.initParentView();
                if (v02.DraggingButton.this.mRootMeasuredWidth > 0 && DraggingButton.this.isBtnAttachLeft()) {
                    DraggingButton draggingButton = DraggingButton.this;
                    draggingButton.setX(draggingButton.mRootMeasuredWidth - DraggingButton.this.getWidth() - n2);
                }
            }
        };
        this.post(runnable2);
    }

    public void setAttachMarginTop(final int n2) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setAttachMarginTop() --> attachMarginTop = " + n2 + ", isDragged = " + this.isDragged);
        }
        this.attachMarginTop = n2;
        if (this.isDragged) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    DraggingButton.this.initParentView();
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(DraggingButton.TAG, "setAttachMarginTop() --> mRootMeasuredHeight = " + DraggingButton.this.mRootMeasuredHeight + ", getY = " + DraggingButton.this.getY() + ", attachMarginTop = " + n2);
                    }
                    if (DraggingButton.this.mRootMeasuredHeight > 0 && DraggingButton.this.getY() != 0.0f) {
                        int n22;
                        int n3 = n2;
                        if (DraggingButton.this.getY() < (float)n22) {
                            DraggingButton.this.setY(n3);
                        }
                    }
                }
            };
            this.post(runnable2);
        }
    }

    public void setAttachMarginBottom(final int n2) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setAttachMarginBottom() --> attachMarginBottom = " + n2 + ", isDragged = " + this.isDragged);
        }
        this.attachMarginBottom = n2;
        if (this.isDragged) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    DraggingButton.this.initParentView();
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(DraggingButton.TAG, "setAttachMarginBottom() --> mRootMeasuredHeight = " + DraggingButton.this.mRootMeasuredHeight + ", getY = " + DraggingButton.this.getY() + ", getHeight = " + DraggingButton.this.getHeight() + ", attachMarginBottom = " + n2);
                    }
                    if (DraggingButton.this.mRootMeasuredHeight > 0 && DraggingButton.this.getY() != 0.0f && DraggingButton.this.getY() > (float)(DraggingButton.this.mRootMeasuredHeight - DraggingButton.this.getHeight() - n2)) {
                        DraggingButton draggingButton = DraggingButton.this;
                        draggingButton.setY(draggingButton.mRootMeasuredHeight - DraggingButton.this.getHeight() - n2);
                    }
                }
            };
            this.post(runnable2);
        }
    }
}

