/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.likebutton;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import com.baidu.navisdk.ui.widget.likebutton.Utils;

public class DotsView
extends View {
    private static final int DOTS_COUNT = 8;
    private static final int OUTER_DOTS_POSITION_ANGLE = 45;
    public static final Property<DotsView, Float> DOTS_PROGRESS = new Property<DotsView, Float>(Float.class, "dotsProgress"){

        public Float get(DotsView dotsView) {
            return Float.valueOf(dotsView.getCurrentProgress());
        }

        public void set(DotsView dotsView, Float f3) {
            dotsView.setCurrentProgress(f3.floatValue());
        }
    };
    private int COLOR_1;
    private int COLOR_2;
    private int COLOR_3;
    private int COLOR_4;
    private final Paint[] circlePaints;
    private int centerX;
    private int centerY;
    private float maxOuterDotsRadius;
    private float maxDotSize;
    private float currentProgress;
    private float currentRadius1;
    private float currentDotSize1;
    private ArgbEvaluator argbEvaluator;

    public DotsView(Context context) {
        DotsView dotsView = this;
        super(context);
        dotsView.COLOR_1 = -16121;
        dotsView.COLOR_2 = -26624;
        dotsView.COLOR_3 = -43230;
        dotsView.COLOR_4 = -769226;
        dotsView.circlePaints = new Paint[4];
        dotsView.currentProgress = 0.0f;
        dotsView.currentRadius1 = 0.0f;
        dotsView.currentDotSize1 = 0.0f;
        dotsView.argbEvaluator = new ArgbEvaluator();
        dotsView.init();
    }

    public DotsView(Context context, AttributeSet attributeSet) {
        DotsView dotsView = this;
        super(context, attributeSet);
        dotsView.COLOR_1 = -16121;
        dotsView.COLOR_2 = -26624;
        dotsView.COLOR_3 = -43230;
        dotsView.COLOR_4 = -769226;
        dotsView.circlePaints = new Paint[4];
        dotsView.currentProgress = 0.0f;
        dotsView.currentRadius1 = 0.0f;
        dotsView.currentDotSize1 = 0.0f;
        dotsView.argbEvaluator = new ArgbEvaluator();
        dotsView.init();
    }

    public DotsView(Context context, AttributeSet attributeSet, int n2) {
        DotsView dotsView = this;
        super(context, attributeSet, n2);
        dotsView.COLOR_1 = -16121;
        dotsView.COLOR_2 = -26624;
        dotsView.COLOR_3 = -43230;
        dotsView.COLOR_4 = -769226;
        dotsView.circlePaints = new Paint[4];
        dotsView.currentProgress = 0.0f;
        dotsView.currentRadius1 = 0.0f;
        dotsView.currentDotSize1 = 0.0f;
        dotsView.argbEvaluator = new ArgbEvaluator();
        dotsView.init();
    }

    private void init() {
        Paint paint;
        for (int i3 = 0; i3 < ((Paint[])(paint = this.circlePaints)).length; ++i3) {
            Paint paint2;
            Paint paint3 = paint;
            paint = paint2;
            paint2 = new Paint();
            paint3[i3] = paint;
            this.circlePaints[i3].setStyle(Paint.Style.FILL);
        }
    }

    private void drawOuterDotsFrame(Canvas canvas) {
        for (int i3 = 0; i3 < 8; ++i3) {
            DotsView dotsView = this;
            double d3 = (double)(i3 * 45) * Math.PI / 180.0;
            int n2 = (int)((double)dotsView.centerX + (double)this.currentRadius1 * Math.cos(d3));
            float f3 = n2;
            float f4 = (int)((double)dotsView.centerY + (double)this.currentRadius1 * Math.sin(d3));
            float f5 = dotsView.currentDotSize1;
            Paint[] paintArray = dotsView.circlePaints;
            Paint paint = paintArray[i3 % paintArray.length];
            canvas.drawCircle(f3, f4, f5, paint);
        }
    }

    private void updateOuterDotsPosition() {
        double d3;
        float f3;
        float f4 = this.currentProgress;
        if (f3 < 0.3f) {
            d3 = this.maxOuterDotsRadius * 0.8f;
            this.currentRadius1 = (float)Utils.mapValueFromRangeToRange(f4, 0.0, 0.3f, 0.0, d3);
        } else {
            float f5 = this.maxOuterDotsRadius;
            d3 = f5 * 0.8f;
            double d4 = f5;
            this.currentRadius1 = (float)Utils.mapValueFromRangeToRange(f4, 0.3f, 1.0, d3, d4);
        }
        float f6 = this.currentProgress;
        if (f6 == 0.0f) {
            this.currentDotSize1 = 0.0f;
        } else {
            double d5;
            double d6 = f6;
            if (d5 < 0.7) {
                this.currentDotSize1 = this.maxDotSize;
            } else {
                double d7 = d6;
                d6 = this.maxDotSize;
                this.currentDotSize1 = (float)Utils.mapValueFromRangeToRange(d7, 0.7f, 1.0, d6, 0.0);
            }
        }
    }

    private void updateDotsPaints() {
        Object object;
        float f3;
        float f4 = object.currentProgress;
        if (f3 < 0.5f) {
            DotsView dotsView = object;
            f4 = (float)Utils.mapValueFromRangeToRange(f4, 0.0, 0.5, 0.0, 1.0);
            DotsView dotsView2 = object;
            Integer n2 = dotsView2.COLOR_1;
            dotsView.circlePaints[0].setColor(((Integer)object.argbEvaluator.evaluate(f4, (Object)n2, (Object)dotsView2.COLOR_2)).intValue());
            DotsView dotsView3 = object;
            n2 = dotsView3.COLOR_2;
            dotsView.circlePaints[1].setColor(((Integer)object.argbEvaluator.evaluate(f4, (Object)n2, (Object)dotsView3.COLOR_3)).intValue());
            DotsView dotsView4 = object;
            n2 = dotsView4.COLOR_3;
            dotsView.circlePaints[2].setColor(((Integer)object.argbEvaluator.evaluate(f4, (Object)n2, (Object)dotsView4.COLOR_4)).intValue());
            DotsView dotsView5 = object;
            object = dotsView5.COLOR_4;
            dotsView.circlePaints[3].setColor(((Integer)object.argbEvaluator.evaluate(f4, object, (Object)dotsView5.COLOR_1)).intValue());
        } else {
            DotsView dotsView = object;
            f4 = (float)Utils.mapValueFromRangeToRange(f4, 0.5, 1.0, 0.0, 1.0);
            DotsView dotsView6 = object;
            Integer n3 = dotsView6.COLOR_2;
            dotsView.circlePaints[0].setColor(((Integer)object.argbEvaluator.evaluate(f4, (Object)n3, (Object)dotsView6.COLOR_3)).intValue());
            DotsView dotsView7 = object;
            n3 = dotsView7.COLOR_3;
            dotsView.circlePaints[1].setColor(((Integer)object.argbEvaluator.evaluate(f4, (Object)n3, (Object)dotsView7.COLOR_4)).intValue());
            DotsView dotsView8 = object;
            n3 = dotsView8.COLOR_4;
            dotsView.circlePaints[2].setColor(((Integer)object.argbEvaluator.evaluate(f4, (Object)n3, (Object)dotsView8.COLOR_1)).intValue());
            DotsView dotsView9 = object;
            object = dotsView9.COLOR_1;
            dotsView.circlePaints[3].setColor(((Integer)object.argbEvaluator.evaluate(f4, object, (Object)dotsView9.COLOR_2)).intValue());
        }
    }

    private void updateDotsAlpha() {
        DotsView dotsView = this;
        int n2 = (int)Utils.mapValueFromRangeToRange((float)Utils.clamp(dotsView.currentProgress, 0.6f, 1.0), 0.6f, 1.0, 255.0, 0.0);
        dotsView.circlePaints[0].setAlpha(n2);
        dotsView.circlePaints[1].setAlpha(n2);
        dotsView.circlePaints[2].setAlpha(n2);
        dotsView.circlePaints[3].setAlpha(n2);
    }

    private float dip2px(Context context, float f3) {
        return context.getResources().getDisplayMetrics().density * f3 + 0.5f;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        float f3;
        DotsView dotsView = this;
        super.onSizeChanged(n2, n3, n4, n5);
        this.centerX = n2 /= 2;
        dotsView.centerY = n3 / 2;
        dotsView.maxDotSize = f3 = dotsView.dip2px(dotsView.getContext(), 0.75f);
        DotsView dotsView2 = this;
        dotsView.maxOuterDotsRadius = (float)n2 - f3 * 2.0f + dotsView2.dip2px(dotsView2.getContext(), 12.0f);
    }

    protected void onDraw(Canvas canvas) {
        this.drawOuterDotsFrame(canvas);
    }

    public void setCurrentProgress(float f3) {
        DotsView dotsView = this;
        dotsView.currentProgress = f3;
        dotsView.updateOuterDotsPosition();
        dotsView.updateDotsPaints();
        dotsView.updateDotsAlpha();
        dotsView.postInvalidate();
    }

    public float getCurrentProgress() {
        return this.currentProgress;
    }

    public void setColors(@ColorInt int n2, @ColorInt int n3) {
        this.COLOR_1 = n2;
        this.COLOR_2 = n3;
        this.COLOR_3 = n2;
        this.COLOR_4 = n3;
        this.invalidate();
    }
}

