/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.likebutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.widget.likebutton.CircleView;
import com.baidu.navisdk.ui.widget.likebutton.DotsView;
import com.baidu.navisdk.ui.widget.likebutton.Icon;
import com.baidu.navisdk.ui.widget.likebutton.OnLikeListener;

public class LikeButton
extends FrameLayout {
    private static final DecelerateInterpolator DECCELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final AccelerateDecelerateInterpolator ACCELERATE_DECELERATE_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private static final OvershootInterpolator OVERSHOOT_INTERPOLATOR = new OvershootInterpolator(4.0f);
    private ImageView icon;
    private DotsView dotsView;
    private CircleView circleView;
    private Icon currentIcon;
    private OnLikeListener likeListener;
    private int dotPrimaryColor;
    private int dotSecondaryColor;
    private int circleStartColor;
    private int circleEndColor;
    private float animationScaleFactor;
    private boolean isChecked;
    private boolean isEnabled;
    private AnimatorSet animatorSet;
    private Drawable likeDrawable;
    private Drawable unLikeDrawable;

    public LikeButton(Context context) {
        this(context, null);
    }

    public LikeButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LikeButton(Context context, AttributeSet attributeSet, int n2) {
        LikeButton likeButton = this;
        super(context, attributeSet, n2);
        if (!likeButton.isInEditMode()) {
            this.init(context, attributeSet, n2);
        }
    }

    private void init(Context context, AttributeSet attributeSet, int n2) {
        int n3;
        LikeButton likeButton = object;
        LayoutInflater.from((Context)likeButton.getContext()).inflate(R.layout.nsdk_likeview, (ViewGroup)object, true);
        likeButton.icon = (ImageView)likeButton.findViewById(R.id.icon);
        likeButton.dotsView = (DotsView)likeButton.findViewById(R.id.dots);
        likeButton.circleView = (CircleView)likeButton.findViewById(R.id.circle);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.LikeButton, n2, 0);
        attributeSet = object.getDrawableFromResource((TypedArray)context, R.styleable.LikeButton_nsdk_bn_like_drawable);
        object.likeDrawable = attributeSet;
        if (attributeSet != null) {
            object.setLikeDrawable((Drawable)attributeSet);
        }
        attributeSet = object.getDrawableFromResource((TypedArray)context, R.styleable.LikeButton_nsdk_bn_unlike_drawable);
        object.unLikeDrawable = attributeSet;
        if (attributeSet != null) {
            object.setUnlikeDrawable((Drawable)attributeSet);
        }
        object.circleStartColor = n3 = context.getColor(R.styleable.LikeButton_nsdk_bn_circle_start_color, 0);
        if (n3 != 0) {
            object.circleView.setStartColor(n3);
        }
        object.circleEndColor = n3 = context.getColor(R.styleable.LikeButton_nsdk_bn_circle_end_color, 0);
        if (n3 != 0) {
            object.circleView.setEndColor(n3);
        }
        object.dotPrimaryColor = context.getColor(R.styleable.LikeButton_nsdk_bn_dots_primary_color, 0);
        object.dotSecondaryColor = n3 = context.getColor(R.styleable.LikeButton_nsdk_bn_dots_secondary_color, 0);
        n2 = object.dotPrimaryColor;
        if (n2 != 0 && n3 != 0) {
            object.dotsView.setColors(n2, n3);
        }
        if (object.likeDrawable == null && object.unLikeDrawable == null && object.currentIcon != null) {
            object.setIcon();
        }
        LikeButton likeButton2 = object;
        Context context2 = context;
        object.setEnabled(context.getBoolean(R.styleable.LikeButton_nsdk_bn_is_enabled, true));
        Object object = context2.getBoolean(R.styleable.LikeButton_nsdk_bn_liked, false);
        likeButton2.setAnimationScaleFactor(context2.getFloat(R.styleable.LikeButton_nsdk_bn_anim_scale_factor, 3.0f));
        likeButton2.setLiked((Boolean)object);
        context.recycle();
    }

    private Drawable getDrawableFromResource(TypedArray typedArray, int n2) {
        int n3 = typedArray.getResourceId(n2, -1);
        return -1 != n3 ? ContextCompat.getDrawable((Context)this.getContext(), (int)n3) : null;
    }

    public void trigger(boolean bl, boolean bl2) {
        if (!bl2) {
            this.setLiked(bl);
            return;
        }
        this.isChecked = bl;
        Object object = this.icon;
        Drawable drawable2 = bl ? this.likeDrawable : this.unLikeDrawable;
        object.setImageDrawable(drawable2);
        object = this.likeListener;
        if (object != null) {
            if (this.isChecked) {
                object.liked(this);
            } else {
                object.unLiked(this);
            }
        }
        if ((object = this.animatorSet) != null) {
            object.cancel();
        }
        if (this.isChecked) {
            LikeButton likeButton = this;
            likeButton.icon.animate().cancel();
            likeButton.icon.setScaleX(0.0f);
            likeButton.icon.setScaleY(0.0f);
            likeButton.circleView.setInnerCircleRadiusProgress(0.0f);
            likeButton.circleView.setOuterCircleRadiusProgress(0.0f);
            likeButton.dotsView.setCurrentProgress(0.0f);
            likeButton.animatorSet = new AnimatorSet();
            object = ObjectAnimator.ofFloat((Object)((Object)likeButton.circleView), CircleView.OUTER_CIRCLE_RADIUS_PROGRESS, (float[])new float[]{0.1f, 1.0f});
            object.setDuration(250L);
            object.setInterpolator((TimeInterpolator)DECCELERATE_INTERPOLATOR);
            drawable2 = ObjectAnimator.ofFloat((Object)((Object)likeButton.circleView), CircleView.INNER_CIRCLE_RADIUS_PROGRESS, (float[])new float[]{0.1f, 1.0f});
            drawable2.setDuration(200L);
            drawable2.setStartDelay(200L);
            drawable2.setInterpolator((TimeInterpolator)DECCELERATE_INTERPOLATOR);
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)likeButton.icon, (Property)ImageView.SCALE_Y, (float[])new float[]{0.2f, 1.0f});
            objectAnimator.setDuration(350L);
            objectAnimator.setStartDelay(250L);
            objectAnimator.setInterpolator((TimeInterpolator)OVERSHOOT_INTERPOLATOR);
            ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)likeButton.icon, (Property)ImageView.SCALE_X, (float[])new float[]{0.2f, 1.0f});
            objectAnimator2.setDuration(350L);
            objectAnimator2.setStartDelay(250L);
            objectAnimator2.setInterpolator((TimeInterpolator)OVERSHOOT_INTERPOLATOR);
            ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)((Object)likeButton.dotsView), DotsView.DOTS_PROGRESS, (float[])new float[]{0.0f, 1.0f});
            objectAnimator3.setDuration(900L);
            objectAnimator3.setStartDelay(50L);
            objectAnimator3.setInterpolator((TimeInterpolator)ACCELERATE_DECELERATE_INTERPOLATOR);
            likeButton.animatorSet.playTogether(new Animator[]{object, drawable2, objectAnimator, objectAnimator2, objectAnimator3});
            likeButton.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animator) {
                    1 v02 = this;
                    v02.LikeButton.this.circleView.setInnerCircleRadiusProgress(0.0f);
                    v02.LikeButton.this.circleView.setOuterCircleRadiusProgress(0.0f);
                    v02.LikeButton.this.dotsView.setCurrentProgress(0.0f);
                    v02.LikeButton.this.icon.setScaleX(1.0f);
                    v02.LikeButton.this.icon.setScaleY(1.0f);
                }
            });
            likeButton.animatorSet.start();
        }
    }

    public void setLikeDrawableRes(@DrawableRes int n2) {
        Drawable drawable2;
        LikeButton likeButton = this;
        likeButton.likeDrawable = drawable2 = ContextCompat.getDrawable((Context)likeButton.getContext(), (int)n2);
        if (likeButton.isChecked) {
            this.icon.setImageDrawable(drawable2);
        }
    }

    public void setLikeDrawable(Drawable drawable2) {
        this.likeDrawable = drawable2;
        if (this.isChecked) {
            this.icon.setImageDrawable(drawable2);
        }
    }

    public void setUnlikeDrawableRes(@DrawableRes int n2) {
        Drawable drawable2;
        LikeButton likeButton = this;
        likeButton.unLikeDrawable = drawable2 = ContextCompat.getDrawable((Context)likeButton.getContext(), (int)n2);
        if (!likeButton.isChecked) {
            this.icon.setImageDrawable(drawable2);
        }
    }

    public void setUnlikeDrawable(Drawable drawable2) {
        this.unLikeDrawable = drawable2;
        if (!this.isChecked) {
            this.icon.setImageDrawable(drawable2);
        }
    }

    public void setIcon() {
        LikeButton likeButton = this;
        likeButton.setLikeDrawableRes(likeButton.currentIcon.getOnIconResourceId());
        likeButton.setUnlikeDrawableRes(likeButton.currentIcon.getOffIconResourceId());
        likeButton.icon.setImageDrawable(this.unLikeDrawable);
    }

    public void setOnLikeListener(OnLikeListener onLikeListener) {
        this.likeListener = onLikeListener;
    }

    public void setExplodingDotColorsRes(@ColorRes int n2, @ColorRes int n3) {
        this.dotsView.setColors(ContextCompat.getColor((Context)this.getContext(), (int)n2), ContextCompat.getColor((Context)this.getContext(), (int)n3));
    }

    public void setExplodingDotColorsInt(@ColorInt int n2, @ColorInt int n3) {
        this.dotsView.setColors(n2, n3);
    }

    public void setCircleStartColorRes(@ColorRes int n2) {
        int n3;
        LikeButton likeButton = this;
        likeButton.circleStartColor = n3 = ContextCompat.getColor((Context)likeButton.getContext(), (int)n2);
        likeButton.circleView.setStartColor(n3);
    }

    public void setCircleStartColorInt(@ColorInt int n2) {
        this.circleStartColor = n2;
        this.circleView.setStartColor(n2);
    }

    public void setCircleEndColorRes(@ColorRes int n2) {
        int n3;
        LikeButton likeButton = this;
        likeButton.circleEndColor = n3 = ContextCompat.getColor((Context)likeButton.getContext(), (int)n2);
        likeButton.circleView.setEndColor(n3);
    }

    public void setLiked(Boolean bl) {
        if (bl.booleanValue()) {
            this.isChecked = true;
            this.icon.setImageDrawable(this.likeDrawable);
        } else {
            this.isChecked = false;
            this.icon.setImageDrawable(this.unLikeDrawable);
        }
    }

    public boolean isLiked() {
        return this.isChecked;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void setAnimationScaleFactor(float f3) {
        this.animationScaleFactor = f3;
    }
}

