/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.likebutton;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class Utils {
    public static double mapValueFromRangeToRange(double d3, double d4, double d5, double d6, double d7) {
        return d6 + (d3 - d4) / (d5 - d4) * (d7 - d6);
    }

    public static double clamp(double d3, double d4, double d5) {
        return Math.min(Math.max(d3, d4), d5);
    }

    public static Drawable resizeDrawable(Context context, Drawable drawable2, int n2, int n3) {
        drawable2 = Utils.getBitmap(drawable2, n2, n3);
        context = context.getResources();
        return new BitmapDrawable((Resources)context, Bitmap.createScaledBitmap((Bitmap)drawable2, (int)n2, (int)n3, (boolean)true));
    }

    public static Bitmap getBitmap(Drawable drawable2, int n2, int n3) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        if (drawable2 instanceof VectorDrawable) {
            return Utils.getBitmap((VectorDrawable)drawable2, n2, n3);
        }
        throw new IllegalArgumentException("Unsupported drawable type");
    }

    @TargetApi(value=21)
    private static Bitmap getBitmap(VectorDrawable vectorDrawable, int n2, int n3) {
        Canvas canvas;
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        VectorDrawable vectorDrawable2 = vectorDrawable;
        vectorDrawable = canvas;
        int n4 = new Canvas(bitmap).getWidth();
        n3 = vectorDrawable.getHeight();
        vectorDrawable2.setBounds(0, 0, n4, n3);
        vectorDrawable2.draw((Canvas)vectorDrawable);
        return bitmap;
    }

    public static float dipToPixels(Context context, float f3) {
        context = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)f3, (DisplayMetrics)context);
    }
}

