/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.loadmore;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.baidu.navisdk.ui.widget.loadmore.BNSwipeView;

public class BNSwipeRefreshLayout
extends FrameLayout
implements NestedScrollingParent {
    public static final int NOT_OVER_TRIGGER_POINT = 1;
    public static final int OVER_TRIGGER_POINT = 2;
    public static final int START = 3;
    private static final int GUIDANCE_VIEW_HEIGHT_DEFAULT = 80;
    private static final int ACTION_PULL_REFRESH = 0;
    private static final int ACTION_LOAD_MORE = 1;
    private NestedScrollingParentHelper parentHelper;
    private BNSwipeRefreshListener onRefreshListener;
    private BNSwipeView headerView = new BNSwipeView(this.getContext());
    private BNSwipeView footerView = new BNSwipeView(this.getContext());
    private View mTargetView;
    private boolean mPullRefreshEnable = true;
    private boolean mPullLoadEnable = true;
    private volatile boolean mRefreshing = false;
    private float guidanceViewHeight = 0.0f;
    private float guidanceViewFlowHeight = 0.0f;
    private int mCurrentAction = -1;
    private boolean isConfirm = false;
    private boolean isNeedTranslateTargetY = true;

    public BNSwipeRefreshLayout(Context context) {
        super(context);
        this.initView(context, null);
    }

    public BNSwipeRefreshLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context, attributeSet);
    }

    public BNSwipeRefreshLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initView(context, attributeSet);
    }

    @TargetApi(value=21)
    public BNSwipeRefreshLayout(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.initView(context, attributeSet);
    }

    private void initView(Context context, AttributeSet attributeSet) {
        if (this.getChildCount() <= 1) {
            this.parentHelper = new NestedScrollingParentHelper((ViewGroup)this);
            this.guidanceViewHeight = this.dipToPx(context, 80.0f);
            this.guidanceViewFlowHeight = this.guidanceViewHeight * 1.5f;
            return;
        }
        throw new RuntimeException("WXSwipeLayout should not have more than one child");
    }

    private void setGuidanceView() {
        FrameLayout.LayoutParams layoutParams;
        FrameLayout.LayoutParams layoutParams2;
        BNSwipeRefreshLayout bNSwipeRefreshLayout = bNSwipeRefreshLayout2;
        BNSwipeRefreshLayout bNSwipeRefreshLayout2 = layoutParams2;
        layoutParams2 = new FrameLayout.LayoutParams(-1, 0);
        bNSwipeRefreshLayout.addView((View)bNSwipeRefreshLayout.headerView, (ViewGroup.LayoutParams)bNSwipeRefreshLayout2);
        bNSwipeRefreshLayout2 = layoutParams;
        new FrameLayout.LayoutParams((int)-1, (int)0).gravity = 80;
        bNSwipeRefreshLayout.addView((View)bNSwipeRefreshLayout.footerView, (ViewGroup.LayoutParams)bNSwipeRefreshLayout2);
    }

    private boolean moveGuidanceView(float f3) {
        if (this.mRefreshing) {
            return false;
        }
        if (!this.canChildScrollUp() && this.mPullRefreshEnable && this.mCurrentAction == 0) {
            BNSwipeRefreshListener bNSwipeRefreshListener;
            float f4;
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.headerView.getLayoutParams();
            layoutParams.height = (int)((float)layoutParams.height + f3);
            if (layoutParams.height < 0) {
                layoutParams.height = 0;
            }
            f3 = this.guidanceViewFlowHeight;
            if ((float)layoutParams.height > f4) {
                layoutParams.height = (int)f3;
            }
            if ((bNSwipeRefreshListener = this.onRefreshListener) != null) {
                float f5;
                int n2;
                int n3 = layoutParams.height;
                float f6 = this.guidanceViewHeight;
                if ((float)n2 >= f5) {
                    bNSwipeRefreshListener.onRefreshPulStateChange((float)n3 / f6, 2);
                } else {
                    bNSwipeRefreshListener.onRefreshPulStateChange((float)n3 / f6, 1);
                }
            }
            if (layoutParams.height == 0) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
                bNSwipeRefreshLayout.isConfirm = false;
                bNSwipeRefreshLayout.mCurrentAction = -1;
            }
            BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
            bNSwipeRefreshLayout.headerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            bNSwipeRefreshLayout.headerView.setProgressRotation((float)layoutParams.height / this.guidanceViewFlowHeight);
            this.moveTargetView(layoutParams.height);
            return true;
        }
        if (!this.canChildScrollDown() && this.mPullLoadEnable && this.mCurrentAction == 1) {
            BNSwipeRefreshListener bNSwipeRefreshListener;
            float f7;
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.footerView.getLayoutParams();
            layoutParams.height = (int)((float)layoutParams.height - f3);
            if (layoutParams.height < 0) {
                layoutParams.height = 0;
            }
            f3 = this.guidanceViewFlowHeight;
            if ((float)layoutParams.height > f7) {
                layoutParams.height = (int)f3;
            }
            if ((bNSwipeRefreshListener = this.onRefreshListener) != null) {
                float f8;
                int n4;
                int n5 = layoutParams.height;
                float f9 = this.guidanceViewHeight;
                if ((float)n4 >= f8) {
                    bNSwipeRefreshListener.onLoadMorePullStateChange((float)n5 / f9, 2);
                } else {
                    bNSwipeRefreshListener.onLoadMorePullStateChange((float)n5 / f9, 1);
                }
            }
            if (layoutParams.height == 0) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
                bNSwipeRefreshLayout.isConfirm = false;
                bNSwipeRefreshLayout.mCurrentAction = -1;
            }
            BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
            bNSwipeRefreshLayout.footerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            bNSwipeRefreshLayout.footerView.setProgressRotation((float)layoutParams.height / this.guidanceViewFlowHeight);
            this.moveTargetView(-layoutParams.height);
            return true;
        }
        return false;
    }

    private void moveTargetView(float f3) {
        if (this.isNeedTranslateTargetY) {
            this.mTargetView.setTranslationY(f3);
        }
    }

    private void handlerAction() {
        if (((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).isRefreshing()) {
            return;
        }
        ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).isConfirm = false;
        if (((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mPullRefreshEnable && ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mCurrentAction == 0) {
            int n2;
            int n3 = ((FrameLayout.LayoutParams)((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).headerView.getLayoutParams()).height;
            if ((float)n2 >= ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).guidanceViewHeight) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = bNSwipeRefreshListener;
                bNSwipeRefreshLayout.startRefresh(n3);
                BNSwipeRefreshListener bNSwipeRefreshListener = bNSwipeRefreshLayout.onRefreshListener;
                if (bNSwipeRefreshListener != null) {
                    bNSwipeRefreshListener.onRefreshPulStateChange(1.0f, 3);
                }
            } else if (n3 > 0) {
                ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).resetHeaderView(n3);
            } else {
                ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).resetRefreshState();
            }
        }
        if (((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mPullLoadEnable && ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).mCurrentAction == 1) {
            int n4;
            int n5 = ((FrameLayout.LayoutParams)((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).footerView.getLayoutParams()).height;
            if ((float)n4 >= ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).guidanceViewHeight) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = bNSwipeRefreshListener;
                bNSwipeRefreshLayout.startLoadMore(n5);
                BNSwipeRefreshListener bNSwipeRefreshListener = bNSwipeRefreshLayout.onRefreshListener;
                if (bNSwipeRefreshListener != null) {
                    bNSwipeRefreshListener.onLoadMorePullStateChange(1.0f, 3);
                }
            } else if (n5 > 0) {
                ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).resetFootView(n5);
            } else {
                ((BNSwipeRefreshLayout)((Object)bNSwipeRefreshListener)).resetLoadmoreState();
            }
        }
    }

    private void startRefresh(int n2) {
        BNSwipeAnimatorListener bNSwipeAnimatorListener;
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
        this.mRefreshing = true;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{n2, this.guidanceViewHeight});
        Object object = animatorUpdateListener;
        animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                1 v02 = this_;
                1 this_ = (FrameLayout.LayoutParams)v02.BNSwipeRefreshLayout.this.headerView.getLayoutParams();
                ((FrameLayout.LayoutParams)v02.BNSwipeRefreshLayout.this.headerView.getLayoutParams()).height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v02.BNSwipeRefreshLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)this_);
                v02.BNSwipeRefreshLayout.this.moveTargetView(((FrameLayout.LayoutParams)this_).height);
            }
        };
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)object);
        object = bNSwipeAnimatorListener;
        bNSwipeAnimatorListener = new BNSwipeAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                2 v02 = this;
                v02.BNSwipeRefreshLayout.this.headerView.startAnimation();
                if (v02.BNSwipeRefreshLayout.this.onRefreshListener != null) {
                    BNSwipeRefreshLayout.this.onRefreshListener.onRefresh();
                }
            }
        };
        valueAnimator.addListener((Animator.AnimatorListener)object);
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetHeaderView(int n2) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        bNSwipeRefreshLayout.headerView.stopAnimation();
        bNSwipeRefreshLayout.headerView.setStartEndTrim(0.0f, 0.75f);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{n2, 0.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                3 v02 = this_;
                3 this_ = (FrameLayout.LayoutParams)v02.BNSwipeRefreshLayout.this.headerView.getLayoutParams();
                ((FrameLayout.LayoutParams)v02.BNSwipeRefreshLayout.this.headerView.getLayoutParams()).height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v02.BNSwipeRefreshLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)this_);
                v02.BNSwipeRefreshLayout.this.moveTargetView(((FrameLayout.LayoutParams)this_).height);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new BNSwipeAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                BNSwipeRefreshLayout.this.resetRefreshState();
            }
        });
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetRefreshState() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        bNSwipeRefreshLayout.mRefreshing = false;
        bNSwipeRefreshLayout.isConfirm = false;
        bNSwipeRefreshLayout.mCurrentAction = -1;
    }

    private void startLoadMore(int n2) {
        BNSwipeAnimatorListener bNSwipeAnimatorListener;
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
        this.mRefreshing = true;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{n2, this.guidanceViewHeight});
        Object object = animatorUpdateListener;
        animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                5 v02 = this_;
                5 this_ = (FrameLayout.LayoutParams)v02.BNSwipeRefreshLayout.this.footerView.getLayoutParams();
                ((FrameLayout.LayoutParams)v02.BNSwipeRefreshLayout.this.footerView.getLayoutParams()).height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v02.BNSwipeRefreshLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)this_);
                v02.BNSwipeRefreshLayout.this.moveTargetView(-((FrameLayout.LayoutParams)this_).height);
            }
        };
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)object);
        object = bNSwipeAnimatorListener;
        bNSwipeAnimatorListener = new BNSwipeAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                6 v02 = this;
                v02.BNSwipeRefreshLayout.this.footerView.startAnimation();
                if (v02.BNSwipeRefreshLayout.this.onRefreshListener != null) {
                    BNSwipeRefreshLayout.this.onRefreshListener.onLoading();
                }
            }
        };
        valueAnimator.addListener((Animator.AnimatorListener)object);
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetFootView(int n2) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        bNSwipeRefreshLayout.footerView.stopAnimation();
        bNSwipeRefreshLayout.footerView.setStartEndTrim(0.5f, 1.25f);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{n2, 0.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                7 v02 = this_;
                7 this_ = (FrameLayout.LayoutParams)v02.BNSwipeRefreshLayout.this.footerView.getLayoutParams();
                ((FrameLayout.LayoutParams)v02.BNSwipeRefreshLayout.this.footerView.getLayoutParams()).height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v02.BNSwipeRefreshLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)this_);
                v02.BNSwipeRefreshLayout.this.moveTargetView(-((FrameLayout.LayoutParams)this_).height);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new BNSwipeAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                BNSwipeRefreshLayout.this.resetLoadmoreState();
            }
        });
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetLoadmoreState() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        bNSwipeRefreshLayout.mRefreshing = false;
        bNSwipeRefreshLayout.isConfirm = false;
        bNSwipeRefreshLayout.mCurrentAction = -1;
    }

    protected void onAttachedToWindow() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        super.onAttachedToWindow();
        bNSwipeRefreshLayout.mTargetView = bNSwipeRefreshLayout.getChildAt(0);
        bNSwipeRefreshLayout.setGuidanceView();
    }

    protected void onDetachedFromWindow() {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        super.onDetachedFromWindow();
        bNSwipeRefreshLayout.removeView((View)bNSwipeRefreshLayout.headerView);
        bNSwipeRefreshLayout.removeView((View)bNSwipeRefreshLayout.footerView);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return false;
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onStartNestedScroll(View view, View view2, int n2) {
        return true;
    }

    public void onNestedScrollAccepted(View view, View view2, int n2) {
        this.parentHelper.onNestedScrollAccepted(view, view2, n2);
    }

    public void onStopNestedScroll(View view) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
        bNSwipeRefreshLayout.parentHelper.onStopNestedScroll(view);
        bNSwipeRefreshLayout.handlerAction();
    }

    public void onNestedPreScroll(View view, int n2, int n3, int[] nArray) {
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return;
        }
        if (Math.abs(n3) > 200) {
            return;
        }
        if (!this.isConfirm) {
            if (n3 < 0 && !this.canChildScrollUp()) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
                bNSwipeRefreshLayout.mCurrentAction = 0;
                bNSwipeRefreshLayout.isConfirm = true;
            } else if (n3 > 0 && !this.canChildScrollDown()) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = this;
                bNSwipeRefreshLayout.mCurrentAction = 1;
                bNSwipeRefreshLayout.isConfirm = true;
            }
        }
        if (this.moveGuidanceView(-n3)) {
            nArray[1] = nArray[1] + n3;
        }
    }

    public void onNestedScroll(View view, int n2, int n3, int n4, int n5) {
    }

    public int getNestedScrollAxes() {
        return this.parentHelper.getNestedScrollAxes();
    }

    public boolean onNestedPreFling(View view, float f3, float f4) {
        return false;
    }

    public boolean onNestedFling(View view, float f3, float f4, boolean bl) {
        return false;
    }

    public boolean canChildScrollUp() {
        View view = bNSwipeRefreshLayout.mTargetView;
        if (view == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = (AbsListView)view;
                return bNSwipeRefreshLayout.getChildCount() > 0 && (bNSwipeRefreshLayout.getFirstVisiblePosition() > 0 || bNSwipeRefreshLayout.getChildAt(0).getTop() < bNSwipeRefreshLayout.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)view, (int)-1) || bNSwipeRefreshLayout.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)view, (int)-1);
    }

    public boolean canChildScrollDown() {
        View view = bNSwipeRefreshLayout.mTargetView;
        if (view == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                BNSwipeRefreshLayout bNSwipeRefreshLayout = (AbsListView)view;
                if (bNSwipeRefreshLayout.getChildCount() > 0) {
                    BNSwipeRefreshLayout bNSwipeRefreshLayout2 = bNSwipeRefreshLayout;
                    int n2 = bNSwipeRefreshLayout2.getChildAt(bNSwipeRefreshLayout2.getChildCount() - 1).getBottom();
                    return bNSwipeRefreshLayout2.getLastVisiblePosition() == ((ListAdapter)bNSwipeRefreshLayout.getAdapter()).getCount() - 1 && n2 <= bNSwipeRefreshLayout.getMeasuredHeight();
                }
                return false;
            }
            return ViewCompat.canScrollVertically((View)view, (int)1) || bNSwipeRefreshLayout.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)view, (int)1);
    }

    public float dipToPx(Context context, float f3) {
        BNSwipeRefreshLayout bNSwipeRefreshLayout = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)f3, (DisplayMetrics)bNSwipeRefreshLayout);
    }

    public void setOnRefreshListener(BNSwipeRefreshListener bNSwipeRefreshListener) {
        this.onRefreshListener = bNSwipeRefreshListener;
    }

    public void finishRefresh() {
        if (this.mCurrentAction == 0) {
            BNSwipeView bNSwipeView = this.headerView;
            int n2 = bNSwipeView == null ? 0 : bNSwipeView.getMeasuredHeight();
            this.resetHeaderView(n2);
        }
    }

    public void finishLoadMore() {
        if (this.mCurrentAction == 1) {
            BNSwipeView bNSwipeView = this.footerView;
            int n2 = bNSwipeView == null ? 0 : bNSwipeView.getMeasuredHeight();
            this.resetFootView(n2);
        }
    }

    public boolean isLoadMoreEnable() {
        return this.mPullLoadEnable;
    }

    public void setLoadMoreEnable(boolean bl) {
        this.mPullLoadEnable = bl;
    }

    public boolean isRefreshEnable() {
        return this.mPullRefreshEnable;
    }

    public void setRefreshEnable(boolean bl) {
        this.mPullRefreshEnable = bl;
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    public void setHeaderView(@LayoutRes int n2) {
        this.headerView.setGuidanceView(n2);
    }

    public void setHeaderView(View view) {
        this.headerView.setGuidanceView(view);
    }

    public void setFooterView(@LayoutRes int n2) {
        this.footerView.setGuidanceView(n2);
    }

    public void setFooterView(View view) {
        this.footerView.setGuidanceView(view);
    }

    public void setNeedTranslateTargetY(boolean bl) {
        this.isNeedTranslateTargetY = bl;
    }

    public void setGuidanceViewHeight(int n2, int n3) {
        this.guidanceViewHeight = n2;
        this.guidanceViewFlowHeight = n3;
    }

    static class BNSwipeAnimatorListener
    implements Animator.AnimatorListener {
        BNSwipeAnimatorListener() {
        }

        public void onAnimationStart(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    }

    public static interface BNSwipeRefreshListener {
        public void onRefresh();

        public void onLoading();

        public void onRefreshPulStateChange(float var1, int var2);

        public void onLoadMorePullStateChange(float var1, int var2);
    }
}

