/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.nestedscroll;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.OverScroller;
import com.baidu.baidumaps.common.util.ScreenUtils;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.framework.message.a;
import com.baidu.navisdk.framework.message.bean.p;
import com.baidu.navisdk.ui.widget.nestedscroll.BlankLinearLayout;
import com.baidu.navisdk.ui.widget.nestedscroll.FlingHelper;
import com.baidu.navisdk.util.common.LogUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class OuterScrollView
extends NestedScrollView
implements a.a {
    private static final String TAG = "OuterScrollView";
    protected boolean scrollAvailable = true;
    protected VelocityTracker mVelocityTracker;
    protected FlingHelper mFlingHelper;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    protected Field scrollerField;
    protected Field lastScrollYField;
    private boolean isDownOnMap = false;
    private BlankLinearLayout blankLayout;
    private LinearLayout contentLayout;
    protected com.baidu.navisdk.model.datastruct.p mStatus = com.baidu.navisdk.model.datastruct.p.a;
    protected int mBottomStatusContentHeight;
    protected int mTopStatusContentHeight;
    protected int scroll_height = 0;
    protected int view_height = 0;
    protected boolean isStartNestFling = false;
    protected boolean enablePageScrollStatus = true;
    protected OnScrollChangeListener mListener;
    private OnScrollViewTouchListener mOnScrollViewTouchListener;

    public OuterScrollView(Context context) {
        super(context);
        this.init(context);
    }

    public OuterScrollView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public OuterScrollView(Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context);
    }

    private int getScreenHeight() {
        return ScreenUtils.getViewScreenHeight((Context)com.baidu.navisdk.framework.a.c().b());
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private boolean canMoveMap(MotionEvent motionEvent, View view) {
        boolean bl = this.isPointInsideView(motionEvent.getY(), view);
        if (motionEvent.getAction() == 0) {
            this.isDownOnMap = bl;
        }
        if (motionEvent.getAction() == 1) {
            this.isDownOnMap = false;
        }
        return this.isDownOnMap && bl && motionEvent.getAction() != 1;
    }

    private boolean isPointInsideView(float f3, View view) {
        Rect rect;
        View view2 = view;
        view = rect;
        view2.getHitRect(new Rect());
        return f3 > (float)view.top && f3 < (float)(view.bottom - this.getScrollY());
    }

    private int getScrollToMiddleValue() {
        return (this.getScrollToTopValue() - this.getScrollToBottomValue()) / 2;
    }

    public void init(Context context) {
        LinearLayout linearLayout;
        OuterScrollView outerScrollView = this;
        LayoutInflater.from((Context)outerScrollView.getContext()).inflate(R.layout.nsdk_layout_out_scroll_view, (ViewGroup)this);
        outerScrollView.blankLayout = (BlankLinearLayout)outerScrollView.findViewById(R.id.ll_blank);
        this.contentLayout = linearLayout = (LinearLayout)outerScrollView.findViewById(R.id.ll_content);
        linearLayout.setMinimumHeight(this.getScreenHeight());
        outerScrollView.mFlingHelper = new FlingHelper(context);
        this.mMaximumVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
        this.mMinimumVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
    }

    protected void onMeasure(int n2, int n3) {
        OuterScrollView outerScrollView = this;
        OuterScrollView outerScrollView2 = this;
        int n4 = outerScrollView2.getScreenHeight();
        int n5 = outerScrollView2.mBottomStatusContentHeight;
        outerScrollView2.blankLayout.setMinHeight(n4 - n5);
        super.onMeasure(n2, n3);
        int n6 = outerScrollView.mBottomStatusContentHeight;
        if (n6 != n5) {
            this.blankLayout.setMinHeight(n4 - n6);
            super.onMeasure(n2, n3);
        } else {
            n6 = n5;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onMeasure() --> widthMeasureSpec = " + n2 + ", heightMeasureSpec = " + n3 + ", bottom = " + n6 + ", screenHeight = " + n4);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        BlankLinearLayout blankLinearLayout;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onTouchEvent() --> scrollAvailable = " + this.scrollAvailable + ", event = " + motionEvent);
        }
        if (!this.scrollAvailable) {
            return false;
        }
        int n2 = motionEvent.getAction();
        if (this.mOnScrollViewTouchListener != null) {
            int n3 = motionEvent.getAction();
            if (n3 != 0) {
                if (n3 == 1) {
                    this.mOnScrollViewTouchListener.onScrollViewTouchUp();
                }
            } else {
                this.mOnScrollViewTouchListener.onScrollViewTouchDown();
            }
        }
        if ((blankLinearLayout = this.blankLayout) == null ? false : this.canMoveMap(motionEvent, (View)blankLinearLayout)) {
            return false;
        }
        if (this.mOnScrollViewTouchListener != null) {
            int n4 = motionEvent.getAction();
            if (n4 != 0) {
                if (n4 == 1) {
                    this.mOnScrollViewTouchListener.onScrollViewContentTouchUp();
                }
            } else {
                this.mOnScrollViewTouchListener.onScrollViewContentTouchDown();
            }
        }
        OuterScrollView outerScrollView = this;
        outerScrollView.initVelocityTrackerIfNotExists();
        outerScrollView.mVelocityTracker.addMovement(motionEvent);
        if (n2 != 1) {
            if (n2 == 3) {
                this.recycleVelocityTracker();
            }
        } else {
            if (this.enablePageScrollStatus) {
                OuterScrollView outerScrollView2 = this;
                outerScrollView2.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n5 = (int)outerScrollView2.mVelocityTracker.getYVelocity();
                com.baidu.navisdk.model.datastruct.p p2 = outerScrollView2.calculateNextStatus(n5, outerScrollView2.getScrollY());
                if (p2 != com.baidu.navisdk.model.datastruct.p.d) {
                    this.updateStatus(p2, true, n5);
                }
                this.recycleVelocityTracker();
                return true;
            }
            this.recycleVelocityTracker();
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        BlankLinearLayout blankLinearLayout;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onInterceptTouchEvent() --> event = " + motionEvent);
        }
        if (!((blankLinearLayout = this.blankLayout) == null ? false : this.canMoveMap(motionEvent, (View)blankLinearLayout)) && this.mOnScrollViewTouchListener != null) {
            int n2 = motionEvent.getAction();
            if (n2 != 0) {
                if (n2 == 1) {
                    this.mOnScrollViewTouchListener.onScrollViewContentTouchUp();
                }
            } else {
                this.mOnScrollViewTouchListener.onScrollViewContentTouchDown();
            }
        }
        if (this.mOnScrollViewTouchListener != null) {
            int n3 = motionEvent.getAction();
            if (n3 != 0) {
                if (n3 == 1) {
                    this.mOnScrollViewTouchListener.onScrollViewTouchUp();
                }
            } else {
                this.mOnScrollViewTouchListener.onScrollViewTouchDown();
            }
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onStartNestedScroll(@NonNull View view, @NonNull View view2, int n2) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onStartNestedScroll() --> child = " + view + ", target = " + view2 + ", axes = " + n2 + ", scrollAvailable = " + this.scrollAvailable);
        }
        if (!this.scrollAvailable) {
            return false;
        }
        if (this.getScrollY() != this.getMaxScrollVal()) {
            return false;
        }
        return super.onStartNestedScroll(view, view2, n2);
    }

    public void onNestedScrollAccepted(@NonNull View view, @NonNull View view2, int n2) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedScrollAccepted() --> child = " + view + ", target = " + view2 + ", axes = " + n2);
        }
        super.onNestedScrollAccepted(view, view2, n2);
    }

    public void onStopNestedScroll(@NonNull View view) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onStopNestedScroll() --> target = " + view + ", isStartNestFling = " + this.isStartNestFling);
        }
        if (this.isStartNestFling) {
            this.isStartNestFling = false;
        } else if (this.enablePageScrollStatus) {
            OuterScrollView outerScrollView = this;
            com.baidu.navisdk.model.datastruct.p p2 = outerScrollView.calculateNextStatus(0, outerScrollView.getScrollY());
            if (p2 != com.baidu.navisdk.model.datastruct.p.d) {
                this.updateStatus(p2, true);
            }
        }
        super.onStopNestedScroll(view);
    }

    public void onNestedScroll(@NonNull View view, int n2, int n3, int n4, int n5) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedScroll() --> target = " + view + ", dxConsumed = " + n2 + ", dyConsumed = " + n3 + ", dxUnconsumed = " + n4 + ", dyUnconsumed = " + n5);
        }
        super.onNestedScroll(view, n2, n3, n4, n5);
    }

    public void onNestedPreScroll(@NonNull View view, int n2, int n3, @NonNull int[] nArray) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedPreScroll() --> target = " + view + ", dx = " + n2 + ", dy = " + n3 + ", consumed = " + Arrays.toString(nArray));
        }
        boolean bl = n3 > 0 && this.getScrollY() < this.getScrollToTopValue();
        boolean bl2 = n3 < 0 && this.getScrollY() >= 0 && !view.canScrollVertically(-1);
        if (bl || bl2) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onNestedPreScroll() --> scroll scrollview!");
            }
            this.scrollBy(0, n3);
            nArray[1] = n3;
        }
        super.onNestedPreScroll(view, n2, n3, nArray);
    }

    public boolean onNestedFling(@NonNull View view, float f3, float f4, boolean bl) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedFling() --> target = " + view + ", velocityX = " + f3 + ", velocityY = " + f4 + ", consumed = " + bl);
        }
        return super.onNestedFling(view, f3, f4, bl);
    }

    public boolean onNestedPreFling(@NonNull View view, float f3, float f4) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "onNestedPreFling() --> target = " + view + ", velocityX = " + f3 + ", velocityY = " + f4);
        }
        this.isStartNestFling = true;
        if (view.getScrollY() != 0 && this.mStatus != com.baidu.navisdk.model.datastruct.p.a) {
            return super.onNestedPreFling(view, f3, f4);
        }
        if (this.enablePageScrollStatus) {
            OuterScrollView outerScrollView = this;
            int n2 = -((int)f4);
            com.baidu.navisdk.model.datastruct.p p2 = outerScrollView.calculateNextStatus(n2, outerScrollView.getScrollY());
            if (p2 != com.baidu.navisdk.model.datastruct.p.d) {
                this.updateStatus(p2, true, n2);
            }
        } else {
            float f5 = f4 - 0.0f;
            float f6 = f5 == 0.0f ? 0 : (f5 < 0.0f ? -1 : 1);
            int n3 = f6 < 0 ? this.getScrollY() : this.getMaxScrollVal() - this.getScrollY();
            float f7 = f6;
            f6 = this.mFlingHelper.getVelocityByDistance(n3);
            f6 = (int)Math.max(Math.abs(f4), (float)Math.abs((int)f6)) + 500;
            if (f7 < 0) {
                f6 = -f6;
            }
            this.fling((int)f6);
        }
        return true;
    }

    public int getNestedScrollAxes() {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "getNestedScrollAxes");
        }
        return super.getNestedScrollAxes();
    }

    protected void onScrollChanged(int n2, int n3, int n4, int n5) {
        OnScrollChangeListener onScrollChangeListener = this.mListener;
        if (onScrollChangeListener != null) {
            onScrollChangeListener.onScroll(n3);
        }
        boolean bl = this.isNeedStopScroll(n3);
        if (n3 == 0 || bl) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onScrollChanged abortAnimation " + n3 + ",scroll_height: " + this.scroll_height + ", view_height:" + this.view_height);
            }
            this.abortAnimation();
        }
        super.onScrollChanged(n2, n3, n4, n5);
    }

    protected boolean isNeedStopScroll(int n2) {
        return this.scroll_height - this.view_height == n2;
    }

    public int computeVerticalScrollRange() {
        int n2 = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        if (this.getChildCount() == 0) {
            return n2;
        }
        OuterScrollView outerScrollView = this;
        int n3 = outerScrollView.getChildAt(0).getBottom();
        int n4 = outerScrollView.getScrollY();
        n2 = Math.max(0, n3 - n2);
        if (n4 < 0) {
            n3 -= n4;
        } else if (n4 > n2) {
            n3 += n4 - n2;
        }
        this.scroll_height = n3;
        n2 = 0;
        BlankLinearLayout blankLinearLayout = this.blankLayout;
        if (blankLinearLayout != null) {
            n2 = blankLinearLayout.getMeasuredHeight() + n2;
            blankLinearLayout = this.contentLayout;
            if (blankLinearLayout != null && blankLinearLayout.getChildAt(1) != null) {
                n2 += this.contentLayout.getChildAt(1).getMeasuredHeight();
            }
        }
        if (n2 > 0) {
            this.scroll_height = n2;
        }
        return this.scroll_height;
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        if (bl) {
            this.view_height = n5 - n3;
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        a.a().a(this, p.class, new Class[0]);
    }

    public void onDetachedFromWindow() {
        OuterScrollView outerScrollView = this;
        super.onDetachedFromWindow();
        a.a().a(this);
        outerScrollView.recycleVelocityTracker();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fling(int n2) {
        block20: {
            OuterScrollView outerScrollView;
            if (!this.enablePageScrollStatus) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "fling() --> 1 --> velocityY = " + n2);
                }
                super.fling(n2);
                return;
            }
            OverScroller overScroller = null;
            if (this.scrollerField == null) {
                this.scrollerField = FlingHelper.getDeclaredField(this, "mScroller");
            }
            if (this.lastScrollYField == null) {
                this.lastScrollYField = FlingHelper.getDeclaredField(this, "mLastScrollerY");
            }
            Object object = null;
            try {
                if (this.scrollerField != null) {
                    object = this.scrollerField.get(this);
                }
                if (object instanceof OverScroller) {
                    overScroller = (OverScroller)object;
                }
                if (overScroller == null || this.lastScrollYField == null) break block20;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.printException("OuterScrollView fling  IllegalAccessException!", illegalAccessException);
                }
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "fling() --> 2 --> velocityY = " + n2);
                }
                super.fling(n2);
                return;
            }
            try {
                if (this.getChildCount() <= 0) return;
                OuterScrollView outerScrollView2 = this;
                outerScrollView = outerScrollView2;
                outerScrollView2.startNestedScroll(2, 1);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.printException("OuterScrollView fling  IllegalAccessException!", illegalAccessException);
                }
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "fling() --> 3 --> velocityY = " + n2);
                }
                super.fling(n2);
                return;
            }
            int n3 = Integer.MIN_VALUE;
            int n4 = Integer.MAX_VALUE;
            {
                if (outerScrollView.enablePageScrollStatus) {
                    if (n2 > 0) {
                        OuterScrollView outerScrollView3 = this;
                        n3 = outerScrollView3.getScrollToTopValue();
                        n4 = outerScrollView3.getScrollToTopValue();
                    } else {
                        n3 = 0;
                        n4 = 0;
                    }
                }
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "fling() --> getScrollX = " + this.getScrollX() + ", getScrollY = " + this.getScrollY() + " velocityY = " + n2 + ", minY = " + n3 + ", maxY = " + n4);
                }
                OuterScrollView outerScrollView4 = this;
                OuterScrollView outerScrollView5 = this;
                int n5 = outerScrollView5.getScrollX();
                overScroller.fling(n5, outerScrollView5.getScrollY(), 0, n2, 0, 0, n3, n4, 0, 0);
                OuterScrollView outerScrollView6 = this;
                outerScrollView4.lastScrollYField.set(outerScrollView6, outerScrollView6.getScrollY());
                ViewCompat.postInvalidateOnAnimation((View)outerScrollView4);
                return;
            }
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "fling() --> 4 --> velocityY = " + n2);
        }
        super.fling(n2);
    }

    protected com.baidu.navisdk.model.datastruct.p calculateNextStatus(int n2, int n3) {
        int n4;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "calculateNextStatus() --> velocityY = " + n2 + ", scrollY = " + n3 + ", scrollToMiddleValue = " + this.getScrollToMiddleValue() + ", mStatus = " + (Object)((Object)this.mStatus));
        }
        if ((n4 = 2.$SwitchMap$com$baidu$navisdk$model$datastruct$ScrollStatus[this.mStatus.ordinal()]) != 1) {
            if (n4 != 2) {
                return com.baidu.navisdk.model.datastruct.p.a;
            }
            if (n2 <= 1000 && n3 >= this.getScrollToMiddleValue()) {
                if (n3 > this.getScrollToTopValue()) {
                    return com.baidu.navisdk.model.datastruct.p.b;
                }
                return com.baidu.navisdk.model.datastruct.p.b;
            }
            return com.baidu.navisdk.model.datastruct.p.a;
        }
        if (n2 < 0 && Math.abs(n2) > 1000 || n3 > this.getScrollToMiddleValue()) {
            return com.baidu.navisdk.model.datastruct.p.b;
        }
        return com.baidu.navisdk.model.datastruct.p.a;
    }

    public void updateStatus(com.baidu.navisdk.model.datastruct.p p2, boolean bl) {
        this.updateStatus(p2, bl, 0);
    }

    protected void updateStatus(com.baidu.navisdk.model.datastruct.p p2, boolean n2, int n3) {
        OnScrollChangeListener onScrollChangeListener;
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "updateStatus() --> status = " + (Object)((Object)p2) + ", smooth = " + (n2 != 0) + ", velocityY = " + n3);
        }
        if ((onScrollChangeListener = this.mListener) != null) {
            onScrollChangeListener.onStatusChanged(this.mStatus, p2);
        }
        this.mStatus = p2;
        int n4 = 2.$SwitchMap$com$baidu$navisdk$model$datastruct$ScrollStatus[p2.ordinal()];
        if (n4 != 1) {
            if (n4 == 2) {
                if (n2 != 0) {
                    n4 = this.getMaxScrollVal() - this.getScrollY();
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    n2 = this.mFlingHelper.getVelocityByDistance(n4);
                    int n5 = Math.max(Math.abs(n3), Math.abs(n2 + 500));
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(TAG, "updateTopStatus() --> velocityY = " + n3 + ", scrollDistance = " + n4 + ", needVelocity = " + n2 + ", finalVelocity = " + n5);
                    }
                    if (n2 > 0) {
                        this.fling(n5);
                    }
                } else {
                    OuterScrollView outerScrollView = this;
                    outerScrollView.scrollTo(0, outerScrollView.getScrollToTopValue());
                }
            }
        } else if (n2 != 0) {
            n4 = this.getScrollY();
            if (n3 > 0) {
                n3 = 0;
            }
            n2 = this.mFlingHelper.getVelocityByDistance(n4);
            int n6 = -Math.max(Math.abs(n3), Math.abs(n2 + 500));
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "updateBottomStatus() --> velocityY = " + n3 + ", scrollDistance = " + n4 + ", needVelocity = " + n2 + ", finalVelocity = " + n6);
            }
            if (n2 > 0) {
                this.fling(n6);
            }
        } else {
            OuterScrollView outerScrollView = this;
            outerScrollView.scrollTo(0, outerScrollView.getScrollToBottomValue());
        }
    }

    protected int getScrollToTopValue() {
        return this.mTopStatusContentHeight - this.mBottomStatusContentHeight;
    }

    protected int getScrollToBottomValue() {
        return 0;
    }

    public void setBottomStatusContentHeight(int n2) {
        this.mBottomStatusContentHeight = n2;
    }

    public void setTopStatusContentHeight(int n2) {
        this.mTopStatusContentHeight = n2;
    }

    public void scrollTo(int n2, int n3) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "scrollTo --> x = " + n2 + ", y = " + n3 + ", getScrollToBottomValue() = " + this.getScrollToBottomValue() + ", getScrollToTopValue() = " + this.getScrollToTopValue());
            LogUtil.printCallStack();
        }
        if (n3 < this.getScrollToBottomValue()) {
            n3 = this.getScrollToBottomValue();
        }
        if (n3 > this.getScrollToTopValue()) {
            n3 = this.getScrollToTopValue();
        }
        super.scrollTo(n2, n3);
    }

    protected void abortAnimation() {
        block14: {
            Object object;
            block13: {
                block12: {
                    if (this.scrollerField != null) break block12;
                    this.scrollerField = FlingHelper.getDeclaredField(this, "mScroller");
                }
                object = null;
                if (this.scrollerField == null) break block13;
                object = this.scrollerField.get(this);
            }
            if (object == null) {
                return;
            }
            Class<?> clazz = object.getClass();
            try {
                clazz.getMethod("abortAnimation", new Class[0]).invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.printException("OuterScrollView abortAnimation InvocationTargetException!", invocationTargetException);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (LogUtil.LOGGABLE) {
                    LogUtil.printException("OuterScrollView abortAnimation NoSuchMethodException!", noSuchMethodException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!LogUtil.LOGGABLE) break block14;
                LogUtil.printException("OuterScrollView abortAnimation IllegalAccessException!", illegalAccessException);
            }
        }
    }

    public void setScrollChangeListener(OnScrollChangeListener onScrollChangeListener) {
        this.mListener = onScrollChangeListener;
    }

    public void setOnScrollViewTouchListener(OnScrollViewTouchListener onScrollViewTouchListener) {
        this.mOnScrollViewTouchListener = onScrollViewTouchListener;
    }

    public int getMaxScrollVal() {
        return this.getScrollToTopValue() - this.getScrollToBottomValue();
    }

    public void setStatus(com.baidu.navisdk.model.datastruct.p p2) {
        this.mStatus = p2;
    }

    public LinearLayout getContentLayout() {
        return this.contentLayout;
    }

    public com.baidu.navisdk.model.datastruct.p getStatus() {
        return this.mStatus;
    }

    public void setBlankViewClickListener(View.OnClickListener onClickListener) {
        BlankLinearLayout blankLinearLayout = object.blankLayout;
        if (blankLinearLayout != null) {
            blankLinearLayout.setOnClickListener(onClickListener);
            Object object = object.blankLayout;
            boolean bl = onClickListener != null;
            object.setClickable(bl);
        }
    }

    public void setScrollAvailable(boolean bl) {
        this.scrollAvailable = bl;
    }

    public void setEnablePageScrollStatus(boolean bl) {
        this.enablePageScrollStatus = bl;
    }

    @Override
    public void onEvent(Object object) {
        if (object instanceof p) {
            object = this.blankLayout;
            if (object != null) {
                object.requestLayout();
            }
            if ((object = this.contentLayout) != null && (object = object.getChildAt(1)) != null) {
                object.requestLayout();
            }
            if (this.mStatus == com.baidu.navisdk.model.datastruct.p.b) {
                Runnable runnable;
                object = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        OuterScrollView outerScrollView = outerScrollView.OuterScrollView.this;
                        if (outerScrollView.mStatus == com.baidu.navisdk.model.datastruct.p.b) {
                            OuterScrollView outerScrollView2 = outerScrollView;
                            outerScrollView2.scrollTo(0, outerScrollView2.getScrollToTopValue());
                        }
                    }
                };
                this.post((Runnable)object);
            }
        }
    }

    public String getName() {
        return "OuterScrollView-OnEvent";
    }

    public static interface OnScrollViewTouchListener {
        public void onScrollViewTouchDown();

        public void onScrollViewTouchUp();

        public void onScrollViewContentTouchDown();

        public void onScrollViewContentTouchUp();
    }

    public static interface OnScrollChangeListener {
        public void onStatusChanged(com.baidu.navisdk.model.datastruct.p var1, com.baidu.navisdk.model.datastruct.p var2);

        public void onScroll(int var1);

        public void onScrollEnd();

        public void onScrollStart();
    }
}

