/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import com.baidu.navisdk.ui.widget.recyclerview.IServiceManager;
import com.baidu.navisdk.ui.widget.recyclerview.MVHelper;
import com.baidu.navisdk.ui.widget.recyclerview.core.adapter.GroupBasicAdapter;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.DataParser;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.IAdapterBuilder;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.BaseCellBinder;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.BaseCellBinderResolver;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.Card;
import com.baidu.navisdk.ui.widget.recyclerview.structure.BaseCell;
import com.baidu.navisdk.ui.widget.recyclerview.support.BannerSupport;
import com.baidu.navisdk.ui.widget.recyclerview.util.Predicate;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutViewFactory;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend.InnerRecycledViewPool;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend.PerformanceMonitor;
import com.baidu.navisdk.util.common.v;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BaseRecyclerViewEngine<O, T, C, L>
implements IServiceManager {
    private Map<Class<?>, Object> mServices;
    @NonNull
    private final Context mContext;
    private RecyclerView mContentView;
    private final VirtualLayoutManager mLayoutManager;
    protected GroupBasicAdapter<C, L> mGroupBasicAdapter;
    private final DataParser<O, T, C, L> mDataParser;
    private final IAdapterBuilder<C, L> mAdapterBuilder;
    private PerformanceMonitor mPerformanceMonitor;

    public BaseRecyclerViewEngine(@NonNull Context context, @NonNull DataParser<O, T, C, L> dataParser, @NonNull IAdapterBuilder<C, L> iAdapterBuilder) {
        ArrayMap arrayMap;
        ArrayMap arrayMap2 = arrayMap;
        arrayMap = new ArrayMap();
        this.mServices = arrayMap2;
        v.a(context != null, (Object)"context is null");
        this.mContext = context;
        this.mLayoutManager = new VirtualLayoutManager(this.mContext);
        this.mLayoutManager.setLayoutViewFactory(new LayoutViewFactory(){

            @Override
            public View generateLayoutView(@NonNull Context context) {
                return new ImageView(context);
            }
        });
        this.mDataParser = v.a(dataParser, (Object)"dataParser in constructor should not be null");
        this.mAdapterBuilder = v.a(iAdapterBuilder, (Object)"adapterBuilder in constructor should not be null");
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    public RecyclerView getContentView() {
        return this.mContentView;
    }

    public GroupBasicAdapter<C, ?> getGroupBasicAdapter() {
        return this.mGroupBasicAdapter;
    }

    public VirtualLayoutManager getLayoutManager() {
        return this.mLayoutManager;
    }

    public void setPerformanceMonitor(PerformanceMonitor performanceMonitor) {
        this.mPerformanceMonitor = performanceMonitor;
    }

    public void bindView(@NonNull RecyclerView object) {
        v.a(object != null, (Object)"view must not be null");
        RecyclerView recyclerView = this.mContentView;
        if (recyclerView != null) {
            recyclerView.setAdapter(null);
            this.mContentView.setLayoutManager(null);
        }
        BaseRecyclerViewEngine baseRecyclerViewEngine = this;
        this.mContentView = object;
        object.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        baseRecyclerViewEngine.mLayoutManager.setPerformanceMonitor(this.mPerformanceMonitor);
        if (baseRecyclerViewEngine.mGroupBasicAdapter == null) {
            BaseRecyclerViewEngine baseRecyclerViewEngine2 = this;
            object = baseRecyclerViewEngine2.mContext;
            this.mGroupBasicAdapter = object = this.mAdapterBuilder.newAdapter((Context)object, baseRecyclerViewEngine2.mLayoutManager, this);
            object.setPerformanceMonitor(this.mPerformanceMonitor);
        }
        if (this.mContentView.getRecycledViewPool() != null) {
            this.mContentView.setRecycledViewPool((RecyclerView.RecycledViewPool)new InnerRecycledViewPool(this.mContentView.getRecycledViewPool()));
        }
        BaseRecyclerViewEngine baseRecyclerViewEngine3 = this;
        baseRecyclerViewEngine3.register((Class<T>)GroupBasicAdapter.class, (T)((Object)baseRecyclerViewEngine3.mGroupBasicAdapter));
        baseRecyclerViewEngine3.register(RecyclerView.RecycledViewPool.class, baseRecyclerViewEngine3.mContentView.getRecycledViewPool());
        baseRecyclerViewEngine3.mContentView.setAdapter(this.mGroupBasicAdapter);
        if (Build.VERSION.SDK_INT < 21) {
            this.mContentView.setChildDrawingOrderCallback((RecyclerView.ChildDrawingOrderCallback)new DrawingOrderCallback());
        }
    }

    public void unbindView() {
        RecyclerView recyclerView = this.mContentView;
        if (recyclerView != null) {
            BaseRecyclerViewEngine baseRecyclerViewEngine = this;
            recyclerView.setAdapter(null);
            baseRecyclerViewEngine.mContentView.setLayoutManager(null);
            baseRecyclerViewEngine.mContentView.setRecycledViewPool(null);
            baseRecyclerViewEngine.mContentView = null;
        }
    }

    public <V extends View> void registerCell(String string2, @NonNull Class<? extends BaseCell> clazz, @NonNull Class<V> clazz2) {
        BaseRecyclerViewEngine baseRecyclerViewEngine = mVHelper;
        baseRecyclerViewEngine.registerCell(string2, clazz2);
        MVHelper mVHelper = baseRecyclerViewEngine.getService(MVHelper.class);
        if (mVHelper != null && mVHelper.resolver() != null) {
            mVHelper.resolver().registerCompatible(string2, clazz);
        }
    }

    public <V extends View> void registerCell(String string2, @NonNull Class<V> clazz) {
        Object object = ((BaseRecyclerViewEngine)((Object)mVHelper)).getService(BaseCellBinderResolver.class);
        MVHelper mVHelper = ((BaseRecyclerViewEngine)((Object)mVHelper)).getService(MVHelper.class);
        if (object != null && mVHelper != null && mVHelper.resolver() != null) {
            BaseCellBinder baseCellBinder;
            BaseCellBinderResolver baseCellBinderResolver = object;
            object = baseCellBinder;
            baseCellBinder = new BaseCellBinder(clazz, mVHelper);
            baseCellBinderResolver.register(string2, object);
            mVHelper.resolver().register(string2, clazz);
        }
    }

    public void destroy() {
        Object object;
        if (((BaseRecyclerViewEngine)this).mContentView != null) {
            object = ((BaseRecyclerViewEngine)this).mGroupBasicAdapter;
            if (object != null) {
                object.destroy();
            }
            ((BaseRecyclerViewEngine)this).unbindView();
        }
        if ((object = ((BaseRecyclerViewEngine)this).getService(BannerSupport.class)) != null) {
            ((BannerSupport)object).destroy();
        }
        if ((this = ((BaseRecyclerViewEngine)this).mServices) != null) {
            this.clear();
        }
    }

    @Deprecated
    public void appendData(@Nullable ArrayList<O> arrayList) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        BaseRecyclerViewEngine baseRecyclerViewEngine = this;
        baseRecyclerViewEngine.appendData(baseRecyclerViewEngine.mDataParser.parseGroup(arrayList, this));
    }

    @Deprecated
    public void insertData(int n2, @Nullable ArrayList<O> arrayList) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        this.insertData(n2, this.mDataParser.parseGroup(arrayList, this));
    }

    @Deprecated
    public void replaceData(int n2, @Nullable ArrayList<O> arrayList) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        this.replaceData(n2, this.mDataParser.parseGroup(arrayList, this));
    }

    public void setData(@Nullable ArrayList<O> arrayList) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        BaseRecyclerViewEngine baseRecyclerViewEngine = this;
        baseRecyclerViewEngine.setData(baseRecyclerViewEngine.mDataParser.parseGroup(arrayList, this));
    }

    public void setData(@Nullable List<C> list) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        MVHelper mVHelper = (MVHelper)this.mServices.get(MVHelper.class);
        if (mVHelper != null) {
            mVHelper.reset();
        }
        this.mGroupBasicAdapter.setData(list);
    }

    @Deprecated
    public void appendData(@Nullable List<C> list) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        this.mGroupBasicAdapter.appendGroup(list);
    }

    @Deprecated
    public void insertData(int n2, @Nullable List<C> list) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        this.mGroupBasicAdapter.insertGroup(n2, list);
    }

    @Deprecated
    public void replaceData(int n2, @Nullable List<C> list) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        this.mGroupBasicAdapter.replaceGroup(n2, list);
    }

    @Deprecated
    public void removeData(int n2) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        this.mGroupBasicAdapter.removeGroup(n2);
    }

    @Deprecated
    public void removeData(C c3) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        this.mGroupBasicAdapter.removeGroup(c3);
    }

    public Range<Integer> getCardRange(Card card) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        return this.mGroupBasicAdapter.getCardRange(card);
    }

    public Range<Integer> getCardRange(String string2) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        return this.mGroupBasicAdapter.getCardRange(string2);
    }

    public int findCardIdxFor(int n2) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        return this.mGroupBasicAdapter.findCardIdxFor(n2);
    }

    public int findCardIdxFor(L l2) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        return this.mGroupBasicAdapter.findCardIdxFor(l2);
    }

    public Card getCardById(String string2) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        return this.mGroupBasicAdapter.getCardById(string2);
    }

    public int findLastPositionOfCell(String string2) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        return this.mGroupBasicAdapter.findLastPositionOfCell(string2);
    }

    public int findFirstPositionOfCell(String string2) {
        v.a(this.mGroupBasicAdapter != null, "Must call bindView() first");
        return this.mGroupBasicAdapter.findFirstPositionOfCell(string2);
    }

    public List<C> parseData(@Nullable ArrayList<O> arrayList) {
        return this.mDataParser.parseGroup(arrayList, this);
    }

    public List<L> parseComponent(@Nullable ArrayList<T> arrayList) {
        return this.mDataParser.parseComponent(arrayList, this);
    }

    public List<L> parseComponent(@Nullable C c3, @Nullable ArrayList<T> arrayList) {
        return this.mDataParser.parseComponent(arrayList, c3, this);
    }

    public C parseSingleData(@Nullable O o2) {
        return this.mDataParser.parseSingleGroup(o2, this);
    }

    public L parseSingleComponent(@Nullable C c3, @Nullable T t2) {
        return this.mDataParser.parseSingleComponent(t2, c3, this);
    }

    @Override
    public <T> void register(@NonNull Class<T> clazz, @NonNull T t2) {
        if ((t2 = clazz.cast(t2)) != null) {
            this.mServices.put(clazz, t2);
        }
    }

    @Override
    public <T> T getService(@NonNull Class<T> clazz) {
        Object object = ((BaseRecyclerViewEngine)object).mServices.get(clazz);
        if (object == null) {
            return null;
        }
        return clazz.cast(object);
    }

    @NonNull
    public <C> List<C> findGroups(Predicate<C> predicate) {
        LinkedList linkedList;
        v.a(((BaseRecyclerViewEngine)object).mGroupBasicAdapter != null, "Must call bindView() first");
        Object object = ((BaseRecyclerViewEngine)object).mGroupBasicAdapter.getGroups();
        if (predicate == null) {
            return object;
        }
        Object object2 = object;
        object = linkedList;
        linkedList = new LinkedList();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Object e3 = iterator.next();
            if (!predicate.isMatch(e3)) continue;
            object.add(e3);
        }
        return object;
    }

    private class DrawingOrderCallback
    implements RecyclerView.ChildDrawingOrderCallback {
        int[] viewIndex = new int[32];
        int[] zIndex = new int[32];

        private DrawingOrderCallback() {
        }

        private int[] doubleIndex(int[] nArray) {
            if (nArray == null) {
                return null;
            }
            int[] nArray2 = new int[nArray.length * 2];
            Object object = nArray2;
            int n2 = nArray.length;
            System.arraycopy(nArray, 0, object, 0, n2);
            return nArray2;
        }

        private void clearIndex(int[] nArray) {
            if (nArray == null) {
                return;
            }
            Arrays.fill(nArray, 0);
        }

        int partition(int[] nArray, int[] nArray2, int n2, int n3) {
            int n4 = nArray[n2];
            int n5 = nArray2[n2];
            while (n2 < n3) {
                while (n2 < n3 && nArray[n3] > n4) {
                    --n3;
                }
                nArray[n2] = nArray[n3];
                nArray2[n2] = nArray2[n3];
                while (n2 < n3 && nArray[n2] <= n4) {
                    ++n2;
                }
                nArray[n3] = nArray[n2];
                nArray2[n3] = nArray2[n3];
            }
            nArray[n2] = n4;
            nArray2[n2] = n5;
            return n2;
        }

        void quickSort(int[] nArray, int[] nArray2, int n2, int n3) {
            if (n2 < n3) {
                DrawingOrderCallback drawingOrderCallback = this;
                int n4 = drawingOrderCallback.partition(nArray, nArray2, n2, n3);
                int n5 = n4 - 1;
                drawingOrderCallback.quickSort(nArray, nArray2, n2, n5);
                drawingOrderCallback.quickSort(nArray, nArray2, ++n4, n3);
            }
        }

        void bubbleSort(int[] nArray, int[] nArray2, int n2) {
            int n3;
            for (int i3 = 0; i3 < (n3 = n2 - 1); ++i3) {
                while (n3 > i3) {
                    int n4 = n3 - 1;
                    if (nArray[n3] < nArray[n4]) {
                        int[] nArray3 = nArray2;
                        int[] nArray4 = nArray2;
                        int[] nArray5 = nArray;
                        int[] nArray6 = nArray;
                        int n5 = nArray5[n3];
                        nArray5[n3] = nArray6[n4];
                        nArray6[n4] = n5;
                        n5 = nArray3[n3];
                        nArray3[n3] = nArray4[n4];
                        nArray4[n4] = n5;
                    }
                    --n3;
                }
            }
        }

        public int onGetChildDrawingOrder(int n2, int n3) {
            int[] nArray = this.zIndex;
            if (this.zIndex.length < n2) {
                DrawingOrderCallback drawingOrderCallback = this;
                drawingOrderCallback.zIndex = drawingOrderCallback.doubleIndex(nArray);
                drawingOrderCallback.viewIndex = drawingOrderCallback.doubleIndex(drawingOrderCallback.viewIndex);
            }
            int n4 = 0;
            while (n4 < n2) {
                Object object = BaseRecyclerViewEngine.this.mContentView.getChildAt(n4);
                if (object != null) {
                    object = (VirtualLayoutManager.LayoutParams)object.getLayoutParams();
                    this.zIndex[n4] = object.zIndex;
                } else {
                    this.zIndex[n4] = 0;
                }
                int n5 = n4++;
                this.viewIndex[n5] = n5;
            }
            DrawingOrderCallback drawingOrderCallback = this;
            int[] nArray2 = drawingOrderCallback.zIndex;
            drawingOrderCallback.bubbleSort(nArray2, drawingOrderCallback.viewIndex, n2);
            int n6 = drawingOrderCallback.viewIndex[n3];
            DrawingOrderCallback drawingOrderCallback2 = this;
            drawingOrderCallback2.clearIndex(drawingOrderCallback2.zIndex);
            drawingOrderCallback2.clearIndex(drawingOrderCallback2.viewIndex);
            return n6;
        }
    }
}

