/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.navisdk.ui.widget.recyclerview.IServiceManager;
import com.baidu.navisdk.ui.widget.recyclerview.MVResolver;
import com.baidu.navisdk.ui.widget.recyclerview.Style;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.Card;
import com.baidu.navisdk.ui.widget.recyclerview.structure.BaseCell;
import com.baidu.navisdk.ui.widget.recyclerview.structure.view.IRecyclerViewLifeCycle;
import com.baidu.navisdk.ui.widget.recyclerview.support.CellSupport;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.util.common.e;

public class MVHelper {
    private static final String TAG = "MVHelper";
    private final MVResolver mvResolver;

    public MVHelper(MVResolver mVResolver) {
        this.mvResolver = mVResolver;
    }

    private void initView(BaseCell baseCell, View view) {
        if (view instanceof IRecyclerViewLifeCycle) {
            ((IRecyclerViewLifeCycle)view).cellInited(baseCell);
        }
    }

    private void renderStyle(BaseCell baseCell, View view) {
        MVHelper mVHelper = this;
        mVHelper.renderLayout(baseCell, view);
        mVHelper.renderBackground(baseCell, view);
    }

    private void postMountView(BaseCell baseCell, View view) {
        if (!baseCell.mIsExposed && baseCell.serviceManager != null) {
            baseCell.mIsExposed = true;
            if (e.H.d()) {
                e.H.e(TAG, "postMountView --> view = " + view + ", cell = " + baseCell + ", cell.pos = " + baseCell.pos);
            }
        }
        if (view instanceof IRecyclerViewLifeCycle) {
            ((IRecyclerViewLifeCycle)view).postBindView(baseCell);
        }
        if (this.mvResolver.isCompatibleType(baseCell.stringType)) {
            this.mvResolver.getCellClass(baseCell.stringType).cast(baseCell).postBindView(view);
        }
    }

    private void postUnMountView(BaseCell baseCell, View view) {
        if (view instanceof IRecyclerViewLifeCycle) {
            ((IRecyclerViewLifeCycle)view).postUnBindView(baseCell);
        }
    }

    public MVResolver resolver() {
        return this.mvResolver;
    }

    public boolean isValid(BaseCell baseCell, IServiceManager iServiceManager) {
        if (iServiceManager != null && (this = iServiceManager.getService(CellSupport.class)) != null) {
            return ((CellSupport)this).isValid(baseCell) && baseCell.isValid();
        }
        return baseCell != null && baseCell.isValid();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mountView(BaseCell baseCell, View view) {
        Object object;
        if (e.H.d()) {
            e.H.e(TAG, "mountView --> cell = " + baseCell + " view = " + view);
        }
        try {
            ((MVHelper)((Object)cellSupport)).mvResolver.register(baseCell, view);
            if (baseCell.serviceManager != null && (object = baseCell.serviceManager.getService(CellSupport.class)) != null) {
                ((CellSupport)object).bindView(baseCell, view);
            }
            MVHelper mVHelper = cellSupport;
            ((MVHelper)((Object)cellSupport)).initView(baseCell, view);
            mVHelper.renderStyle(baseCell, view);
            if (mVHelper.mvResolver.isCompatibleType(baseCell.stringType)) {
                ((MVHelper)((Object)cellSupport)).mvResolver.getCellClass(baseCell.stringType).cast(baseCell).bindView(view);
            }
            ((MVHelper)((Object)cellSupport)).postMountView(baseCell, view);
            if (baseCell.serviceManager == null) return;
            CellSupport cellSupport = baseCell.serviceManager.getService(CellSupport.class);
            if (cellSupport == null) return;
            cellSupport.postBindView(baseCell, view);
            return;
        }
        catch (Exception exception) {
            if (e.H.c()) {
                e.H.a("MVHelper mountView exception", exception);
            }
            if ((object = baseCell.serviceManager) == null) return;
            if ((object = object.getService(CellSupport.class)) == null) return;
            ((CellSupport)object).onBindViewException(baseCell, view, exception);
        }
    }

    public void unMountView(BaseCell baseCell, View view) {
        this.postUnMountView(baseCell, view);
        Object object = baseCell.serviceManager;
        if (object != null && (object = object.getService(CellSupport.class)) != null) {
            ((CellSupport)object).unBindView(baseCell, view);
        }
        if (this.mvResolver.isCompatibleType(baseCell.stringType)) {
            this.mvResolver.getCellClass(baseCell.stringType).cast(baseCell).unbindView(view);
        }
    }

    protected void renderLayout(BaseCell object, View view) {
        if (((BaseCell)object).style != null) {
            Object object2;
            Object object3 = view.getLayoutParams();
            if (object3 != null && object3 instanceof VirtualLayoutManager.LayoutParams) {
                object2 = object3;
            } else {
                if (object3 == null) {
                    VirtualLayoutManager.LayoutParams layoutParams;
                    object3 = layoutParams;
                    layoutParams = new VirtualLayoutManager.LayoutParams(-1, -1);
                    object2 = object3;
                } else {
                    VirtualLayoutManager.LayoutParams layoutParams;
                    object2 = layoutParams;
                    Object object4 = object3;
                    int n2 = ((ViewGroup.LayoutParams)object4).width;
                    layoutParams = new VirtualLayoutManager.LayoutParams(n2, ((ViewGroup.LayoutParams)object4).height);
                }
                view.setLayoutParams((ViewGroup.LayoutParams)object2);
            }
            if (object2 instanceof VirtualLayoutManager.LayoutParams) {
                Object object5;
                VirtualLayoutManager.LayoutParams layoutParams = (VirtualLayoutManager.LayoutParams)((Object)object2);
                if (((BaseCell)object).style.height >= 0) {
                    layoutParams.storeOriginHeight();
                    layoutParams.height = ((BaseCell)object).style.height;
                } else {
                    layoutParams.restoreOriginHeight();
                }
                if (((BaseCell)object).style.width >= 0) {
                    layoutParams.storeOriginWidth();
                    layoutParams.width = ((BaseCell)object).style.width;
                } else {
                    layoutParams.restoreOriginWidth();
                }
                Style style2 = ((BaseCell)object).style;
                layoutParams.mAspectRatio = style2.aspectRatio;
                layoutParams.zIndex = style2.zIndex;
                if (layoutParams.zIndex == 0 && (object5 = ((BaseCell)object).parent) != null && (object5 = ((Card)object5).style) != null) {
                    layoutParams.zIndex = ((Style)object5).zIndex;
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    view.setZ((float)layoutParams.zIndex);
                }
            } else {
                int n3 = ((BaseCell)object).style.height;
                if (n3 >= 0) {
                    ((ViewGroup.LayoutParams)object2).height = n3;
                }
                if ((n3 = ((BaseCell)object).style.width) >= 0) {
                    ((ViewGroup.LayoutParams)object2).width = n3;
                }
            }
            if (object2 instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)object2;
                object = ((BaseCell)object).style.margin;
                marginLayoutParams.topMargin = (int)object[0];
                marginLayoutParams.leftMargin = (int)object[3];
                marginLayoutParams.bottomMargin = (int)object[2];
                ((ViewGroup.MarginLayoutParams)object2).rightMargin = ((BaseCell)object).style.margin[1];
            }
            View view2 = view;
            view2.setTranslationX(0.0f);
            view2.setTranslationY(0.0f);
        }
    }

    protected void renderBackground(BaseCell baseCell, View view) {
        long l2;
        Style style2 = baseCell.style;
        if (style2 != null && (l2 = style2.bgColor) != Long.MIN_VALUE) {
            view.setBackgroundColor((int)l2);
        }
    }

    public void reset() {
        this.mvResolver.reset();
    }
}

