/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class RecycleViewDivider
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private Paint mPaint;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mRectHeight;
    private int mOrientation;

    public RecycleViewDivider(Context context, int n2) {
        this.mDividerHeight = 2;
        this.mRectHeight = 2;
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53c2\u6570\uff01");
        }
        this.mOrientation = n2;
        TypedArray typedArray = context.obtainStyledAttributes(ATTRS);
        this.mDivider = typedArray.getDrawable(0);
        typedArray.recycle();
    }

    public RecycleViewDivider(Context context, int n2, int n3) {
        RecycleViewDivider recycleViewDivider = recycleViewDivider2;
        recycleViewDivider2(context, n2);
        RecycleViewDivider recycleViewDivider2 = ContextCompat.getDrawable((Context)context, (int)n3);
        recycleViewDivider.mDivider = recycleViewDivider2;
        recycleViewDivider.mDividerHeight = recycleViewDivider2.getIntrinsicHeight();
    }

    public RecycleViewDivider(Context context, int n2, int n3, int n4) {
        this(context, n2, n3, n4, n3);
    }

    public RecycleViewDivider(Context context, int n2, int n3, int n4, int n5) {
        this(context, n2);
        Paint paint;
        this.mDividerHeight = n3;
        this.mRectHeight = n5;
        Context context2 = context = paint;
        super(1);
        this.mPaint = context2;
        paint.setColor(n4);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        super.getItemOffsets(rect, view, recyclerView, state);
        if (this.shouAddDivider(recyclerView.getChildAdapterPosition(view))) {
            if (this.mOrientation == 1) {
                int n2 = this.mRectHeight;
                rect.set(0, 0, 0, n2);
            } else {
                int n3 = this.mRectHeight;
                rect.set(0, 0, n3, 0);
            }
        }
    }

    public boolean shouAddDivider(int n2) {
        return true;
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        RecycleViewDivider recycleViewDivider = this;
        super.onDraw(canvas, recyclerView, state);
        if (recycleViewDivider.mOrientation == 1) {
            this.drawVertical(canvas, recyclerView);
        } else {
            this.drawHorizontal(canvas, recyclerView);
        }
    }

    protected void drawVertical(Canvas canvas, RecyclerView recyclerView) {
        RecyclerView recyclerView2 = recyclerView;
        int n2 = recyclerView2.getPaddingLeft();
        int n3 = recyclerView2.getMeasuredWidth() - recyclerView.getPaddingRight();
        int n4 = recyclerView2.getChildCount();
        for (int i3 = 0; i3 < n4; ++i3) {
            RecyclerView recyclerView3 = recyclerView;
            View view = recyclerView3.getChildAt(i3);
            if (!this.shouAddDivider(recyclerView3.getChildAdapterPosition(view))) continue;
            View view2 = view;
            view = (RecyclerView.LayoutParams)view2.getLayoutParams();
            int n5 = this.mDividerHeight;
            int n6 = view2.getBottom() + view.bottomMargin + (this.mRectHeight - n5) / 2;
            n5 = n6 + n5;
            Drawable drawable2 = this.mDivider;
            if (drawable2 != null) {
                drawable2.setBounds(n2, n6, n3, n5);
                this.mDivider.draw(canvas);
            }
            if ((drawable2 = this.mPaint) == null) continue;
            float f3 = n2;
            float f4 = n6;
            float f5 = n3;
            float f6 = n5;
            canvas.drawRect(f3, f4, f5, f6, (Paint)drawable2);
        }
    }

    protected void drawHorizontal(Canvas canvas, RecyclerView recyclerView) {
        RecyclerView recyclerView2 = recyclerView;
        int n2 = recyclerView2.getPaddingTop();
        int n3 = recyclerView2.getMeasuredHeight() - recyclerView.getPaddingBottom();
        int n4 = recyclerView2.getChildCount();
        for (int i3 = 0; i3 < n4; ++i3) {
            RecyclerView recyclerView3 = recyclerView;
            View view = recyclerView3.getChildAt(i3);
            if (!this.shouAddDivider(recyclerView3.getChildAdapterPosition(view))) continue;
            View view2 = view;
            view = (RecyclerView.LayoutParams)view2.getLayoutParams();
            int n5 = this.mDividerHeight;
            int n6 = view2.getRight() + view.rightMargin + (this.mRectHeight - n5) / 2;
            n5 = n6 + n5;
            Drawable drawable2 = this.mDivider;
            if (drawable2 != null) {
                drawable2.setBounds(n6, n2, n5, n3);
                this.mDivider.draw(canvas);
            }
            if ((drawable2 = this.mPaint) == null) continue;
            float f3 = n6;
            float f4 = n2;
            float f5 = n5;
            float f6 = n3;
            canvas.drawRect(f3, f4, f5, f6, (Paint)drawable2);
        }
    }
}

