/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.BaseCardData;
import com.baidu.navisdk.ui.widget.recyclerview.BaseCellData;
import com.baidu.navisdk.ui.widget.recyclerview.BaseRecyclerViewEngine;
import com.baidu.navisdk.ui.widget.recyclerview.Engine;
import com.baidu.navisdk.ui.widget.recyclerview.MVHelper;
import com.baidu.navisdk.ui.widget.recyclerview.OnCellClickListener;
import com.baidu.navisdk.ui.widget.recyclerview.async.CardLoadSupport;
import com.baidu.navisdk.ui.widget.recyclerview.core.adapter.GroupBasicAdapter;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.DataParser;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.IAdapterBuilder;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.Card;
import com.baidu.navisdk.ui.widget.recyclerview.ext.PullFromEndListener;
import com.baidu.navisdk.ui.widget.recyclerview.ext.SwipeItemTouchListener;
import com.baidu.navisdk.ui.widget.recyclerview.structure.BaseCell;
import com.baidu.navisdk.ui.widget.recyclerview.util.Predicate;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RecyclerViewEngine
extends BaseRecyclerViewEngine<BaseCardData, BaseCellData, Card, BaseCell>
implements Engine {
    private static final int NO_SWIPE = -1;
    private Runnable updateRunnable;
    private int mPreLoadNumber = 5;
    private boolean mEnableAutoLoadMore = true;
    private boolean mEnableLoadFirstPageCard = true;
    public int scrolledY;
    private SwipeItemTouchListener mSwipeItemTouchListener = null;
    private RecyclerView.OnScrollListener mScrollListener = null;
    private final int mSwipeCardActionEdge;

    public RecyclerViewEngine(@NonNull Context context, @NonNull DataParser<BaseCardData, BaseCellData, Card, BaseCell> dataParser, @NonNull IAdapterBuilder<Card, BaseCell> iAdapterBuilder) {
        super(context, dataParser, iAdapterBuilder);
        this.mSwipeCardActionEdge = -1;
    }

    public void enableAutoLoadMore(boolean bl) {
        this.mEnableAutoLoadMore = bl;
    }

    public void setPreLoadNumber(int n2) {
        this.mPreLoadNumber = n2 >= 0 ? n2 : 0;
    }

    @Override
    public void bindView(@NonNull RecyclerView recyclerView) {
        RecyclerView recyclerView2 = recyclerView;
        RecyclerView recyclerView3 = recyclerView;
        RecyclerViewEngine recyclerViewEngine = this;
        super.bindView(recyclerView);
        RecyclerViewEngine recyclerViewEngine2 = this;
        recyclerView = recyclerView.getContext();
        GroupBasicAdapter groupBasicAdapter = recyclerViewEngine2.mGroupBasicAdapter;
        RecyclerView recyclerView4 = recyclerViewEngine2.getContentView();
        recyclerViewEngine.mSwipeItemTouchListener = new SwipeItemTouchListener((Context)recyclerView, groupBasicAdapter, recyclerView4);
        recyclerViewEngine.mScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int n2, int n3) {
                super.onScrolled(recyclerView, n2, n3);
                if (recyclerView != null) {
                    RecyclerViewEngine.this.scrolledY += n3;
                }
            }
        };
        recyclerView3.addOnItemTouchListener((RecyclerView.OnItemTouchListener)recyclerViewEngine.mSwipeItemTouchListener);
        recyclerView2.addOnScrollListener(this.mScrollListener);
    }

    public void setPullFromEndListener(PullFromEndListener pullFromEndListener) {
        SwipeItemTouchListener swipeItemTouchListener = ((RecyclerViewEngine)((Object)swipeItemTouchListener)).mSwipeItemTouchListener;
        if (swipeItemTouchListener != null) {
            swipeItemTouchListener.setPullFromEndListener(pullFromEndListener);
        }
    }

    public void setNoScrolling(boolean bl) {
        this.getLayoutManager().setNoScrolling(bl);
    }

    public void setCanScrollVertically(boolean bl) {
        this.getLayoutManager().setCanScrollVertically(bl);
    }

    public void setCanScrollHorizontally(boolean bl) {
        this.getLayoutManager().setCanScrollHorizontally(bl);
    }

    public void setEnableOverlapMargin(boolean bl) {
        this.getLayoutManager().setEnableMarginOverlapping(bl);
    }

    @Override
    public void unbindView() {
        SwipeItemTouchListener swipeItemTouchListener;
        RecyclerView recyclerView = this.getContentView();
        if (recyclerView != null && (swipeItemTouchListener = this.mSwipeItemTouchListener) != null) {
            RecyclerViewEngine recyclerViewEngine = this;
            RecyclerView recyclerView2 = recyclerView;
            recyclerView2.removeOnItemTouchListener((RecyclerView.OnItemTouchListener)swipeItemTouchListener);
            recyclerView2.clearOnScrollListeners();
            recyclerView.removeCallbacks(this.updateRunnable);
            recyclerViewEngine.mSwipeItemTouchListener = null;
            recyclerViewEngine.mScrollListener = null;
        }
        super.unbindView();
    }

    public void onScrolled() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block12: {
            RecyclerViewEngine recyclerViewEngine = this;
            n6 = recyclerViewEngine.getLayoutManager().findLastVisibleItemPosition();
            n5 = recyclerViewEngine.getLayoutManager().findFirstVisibleItemPosition();
            n4 = -1;
            n3 = -1;
            for (n2 = n6; n2 >= n5; --n2) {
                n4 = this.mGroupBasicAdapter.findCardIdxFor(n2);
                if (n4 < 0) {
                    continue;
                }
                break block12;
            }
            n2 = n6;
        }
        n5 = n3;
        while (n3 <= n6 && (n5 = this.mGroupBasicAdapter.findCardIdxFor(n3)) < 0) {
            ++n3;
        }
        if (n4 >= 0 && n5 >= 0) {
            CardLoadSupport cardLoadSupport = this.getService(CardLoadSupport.class);
            if (cardLoadSupport == null) {
                return;
            }
            RecyclerViewEngine recyclerViewEngine = this;
            List list = recyclerViewEngine.mGroupBasicAdapter.getGroups();
            Card card = (Card)list.get(n4);
            Object object = recyclerViewEngine.mGroupBasicAdapter.getCardRange(n4);
            if (object != null && n2 >= (Integer)((Range)object.first).getUpper() - this.mPreLoadNumber && !TextUtils.isEmpty((CharSequence)card.load) && card.loaded) {
                if (card.loadMore) {
                    cardLoadSupport.loadMore(card);
                }
                return;
            }
            boolean bl = false;
            while (n5 < Math.min(n4 + this.mPreLoadNumber, list.size())) {
                object = (Card)list.get(n5);
                if (!TextUtils.isEmpty((CharSequence)object.load) && !object.loaded) {
                    if (object.loadMore && !bl) {
                        cardLoadSupport.loadMore((Card)object);
                        bl = true;
                    } else {
                        cardLoadSupport.doLoad((Card)object);
                    }
                    object.loaded = true;
                }
                ++n5;
            }
            if (this.mEnableAutoLoadMore && this.mGroupBasicAdapter.getItemCount() - n2 < this.mPreLoadNumber) {
                this.loadMoreCard();
            }
            return;
        }
    }

    @Override
    public void setData(@Nullable ArrayList<BaseCardData> arrayList) {
        RecyclerViewEngine recyclerViewEngine = this;
        super.setData(arrayList);
        recyclerViewEngine.loadFirstPageCard();
    }

    @Override
    public void setData(@Nullable List<Card> list) {
        RecyclerViewEngine recyclerViewEngine = this;
        super.setData(list);
        recyclerViewEngine.loadFirstPageCard();
    }

    public void setEnableLoadFirstPageCard(boolean bl) {
        this.mEnableLoadFirstPageCard = bl;
    }

    public void loadFirstPageCard() {
        if (!this.mEnableLoadFirstPageCard) {
            return;
        }
        CardLoadSupport cardLoadSupport = this.getService(CardLoadSupport.class);
        if (cardLoadSupport == null) {
            return;
        }
        boolean bl = false;
        List list = this.mGroupBasicAdapter.getGroups();
        for (int i3 = 0; i3 < Math.min(this.mPreLoadNumber, list.size()); ++i3) {
            Card card = (Card)list.get(i3);
            if (TextUtils.isEmpty((CharSequence)card.load) || card.loaded) continue;
            if (card.loadMore && !bl) {
                cardLoadSupport.loadMore(card);
                bl = true;
            } else {
                cardLoadSupport.doLoad(card);
            }
            card.loaded = true;
        }
    }

    public void addSimpleClickSupport(@NonNull OnCellClickListener onCellClickListener) {
        this.register(OnCellClickListener.class, onCellClickListener);
    }

    public void addCardLoadSupport(@NonNull CardLoadSupport cardLoadSupport) {
        this.register(CardLoadSupport.class, cardLoadSupport);
    }

    public void loadMoreCard() {
        CardLoadSupport cardLoadSupport = ((BaseRecyclerViewEngine)this).getService(CardLoadSupport.class);
        if (cardLoadSupport == null) {
            return;
        }
        if ((this = ((BaseRecyclerViewEngine)this).findGroups(new Predicate<Card>(){

            @Override
            public boolean isMatch(Card card) {
                return card.loadMore && card.hasMore && !card.loading && !TextUtils.isEmpty((CharSequence)card.load);
            }
        })).size() != 0) {
            Object object = this;
            cardLoadSupport.loadMore((Card)object.get(object.size() - 1));
        }
    }

    public Card findCardById(String string2) {
        if ((this = ((BaseRecyclerViewEngine)this).getService(MVHelper.class)) == null) {
            return null;
        }
        return ((MVHelper)this).resolver().findCardById(string2);
    }

    public BaseCell findCellById(String string2) {
        Object object = object.mGroupBasicAdapter;
        if (object != null && string2 != null) {
            object = ((GroupBasicAdapter)((Object)object)).getComponents();
            int n2 = object.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!string2.equals(((BaseCell)object.get((int)i3)).id)) continue;
                return (BaseCell)object.get(i3);
            }
        }
        return null;
    }

    @Override
    public void refresh(final boolean bl) {
        Runnable runnable;
        final RecyclerView recyclerView = this.getContentView();
        if (recyclerView == null) {
            return;
        }
        recyclerView.getScrollState();
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (!recyclerView.isComputingLayout()) {
                    3 v02 = this;
                    v02.RecyclerViewEngine.this.mGroupBasicAdapter.notifyUpdate(bl);
                    if (v02.RecyclerViewEngine.this.mSwipeItemTouchListener != null) {
                        RecyclerViewEngine.this.mSwipeItemTouchListener.updateCurrCard();
                    }
                }
            }
        };
        this.updateRunnable = runnable2;
        recyclerView.post(runnable2);
    }

    @Override
    public void refresh() {
        this.refresh(true);
    }

    @Override
    public void replaceCard(Card card, Card card2) {
        int n2 = this.mGroupBasicAdapter.getGroups().indexOf(card);
        if (n2 >= 0) {
            this.replaceData(n2, Collections.singletonList(card2));
        }
    }

    @Override
    public void replaceCells(Card card, List<BaseCell> list) {
        if (card != null && list != null) {
            Card card2 = card;
            card2.setCells(list);
            card2.notifyDataChange();
        }
    }

    @Override
    public void scrollToPosition(Card object) {
        if ((object = ((Card)object).getCells()).size() > 0) {
            object = (BaseCell)object.get(0);
            int n2 = this.mGroupBasicAdapter.getComponents().indexOf(object);
            if (n2 > 0 && (this = this.getContentView()) != null) {
                this.scrollToPosition(n2);
            }
        }
    }

    @Override
    public void scrollToPosition(BaseCell baseCell) {
        int n2;
        if (baseCell != null && (n2 = this.mGroupBasicAdapter.getComponents().indexOf(baseCell)) > 0 && (this = this.getContentView()) != null) {
            this.scrollToPosition(n2);
        }
    }

    @Override
    public void topPosition(BaseCell baseCell) {
        int n2;
        if (baseCell != null && (n2 = this.mGroupBasicAdapter.getComponents().indexOf(baseCell)) > 0) {
            VirtualLayoutManager virtualLayoutManager = this.getLayoutManager();
            View view = virtualLayoutManager.findViewByPosition(n2);
            if (view != null) {
                int n3 = virtualLayoutManager.getDecoratedTop(view);
                RecyclerView recyclerView = this.getContentView();
                if (recyclerView != null) {
                    recyclerView.scrollBy(0, n3);
                }
            } else if ((this = this.getContentView()) != null) {
                this.scrollToPosition(n2);
            }
        }
    }

    @Override
    public void topPosition(Card object) {
        if ((object = ((Card)object).getCells()).size() > 0) {
            object = (BaseCell)object.get(0);
            int n2 = this.mGroupBasicAdapter.getComponents().indexOf(object);
            if (n2 > 0) {
                VirtualLayoutManager virtualLayoutManager = this.getLayoutManager();
                View view = virtualLayoutManager.findViewByPosition(n2);
                if (view != null) {
                    int n3 = virtualLayoutManager.getDecoratedTop(view);
                    RecyclerView recyclerView = this.getContentView();
                    if (recyclerView != null) {
                        recyclerView.scrollBy(0, n3);
                    }
                } else if ((this = this.getContentView()) != null) {
                    this.scrollToPosition(n2);
                }
            }
        }
    }

    public void insertWith(int n2, BaseCell baseCell) {
        this.insertWith(n2, Arrays.asList(baseCell));
    }

    public void insertWith(int n2, List<BaseCell> list) {
        Object object;
        int n3 = list != null ? list.size() : 0;
        if (n3 > 0 && (object = this.mGroupBasicAdapter) != null) {
            if (n2 >= ((GroupBasicAdapter)((Object)object)).getItemCount()) {
                n2 = this.mGroupBasicAdapter.getItemCount() - 1;
            }
            RecyclerViewEngine recyclerViewEngine = this;
            object = (BaseCell)recyclerViewEngine.mGroupBasicAdapter.getItemByPosition(n2);
            int n4 = recyclerViewEngine.mGroupBasicAdapter.findCardIdxFor(n2);
            Card card = (Card)recyclerViewEngine.mGroupBasicAdapter.getCardRange((int)n4).second;
            card.addCells(card, card.getCells().indexOf(object), list);
            object = recyclerViewEngine.getLayoutManager().getLayoutHelpers();
            if (object != null && n4 >= 0 && n4 < object.size()) {
                int n5 = object.size();
                for (n4 = 0; n4 < n5; ++n4) {
                    LayoutHelper layoutHelper = (LayoutHelper)object.get(n4);
                    int n6 = layoutHelper.getRange().getLower();
                    int n7 = layoutHelper.getRange().getUpper();
                    if (n7 < n2) continue;
                    if (n6 <= n2 && n2 <= n7) {
                        LayoutHelper layoutHelper2 = layoutHelper;
                        layoutHelper2.setItemCount(layoutHelper2.getItemCount() + n3);
                        layoutHelper.setRange(n6, n7 + n3);
                        continue;
                    }
                    if (n2 >= n6) continue;
                    int n8 = n6 + n3;
                    layoutHelper.setRange(n8, n7 + n3);
                }
                this.mGroupBasicAdapter.insertComponents(n2, list);
            }
        }
    }

    public void insertBatchWith(int n2, Card card) {
        this.insertBatchWith(n2, Arrays.asList(card));
    }

    public void insertBatchWith(int n2, List<Card> list) {
        VirtualLayoutManager virtualLayoutManager = this.getLayoutManager();
        if (list != null && list.size() > 0 && this.mGroupBasicAdapter != null && virtualLayoutManager != null) {
            ArrayList<LayoutHelper> arrayList;
            ArrayList<LayoutHelper> arrayList2;
            List<LayoutHelper> list2 = virtualLayoutManager.getLayoutHelpers();
            ArrayList<LayoutHelper> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<LayoutHelper>(list2);
            ArrayList<LayoutHelper> arrayList4 = arrayList;
            arrayList = new ArrayList<LayoutHelper>();
            int n3 = list.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                arrayList4.add(list.get(i3).getLayoutHelper());
            }
            if (n2 >= list2.size()) {
                arrayList3.addAll(arrayList4);
            } else {
                arrayList3.addAll(n2, arrayList4);
            }
            virtualLayoutManager.setLayoutHelpers(arrayList3);
            this.mGroupBasicAdapter.insertBatchComponents(n2, list);
        }
    }

    public void appendWith(Card card) {
        this.appendBatchWith(Arrays.asList(card));
    }

    public void appendBatchWith(List<Card> list) {
        GroupBasicAdapter groupBasicAdapter = this.mGroupBasicAdapter;
        if (groupBasicAdapter != null) {
            this.insertBatchWith(groupBasicAdapter.getGroups().size(), list);
        }
    }

    protected void removeBy(int n2) {
        GroupBasicAdapter groupBasicAdapter = this.mGroupBasicAdapter;
        if (groupBasicAdapter != null && n2 < groupBasicAdapter.getItemCount() && n2 >= 0) {
            RecyclerViewEngine recyclerViewEngine = this;
            recyclerViewEngine.removeBy((BaseCell)recyclerViewEngine.mGroupBasicAdapter.getItemByPosition(n2));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void removeBy(BaseCell var1_1) {
        block6: {
            var2_2 = this.getLayoutManager();
            if (var1_1 == null || (var3_3 = this.mGroupBasicAdapter) == null || var2_2 == null || (var3_4 = var3_3.getPositionByItem(var1_1)) < 0) break block6;
            v0 = this;
            var4_5 = v0.mGroupBasicAdapter.findCardIdxFor(var3_4);
            ((Card)v0.mGroupBasicAdapter.getCardRange((int)var4_5).second).removeCellSilently(var1_1);
            var5_6 = var2_2.getLayoutHelpers();
            var6_7 = null;
            if (var5_6 == null || var4_5 < 0 || var4_5 >= var5_6.size()) break block6;
            var7_8 = var5_6.size();
            for (var4_5 = 0; var4_5 < var7_8; ++var4_5) {
                var8_9 = var5_6.get(var4_5);
                var9_11 = var8_9.getRange().getLower();
                var10_12 = var8_9.getRange().getUpper();
                if (var10_12 < var3_4) ** GOTO lbl26
                if (var9_11 <= var3_4 && var3_4 <= var10_12) {
                    var11_13 = var8_9.getItemCount() - 1;
                    if (var11_13 > 0) {
                        var8_9.setItemCount(var11_13);
                        var8_9.setRange(var9_11, var10_12 - 1);
                        var8_9 = var6_7;
                    }
                } else {
                    if (var3_4 < var9_11) {
                        var8_10 = var9_11 - 1;
                        var8_9.setRange(var8_10, var10_12 - 1);
                    }
lbl26:
                    // 4 sources

                    var8_9 = var6_7;
                }
                var6_7 = var8_9;
            }
            if (var6_7 != null) {
                v1 = var2_2;
                var2_2 = v2;
                new LinkedList<LayoutHelper>(var5_6).remove(var6_7);
                v1.setLayoutHelpers((List<LayoutHelper>)var2_2);
            }
            this.mGroupBasicAdapter.removeComponent(var1_1);
        }
    }

    public void removeBatchBy(int n2) {
        Pair pair;
        GroupBasicAdapter groupBasicAdapter = this.mGroupBasicAdapter;
        if (groupBasicAdapter != null && (pair = groupBasicAdapter.getCardRange(n2)) != null) {
            this.removeBatchBy((Card)pair.second);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void removeBatchBy(Card var1_1) {
        block4: {
            var2_2 = this.getLayoutManager();
            if (var1_1 == null || (var3_3 = this.mGroupBasicAdapter) == null || var2_2 == null) break block4;
            var3_4 = var3_3.findCardIdxForCard(var1_1);
            var4_5 = var2_2.getLayoutHelpers();
            var5_6 = null;
            var6_7 = 0;
            if (var4_5 == null || var3_4 < 0 || var3_4 >= var4_5.size()) break block4;
            var8_9 = var4_5.size();
            for (var7_8 = 0; var7_8 < var8_9; ++var7_8) {
                var9_10 = var4_5.get(var7_8);
                var10_12 = var9_10.getRange().getLower();
                var11_13 = var9_10.getRange().getUpper();
                if (var7_8 < var3_4) ** GOTO lbl19
                if (var7_8 == var3_4) {
                    var6_7 = var9_10.getItemCount();
                } else {
                    var9_11 = var10_12 - var6_7;
                    var9_10.setRange(var9_11, var11_13 - var6_7);
lbl19:
                    // 2 sources

                    var9_10 = var5_6;
                }
                var5_6 = var9_10;
            }
            if (var5_6 != null) {
                v0 = var2_2;
                var2_2 = v1;
                new LinkedList<LayoutHelper>(var4_5).remove(var5_6);
                v0.setLayoutHelpers((List<LayoutHelper>)var2_2);
            }
            this.mGroupBasicAdapter.removeComponents(var1_1);
        }
    }

    public void replace(BaseCell baseCell, BaseCell baseCell2) {
        int n2;
        GroupBasicAdapter groupBasicAdapter;
        VirtualLayoutManager virtualLayoutManager = this.getLayoutManager();
        if (baseCell != null && baseCell2 != null && (groupBasicAdapter = this.mGroupBasicAdapter) != null && virtualLayoutManager != null && (n2 = groupBasicAdapter.getPositionByItem(baseCell)) >= 0) {
            RecyclerViewEngine recyclerViewEngine = this;
            int n3 = recyclerViewEngine.mGroupBasicAdapter.findCardIdxFor(n2);
            ((Card)recyclerViewEngine.mGroupBasicAdapter.getCardRange((int)n3).second).replaceCell(baseCell, baseCell2);
            recyclerViewEngine.mGroupBasicAdapter.replaceComponent(Arrays.asList(baseCell), Arrays.asList(baseCell2));
        }
    }

    public void replace(Card card, List<BaseCell> list) {
        Object object = this.getLayoutManager();
        if (card != null && list != null && list.size() > 0 && this.mGroupBasicAdapter != null && object != null) {
            ArrayList<BaseCell> arrayList;
            ArrayList<BaseCell> arrayList2 = arrayList;
            if (new ArrayList<BaseCell>(card.getCells()).size() == list.size()) {
                card.setCells(list);
                this.mGroupBasicAdapter.replaceComponent(arrayList2, list);
            } else {
                object = ((VirtualLayoutManager)object).getLayoutHelpers();
                int n2 = this.mGroupBasicAdapter.findCardIdxForCard(card);
                int n3 = 0;
                if (object != null && n2 >= 0 && n2 < object.size()) {
                    int n4 = object.size();
                    for (int i3 = 0; i3 < n4; ++i3) {
                        LayoutHelper layoutHelper = (LayoutHelper)object.get(i3);
                        int n5 = layoutHelper.getRange().getLower();
                        int n6 = layoutHelper.getRange().getUpper();
                        if (i3 < n2) continue;
                        if (i3 == n2) {
                            List<BaseCell> list2 = list;
                            n3 = list2.size() - layoutHelper.getItemCount();
                            layoutHelper.setItemCount(list2.size());
                            layoutHelper.setRange(n5, n6 + n3);
                            continue;
                        }
                        int n7 = n5 + n3;
                        layoutHelper.setRange(n7, n6 + n3);
                    }
                    card.setCells(list);
                    this.mGroupBasicAdapter.replaceComponent(arrayList2, list);
                }
            }
        }
    }

    public void replace(Card card, Card card2) {
        VirtualLayoutManager virtualLayoutManager = this.getLayoutManager();
        if (card != null && card2 != null && this.mGroupBasicAdapter != null && virtualLayoutManager != null) {
            List<LayoutHelper> list = virtualLayoutManager.getLayoutHelpers();
            int n2 = this.mGroupBasicAdapter.findCardIdxForCard(card);
            if (list != null && n2 >= 0 && n2 < list.size()) {
                LinkedList<LayoutHelper> linkedList;
                LinkedList<LayoutHelper> linkedList2 = linkedList;
                linkedList = new LinkedList<LayoutHelper>();
                int n3 = list.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    LayoutHelper layoutHelper = list.get(i3);
                    if (i3 == n2) {
                        layoutHelper = card2.getLayoutHelper();
                    }
                    linkedList2.add(layoutHelper);
                }
                virtualLayoutManager.setLayoutHelpers(linkedList2);
                this.mGroupBasicAdapter.replaceComponent(card, card2);
            }
        }
    }

    public void updateCell(String string2, int n2) {
        GroupBasicAdapter groupBasicAdapter;
        if (!TextUtils.isEmpty((CharSequence)string2) && (groupBasicAdapter = this.mGroupBasicAdapter) != null) {
            this.updateCell(groupBasicAdapter.getCardById(string2).getCells().get(n2));
        }
    }

    public void updateCell(BaseCell baseCell) {
        int n2;
        GroupBasicAdapter groupBasicAdapter;
        if (baseCell != null && (groupBasicAdapter = this.mGroupBasicAdapter) != null && (n2 = groupBasicAdapter.getPositionByItem(baseCell)) >= 0) {
            baseCell.extras.put((Object)"_flag_invalidate_", (Object)true);
            this.mGroupBasicAdapter.notifyItemChanged(n2);
        }
    }

    public void updateCard(String string2) {
        GroupBasicAdapter groupBasicAdapter;
        if (!TextUtils.isEmpty((CharSequence)string2) && (groupBasicAdapter = this.mGroupBasicAdapter) != null) {
            this.updateCard(groupBasicAdapter.getCardById(string2));
        }
    }

    public void updateCard(Card object) {
        GroupBasicAdapter groupBasicAdapter;
        if (object != null && (groupBasicAdapter = this.mGroupBasicAdapter) != null) {
            object = groupBasicAdapter.getCardRange((Card)object);
            for (int i3 = ((Range)object).getLower().intValue(); i3 < (Integer)((Range)object).getUpper(); ++i3) {
                ((BaseCell)this.mGroupBasicAdapter.getItemByPosition((int)i3)).extras.put((Object)"_flag_invalidate_", (Object)true);
            }
            this.mGroupBasicAdapter.notifyItemRangeChanged((Integer)((Range)object).getLower(), (Integer)((Range)object).getUpper());
        }
    }
}

